program DFA(input, output);

{
Based on Algorithm 4.2, this program simulates the completely specified DFA depicted in Figure 4.1. It reads an input string from file input. The input string is terminated with #.
}

type
  states    = 1..4;
  stateset  = set of states;
  symbols   = Char;
  symbolset = set of symbols;
  rules     = array[states, symbols] of states;

var
  state       : states;
  finalstates : stateset;
  symbol      : symbols;
  rule        : rules;

const
  alphabet : symbolset = ['a'..'b'];

begin
  {initialization of rule according to the state table in Figure 4.1}
  rule[1, 'a'] := 2; rule[1, 'b'] := 3;
  rule[2, 'a'] := 2; rule[2, 'b'] := 3;
  rule[3, 'a'] := 4; rule[3, 'b'] := 3;
  rule[4, 'a'] := 4; rule[4, 'b'] := 4;

  finalstates := [2, 3];            {initialization of final states}
  state := 1;                       {1 is the start state}

  read(symbol);

  while symbol in alphabet do
  begin
    state := rule[state, symbol];   {simulation of a move}
    read(symbol) 
  end;

  if symbol = '#' then              {the input has been completely read}
    if state in finalstates then    {decision of acceptance}
      writeln('ACCEPT')
    else 
      writeln('REJECT') 
  else 
    writeln('ILLEGAL INPUT SYMBOL') {symbol differs from the symbols of 
alphabet or #}
end.
