/*
 * Decompiled with CFR 0.152.
 */
package didefom.DKASimulation;

import didefom.DKASimulation.State;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

public class Rule {
    protected State m_src;
    protected State m_dest;
    protected SortedSet<Character> m_set;
    boolean m_epsilon;
    boolean m_active;

    public Rule() {
        this.m_src = null;
        this.m_dest = null;
        this.m_set = new TreeSet<Character>();
    }

    public Rule(State src, State dest, SortedSet<Character> c) {
        this.m_src = src;
        this.m_dest = dest;
        this.m_set = new TreeSet<Character>();
        Iterator i$ = c.iterator();
        while (i$.hasNext()) {
            char i = ((Character)i$.next()).charValue();
            this.m_set.add(Character.valueOf(i));
        }
    }

    public State GetSrc() {
        return this.m_src;
    }

    public State GetDest() {
        return this.m_dest;
    }

    public void SetSrc(State src) {
        this.m_src = src;
    }

    public void SetDest(State dest) {
        this.m_dest = dest;
    }

    public void SetChar(char c) {
        this.m_set.add(Character.valueOf(c));
    }

    public void ClearChar(char c) {
        this.m_set.remove(Character.valueOf(c));
    }

    public SortedSet<Character> GetSet() {
        return this.m_set;
    }

    public boolean IsChar(char c) {
        return this.m_set.contains(Character.valueOf(c));
    }

    public boolean IsEpsilon() {
        return this.m_epsilon;
    }

    public void SetEpsilon(boolean epsilon) {
        this.m_epsilon = epsilon;
    }

    public boolean IsActive() {
        return this.m_active;
    }

    public void SetActive(boolean active) {
        this.m_active = active;
    }

    private int SetString_Add(char c, SetString_State s) {
        if (s.minus) {
            for (char j = s.last; j <= c; j = (char)(j + '\u0001')) {
                this.m_set.add(Character.valueOf(j));
            }
            s.minus = false;
        } else {
            this.m_set.add(Character.valueOf(c));
        }
        s.last = c;
        return c;
    }

    public void SetString(String p) {
        int state = 0;
        this.m_set.clear();
        char[] str = p.toCharArray();
        SetString_State s = new SetString_State();
        int number = 0;
        block6: for (int i = 0; i < str.length; ++i) {
            boolean end = i + 1 == str.length;
            switch (state) {
                case 0: {
                    if (!end && str[i] == '0') {
                        state = 2;
                        continue block6;
                    }
                    this.SetString_Add(str[i], s);
                    state = 1;
                    continue block6;
                }
                case 1: {
                    if (str[i] == ',') {
                        state = 0;
                        continue block6;
                    }
                    if (str[i] == '-') {
                        s.minus = true;
                        state = 0;
                        continue block6;
                    }
                    this.m_set.add(Character.valueOf(str[i]));
                    s.last = str[i];
                    state = 1;
                    continue block6;
                }
                case 2: {
                    if (str[i] == 'x') {
                        state = 3;
                        number = 0;
                        continue block6;
                    }
                    if (str[i] == ',') {
                        this.SetString_Add('0', s);
                        state = 0;
                        continue block6;
                    }
                    if (str[i] == '-') {
                        this.SetString_Add('0', s);
                        s.minus = true;
                        state = 0;
                        continue block6;
                    }
                    this.SetString_Add('0', s);
                    if (str[i] == '0') {
                        state = 2;
                        continue block6;
                    }
                    this.SetString_Add(str[i], s);
                    state = 1;
                    continue block6;
                }
                case 3: {
                    if (str[i] >= '0' && str[i] <= '9') {
                        number = (number << 4) + (str[i] - 48);
                    } else if (str[i] >= 'a' && str[i] <= 'f') {
                        number = (number << 4) + (str[i] - 97 + 10);
                    } else if (str[i] >= 'A' && str[i] <= 'F') {
                        number = (number << 4) + (str[i] - 65 + 10);
                    } else if (str[i] == ',') {
                        this.SetString_Add((char)number, s);
                        state = 0;
                    } else if (str[i] == '-') {
                        this.SetString_Add((char)number, s);
                        s.minus = true;
                        state = 0;
                    } else {
                        this.SetString_Add((char)number, s);
                        this.SetString_Add(str[i], s);
                        state = 1;
                    }
                    if (!end) continue block6;
                    this.SetString_Add((char)number, s);
                }
            }
        }
    }

    String getRep(char c) {
        if (c <= ' ') {
            return String.format("0x%02x", c);
        }
        if (c <= '~') {
            return String.format("%c", c);
        }
        return String.format("0x%02x", c);
    }

    public String GetString() {
        StringBuffer ret = new StringBuffer();
        int last = 0;
        boolean minus = false;
        int state = 0;
        Iterator i$ = this.m_set.iterator();
        while (i$.hasNext()) {
            int c = ((Character)i$.next()).charValue();
            switch (state) {
                case 0: {
                    ret.append(this.getRep((char)c));
                    last = c;
                    state = 1;
                    break;
                }
                case 1: {
                    if (c == last + '\u0001') {
                        ret.append('-');
                        last = c;
                        state = 2;
                        break;
                    }
                    ret.append(',');
                    ret.append(this.getRep((char)c));
                    last = c;
                    break;
                }
                case 2: {
                    if (c == last + '\u0001') {
                        last = c;
                        break;
                    }
                    ret.append(this.getRep((char)last));
                    ret.append(',');
                    ret.append(this.getRep((char)c));
                    state = 1;
                }
            }
        }
        if (state == 2) {
            ret.append(this.getRep((char)last));
        }
        return ret.toString();
    }

    public boolean formallyEqual(Rule r) {
        if (r == this) {
            return true;
        }
        if (r == null) {
            return false;
        }
        if (this.GetSrc().equals(r.GetSrc()) && this.GetDest().equals(r.GetDest())) {
            if (this.IsEpsilon() == r.IsEpsilon()) {
                return true;
            }
            if (this.GetSet().equals(r.GetSet())) {
                return true;
            }
        }
        return false;
    }

    private class SetString_State {
        public boolean minus = false;
        public char last = '\u0000';

        private SetString_State() {
        }
    }
}

