/*
 * Decompiled with CFR 0.152.
 */
package didefom.common;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import didefom.common.XMLSerializable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XMLManager {
    private String fileName;
    private DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    private DocumentBuilder db;
    private Document doc;
    private DOMImplementation di;
    private XMLSerializable formalModel;

    public XMLManager() {
        try {
            this.db = this.dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            ex.printStackTrace();
        }
    }

    public XMLManager(String fileName) {
        this.setFileName(fileName);
        try {
            this.db = this.dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            ex.printStackTrace();
        }
    }

    public void parse() {
        this.parse(this.getFileName());
    }

    public void parse(String fn) {
        this.setFileName(fn);
        try {
            this.doc = this.db.parse(new File(this.getFileName()));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (SAXException ex) {
            ex.printStackTrace();
        }
    }

    public void Load(XMLSerializable fm) {
        this.setFormalModel(fm);
        this.Load();
    }

    public void Load() {
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
        this.getFormalModel().setAliases(xstream);
        String xml = "";
        String in = XMLManager.ReadEntireTextFile(this.getFileName());
        this.setFormalModel((XMLSerializable)xstream.fromXML(in));
    }

    public void Save(XMLSerializable fm) {
        this.Save(fm, this.getFileName());
    }

    public void Save(XMLSerializable fm, String fileName) {
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
        fm.setAliases(xstream);
        String xml = xstream.toXML((Object)fm);
        try {
            FileWriter fout = new FileWriter(fileName);
            fout.write(xml);
            fout.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    protected void InitialStorage() {
    }

    protected void StoreFormalModel(XMLSerializable fm) {
    }

    protected void StoreFomalModel() {
        this.StoreFormalModel(this.getFormalModel());
    }

    protected void SaveCreatedDocumentIntoFile() {
        DOMSource ds = new DOMSource(this.doc);
        StreamResult sr = new StreamResult(new File(this.getFileName()));
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            Transformer trans = tf.newTransformer();
            trans.transform(ds, sr);
        }
        catch (TransformerConfigurationException ex) {
            ex.printStackTrace();
        }
        catch (TransformerException ex) {
            ex.printStackTrace();
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Document getDocument() {
        return this.doc;
    }

    public void setDocument(Document document) {
        this.doc = document;
    }

    public XMLSerializable getFormalModel() {
        return this.formalModel;
    }

    public void setFormalModel(XMLSerializable formalModel) {
        this.formalModel = formalModel;
    }

    public static String ReadEntireTextFile(String filename) {
        StringBuilder content = new StringBuilder();
        try {
            BufferedReader fr = new BufferedReader(new FileReader(filename));
            String line = null;
            while ((line = fr.readLine()) != null) {
                content.append(line + "\n");
            }
            fr.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return content.toString();
    }
}

