/*
 * Decompiled with CFR 0.152.
 */
package didefom.DKASimulation;

import didefom.DKASimulation.Rule;
import didefom.DKASimulation.State;
import didefom.DKASimulation.StepEnum;
import didefom.DKASimulation.VisualAutomat;
import java.util.HashSet;
import java.util.List;

public class StepVisualAutomata
extends VisualAutomat {
    private StepState stepState = new StepState();

    public int ReadNextChar() {
        int ret = -1;
        if (this.m_string.length() > 0) {
            ret = this.m_string.charAt(0);
        }
        return ret;
    }

    @Override
    public void Step() {
        int c;
        HashSet<Rule> rules = new HashSet<Rule>();
        HashSet<Rule> oldActiveRules = new HashSet<Rule>();
        HashSet<State> oldActiveStates = new HashSet<State>();
        HashSet<State> activeStates = new HashSet<State>();
        this.GetActiveStates(oldActiveStates);
        this.GetActiveRules(oldActiveRules);
        this.ClearRulesActivity();
        if (this.stepState.toDo()) {
            c = this.GetNextChar();
            if (c == -1) {
                return;
            }
            for (State s : oldActiveStates) {
                s.SetActive(false);
                rules.clear();
                this.GetNextRules(s, rules);
                for (Rule r : rules) {
                    if (!r.IsChar((char)c) || r.IsEpsilon()) continue;
                    r.SetActive(true);
                    activeStates.add(r.GetDest());
                }
            }
            this.ActivateEpsilonStates(activeStates);
        }
        if (this.stepState.toChoose()) {
            c = this.ReadNextChar();
            if (c == -1) {
                return;
            }
            for (State s : oldActiveStates) {
                s.SetActive(false);
                rules.clear();
                this.GetNextRules(s, rules);
                for (Rule r : rules) {
                    if (!r.IsEpsilon()) {
                        this.DeActivateEpsilonRulesToThisState(s);
                    }
                    if (!r.IsChar((char)c) || r.IsEpsilon()) continue;
                    activeStates.add(s);
                    r.SetActive(true);
                }
            }
            this.ActivateEpsilonStates(activeStates);
        }
        this.stepState.next();
    }

    private void DeActivateEpsilonRulesToThisState(State s) {
        List<Rule> rules = this.GetRules();
        State actual = s;
        for (Rule r : rules) {
            if (r.GetDest() != actual || !r.IsEpsilon() || !r.IsActive()) continue;
            r.SetActive(false);
            r.GetSrc().SetActive(false);
            this.DeActivateEpsilonRulesToThisState(r.GetSrc());
        }
    }

    @Override
    public void Reset() {
        super.Reset();
        this.stepState.init();
    }

    public class StepState {
        private StepEnum actualState = StepEnum.CHOOSE_TRANSITION;

        public void init() {
            this.actualState = StepEnum.CHOOSE_TRANSITION;
        }

        public StepEnum getNext() {
            switch (this.actualState) {
                case INIT: {
                    return StepEnum.CHOOSE_TRANSITION;
                }
                case CHOOSE_TRANSITION: {
                    return StepEnum.DO_TRANSITION;
                }
                case DO_TRANSITION: {
                    return StepEnum.CHOOSE_TRANSITION;
                }
            }
            return StepEnum.INIT;
        }

        public StepEnum next() {
            this.actualState = this.getNext();
            return this.actualState;
        }

        public boolean toChoose() {
            return this.actualState == StepEnum.CHOOSE_TRANSITION;
        }

        public boolean toDo() {
            return this.actualState == StepEnum.DO_TRANSITION;
        }
    }
}

