/*
 * Decompiled with CFR 0.152.
 */
package didefom.DKASimulation;

import didefom.DKASimulation.Rule;
import didefom.DKASimulation.State;
import didefom.DKASimulation.VisualState;
import didefom.common.Epsilon;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;

public class VisualRule
extends Rule {
    protected ArrayList<Point> m_points = new ArrayList();
    protected ArrayList<Boolean> bSelectedPoint = new ArrayList();
    private Font m_font;
    protected Point m_offset = new Point(0, 0);
    protected int w;
    protected int h;
    private BasicStroke m_lineStroke;
    protected boolean bTextSelected = false;

    public VisualRule() {
        this.setFont(new Font("SansSerif", 1, 16));
        this.m_lineStroke = new BasicStroke(2.0f, 0, 0);
    }

    public VisualRule(State src, State dst, SortedSet<Character> c) {
        super(src, dst, c);
    }

    public VisualRule(State src, State dst, SortedSet<Character> c, List<Point> pts) {
        super(src, dst, c);
        this.SetPoints(pts);
    }

    public void SetPoints(List<Point> pts) {
        this.m_points = new ArrayList();
        this.bSelectedPoint = new ArrayList();
        for (Point pt : pts) {
            this.m_points.add((Point)pt.clone());
            this.bSelectedPoint.add(false);
        }
    }

    public void Draw(Graphics2D g) {
        Point end2;
        VisualState src = (VisualState)this.GetSrc();
        VisualState dst = (VisualState)this.GetDest();
        g.setStroke(this.m_lineStroke);
        Point start = this.m_points.size() != 0 ? src.GetNearestSurfacePoint(this.m_points.iterator().next()) : src.GetNearestSurfacePoint(dst.GetPos());
        Color paint = Color.black;
        if (this.IsActive()) {
            paint = Color.red;
        }
        if (this.bTextSelected) {
            paint = Color.green;
        }
        g.setPaint(paint);
        int ind = 0;
        for (Point end2 : this.m_points) {
            g.drawLine(start.x, start.y, end2.x, end2.y);
            if (this.bSelectedPoint.get(ind).booleanValue()) {
                g.setPaint(Color.green);
            }
            g.drawRect(end2.x - 2, end2.y - 2, 5, 5);
            g.setPaint(paint);
            start = end2;
            ++ind;
        }
        end2 = this.m_points.size() != 0 ? dst.GetNearestSurfacePoint(start) : dst.GetNearestSurfacePoint(src.GetPos());
        g.drawLine(start.x, start.y, end2.x, end2.y);
        Point vec = new Point(start.x - end2.x, start.y - end2.y);
        double len = Math.sqrt((double)vec.x * (double)vec.x + (double)(vec.y * vec.y)) / (double)this.getLineWidth() * 2.0;
        if (len > 0.0) {
            double arrow_size = 10.0;
            double arrow_angle = 0.39269908169872414;
            double dx = arrow_size * (double)vec.x / len;
            double dy = arrow_size * (double)vec.y / len;
            double px = dx * Math.cos(arrow_angle) + dy * Math.sin(arrow_angle);
            double py = -dx * Math.sin(arrow_angle) + dy * Math.cos(arrow_angle);
            g.drawLine(end2.x, end2.y, (int)((double)end2.x + px), (int)((double)end2.y + py));
            px = dx * Math.cos(-arrow_angle) + dy * Math.sin(-arrow_angle);
            py = -dx * Math.sin(-arrow_angle) + dy * Math.cos(-arrow_angle);
            g.drawLine(end2.x, end2.y, (int)((double)end2.x + px), (int)((double)end2.y + py));
        }
        String text = this.IsEpsilon() ? Epsilon.unicode() : this.GetString();
        FontRenderContext frc = g.getFontRenderContext();
        TextLayout layout = new TextLayout(text, this.getFont(), frc);
        Rectangle2D r = layout.getBounds();
        this.w = (int)r.getWidth();
        this.h = (int)r.getHeight();
        g.setPaint(paint);
        if (this.m_points.size() != 0) {
            Iterator<Point> i = this.m_points.iterator();
            start = src.GetNearestSurfacePoint(i.next());
        } else {
            start = src.GetNearestSurfacePoint(dst.GetPos());
        }
        layout.draw(g, start.x + this.GetTextOffset().x, start.y + this.GetTextOffset().y + this.h);
        g.setPaint(Color.black);
    }

    static float distance(Point start, Point end, Point pt) {
        Point Intersection = new Point();
        Point pom = new Point(start.x - end.x, start.y - end.y);
        float LineMag = (float)Math.sqrt((double)pom.x * (double)pom.x + (double)(pom.y * pom.y));
        if (LineMag == 0.0f) {
            return 0.0f;
        }
        float U = (float)((pt.x - start.x) * (end.x - start.x) + (pt.y - start.y) * (end.y - start.y)) / (LineMag * LineMag);
        if (U < 0.0f || U > 1.0f) {
            return 1000.0f;
        }
        Intersection.x = start.x + (int)(U * (float)(end.x - start.x));
        Intersection.y = start.y + (int)(U * (float)(end.y - start.y));
        pom.x = Intersection.x - pt.x;
        pom.y = Intersection.y - pt.y;
        return (float)Math.sqrt((double)pom.x * (double)pom.x + (double)(pom.y * pom.y));
    }

    public List<Point> GetPoints() {
        return this.m_points;
    }

    public int GetPointsSize() {
        return this.m_points.size();
    }

    public boolean IsHit(Point pt) {
        Point end2;
        VisualState src = (VisualState)this.GetSrc();
        VisualState dst = (VisualState)this.GetDest();
        Point start = this.m_points.size() != 0 ? src.GetNearestSurfacePoint(this.m_points.iterator().next()) : src.GetNearestSurfacePoint(dst.GetPos());
        for (Point end2 : this.m_points) {
            if (VisualRule.distance(start, end2, pt) < 3.0f) {
                return true;
            }
            start = end2;
        }
        end2 = this.m_points.size() != 0 ? dst.GetNearestSurfacePoint(start) : dst.GetNearestSurfacePoint(src.GetPos());
        return VisualRule.distance(start, end2, pt) < 3.0f;
    }

    public int IsPointHit(Point pt) {
        int counter = 0;
        for (Point point : this.m_points) {
            if (pt.x >= point.x - 2 && pt.x <= point.x + 2 && pt.y >= point.y - 2 && pt.y <= point.y + 2) {
                return counter;
            }
            ++counter;
        }
        return -1;
    }

    public boolean IsTextHit(Point pt) {
        VisualState src = (VisualState)this.GetSrc();
        VisualState dst = (VisualState)this.GetDest();
        Point pos = this.m_points.size() != 0 ? src.GetNearestSurfacePoint(this.m_points.iterator().next()) : src.GetNearestSurfacePoint(dst.GetPos());
        int px = pos.x + this.GetTextOffset().x;
        int py = pos.y + this.GetTextOffset().y;
        return pt.x >= px && pt.x <= px + this.w && pt.y >= py && pt.y <= py + this.h;
    }

    public void DeletePointAt(Point pt) {
        if (this.GetSrc() == this.GetDest() && this.m_points.size() <= 2) {
            return;
        }
        int counter = 0;
        Iterator<Point> j = this.m_points.iterator();
        while (j.hasNext()) {
            Point point = j.next();
            if (pt.x > point.x - 2 && pt.x < point.x + 2 && pt.y > point.y - 2 && pt.y < point.y + 2) {
                j.remove();
                this.bSelectedPoint.remove(counter);
                return;
            }
            ++counter;
        }
    }

    public void DeletePoint(int index) {
        if (index >= this.bSelectedPoint.size()) {
            return;
        }
        this.m_points.remove(index);
        this.bSelectedPoint.remove(index);
    }

    public void InsertPointAt(Point pt) {
        Point end2;
        VisualState src = (VisualState)this.GetSrc();
        VisualState dst = (VisualState)this.GetDest();
        Point start = this.m_points.size() != 0 ? src.GetNearestSurfacePoint(this.m_points.iterator().next()) : src.GetNearestSurfacePoint(dst.GetPos());
        int count = 0;
        for (Point end2 : this.m_points) {
            if (VisualRule.distance(start, end2, pt) < 3.0f) {
                this.m_points.add(count, pt);
                this.bSelectedPoint.add(count, false);
                break;
            }
            start = end2;
            ++count;
        }
        if (VisualRule.distance(start, end2 = this.m_points.size() != 0 ? dst.GetNearestSurfacePoint(start) : dst.GetNearestSurfacePoint(src.GetPos()), pt) < 3.0f) {
            this.m_points.add(count, pt);
            this.bSelectedPoint.add(count, false);
        }
    }

    public void SetTextOffset(Point pt) {
        this.m_offset = (Point)pt.clone();
    }

    public Point GetTextOffset() {
        return (Point)this.m_offset.clone();
    }

    public void SetTextSelect(boolean sel) {
        this.bTextSelected = sel;
    }

    public boolean GetTextSelect() {
        return this.bTextSelected;
    }

    public void SetPointSelect(int index, boolean sel) {
        if (index < 0 || index >= this.bSelectedPoint.size()) {
            return;
        }
        this.bSelectedPoint.set(index, sel);
    }

    public boolean GetPointSelect(int index) {
        if (index < 0 || index >= this.bSelectedPoint.size()) {
            return false;
        }
        return this.bSelectedPoint.get(index);
    }

    public void MoveBy(int x, int y) {
        for (Point pt : this.m_points) {
            pt.x += x;
            pt.y += y;
        }
    }

    public Font getFont() {
        return this.m_font;
    }

    public void setFont(Font m_font) {
        this.m_font = m_font;
    }

    public void setLineWidth(int lineWidth) {
        this.m_lineStroke = new BasicStroke(lineWidth, 0, 0);
    }

    public int getLineWidth() {
        return this.m_lineStroke != null ? (int)this.m_lineStroke.getLineWidth() : 0;
    }

    public String toString() {
        return super.toString() + ": " + this.GetSrc().GetText() + this.GetString() + "->" + this.GetDest().GetText();
    }
}

