/*
 * Decompiled with CFR 0.152.
 */
package didefom.common;

import com.thoughtworks.xstream.XStream;
import didefom.common.Epsilon;
import didefom.common.Nonterminal;
import didefom.common.Symbol;
import didefom.common.TermNontermString;
import didefom.common.Terminal;
import didefom.common.XMLSerializable;
import java.util.ArrayList;

public class Rule
implements XMLSerializable {
    private TermNontermString leftHandSide = new TermNontermString();
    private TermNontermString rightHandSide = new TermNontermString();
    private ArrayList<Terminal> predictSet = new ArrayList();
    boolean correctRule = true;

    public Rule() {
    }

    public Rule(String _ruleString, ArrayList<Terminal> setOfTerminals, ArrayList<Nonterminal> setOfNonterminals, Epsilon setOfEpsilon) {
        Nonterminal nonAdd = null;
        Terminal termAdd = null;
        String token = this.getToken(_ruleString);
        _ruleString = this.cutToken(_ruleString);
        if (token == null || !this.isNonterminal(token)) {
            this.correctRule = false;
            return;
        }
        nonAdd = this.existsSymbolN(setOfNonterminals, token);
        if (nonAdd == null) {
            nonAdd = new Nonterminal(token);
            setOfNonterminals.add(nonAdd);
        }
        this.leftHandSide.add(nonAdd);
        int rightSideNum = 0;
        while ((token = this.getToken(_ruleString)) != null) {
            _ruleString = this.cutToken(_ruleString);
            if (this.isEpsilon(token)) {
                if (setOfEpsilon == null) {
                    setOfEpsilon = new Epsilon(token);
                }
                this.rightHandSide.add(setOfEpsilon);
            } else if (this.isNonterminal(token)) {
                nonAdd = this.existsSymbolN(setOfNonterminals, token);
                if (nonAdd == null) {
                    nonAdd = new Nonterminal(token);
                    setOfNonterminals.add(nonAdd);
                }
                this.rightHandSide.add(nonAdd);
            } else {
                termAdd = this.existsSymbolT(setOfTerminals, token);
                if (termAdd == null) {
                    termAdd = new Terminal(token);
                    setOfTerminals.add(termAdd);
                }
                this.rightHandSide.add(termAdd);
            }
            ++rightSideNum;
        }
        if (rightSideNum == 0) {
            this.correctRule = false;
        }
    }

    public String getToken(String sent) {
        char actual;
        int i;
        for (i = 0; i < sent.length() && (sent.charAt(i) == ' ' || sent.charAt(i) == '\u2192'); ++i) {
        }
        if (sent.length() == i) {
            return null;
        }
        String parsed = new String("");
        while (i < sent.length() && (actual = sent.charAt(i)) != ' ' && actual != '\u2192') {
            parsed = parsed + actual;
            ++i;
        }
        return parsed;
    }

    public String cutToken(String sent) {
        char actual;
        int i;
        for (i = 0; i < sent.length() && (sent.charAt(i) == ' ' || sent.charAt(i) == '\u2192'); ++i) {
        }
        if (sent.length() == i) {
            return null;
        }
        while (i < sent.length() && (actual = sent.charAt(i)) != ' ' && actual != '\u2192') {
            ++i;
        }
        sent = sent.substring(i);
        return sent;
    }

    public boolean isNonterminal(String str) {
        return str.charAt(0) >= 'A' && str.charAt(0) <= 'Z';
    }

    public boolean isEpsilon(String str) {
        return str.length() == 1 && str.charAt(0) == '\u03b5';
    }

    public boolean isCorrect() {
        return this.correctRule;
    }

    public Nonterminal existsSymbolN(ArrayList<Nonterminal> terminalNonterminalString, String _symbol) {
        for (Nonterminal symb : terminalNonterminalString) {
            if (symb.getSymbol().compareTo(_symbol) != 0) continue;
            return symb;
        }
        return null;
    }

    public Terminal existsSymbolT(ArrayList<Terminal> terminalTerminalString, String _symbol) {
        for (Terminal symb : terminalTerminalString) {
            if (symb.getSymbol().compareTo(_symbol) != 0) continue;
            return symb;
        }
        return null;
    }

    public TermNontermString getLeftSide() {
        return this.leftHandSide;
    }

    public TermNontermString getRightSide() {
        return this.rightHandSide;
    }

    public String getRule() {
        String text = new String();
        for (Symbol symb : this.leftHandSide.getSymbols()) {
            text = text + symb.getSymbol();
        }
        text = text + '\u2192';
        for (Symbol symb : this.rightHandSide.getSymbols()) {
            text = text + symb.getSymbol() + " ";
        }
        return text;
    }

    public String getUnicodeRule() {
        String text = new String();
        for (Symbol symb : this.leftHandSide.getSymbols()) {
            text = text + symb.getUnicodeSymbol();
        }
        text = text + '\u2192';
        for (Symbol symb : this.rightHandSide.getSymbols()) {
            text = text + symb.getUnicodeSymbol() + " ";
        }
        return text;
    }

    public void resetPredictSet() {
        this.predictSet.clear();
    }

    public void addToPredictSet(Terminal terminal) {
        if (!this.predictSet.contains(terminal)) {
            this.predictSet.add(terminal);
        }
    }

    public ArrayList<Terminal> getPredictSet() {
        return (ArrayList)this.predictSet.clone();
    }

    public void addSetToPredictSet(ArrayList<Terminal> terminals) {
        for (Terminal symb : terminals) {
            this.addToPredictSet(symb);
        }
    }

    @Override
    public void setAliases(XStream xs) {
    }

    public boolean isEqual(Rule rule) {
        if (this.getRule().equals(rule.getRule())) {
            return true;
        }
        return this.getRightSide().isEqual(rule.getRightSide()) && this.getLeftSide().isEqual(rule.getLeftSide());
    }

    public void reduceEpsilon() {
        this.rightHandSide = this.getRightSide().reduceEpsilon();
    }
}

