/*
 * Decompiled with CFR 0.152.
 */
package didefom.DKASimulation;

import didefom.DKASimulation.MainFrame;
import didefom.DKASimulation.VisualRule;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class RuleWindow
extends JDialog
implements ActionListener {
    JLabel m_title;
    JTextField m_text;
    JCheckBox m_isEpsilon;
    JCheckBox m_isActive;
    JButton m_ok;
    JButton m_storno;
    JLabel m_activeLabel;
    JLabel m_epsilonLabel;
    VisualRule m_pRule = null;
    MainFrame m_parent;
    private boolean m_snapToMainWindow = false;

    public RuleWindow(MainFrame parent) {
        super(parent.isApplet() ? null : (JFrame)JFrame.class.cast(parent), ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("RuleWindowTitle"), false);
        this.setSize(200, 180);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        this.m_title = new JLabel(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("RuleWindowCharacters"));
        this.m_title.setAlignmentX(0.0f);
        panel.add(this.m_title);
        this.m_text = new JTextField();
        panel.add(this.m_text);
        this.m_epsilonLabel = new JLabel(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("RuleWindowEpsilon"));
        panel.add(this.m_epsilonLabel);
        this.m_isEpsilon = new JCheckBox();
        panel.add(this.m_isEpsilon);
        this.m_activeLabel = new JLabel(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("RuleWindowActive"));
        panel.add(this.m_activeLabel);
        this.m_isActive = new JCheckBox();
        panel.add(this.m_isActive);
        JPanel btnpanel = new JPanel();
        btnpanel.setLayout(new BoxLayout(btnpanel, 2));
        btnpanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        btnpanel.add(Box.createHorizontalGlue());
        this.m_ok = new JButton(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("OK"));
        this.m_ok.addActionListener(this);
        btnpanel.add(this.m_ok);
        btnpanel.add(Box.createRigidArea(new Dimension(10, 0)));
        this.m_storno = new JButton(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("Cancel"));
        this.m_storno.addActionListener(this);
        btnpanel.add(this.m_storno);
        this.getContentPane().add((Component)panel, "Center");
        this.getContentPane().add((Component)btnpanel, "Last");
        this.m_parent = parent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_ok) {
            if (this.m_pRule != null) {
                this.m_pRule.SetString(this.m_text.getText());
                this.m_pRule.SetEpsilon(this.m_isEpsilon.isSelected());
                this.m_pRule.SetActive(this.m_isActive.isSelected());
            }
            this.m_parent.RefreshView();
            this.setVisible(false);
        } else if (e.getSource() == this.m_storno) {
            this.m_pRule = null;
            this.setVisible(false);
        }
    }

    public void SetRule(VisualRule r) {
        if (this.m_pRule != null) {
            this.m_pRule.SetString(this.m_text.getText());
            this.m_pRule.SetEpsilon(this.m_isEpsilon.isSelected());
            this.m_pRule.SetActive(this.m_isActive.isSelected());
        }
        this.m_pRule = r;
        if (r != null) {
            this.m_text.setText(r.GetString());
            this.m_isEpsilon.setSelected(r.IsEpsilon());
            this.m_isActive.setSelected(r.IsActive());
        } else {
            this.m_text.setText("");
            this.m_isEpsilon.setSelected(false);
            this.m_isActive.setSelected(false);
        }
    }

    public void UpdateLabels() {
        this.setTitle(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("RuleWindowTitle"));
        this.m_title.setText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("RuleWindowCharacters"));
        this.m_epsilonLabel.setText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("RuleWindowEpsilon"));
        this.m_activeLabel.setText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("RuleWindowActive"));
        this.m_ok.setText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("OK"));
        this.m_storno.setText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("Cancel"));
    }

    @Override
    public void setVisible(boolean b) {
        if (b && this.snapToMainWindow()) {
            Point pt = this.getParent().getLocation();
            this.setLocation(pt.x + this.getParent().getWidth(), pt.y + this.getParent().getHeight() / 2 - this.getHeight() / 2);
        }
        super.setVisible(b);
    }

    public boolean snapToMainWindow() {
        return this.m_snapToMainWindow;
    }

    public void setSnappingToMainWindow(boolean m_snapToMainWindow) {
        this.m_snapToMainWindow = m_snapToMainWindow;
    }
}

