/*
 * Decompiled with CFR 0.152.
 */
package didefom.DKASimulation;

import didefom.DKASimulation.MainFrame;
import didefom.DKASimulation.Rule;
import didefom.DKASimulation.State;
import didefom.DKASimulation.VisualAutomat;
import didefom.DKASimulation.VisualRule;
import didefom.DKASimulation.VisualState;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;

public class View
extends JComponent
implements MouseListener,
MouseMotionListener,
KeyListener {
    private VisualAutomat m_automat;
    private MainFrame m_parent;
    private boolean m_bDragging = false;
    private List<Point> m_pt_list = new LinkedList<Point>();
    VisualState firststate = null;
    Point mousepos = new Point();
    private Dimension preferredSize = new Dimension(0, 0);
    private Point mm_point = null;

    View(MainFrame parent) {
        this.m_parent = parent;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
    }

    public VisualAutomat GetAutomat() {
        return this.m_automat;
    }

    public void SetAutomat(VisualAutomat a) {
        this.m_automat = a;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        Color old = g.getColor();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.getParent().getWidth(), this.getParent().getHeight());
        g.setColor(old);
        if (this.firststate != null) {
            Point pt = this.firststate.GetPos();
            for (Point pt2 : this.m_pt_list) {
                g.drawLine(pt.x, pt.y, pt2.x, pt2.y);
                pt = pt2;
            }
            g.drawLine(pt.x, pt.y, this.mousepos.x, this.mousepos.y);
        }
        this.m_automat.Draw(g2d);
        g2d.dispose();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.m_automat == null) {
            return;
        }
        this.requestFocusInWindow();
        if (e.getClickCount() == 2) {
            this.mouseDoubleClicked(e);
            return;
        }
    }

    public void mouseDoubleClicked(MouseEvent event) {
        if (this.m_automat == null) {
            return;
        }
        Point pos = event.getPoint();
        List<Rule> rules = this.m_automat.GetRules();
        for (VisualRule visualRule : rules) {
            int hit = visualRule.IsPointHit(pos);
            if (hit < 0) continue;
            visualRule.DeletePointAt(pos);
            this.repaint();
            return;
        }
        for (VisualRule visualRule : rules) {
            if (visualRule.IsHit(pos)) {
                visualRule.InsertPointAt(pos);
                this.repaint();
                return;
            }
            if (!visualRule.IsTextHit(pos)) continue;
            this.m_parent.ToggleRule();
            return;
        }
        VisualState visualState = this.m_automat.GetStateAt(pos);
        if (visualState == null) {
            this.m_automat.AddState(pos, "Stav");
            this.repaint();
        } else {
            this.m_parent.ToggleState();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        boolean bShift;
        if (this.m_automat == null) {
            return;
        }
        this.requestFocusInWindow();
        Point pos = e.getPoint();
        boolean bControl = (e.getModifiersEx() & 0x80) == 128;
        boolean bl = bShift = (e.getModifiersEx() & 0x40) == 64;
        if (!bShift && !this.m_bDragging) {
            this.m_automat.ClearSelection();
        }
        VisualState state = this.m_automat.GetStateAt(pos);
        if (bControl) {
            if (state != null && this.firststate == null) {
                this.firststate = state;
                this.m_pt_list.clear();
            } else if (state != null && this.firststate != null) {
                this.m_automat.AddRule(this.firststate, state, this.m_pt_list);
                this.firststate = null;
                this.m_pt_list.clear();
            } else if (state == null && this.firststate != null) {
                this.m_pt_list.add(pos);
            }
        } else {
            this.m_pt_list.clear();
            this.firststate = null;
        }
        List<Rule> rules = this.m_automat.GetRules();
        for (VisualRule visualRule : rules) {
            if (visualRule.IsTextHit(pos)) {
                visualRule.SetTextSelect(true);
                this.m_parent.SelectRule(visualRule);
                this.repaint();
                return;
            }
            this.m_parent.SelectRule(null);
            int hit = visualRule.IsPointHit(pos);
            if (hit < 0) continue;
            visualRule.SetPointSelect(hit, true);
        }
        if (!bControl && state != null) {
            state.SetSelect(true);
            this.m_parent.SelectState(state);
        } else if (!bControl && state == null) {
            this.m_parent.SelectState(null);
        }
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.m_bDragging = true;
        if (this.mm_point == null) {
            this.mm_point = e.getPoint();
        }
        Point point = this.mm_point;
        List<State> states = this.m_automat.GetStates();
        Point delta = new Point(e.getPoint().x - point.x, e.getPoint().y - point.y);
        for (VisualState visualState : states) {
            if (!visualState.isSelected()) continue;
            visualState.SetPos(new Point(visualState.GetPos().x + delta.x, visualState.GetPos().y + delta.y));
        }
        List<Rule> rules = this.m_automat.GetRules();
        for (VisualRule visualRule : rules) {
            if (visualRule.GetTextSelect()) {
                visualRule.SetTextOffset(new Point(visualRule.GetTextOffset().x + delta.x, visualRule.GetTextOffset().y + delta.y));
            }
            List<Point> points = visualRule.GetPoints();
            int index = 0;
            for (Point pt : points) {
                if (visualRule.GetPointSelect(index)) {
                    pt.x += delta.x;
                    pt.y += delta.y;
                }
                ++index;
            }
        }
        this.mm_point = e.getPoint();
        this.updatePreferredSize();
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.mousepos = e.getPoint();
        this.m_bDragging = false;
        this.mm_point = e.getPoint();
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (e.getKeyChar() == '\u007f') {
            LinkedList<VisualRule> rules_to_delete = new LinkedList<VisualRule>();
            List<Rule> rules = this.m_automat.GetRules();
            for (VisualRule visualRule : rules) {
                for (int j = 0; j < visualRule.GetPointsSize(); ++j) {
                    if (!visualRule.GetPointSelect(j)) continue;
                    visualRule.DeletePoint(j);
                    --j;
                }
                if (!visualRule.GetTextSelect()) continue;
                rules_to_delete.add(visualRule);
            }
            LinkedList<VisualState> states_to_delete = new LinkedList<VisualState>();
            List<State> states = this.m_automat.GetStates();
            for (VisualState visualState : states) {
                if (!visualState.isSelected()) continue;
                states_to_delete.add(visualState);
            }
            Iterator<Rule> i = rules_to_delete.iterator();
            while (i.hasNext()) {
                this.m_automat.DeleteRule((VisualRule)i.next());
            }
            Iterator iterator = states_to_delete.iterator();
            while (iterator.hasNext()) {
                this.m_automat.DeleteState((VisualState)iterator.next());
            }
            this.repaint();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    private void updatePreferredSize() {
        int yoff;
        int l = 0;
        int r = 0;
        int t = 0;
        int b = 0;
        for (State s : this.m_automat.GetStates()) {
            VisualState vs = (VisualState)s;
            Point pt = vs.GetPos();
            if (pt.x - vs.GetWidth() < l) {
                l = pt.x - vs.GetWidth();
            }
            if (pt.x + vs.GetWidth() > r) {
                r = pt.x + vs.GetWidth();
            }
            if (pt.y - vs.GetHeight() < t) {
                t = pt.y - vs.GetHeight();
            }
            if (pt.y + vs.GetHeight() <= b) continue;
            b = pt.y + vs.GetHeight();
        }
        int xoff = l < 0 ? -l : 0;
        int n = yoff = t < 0 ? -t : 0;
        if (xoff > 0 || yoff > 0) {
            for (State s : this.m_automat.GetStates()) {
                VisualState vs = (VisualState)s;
                vs.MoveBy(xoff, yoff);
            }
            for (Rule m : this.m_automat.GetRules()) {
                VisualRule vr = (VisualRule)m;
                vr.MoveBy(xoff, yoff);
            }
        }
        this.preferredSize = new Dimension(r, b);
        this.revalidate();
    }
}

