/*
 * Decompiled with CFR 0.152.
 */
package didefom.DKASimulation;

import didefom.DKASimulation.State;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;

public class VisualState
extends State {
    int m_a;
    int m_b;
    private boolean bSelected;
    private BasicStroke m_lineStroke;
    private Font m_font;
    Point m_pos = new Point();

    public VisualState() {
        this.SetSelect(false);
        this.m_font = new Font("SansSerif", 1, 16);
        this.m_lineStroke = new BasicStroke(2.0f, 0, 0);
    }

    public void Draw(Graphics2D g) {
        Ellipse2D.Float ellipse;
        String text = this.GetText();
        if (text.length() == 0) {
            text = "null";
        }
        g.setFont(this.m_font);
        g.setStroke(this.m_lineStroke);
        FontRenderContext frc = g.getFontRenderContext();
        TextLayout layout = new TextLayout(text, this.m_font, frc);
        Rectangle2D bounds = layout.getBounds();
        float lw = this.m_lineStroke.getLineWidth();
        int w = (int)(bounds.getWidth() * 1.1 + (double)(2.0f * lw));
        int h = (int)(bounds.getHeight() * 1.1 + (double)(2.0f * lw));
        int ilw = (int)lw;
        this.m_a = (int)(Math.sqrt(2.0) * (double)w) / 2 + 2;
        this.m_b = (int)(Math.sqrt(2.0) * (double)h) / 2 + 2;
        if (this.m_a < this.m_b) {
            this.m_a = this.m_b;
        }
        if (this.IsActive()) {
            g.setPaint(Color.red);
        }
        if (this.isSelected()) {
            g.setPaint(Color.green);
        }
        if (this.IsFinal()) {
            ellipse = new Ellipse2D.Float(this.m_pos.x - this.m_a - 2 * ilw, this.m_pos.y - this.m_b - 2 * ilw, this.m_a * 2 + 4 * ilw, this.m_b * 2 + 4 * ilw);
            g.draw(ellipse);
        }
        ellipse = new Ellipse2D.Float(this.m_pos.x - this.m_a, this.m_pos.y - this.m_b, this.m_a * 2, this.m_b * 2);
        g.draw(ellipse);
        if (this.IsFirst()) {
            Point pt = this.GetNearestSurfacePoint(new Point(this.m_pos.x - this.m_a, this.m_pos.y - this.m_a));
            g.drawLine(pt.x - 10, pt.y - 10, pt.x, pt.y);
        }
        layout.draw(g, this.m_pos.x - w / 2 + ilw, this.m_pos.y + h / 2 - ilw);
        g.setPaint(Color.black);
    }

    public boolean IsHit(Point p) {
        Point pt = this.GetPos();
        float px = p.x;
        float sx = pt.x;
        float py = p.y;
        float sy = pt.y;
        return (px - sx) * (px - sx) / (float)(this.m_a * this.m_a) + (py - sy) * (py - sy) / (float)(this.m_b * this.m_b) <= 1.0f;
    }

    public void SetPos(Point pt) {
        this.m_pos = (Point)pt.clone();
    }

    public Point GetPos() {
        return (Point)this.m_pos.clone();
    }

    Point GetNearestSurfacePoint(Point pt) {
        Point center = this.GetPos();
        if (center == null) {
            return null;
        }
        float a = this.m_a;
        float b = this.m_b;
        float s = pt.x - center.x;
        float t = pt.y - center.y;
        float x = a * b * s / (float)Math.sqrt(a * a * t * t + b * b * s * s);
        float y = a * b * t / (float)Math.sqrt(a * a * t * t + b * b * s * s);
        if (x * s < 0.0f) {
            x = -x;
        }
        if (y * t < 0.0f) {
            y = -y;
        }
        return new Point((int)x + center.x, (int)y + center.y);
    }

    public void SetSelect(boolean sel) {
        this.bSelected = sel;
    }

    public boolean isSelected() {
        return this.bSelected;
    }

    public int GetWidth() {
        return this.m_a;
    }

    public int GetHeight() {
        return this.m_b;
    }

    public void MoveBy(int x, int y) {
        this.m_pos.x += x;
        this.m_pos.y += y;
    }

    public BasicStroke getLineStroke() {
        return this.m_lineStroke;
    }

    public void setLineStroke(BasicStroke m_lineStroke) {
        this.m_lineStroke = m_lineStroke;
    }

    public Font getFont() {
        return this.m_font;
    }

    public void setFont(Font m_font) {
        this.m_font = m_font;
    }

    void setLineWidth(int lineWidth) {
        this.m_lineStroke = new BasicStroke(lineWidth, 0, 0);
    }

    public String toString() {
        return this.GetText() + "_" + super.toString();
    }
}

