/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.base;

import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.MutableInterval;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public abstract class AbstractInterval
implements ReadableInterval {
    protected AbstractInterval() {
    }

    protected void checkInterval(long start, long end) {
        if (end < start) {
            throw new IllegalArgumentException("The end instant must be greater or equal to the start");
        }
    }

    public DateTime getStart() {
        return new DateTime(this.getStartMillis(), this.getChronology());
    }

    public DateTime getEnd() {
        return new DateTime(this.getEndMillis(), this.getChronology());
    }

    public boolean contains(long millisInstant) {
        long thisStart = this.getStartMillis();
        long thisEnd = this.getEndMillis();
        return millisInstant >= thisStart && millisInstant < thisEnd;
    }

    public boolean containsNow() {
        return this.contains(DateTimeUtils.currentTimeMillis());
    }

    public boolean contains(ReadableInstant instant) {
        if (instant == null) {
            return this.containsNow();
        }
        return this.contains(instant.getMillis());
    }

    public boolean contains(ReadableInterval interval) {
        if (interval == null) {
            return this.containsNow();
        }
        long otherStart = interval.getStartMillis();
        long otherEnd = interval.getEndMillis();
        long thisStart = this.getStartMillis();
        long thisEnd = this.getEndMillis();
        return otherStart >= thisStart && otherStart < thisEnd && otherEnd <= thisEnd;
    }

    public boolean overlaps(ReadableInterval interval) {
        if (interval == null) {
            return this.containsNow();
        }
        long otherStart = interval.getStartMillis();
        long otherEnd = interval.getEndMillis();
        long thisStart = this.getStartMillis();
        long thisEnd = this.getEndMillis();
        return thisStart < otherEnd && otherStart < thisEnd;
    }

    public boolean isBefore(long millisInstant) {
        return this.getEndMillis() <= millisInstant;
    }

    public boolean isBeforeNow() {
        return this.isBefore(DateTimeUtils.currentTimeMillis());
    }

    public boolean isBefore(ReadableInstant instant) {
        if (instant == null) {
            return this.isBeforeNow();
        }
        return this.isBefore(instant.getMillis());
    }

    public boolean isBefore(ReadableInterval interval) {
        if (interval == null) {
            return this.isBeforeNow();
        }
        return this.isBefore(interval.getStartMillis());
    }

    public boolean isAfter(long millisInstant) {
        return this.getStartMillis() > millisInstant;
    }

    public boolean isAfterNow() {
        return this.isAfter(DateTimeUtils.currentTimeMillis());
    }

    public boolean isAfter(ReadableInstant instant) {
        if (instant == null) {
            return this.isAfterNow();
        }
        return this.isAfter(instant.getMillis());
    }

    public boolean isAfter(ReadableInterval interval) {
        long endMillis = interval == null ? DateTimeUtils.currentTimeMillis() : interval.getEndMillis();
        return this.getStartMillis() >= endMillis;
    }

    public Interval toInterval() {
        return new Interval(this.getStartMillis(), this.getEndMillis(), this.getChronology());
    }

    public MutableInterval toMutableInterval() {
        return new MutableInterval(this.getStartMillis(), this.getEndMillis(), this.getChronology());
    }

    public long toDurationMillis() {
        return FieldUtils.safeAdd(this.getEndMillis(), -this.getStartMillis());
    }

    public Duration toDuration() {
        long durMillis = this.toDurationMillis();
        if (durMillis == 0L) {
            return Duration.ZERO;
        }
        return new Duration(durMillis);
    }

    public Period toPeriod() {
        return new Period(this.getStartMillis(), this.getEndMillis(), this.getChronology());
    }

    public Period toPeriod(PeriodType type) {
        return new Period(this.getStartMillis(), this.getEndMillis(), type, this.getChronology());
    }

    public boolean equals(Object readableInterval) {
        if (this == readableInterval) {
            return true;
        }
        if (!(readableInterval instanceof ReadableInterval)) {
            return false;
        }
        ReadableInterval other = (ReadableInterval)readableInterval;
        return this.getStartMillis() == other.getStartMillis() && this.getEndMillis() == other.getEndMillis() && this.getChronology() == other.getChronology();
    }

    public int hashCode() {
        long start = this.getStartMillis();
        long end = this.getEndMillis();
        int result = 97;
        result = 31 * result + (int)(start ^ start >>> 32);
        result = 31 * result + (int)(end ^ end >>> 32);
        result = 31 * result + this.getChronology().hashCode();
        return result;
    }

    public String toString() {
        DateTimeFormatter printer = ISODateTimeFormat.dateHourMinuteSecondFraction();
        printer = printer.withChronology(this.getChronology());
        StringBuffer buf = new StringBuffer(48);
        printer.printTo(buf, this.getStartMillis());
        buf.append('/');
        printer.printTo(buf, this.getEndMillis());
        return buf.toString();
    }

    public abstract long getEndMillis();

    public abstract long getStartMillis();

    public abstract Chronology getChronology();
}

