/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationField;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.AssembledChronology;
import org.joda.time.chrono.GregorianChronology;
import org.joda.time.chrono.JulianChronology;
import org.joda.time.chrono.ZonedChronology;
import org.joda.time.field.BaseDateTimeField;
import org.joda.time.field.DecoratedDurationField;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class GJChronology
extends AssembledChronology {
    private static final long serialVersionUID = -2545574827706931671L;
    static final Instant DEFAULT_CUTOVER = new Instant(-12219292800000L);
    private static final Map cCache = new HashMap();
    private JulianChronology iJulianChronology;
    private GregorianChronology iGregorianChronology;
    private Instant iCutoverInstant;
    private long iCutoverMillis;
    private long iGapDuration;

    private static long convertByYear(long instant, Chronology from, Chronology to) {
        return to.getDateTimeMillis(from.year().get(instant), from.monthOfYear().get(instant), from.dayOfMonth().get(instant), from.millisOfDay().get(instant));
    }

    private static long convertByWeekyear(long instant, Chronology from, Chronology to) {
        long newInstant = to.weekyear().set(0L, from.weekyear().get(instant));
        newInstant = to.weekOfWeekyear().set(newInstant, from.weekOfWeekyear().get(instant));
        newInstant = to.dayOfWeek().set(newInstant, from.dayOfWeek().get(instant));
        newInstant = to.millisOfDay().set(newInstant, from.millisOfDay().get(instant));
        return newInstant;
    }

    public static GJChronology getInstanceUTC() {
        return GJChronology.getInstance(DateTimeZone.UTC, DEFAULT_CUTOVER, 4);
    }

    public static GJChronology getInstance() {
        return GJChronology.getInstance(DateTimeZone.getDefault(), DEFAULT_CUTOVER, 4);
    }

    public static GJChronology getInstance(DateTimeZone zone) {
        return GJChronology.getInstance(zone, DEFAULT_CUTOVER, 4);
    }

    public static GJChronology getInstance(DateTimeZone zone, ReadableInstant gregorianCutover) {
        return GJChronology.getInstance(zone, gregorianCutover, 4);
    }

    public static synchronized GJChronology getInstance(DateTimeZone zone, ReadableInstant gregorianCutover, int minDaysInFirstWeek) {
        GJChronology chrono;
        zone = DateTimeUtils.getZone(zone);
        Instant cutoverInstant = gregorianCutover == null ? DEFAULT_CUTOVER : gregorianCutover.toInstant();
        ArrayList<GJChronology> chronos = (ArrayList<GJChronology>)cCache.get(zone);
        if (chronos == null) {
            chronos = new ArrayList<GJChronology>(2);
            cCache.put(zone, chronos);
        } else {
            int i = chronos.size();
            while (--i >= 0) {
                chrono = (GJChronology)chronos.get(i);
                if (minDaysInFirstWeek != chrono.getMinimumDaysInFirstWeek() || !cutoverInstant.equals(chrono.getGregorianCutover())) continue;
                return chrono;
            }
        }
        if (zone == DateTimeZone.UTC) {
            chrono = new GJChronology(JulianChronology.getInstance(zone, minDaysInFirstWeek), GregorianChronology.getInstance(zone, minDaysInFirstWeek), cutoverInstant);
        } else {
            chrono = GJChronology.getInstance(DateTimeZone.UTC, cutoverInstant, minDaysInFirstWeek);
            chrono = new GJChronology(ZonedChronology.getInstance(chrono, zone), chrono.iJulianChronology, chrono.iGregorianChronology, chrono.iCutoverInstant);
        }
        chronos.add(chrono);
        return chrono;
    }

    public static GJChronology getInstance(DateTimeZone zone, long gregorianCutover, int minDaysInFirstWeek) {
        Instant cutoverInstant = gregorianCutover == DEFAULT_CUTOVER.getMillis() ? null : new Instant(gregorianCutover);
        return GJChronology.getInstance(zone, cutoverInstant, minDaysInFirstWeek);
    }

    private GJChronology(JulianChronology julian, GregorianChronology gregorian, Instant cutoverInstant) {
        super(null, new Object[]{julian, gregorian, cutoverInstant});
    }

    private GJChronology(Chronology base, JulianChronology julian, GregorianChronology gregorian, Instant cutoverInstant) {
        super(base, new Object[]{julian, gregorian, cutoverInstant});
    }

    private Object readResolve() {
        return GJChronology.getInstance(this.getZone(), this.iCutoverInstant, this.getMinimumDaysInFirstWeek());
    }

    public DateTimeZone getZone() {
        Chronology base = this.getBase();
        if (base != null) {
            return base.getZone();
        }
        return DateTimeZone.UTC;
    }

    public Chronology withUTC() {
        return this.withZone(DateTimeZone.UTC);
    }

    public Chronology withZone(DateTimeZone zone) {
        if (zone == null) {
            zone = DateTimeZone.getDefault();
        }
        if (zone == this.getZone()) {
            return this;
        }
        return GJChronology.getInstance(zone, this.iCutoverInstant, this.getMinimumDaysInFirstWeek());
    }

    public long getDateTimeMillis(int year, int monthOfYear, int dayOfMonth, int millisOfDay) throws IllegalArgumentException {
        Chronology base = this.getBase();
        if (base != null) {
            return base.getDateTimeMillis(year, monthOfYear, dayOfMonth, millisOfDay);
        }
        long instant = this.iGregorianChronology.getDateTimeMillis(year, monthOfYear, dayOfMonth, millisOfDay);
        if (instant < this.iCutoverMillis && (instant = this.iJulianChronology.getDateTimeMillis(year, monthOfYear, dayOfMonth, millisOfDay)) >= this.iCutoverMillis) {
            throw new IllegalArgumentException("Specified date does not exist");
        }
        return instant;
    }

    public long getDateTimeMillis(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond) throws IllegalArgumentException {
        Chronology base = this.getBase();
        if (base != null) {
            return base.getDateTimeMillis(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond);
        }
        long instant = this.iGregorianChronology.getDateTimeMillis(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond);
        if (instant < this.iCutoverMillis && (instant = this.iJulianChronology.getDateTimeMillis(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond)) >= this.iCutoverMillis) {
            throw new IllegalArgumentException("Specified date does not exist");
        }
        return instant;
    }

    public Instant getGregorianCutover() {
        return this.iCutoverInstant;
    }

    public int getMinimumDaysInFirstWeek() {
        return this.iGregorianChronology.getMinimumDaysInFirstWeek();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(60);
        sb.append("GJChronology");
        sb.append('[');
        sb.append(this.getZone().getID());
        if (this.iCutoverMillis != DEFAULT_CUTOVER.getMillis()) {
            sb.append(",cutover=");
            DateTimeFormatter printer = this.withUTC().dayOfYear().remainder(this.iCutoverMillis) == 0L ? ISODateTimeFormat.date() : ISODateTimeFormat.dateTime();
            printer.withChronology(this.withUTC()).printTo(sb, this.iCutoverMillis);
        }
        if (this.getMinimumDaysInFirstWeek() != 4) {
            sb.append(",mdfw=");
            sb.append(this.getMinimumDaysInFirstWeek());
        }
        sb.append(']');
        return sb.toString();
    }

    protected void assemble(AssembledChronology.Fields fields) {
        Object[] params = (Object[])this.getParam();
        JulianChronology julian = (JulianChronology)params[0];
        GregorianChronology gregorian = (GregorianChronology)params[1];
        Instant cutoverInstant = (Instant)params[2];
        this.iCutoverMillis = cutoverInstant.getMillis();
        this.iJulianChronology = julian;
        this.iGregorianChronology = gregorian;
        this.iCutoverInstant = cutoverInstant;
        if (this.getBase() != null) {
            return;
        }
        if (julian.getMinimumDaysInFirstWeek() != gregorian.getMinimumDaysInFirstWeek()) {
            throw new IllegalArgumentException();
        }
        this.iGapDuration = this.iCutoverMillis - this.julianToGregorianByYear(this.iCutoverMillis);
        fields.copyFieldsFrom(gregorian);
        if (gregorian.millisOfDay().get(this.iCutoverMillis) == 0) {
            fields.millisOfSecond = new CutoverField(julian.millisOfSecond(), fields.millisOfSecond, this.iCutoverMillis);
            fields.millisOfDay = new CutoverField(julian.millisOfDay(), fields.millisOfDay, this.iCutoverMillis);
            fields.secondOfMinute = new CutoverField(julian.secondOfMinute(), fields.secondOfMinute, this.iCutoverMillis);
            fields.secondOfDay = new CutoverField(julian.secondOfDay(), fields.secondOfDay, this.iCutoverMillis);
            fields.minuteOfHour = new CutoverField(julian.minuteOfHour(), fields.minuteOfHour, this.iCutoverMillis);
            fields.minuteOfDay = new CutoverField(julian.minuteOfDay(), fields.minuteOfDay, this.iCutoverMillis);
            fields.hourOfDay = new CutoverField(julian.hourOfDay(), fields.hourOfDay, this.iCutoverMillis);
            fields.hourOfHalfday = new CutoverField(julian.hourOfHalfday(), fields.hourOfHalfday, this.iCutoverMillis);
            fields.clockhourOfDay = new CutoverField(julian.clockhourOfDay(), fields.clockhourOfDay, this.iCutoverMillis);
            fields.clockhourOfHalfday = new CutoverField(julian.clockhourOfHalfday(), fields.clockhourOfHalfday, this.iCutoverMillis);
            fields.halfdayOfDay = new CutoverField(julian.halfdayOfDay(), fields.halfdayOfDay, this.iCutoverMillis);
        }
        fields.era = new CutoverField(julian.era(), fields.era, this.iCutoverMillis);
        long cutover = gregorian.year().roundCeiling(this.iCutoverMillis);
        fields.dayOfYear = new CutoverField(julian.dayOfYear(), fields.dayOfYear, cutover);
        cutover = gregorian.weekyear().roundCeiling(this.iCutoverMillis);
        fields.weekOfWeekyear = new CutoverField(julian.weekOfWeekyear(), fields.weekOfWeekyear, cutover, true);
        fields.year = new ImpreciseCutoverField(julian.year(), fields.year, this.iCutoverMillis);
        fields.years = fields.year.getDurationField();
        fields.yearOfEra = new ImpreciseCutoverField(julian.yearOfEra(), fields.yearOfEra, fields.years, this.iCutoverMillis);
        fields.yearOfCentury = new ImpreciseCutoverField(julian.yearOfCentury(), fields.yearOfCentury, fields.years, this.iCutoverMillis);
        fields.centuryOfEra = new ImpreciseCutoverField(julian.centuryOfEra(), fields.centuryOfEra, this.iCutoverMillis);
        fields.centuries = fields.centuryOfEra.getDurationField();
        fields.monthOfYear = new ImpreciseCutoverField(julian.monthOfYear(), fields.monthOfYear, this.iCutoverMillis);
        fields.months = fields.monthOfYear.getDurationField();
        fields.weekyear = new ImpreciseCutoverField(julian.weekyear(), fields.weekyear, null, this.iCutoverMillis, true);
        fields.weekyearOfCentury = new ImpreciseCutoverField(julian.weekyearOfCentury(), fields.weekyearOfCentury, fields.weekyears, this.iCutoverMillis);
        fields.weekyears = fields.weekyear.getDurationField();
        CutoverField cf = new CutoverField(julian.dayOfMonth(), fields.dayOfMonth, this.iCutoverMillis);
        cf.iRangeDurationField = fields.months;
        fields.dayOfMonth = cf;
    }

    long julianToGregorianByYear(long instant) {
        return GJChronology.convertByYear(instant, this.iJulianChronology, this.iGregorianChronology);
    }

    long gregorianToJulianByYear(long instant) {
        return GJChronology.convertByYear(instant, this.iGregorianChronology, this.iJulianChronology);
    }

    long julianToGregorianByWeekyear(long instant) {
        return GJChronology.convertByWeekyear(instant, this.iJulianChronology, this.iGregorianChronology);
    }

    long gregorianToJulianByWeekyear(long instant) {
        return GJChronology.convertByWeekyear(instant, this.iGregorianChronology, this.iJulianChronology);
    }

    private static class LinkedDurationField
    extends DecoratedDurationField {
        private static final long serialVersionUID = 4097975388007713084L;
        private final ImpreciseCutoverField iField;

        LinkedDurationField(DurationField durationField, ImpreciseCutoverField dateTimeField) {
            super(durationField, durationField.getType());
            this.iField = dateTimeField;
        }

        public long add(long instant, int value) {
            return this.iField.add(instant, value);
        }

        public long add(long instant, long value) {
            return this.iField.add(instant, value);
        }

        public int getDifference(long minuendInstant, long subtrahendInstant) {
            return this.iField.getDifference(minuendInstant, subtrahendInstant);
        }

        public long getDifferenceAsLong(long minuendInstant, long subtrahendInstant) {
            return this.iField.getDifferenceAsLong(minuendInstant, subtrahendInstant);
        }
    }

    private final class ImpreciseCutoverField
    extends CutoverField {
        private static final long serialVersionUID = 3410248757173576441L;

        ImpreciseCutoverField(DateTimeField julianField, DateTimeField gregorianField, long cutoverMillis) {
            this(julianField, gregorianField, null, cutoverMillis, false);
        }

        ImpreciseCutoverField(DateTimeField julianField, DateTimeField gregorianField, DurationField durationField, long cutoverMillis) {
            this(julianField, gregorianField, durationField, cutoverMillis, false);
        }

        ImpreciseCutoverField(DateTimeField julianField, DateTimeField gregorianField, DurationField durationField, long cutoverMillis, boolean convertByWeekyear) {
            super(julianField, gregorianField, cutoverMillis, convertByWeekyear);
            if (durationField == null) {
                durationField = new LinkedDurationField(this.iDurationField, this);
            }
            this.iDurationField = durationField;
        }

        public long add(long instant, int value) {
            if (instant >= this.iCutover) {
                if ((instant = this.iGregorianField.add(instant, value)) < this.iCutover && instant + GJChronology.this.iGapDuration < this.iCutover) {
                    instant = this.gregorianToJulian(instant);
                }
            } else if ((instant = this.iJulianField.add(instant, value)) >= this.iCutover && instant - GJChronology.this.iGapDuration >= this.iCutover) {
                instant = this.julianToGregorian(instant);
            }
            return instant;
        }

        public long add(long instant, long value) {
            if (instant >= this.iCutover) {
                if ((instant = this.iGregorianField.add(instant, value)) < this.iCutover && instant + GJChronology.this.iGapDuration < this.iCutover) {
                    instant = this.gregorianToJulian(instant);
                }
            } else if ((instant = this.iJulianField.add(instant, value)) >= this.iCutover && instant - GJChronology.this.iGapDuration >= this.iCutover) {
                instant = this.julianToGregorian(instant);
            }
            return instant;
        }

        public int getDifference(long minuendInstant, long subtrahendInstant) {
            if (minuendInstant >= this.iCutover) {
                if (subtrahendInstant >= this.iCutover) {
                    return this.iGregorianField.getDifference(minuendInstant, subtrahendInstant);
                }
                minuendInstant = this.gregorianToJulian(minuendInstant);
                return this.iJulianField.getDifference(minuendInstant, subtrahendInstant);
            }
            if (subtrahendInstant < this.iCutover) {
                return this.iJulianField.getDifference(minuendInstant, subtrahendInstant);
            }
            minuendInstant = this.julianToGregorian(minuendInstant);
            return this.iGregorianField.getDifference(minuendInstant, subtrahendInstant);
        }

        public long getDifferenceAsLong(long minuendInstant, long subtrahendInstant) {
            if (minuendInstant >= this.iCutover) {
                if (subtrahendInstant >= this.iCutover) {
                    return this.iGregorianField.getDifferenceAsLong(minuendInstant, subtrahendInstant);
                }
                minuendInstant = this.gregorianToJulian(minuendInstant);
                return this.iJulianField.getDifferenceAsLong(minuendInstant, subtrahendInstant);
            }
            if (subtrahendInstant < this.iCutover) {
                return this.iJulianField.getDifferenceAsLong(minuendInstant, subtrahendInstant);
            }
            minuendInstant = this.julianToGregorian(minuendInstant);
            return this.iGregorianField.getDifferenceAsLong(minuendInstant, subtrahendInstant);
        }

        public int getMinimumValue(long instant) {
            if (instant >= this.iCutover) {
                return this.iGregorianField.getMinimumValue(instant);
            }
            return this.iJulianField.getMinimumValue(instant);
        }

        public int getMaximumValue(long instant) {
            if (instant >= this.iCutover) {
                return this.iGregorianField.getMaximumValue(instant);
            }
            return this.iJulianField.getMaximumValue(instant);
        }
    }

    private class CutoverField
    extends BaseDateTimeField {
        private static final long serialVersionUID = 3528501219481026402L;
        final DateTimeField iJulianField;
        final DateTimeField iGregorianField;
        final long iCutover;
        final boolean iConvertByWeekyear;
        protected DurationField iDurationField;
        protected DurationField iRangeDurationField;

        CutoverField(DateTimeField julianField, DateTimeField gregorianField, long cutoverMillis) {
            this(julianField, gregorianField, cutoverMillis, false);
        }

        CutoverField(DateTimeField julianField, DateTimeField gregorianField, long cutoverMillis, boolean convertByWeekyear) {
            super(gregorianField.getType());
            this.iJulianField = julianField;
            this.iGregorianField = gregorianField;
            this.iCutover = cutoverMillis;
            this.iConvertByWeekyear = convertByWeekyear;
            this.iDurationField = gregorianField.getDurationField();
            DurationField rangeField = gregorianField.getRangeDurationField();
            if (rangeField == null) {
                rangeField = julianField.getRangeDurationField();
            }
            this.iRangeDurationField = rangeField;
        }

        public boolean isLenient() {
            return false;
        }

        public int get(long instant) {
            if (instant >= this.iCutover) {
                return this.iGregorianField.get(instant);
            }
            return this.iJulianField.get(instant);
        }

        public String getAsText(long instant, Locale locale) {
            if (instant >= this.iCutover) {
                return this.iGregorianField.getAsText(instant, locale);
            }
            return this.iJulianField.getAsText(instant, locale);
        }

        public String getAsShortText(long instant, Locale locale) {
            if (instant >= this.iCutover) {
                return this.iGregorianField.getAsShortText(instant, locale);
            }
            return this.iJulianField.getAsShortText(instant, locale);
        }

        public long add(long instant, int value) {
            return this.iGregorianField.add(instant, value);
        }

        public long add(long instant, long value) {
            return this.iGregorianField.add(instant, value);
        }

        public int[] add(ReadablePartial partial, int fieldIndex, int[] values, int valueToAdd) {
            if (valueToAdd == 0) {
                return values;
            }
            if (DateTimeUtils.isContiguous(partial)) {
                long instant = 0L;
                int i = 0;
                int isize = partial.size();
                while (i < isize) {
                    instant = partial.getFieldType(i).getField(GJChronology.this).set(instant, values[i]);
                    ++i;
                }
                instant = this.add(instant, valueToAdd);
                return GJChronology.this.get(partial, instant);
            }
            return super.add(partial, fieldIndex, values, valueToAdd);
        }

        public int getDifference(long minuendInstant, long subtrahendInstant) {
            return this.iGregorianField.getDifference(minuendInstant, subtrahendInstant);
        }

        public long getDifferenceAsLong(long minuendInstant, long subtrahendInstant) {
            return this.iGregorianField.getDifferenceAsLong(minuendInstant, subtrahendInstant);
        }

        public long set(long instant, int value) {
            if (instant >= this.iCutover) {
                if ((instant = this.iGregorianField.set(instant, value)) < this.iCutover) {
                    if (instant + GJChronology.this.iGapDuration < this.iCutover) {
                        instant = this.gregorianToJulian(instant);
                    }
                    if (this.get(instant) != value) {
                        throw new IllegalFieldValueException(this.iGregorianField.getType(), (Number)new Integer(value), null, null);
                    }
                }
            } else if ((instant = this.iJulianField.set(instant, value)) >= this.iCutover) {
                if (instant - GJChronology.this.iGapDuration >= this.iCutover) {
                    instant = this.julianToGregorian(instant);
                }
                if (this.get(instant) != value) {
                    throw new IllegalFieldValueException(this.iJulianField.getType(), (Number)new Integer(value), null, null);
                }
            }
            return instant;
        }

        public long set(long instant, String text, Locale locale) {
            if (instant >= this.iCutover) {
                if ((instant = this.iGregorianField.set(instant, text, locale)) < this.iCutover && instant + GJChronology.this.iGapDuration < this.iCutover) {
                    instant = this.gregorianToJulian(instant);
                }
            } else if ((instant = this.iJulianField.set(instant, text, locale)) >= this.iCutover && instant - GJChronology.this.iGapDuration >= this.iCutover) {
                instant = this.julianToGregorian(instant);
            }
            return instant;
        }

        public DurationField getDurationField() {
            return this.iDurationField;
        }

        public DurationField getRangeDurationField() {
            return this.iRangeDurationField;
        }

        public boolean isLeap(long instant) {
            if (instant >= this.iCutover) {
                return this.iGregorianField.isLeap(instant);
            }
            return this.iJulianField.isLeap(instant);
        }

        public int getLeapAmount(long instant) {
            if (instant >= this.iCutover) {
                return this.iGregorianField.getLeapAmount(instant);
            }
            return this.iJulianField.getLeapAmount(instant);
        }

        public DurationField getLeapDurationField() {
            return this.iGregorianField.getLeapDurationField();
        }

        public int getMinimumValue() {
            return this.iJulianField.getMinimumValue();
        }

        public int getMinimumValue(ReadablePartial partial) {
            return this.iJulianField.getMinimumValue(partial);
        }

        public int getMinimumValue(ReadablePartial partial, int[] values) {
            return this.iJulianField.getMinimumValue(partial, values);
        }

        public int getMinimumValue(long instant) {
            if (instant < this.iCutover) {
                return this.iJulianField.getMinimumValue(instant);
            }
            int min = this.iGregorianField.getMinimumValue(instant);
            if ((instant = this.iGregorianField.set(instant, min)) < this.iCutover) {
                min = this.iGregorianField.get(this.iCutover);
            }
            return min;
        }

        public int getMaximumValue() {
            return this.iGregorianField.getMaximumValue();
        }

        public int getMaximumValue(long instant) {
            if (instant >= this.iCutover) {
                return this.iGregorianField.getMaximumValue(instant);
            }
            int max = this.iJulianField.getMaximumValue(instant);
            if ((instant = this.iJulianField.set(instant, max)) >= this.iCutover) {
                max = this.iJulianField.get(this.iJulianField.add(this.iCutover, -1));
            }
            return max;
        }

        public int getMaximumValue(ReadablePartial partial) {
            long instant = GJChronology.getInstanceUTC().set(partial, 0L);
            return this.getMaximumValue(instant);
        }

        public int getMaximumValue(ReadablePartial partial, int[] values) {
            GJChronology chrono = GJChronology.getInstanceUTC();
            long instant = 0L;
            int i = 0;
            int isize = partial.size();
            while (i < isize) {
                DateTimeField field = partial.getFieldType(i).getField(chrono);
                if (values[i] <= field.getMaximumValue(instant)) {
                    instant = field.set(instant, values[i]);
                }
                ++i;
            }
            return this.getMaximumValue(instant);
        }

        public long roundFloor(long instant) {
            if (instant >= this.iCutover) {
                if ((instant = this.iGregorianField.roundFloor(instant)) < this.iCutover && instant + GJChronology.this.iGapDuration < this.iCutover) {
                    instant = this.gregorianToJulian(instant);
                }
            } else {
                instant = this.iJulianField.roundFloor(instant);
            }
            return instant;
        }

        public long roundCeiling(long instant) {
            if (instant >= this.iCutover) {
                instant = this.iGregorianField.roundCeiling(instant);
            } else if ((instant = this.iJulianField.roundCeiling(instant)) >= this.iCutover && instant - GJChronology.this.iGapDuration >= this.iCutover) {
                instant = this.julianToGregorian(instant);
            }
            return instant;
        }

        public int getMaximumTextLength(Locale locale) {
            return Math.max(this.iJulianField.getMaximumTextLength(locale), this.iGregorianField.getMaximumTextLength(locale));
        }

        public int getMaximumShortTextLength(Locale locale) {
            return Math.max(this.iJulianField.getMaximumShortTextLength(locale), this.iGregorianField.getMaximumShortTextLength(locale));
        }

        protected long julianToGregorian(long instant) {
            if (this.iConvertByWeekyear) {
                return GJChronology.this.julianToGregorianByWeekyear(instant);
            }
            return GJChronology.this.julianToGregorianByYear(instant);
        }

        protected long gregorianToJulian(long instant) {
            if (this.iConvertByWeekyear) {
                return GJChronology.this.gregorianToJulianByWeekyear(instant);
            }
            return GJChronology.this.gregorianToJulianByYear(instant);
        }
    }
}

