/*
 * pic18f86j60.h - device specific declarations
 *
 * This file is part of the GNU PIC library for SDCC,
 * originally devised by Vangelis Rokas <vrokas AT otenet.gr>
 *
 * It has been automatically generated by inc2h-pic16.pl,
 * (c) 2007 by Raphael Neider <rneider AT web.de>
 */

#ifndef __PIC18F86J60_H__
#define __PIC18F86J60_H__ 1

#define __CONFIG1L              0xFFF8
#define __CONFIG1H              0xFFF9
#define __CONFIG2L              0xFFFA
#define __CONFIG2H              0xFFFB
#define __CONFIG3L              0xFFFC
#define __CONFIG3H              0xFFFD

#define	_DEVID1             	0x3FFFFE
#define	_DEVID2             	0x3FFFFF

extern __sfr __at (0xE80) MAADR5;

extern __sfr __at (0xE81) MAADR6;

extern __sfr __at (0xE82) MAADR3;

extern __sfr __at (0xE83) MAADR4;

extern __sfr __at (0xE84) MAADR1;

extern __sfr __at (0xE85) MAADR2;

extern __sfr __at (0xE86) EBSTSD;

extern __sfr __at (0xE87) EBSTCON;
typedef union {
	struct {
		unsigned BISTST    	: 1;
		unsigned TME       	: 1;
		unsigned TMSEL0    	: 1;
		unsigned TMSEL1    	: 1;
		unsigned           	: 1;
		unsigned PSV0      	: 1;
		unsigned PSV1      	: 1;
		unsigned PSV2      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned TMSEL     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned PSV       	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __EBSTCONbits_t;
extern volatile __EBSTCONbits_t __at (0xE87) EBSTCONbits;

extern __sfr __at (0xE88) EBSTCS;

extern __sfr __at (0xE88) EBSTCSL;

extern __sfr __at (0xE89) EBSTCSH;

extern __sfr __at (0xE8A) MISTAT;
typedef union {
	struct {
		unsigned BUSY      	: 1;
		unsigned SCAN      	: 1;
		unsigned NVALID    	: 1;
		unsigned LINKFL    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __MISTATbits_t;
extern volatile __MISTATbits_t __at (0xE8A) MISTATbits;

extern __sfr __at (0xE97) EFLOCON;
typedef union {
	struct {
		unsigned FCEN0     	: 1;
		unsigned FCEN1     	: 1;
		unsigned FULDPXS   	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __EFLOCONbits_t;
extern volatile __EFLOCONbits_t __at (0xE97) EFLOCONbits;

extern __sfr __at (0xE98) EPAUS;

extern __sfr __at (0xE98) EPAUSL;

extern __sfr __at (0xE99) EPAUSH;

extern __sfr __at (0xEA0) MACON1;
typedef union {
	struct {
		unsigned MARXEN    	: 1;
		unsigned PASSALL   	: 1;
		unsigned RXPAUS    	: 1;
		unsigned TXPAUS    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __MACON1bits_t;
extern volatile __MACON1bits_t __at (0xEA0) MACON1bits;

extern __sfr __at (0xEA1) MACON2;
typedef union {
	struct {
		unsigned TFUNRST   	: 1;
		unsigned MATXRST   	: 1;
		unsigned RFUNRST   	: 1;
		unsigned MARXRST   	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RNDRST    	: 1;
		unsigned MARST     	: 1;
	};
} __MACON2bits_t;
extern volatile __MACON2bits_t __at (0xEA1) MACON2bits;

extern __sfr __at (0xEA2) MACON3;
typedef union {
	struct {
		unsigned FULDPX    	: 1;
		unsigned FRMLNEN   	: 1;
		unsigned HFRMEN    	: 1;
		unsigned PHDRLEN   	: 1;
		unsigned TXCRCEN   	: 1;
		unsigned PADCFG0   	: 1;
		unsigned PADCFG1   	: 1;
		unsigned PADCFG2   	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned PADCFG    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __MACON3bits_t;
extern volatile __MACON3bits_t __at (0xEA2) MACON3bits;

extern __sfr __at (0xEA3) MACON4;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOBKOFF   	: 1;
		unsigned BPEN      	: 1;
		unsigned DEFER     	: 1;
		unsigned           	: 1;
	};
} __MACON4bits_t;
extern volatile __MACON4bits_t __at (0xEA3) MACON4bits;

extern __sfr __at (0xEA4) MABBIPG;

extern __sfr __at (0xEA6) MAIPG;

extern __sfr __at (0xEA6) MAIPGL;

extern __sfr __at (0xEA7) MAIPGH;

extern __sfr __at (0xEA8) MACLCON1;
typedef union {
	struct {
		unsigned RETMAX    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __MACLCON1bits_t;
extern volatile __MACLCON1bits_t __at (0xEA8) MACLCON1bits;

extern __sfr __at (0xEA9) MACLCON2;
typedef union {
	struct {
		unsigned COLWIN    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __MACLCON2bits_t;
extern volatile __MACLCON2bits_t __at (0xEA9) MACLCON2bits;

extern __sfr __at (0xEAA) MAMXFL;

extern __sfr __at (0xEAA) MAMXFLL;

extern __sfr __at (0xEAB) MAMXFLH;

extern __sfr __at (0xEB1) MICON;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RSTMII    	: 1;
	};
} __MICONbits_t;
extern volatile __MICONbits_t __at (0xEB1) MICONbits;

extern __sfr __at (0xEB2) MICMD;
typedef union {
	struct {
		unsigned MIIRD     	: 1;
		unsigned MIISCAN   	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __MICMDbits_t;
extern volatile __MICMDbits_t __at (0xEB2) MICMDbits;

extern __sfr __at (0xEB4) MIREGADR;

extern __sfr __at (0xEB6) MIWR;

extern __sfr __at (0xEB6) MIWRL;

extern __sfr __at (0xEB7) MIWRH;

extern __sfr __at (0xEB8) MIRD;

extern __sfr __at (0xEB8) MIRDL;

extern __sfr __at (0xEB9) MIRDH;

extern __sfr __at (0xEC0) EHT0;

extern __sfr __at (0xEC1) EHT1;

extern __sfr __at (0xEC2) EHT2;

extern __sfr __at (0xEC3) EHT3;

extern __sfr __at (0xEC4) EHT4;

extern __sfr __at (0xEC5) EHT5;

extern __sfr __at (0xEC6) EHT6;

extern __sfr __at (0xEC7) EHT7;

extern __sfr __at (0xEC8) EPMM0;

extern __sfr __at (0xEC9) EPMM1;

extern __sfr __at (0xECA) EPMM2;

extern __sfr __at (0xECB) EPMM3;

extern __sfr __at (0xECC) EPMM4;

extern __sfr __at (0xECD) EPMM5;

extern __sfr __at (0xECE) EPMM6;

extern __sfr __at (0xECF) EPMM7;

extern __sfr __at (0xED0) EPMCS;

extern __sfr __at (0xED0) EPMCSL;

extern __sfr __at (0xED1) EPMCSH;

extern __sfr __at (0xED4) EPMO;

extern __sfr __at (0xED4) EPMOL;

extern __sfr __at (0xED5) EPMOH;

extern __sfr __at (0xED6) EWOLIE;
typedef union {
	struct {
		unsigned BCWOLIE   	: 1;
		unsigned MCWOLIE   	: 1;
		unsigned HTWOLIE   	: 1;
		unsigned MPWOLIE   	: 1;
		unsigned PMWOLIE   	: 1;
		unsigned           	: 1;
		unsigned AWOLIE    	: 1;
		unsigned UCWOLIE   	: 1;
	};
} __EWOLIEbits_t;
extern volatile __EWOLIEbits_t __at (0xED6) EWOLIEbits;

extern __sfr __at (0xED7) EWOLIR;
typedef union {
	struct {
		unsigned BCWOLIF   	: 1;
		unsigned MCWOLIF   	: 1;
		unsigned HTWOLIF   	: 1;
		unsigned MPWOLIF   	: 1;
		unsigned PMWOLIF   	: 1;
		unsigned           	: 1;
		unsigned AWOLIF    	: 1;
		unsigned UCWOLIF   	: 1;
	};
} __EWOLIRbits_t;
extern volatile __EWOLIRbits_t __at (0xED7) EWOLIRbits;

extern __sfr __at (0xED8) ERXFCON;
typedef union {
	struct {
		unsigned BCEN      	: 1;
		unsigned MCEN      	: 1;
		unsigned HTEN      	: 1;
		unsigned MPEN      	: 1;
		unsigned PMEN      	: 1;
		unsigned CRCEN     	: 1;
		unsigned ANDOR     	: 1;
		unsigned UCEN      	: 1;
	};
} __ERXFCONbits_t;
extern volatile __ERXFCONbits_t __at (0xED8) ERXFCONbits;

extern __sfr __at (0xED9) EPKTCNT;

extern __sfr __at (0xEE2) EWRPT;

extern __sfr __at (0xEE2) EWRPTL;

extern __sfr __at (0xEE3) EWRPTH;

extern __sfr __at (0xEE4) ETXST;

extern __sfr __at (0xEE4) ETXSTL;

extern __sfr __at (0xEE5) ETXSTH;

extern __sfr __at (0xEE6) ETXND;

extern __sfr __at (0xEE6) ETXNDL;

extern __sfr __at (0xEE7) ETXNDH;

extern __sfr __at (0xEE8) ERXST;

extern __sfr __at (0xEE8) ERXSTL;

extern __sfr __at (0xEE9) ERXSTH;

extern __sfr __at (0xEEA) ERXND;

extern __sfr __at (0xEEA) ERXNDL;

extern __sfr __at (0xEEB) ERXNDH;

extern __sfr __at (0xEEC) ERXRDPT;

extern __sfr __at (0xEEC) ERXRDPTL;

extern __sfr __at (0xEED) ERXRDPTH;

extern __sfr __at (0xEEE) ERXWRPT;

extern __sfr __at (0xEEE) ERXWRPTL;

extern __sfr __at (0xEEF) ERXWRPTH;

extern __sfr __at (0xEF0) EDMAST;

extern __sfr __at (0xEF0) EDMASTL;

extern __sfr __at (0xEF1) EDMASTH;

extern __sfr __at (0xEF2) EDMAND;

extern __sfr __at (0xEF2) EDMANDL;

extern __sfr __at (0xEF3) EDMANDH;

extern __sfr __at (0xEF4) EDMADST;

extern __sfr __at (0xEF4) EDMADSTL;

extern __sfr __at (0xEF5) EDMADSTH;

extern __sfr __at (0xEF6) EDMACS;

extern __sfr __at (0xEF6) EDMACSL;

extern __sfr __at (0xEF7) EDMACSH;

extern __sfr __at (0xEFB) EIE;
typedef union {
	struct {
		unsigned RXERIE    	: 1;
		unsigned TXERIE    	: 1;
		unsigned           	: 1;
		unsigned TXIE_EIE  	: 1;
		unsigned LINKIE    	: 1;
		unsigned DMAIE     	: 1;
		unsigned PKTIE     	: 1;
		unsigned           	: 1;
	};
} __EIEbits_t;
extern volatile __EIEbits_t __at (0xEFB) EIEbits;

extern __sfr __at (0xEFD) ESTAT;
typedef union {
	struct {
		unsigned PHYRDY    	: 1;
		unsigned TXABRT    	: 1;
		unsigned RXBUSY    	: 1;
		unsigned           	: 1;
		unsigned LATECOL   	: 1;
		unsigned           	: 1;
		unsigned BUFER     	: 1;
		unsigned           	: 1;
	};
} __ESTATbits_t;
extern volatile __ESTATbits_t __at (0xEFD) ESTATbits;

extern __sfr __at (0xEFE) ECON2;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned ETHEN     	: 1;
		unsigned PKTDEC    	: 1;
		unsigned AUTOINC   	: 1;
	};
} __ECON2bits_t;
extern volatile __ECON2bits_t __at (0xEFE) ECON2bits;

extern __sfr __at (0xF60) EIR;
typedef union {
	struct {
		unsigned RXERIF    	: 1;
		unsigned TXERIF    	: 1;
		unsigned           	: 1;
		unsigned TXIF_EIR  	: 1;
		unsigned LINKIF    	: 1;
		unsigned DMAIF     	: 1;
		unsigned PKTIF     	: 1;
		unsigned           	: 1;
	};
} __EIRbits_t;
extern volatile __EIRbits_t __at (0xF60) EIRbits;

extern __sfr __at (0xF61) EDATA;
typedef union {
	struct {
		unsigned EDATA0    	: 1;
		unsigned EDATA1    	: 1;
		unsigned EDATA2    	: 1;
		unsigned EDATA3    	: 1;
		unsigned EDATA4    	: 1;
		unsigned EDATA5    	: 1;
		unsigned EDATA6    	: 1;
		unsigned EDATA7    	: 1;
	};
} __EDATAbits_t;
extern volatile __EDATAbits_t __at (0xF61) EDATAbits;

extern __sfr __at (0xF67) ECCP2DEL;
typedef union {
	struct {
		unsigned PDC0      	: 1;
		unsigned PDC1      	: 1;
		unsigned PDC2      	: 1;
		unsigned PDC3      	: 1;
		unsigned PDC4      	: 1;
		unsigned PDC5      	: 1;
		unsigned PDC6      	: 1;
		unsigned PRSEN     	: 1;
	};
	struct {
		unsigned P2DC0     	: 1;
		unsigned P2DC1     	: 1;
		unsigned P2DC2     	: 1;
		unsigned P2DC3     	: 1;
		unsigned P2DC4     	: 1;
		unsigned P2DC5     	: 1;
		unsigned P2DC6     	: 1;
		unsigned P2RSEN    	: 1;
	};
} __ECCP2DELbits_t;
extern volatile __ECCP2DELbits_t __at (0xF67) ECCP2DELbits;

extern __sfr __at (0xF68) ECCP2AS;
typedef union {
	struct {
		unsigned PSSBD0    	: 1;
		unsigned PSSBD1    	: 1;
		unsigned PSSAC0    	: 1;
		unsigned PSSAC1    	: 1;
		unsigned ECCPAS0   	: 1;
		unsigned ECCPAS1   	: 1;
		unsigned ECCPAS2   	: 1;
		unsigned ECCPASE   	: 1;
	};
	struct {
		unsigned PSS2BD0   	: 1;
		unsigned PSS2BD1   	: 1;
		unsigned PSS2AC0   	: 1;
		unsigned PSS2AC1   	: 1;
		unsigned ECCP2AS0  	: 1;
		unsigned ECCP2AS1  	: 1;
		unsigned ECCP2AS2  	: 1;
		unsigned ECCP2ASE  	: 1;
	};
} __ECCP2ASbits_t;
extern volatile __ECCP2ASbits_t __at (0xF68) ECCP2ASbits;

extern __sfr __at (0xF69) ECCP3DEL;
typedef union {
	struct {
		unsigned PDC0      	: 1;
		unsigned PDC1      	: 1;
		unsigned PDC2      	: 1;
		unsigned PDC3      	: 1;
		unsigned PDC4      	: 1;
		unsigned PDC5      	: 1;
		unsigned PDC6      	: 1;
		unsigned PRSEN     	: 1;
	};
	struct {
		unsigned P3DC0     	: 1;
		unsigned P3DC1     	: 1;
		unsigned P3DC2     	: 1;
		unsigned P3DC3     	: 1;
		unsigned P3DC4     	: 1;
		unsigned P3DC5     	: 1;
		unsigned P3DC6     	: 1;
		unsigned P3RSEN    	: 1;
	};
} __ECCP3DELbits_t;
extern volatile __ECCP3DELbits_t __at (0xF69) ECCP3DELbits;

extern __sfr __at (0xF6A) ECCP3AS;
typedef union {
	struct {
		unsigned PSSBD0    	: 1;
		unsigned PSSBD1    	: 1;
		unsigned PSSAC0    	: 1;
		unsigned PSSAC1    	: 1;
		unsigned ECCPAS0   	: 1;
		unsigned ECCPAS1   	: 1;
		unsigned ECCPAS2   	: 1;
		unsigned ECCPASE   	: 1;
	};
	struct {
		unsigned PSS3BD0   	: 1;
		unsigned PSS3BD1   	: 1;
		unsigned PSS3AC0   	: 1;
		unsigned PSS3AC1   	: 1;
		unsigned ECCP3AS0  	: 1;
		unsigned ECCP3AS1  	: 1;
		unsigned ECCP3AS2  	: 1;
		unsigned ECCP3ASE  	: 1;
	};
} __ECCP3ASbits_t;
extern volatile __ECCP3ASbits_t __at (0xF6A) ECCP3ASbits;

extern __sfr __at (0xF6B) RCSTA2;
typedef union {
	struct {
		unsigned RCD8      	: 1;
		unsigned OERR      	: 1;
		unsigned FERR      	: 1;
		unsigned ADDEN     	: 1;
		unsigned CREN      	: 1;
		unsigned SREN      	: 1;
		unsigned RC9       	: 1;
		unsigned SPEN      	: 1;
	};
	struct {
		unsigned RX9D      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_RC8   	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RC8_9     	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RX9       	: 1;
		unsigned           	: 1;
	};
} __RCSTA2bits_t;
extern volatile __RCSTA2bits_t __at (0xF6B) RCSTA2bits;

extern __sfr __at (0xF6C) TXSTA2;
typedef union {
	struct {
		unsigned TX9D      	: 1;
		unsigned TRMT      	: 1;
		unsigned BRGH      	: 1;
		unsigned SENDB     	: 1;
		unsigned SYNC      	: 1;
		unsigned TXEN      	: 1;
		unsigned TX9       	: 1;
		unsigned CSRC      	: 1;
	};
	struct {
		unsigned TXD8      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned TX8_9     	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_TX8   	: 1;
		unsigned           	: 1;
	};
} __TXSTA2bits_t;
extern volatile __TXSTA2bits_t __at (0xF6C) TXSTA2bits;

extern __sfr __at (0xF6D) TXREG2;

extern __sfr __at (0xF6E) RCREG2;

extern __sfr __at (0xF6F) SPBRG2;

extern __sfr __at (0xF70) CCP5CON;
typedef union {
	struct {
		unsigned CCP5M0    	: 1;
		unsigned CCP5M1    	: 1;
		unsigned CCP5M2    	: 1;
		unsigned CCP5M3    	: 1;
		unsigned CCP5Y     	: 1;
		unsigned CCP5X     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned DC5B0     	: 1;
		unsigned DC5B1     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __CCP5CONbits_t;
extern volatile __CCP5CONbits_t __at (0xF70) CCP5CONbits;

extern __sfr __at (0xF71) CCPR5;

extern __sfr __at (0xF71) CCPR5L;

extern __sfr __at (0xF72) CCPR5H;

extern __sfr __at (0xF73) CCP4CON;
typedef union {
	struct {
		unsigned CCP4M0    	: 1;
		unsigned CCP4M1    	: 1;
		unsigned CCP4M2    	: 1;
		unsigned CCP4M3    	: 1;
		unsigned CCP4Y     	: 1;
		unsigned CCP4X     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned DC4B0     	: 1;
		unsigned DC4B1     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __CCP4CONbits_t;
extern volatile __CCP4CONbits_t __at (0xF73) CCP4CONbits;

extern __sfr __at (0xF74) CCPR4;

extern __sfr __at (0xF74) CCPR4L;

extern __sfr __at (0xF75) CCPR4H;

extern __sfr __at (0xF76) T4CON;
typedef union {
	struct {
		unsigned T4CKPS0   	: 1;
		unsigned T4CKPS1   	: 1;
		unsigned TMR4ON    	: 1;
		unsigned T4OUTPS0  	: 1;
		unsigned T4OUTPS1  	: 1;
		unsigned T4OUTPS2  	: 1;
		unsigned T4OUTPS3  	: 1;
		unsigned           	: 1;
	};
} __T4CONbits_t;
extern volatile __T4CONbits_t __at (0xF76) T4CONbits;

extern __sfr __at (0xF77) PR4;

extern __sfr __at (0xF78) TMR4;

extern __sfr __at (0xF79) ECCP1DEL;
typedef union {
	struct {
		unsigned PDC0      	: 1;
		unsigned PDC1      	: 1;
		unsigned PDC2      	: 1;
		unsigned PDC3      	: 1;
		unsigned PDC4      	: 1;
		unsigned PDC5      	: 1;
		unsigned PDC6      	: 1;
		unsigned PRSEN     	: 1;
	};
	struct {
		unsigned P1DC0     	: 1;
		unsigned P1DC1     	: 1;
		unsigned P1DC2     	: 1;
		unsigned P1DC3     	: 1;
		unsigned P1DC4     	: 1;
		unsigned P1DC5     	: 1;
		unsigned P1DC6     	: 1;
		unsigned P1RSEN    	: 1;
	};
} __ECCP1DELbits_t;
extern volatile __ECCP1DELbits_t __at (0xF79) ECCP1DELbits;

extern __sfr __at (0xF7A) ERDPT;

extern __sfr __at (0xF7A) ERDPTL;

extern __sfr __at (0xF7B) ERDPTH;

extern __sfr __at (0xF7C) BAUDCON2;
typedef union {
	struct {
		unsigned ABDEN     	: 1;
		unsigned WUE       	: 1;
		unsigned           	: 1;
		unsigned BRG16     	: 1;
		unsigned SCKP      	: 1;
		unsigned RXDTP     	: 1;
		unsigned RCMT      	: 1;
		unsigned ABDOVF    	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned TXCKP     	: 1;
		unsigned           	: 1;
		unsigned RCIDL     	: 1;
		unsigned           	: 1;
	};
} __BAUDCON2bits_t;
extern volatile __BAUDCON2bits_t __at (0xF7C) BAUDCON2bits;

extern __sfr __at (0xF7C) BAUDCTL2;
typedef union {
	struct {
		unsigned ABDEN     	: 1;
		unsigned WUE       	: 1;
		unsigned           	: 1;
		unsigned BRG16     	: 1;
		unsigned SCKP      	: 1;
		unsigned RXDTP     	: 1;
		unsigned RCMT      	: 1;
		unsigned ABDOVF    	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned TXCKP     	: 1;
		unsigned           	: 1;
		unsigned RCIDL     	: 1;
		unsigned           	: 1;
	};
} __BAUDCTL2bits_t;
extern volatile __BAUDCTL2bits_t __at (0xF7C) BAUDCTL2bits;

extern __sfr __at (0xF7D) SPBRGH2;

extern __sfr __at (0xF7E) BAUDCON;
typedef union {
	struct {
		unsigned ABDEN     	: 1;
		unsigned WUE       	: 1;
		unsigned           	: 1;
		unsigned BRG16     	: 1;
		unsigned SCKP      	: 1;
		unsigned RXDTP     	: 1;
		unsigned RCMT      	: 1;
		unsigned ABDOVF    	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned TXCKP     	: 1;
		unsigned           	: 1;
		unsigned RCIDL     	: 1;
		unsigned           	: 1;
	};
} __BAUDCONbits_t;
extern volatile __BAUDCONbits_t __at (0xF7E) BAUDCONbits;

extern __sfr __at (0xF7E) BAUDCON1;
typedef union {
	struct {
		unsigned ABDEN     	: 1;
		unsigned WUE       	: 1;
		unsigned           	: 1;
		unsigned BRG16     	: 1;
		unsigned SCKP      	: 1;
		unsigned RXDTP     	: 1;
		unsigned RCMT      	: 1;
		unsigned ABDOVF    	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned TXCKP     	: 1;
		unsigned           	: 1;
		unsigned RCIDL     	: 1;
		unsigned           	: 1;
	};
} __BAUDCON1bits_t;
extern volatile __BAUDCON1bits_t __at (0xF7E) BAUDCON1bits;

extern __sfr __at (0xF7E) BAUDCTL;
typedef union {
	struct {
		unsigned ABDEN     	: 1;
		unsigned WUE       	: 1;
		unsigned           	: 1;
		unsigned BRG16     	: 1;
		unsigned SCKP      	: 1;
		unsigned RXDTP     	: 1;
		unsigned RCMT      	: 1;
		unsigned ABDOVF    	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned TXCKP     	: 1;
		unsigned           	: 1;
		unsigned RCIDL     	: 1;
		unsigned           	: 1;
	};
} __BAUDCTLbits_t;
extern volatile __BAUDCTLbits_t __at (0xF7E) BAUDCTLbits;

extern __sfr __at (0xF7E) BAUDCTL1;
typedef union {
	struct {
		unsigned ABDEN     	: 1;
		unsigned WUE       	: 1;
		unsigned           	: 1;
		unsigned BRG16     	: 1;
		unsigned SCKP      	: 1;
		unsigned RXDTP     	: 1;
		unsigned RCMT      	: 1;
		unsigned ABDOVF    	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned TXCKP     	: 1;
		unsigned           	: 1;
		unsigned RCIDL     	: 1;
		unsigned           	: 1;
	};
} __BAUDCTL1bits_t;
extern volatile __BAUDCTL1bits_t __at (0xF7E) BAUDCTL1bits;

extern __sfr __at (0xF7F) SPBRGH;

extern __sfr __at (0xF7F) SPBRGH1;

extern __sfr __at (0xF80) PORTA;
typedef union {
	struct {
		unsigned RA0       	: 1;
		unsigned RA1       	: 1;
		unsigned RA2       	: 1;
		unsigned RA3       	: 1;
		unsigned RA4       	: 1;
		unsigned RA5       	: 1;
		unsigned           	: 1;
		unsigned RJPU      	: 1;
	};
	struct {
		unsigned AN0       	: 1;
		unsigned AN1       	: 1;
		unsigned AN2       	: 1;
		unsigned AN3       	: 1;
		unsigned T0CKI     	: 1;
		unsigned AN4       	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned LEDA      	: 1;
		unsigned LEDB      	: 1;
		unsigned VREFM     	: 1;
		unsigned VREFP     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __PORTAbits_t;
extern volatile __PORTAbits_t __at (0xF80) PORTAbits;

extern __sfr __at (0xF81) PORTB;
typedef union {
	struct {
		unsigned RB0       	: 1;
		unsigned RB1       	: 1;
		unsigned RB2       	: 1;
		unsigned RB3       	: 1;
		unsigned RB4       	: 1;
		unsigned RB5       	: 1;
		unsigned RB6       	: 1;
		unsigned RB7       	: 1;
	};
	struct {
		unsigned INT0      	: 1;
		unsigned INT1      	: 1;
		unsigned INT2      	: 1;
		unsigned INT3      	: 1;
		unsigned KBI0      	: 1;
		unsigned KBI1      	: 1;
		unsigned KBI2      	: 1;
		unsigned KBI3      	: 1;
	};
	struct {
		unsigned FLT0      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned PGC       	: 1;
		unsigned PGD       	: 1;
	};
} __PORTBbits_t;
extern volatile __PORTBbits_t __at (0xF81) PORTBbits;

extern __sfr __at (0xF82) PORTC;
typedef union {
	struct {
		unsigned RC0       	: 1;
		unsigned RC1       	: 1;
		unsigned RC2       	: 1;
		unsigned RC3       	: 1;
		unsigned RC4       	: 1;
		unsigned RC5       	: 1;
		unsigned RC6       	: 1;
		unsigned RC7       	: 1;
	};
	struct {
		unsigned T1OSO     	: 1;
		unsigned T1OSI     	: 1;
		unsigned CCP1      	: 1;
		unsigned SCK       	: 1;
		unsigned SDI       	: 1;
		unsigned SDO       	: 1;
		unsigned TX        	: 1;
		unsigned RX        	: 1;
	};
	struct {
		unsigned T13CKI    	: 1;
		unsigned CCP2      	: 1;
		unsigned           	: 1;
		unsigned SCL       	: 1;
		unsigned SDA       	: 1;
		unsigned SDO1      	: 1;
		unsigned CK        	: 1;
		unsigned DT        	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned SCK1      	: 1;
		unsigned SDI1      	: 1;
		unsigned           	: 1;
		unsigned TX1       	: 1;
		unsigned RX1       	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned SCL1      	: 1;
		unsigned SDA1      	: 1;
		unsigned           	: 1;
		unsigned CK1       	: 1;
		unsigned DT1       	: 1;
	};
} __PORTCbits_t;
extern volatile __PORTCbits_t __at (0xF82) PORTCbits;

extern __sfr __at (0xF83) PORTD;
typedef union {
	struct {
		unsigned RD0       	: 1;
		unsigned RD1       	: 1;
		unsigned RD2       	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __PORTDbits_t;
extern volatile __PORTDbits_t __at (0xF83) PORTDbits;

extern __sfr __at (0xF84) PORTE;
typedef union {
	struct {
		unsigned RE0       	: 1;
		unsigned RE1       	: 1;
		unsigned RE2       	: 1;
		unsigned RE3       	: 1;
		unsigned RE4       	: 1;
		unsigned RE5       	: 1;
		unsigned RE6       	: 1;
		unsigned RE7       	: 1;
	};
} __PORTEbits_t;
extern volatile __PORTEbits_t __at (0xF84) PORTEbits;

extern __sfr __at (0xF85) PORTF;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned RF1       	: 1;
		unsigned RF2       	: 1;
		unsigned RF3       	: 1;
		unsigned RF4       	: 1;
		unsigned RF5       	: 1;
		unsigned RF6       	: 1;
		unsigned RF7       	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned AN6       	: 1;
		unsigned AN7       	: 1;
		unsigned AN8       	: 1;
		unsigned AN9       	: 1;
		unsigned AN10      	: 1;
		unsigned AN11      	: 1;
		unsigned SS        	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned CVREF     	: 1;
		unsigned           	: 1;
		unsigned NOT_SS    	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned SS1       	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_SS1   	: 1;
	};
} __PORTFbits_t;
extern volatile __PORTFbits_t __at (0xF85) PORTFbits;

extern __sfr __at (0xF86) PORTG;
typedef union {
	struct {
		unsigned RG0       	: 1;
		unsigned RG1       	: 1;
		unsigned RG2       	: 1;
		unsigned RG3       	: 1;
		unsigned RG4       	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned CCP3      	: 1;
		unsigned TX2       	: 1;
		unsigned RX2       	: 1;
		unsigned CCP4      	: 1;
		unsigned CCP5      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned CK2       	: 1;
		unsigned DT2       	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __PORTGbits_t;
extern volatile __PORTGbits_t __at (0xF86) PORTGbits;

extern __sfr __at (0xF87) PORTH;
typedef union {
	struct {
		unsigned RH0       	: 1;
		unsigned RH1       	: 1;
		unsigned RH2       	: 1;
		unsigned RH3       	: 1;
		unsigned RH4       	: 1;
		unsigned RH5       	: 1;
		unsigned RH6       	: 1;
		unsigned RH7       	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned AN12      	: 1;
		unsigned AN13      	: 1;
		unsigned AN14      	: 1;
		unsigned AN15      	: 1;
	};
} __PORTHbits_t;
extern volatile __PORTHbits_t __at (0xF87) PORTHbits;

extern __sfr __at (0xF88) PORTJ;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RJ4       	: 1;
		unsigned RJ5       	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __PORTJbits_t;
extern volatile __PORTJbits_t __at (0xF88) PORTJbits;

extern __sfr __at (0xF89) LATA;
typedef union {
	struct {
		unsigned LATA0     	: 1;
		unsigned LATA1     	: 1;
		unsigned LATA2     	: 1;
		unsigned LATA3     	: 1;
		unsigned LATA4     	: 1;
		unsigned LATA5     	: 1;
		unsigned REPU      	: 1;
		unsigned RDPU      	: 1;
	};
} __LATAbits_t;
extern volatile __LATAbits_t __at (0xF89) LATAbits;

extern __sfr __at (0xF8A) LATB;
typedef union {
	struct {
		unsigned LATB0     	: 1;
		unsigned LATB1     	: 1;
		unsigned LATB2     	: 1;
		unsigned LATB3     	: 1;
		unsigned LATB4     	: 1;
		unsigned LATB5     	: 1;
		unsigned LATB6     	: 1;
		unsigned LATB7     	: 1;
	};
} __LATBbits_t;
extern volatile __LATBbits_t __at (0xF8A) LATBbits;

extern __sfr __at (0xF8B) LATC;
typedef union {
	struct {
		unsigned LATC0     	: 1;
		unsigned LATC1     	: 1;
		unsigned LATC2     	: 1;
		unsigned LATC3     	: 1;
		unsigned LATC4     	: 1;
		unsigned LATC5     	: 1;
		unsigned LATC6     	: 1;
		unsigned LATC7     	: 1;
	};
} __LATCbits_t;
extern volatile __LATCbits_t __at (0xF8B) LATCbits;

extern __sfr __at (0xF8C) LATD;
typedef union {
	struct {
		unsigned LATD0     	: 1;
		unsigned LATD1     	: 1;
		unsigned LATD2     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __LATDbits_t;
extern volatile __LATDbits_t __at (0xF8C) LATDbits;

extern __sfr __at (0xF8D) LATE;
typedef union {
	struct {
		unsigned LATE0     	: 1;
		unsigned LATE1     	: 1;
		unsigned LATE2     	: 1;
		unsigned LATE3     	: 1;
		unsigned LATE4     	: 1;
		unsigned LATE5     	: 1;
		unsigned LATE6     	: 1;
		unsigned LATE7     	: 1;
	};
} __LATEbits_t;
extern volatile __LATEbits_t __at (0xF8D) LATEbits;

extern __sfr __at (0xF8E) LATF;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned LATF1     	: 1;
		unsigned LATF2     	: 1;
		unsigned LATF3     	: 1;
		unsigned LATF4     	: 1;
		unsigned LATF5     	: 1;
		unsigned LATF6     	: 1;
		unsigned LATF7     	: 1;
	};
} __LATFbits_t;
extern volatile __LATFbits_t __at (0xF8E) LATFbits;

extern __sfr __at (0xF8F) LATG;
typedef union {
	struct {
		unsigned LATG0     	: 1;
		unsigned LATG1     	: 1;
		unsigned LATG2     	: 1;
		unsigned LATG3     	: 1;
		unsigned LATG4     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __LATGbits_t;
extern volatile __LATGbits_t __at (0xF8F) LATGbits;

extern __sfr __at (0xF90) LATH;
typedef union {
	struct {
		unsigned LATH0     	: 1;
		unsigned LATH1     	: 1;
		unsigned LATH2     	: 1;
		unsigned LATH3     	: 1;
		unsigned LATH4     	: 1;
		unsigned LATH5     	: 1;
		unsigned LATH6     	: 1;
		unsigned LATH7     	: 1;
	};
} __LATHbits_t;
extern volatile __LATHbits_t __at (0xF90) LATHbits;

extern __sfr __at (0xF91) LATJ;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned LATJ4     	: 1;
		unsigned LATJ5     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __LATJbits_t;
extern volatile __LATJbits_t __at (0xF91) LATJbits;

extern __sfr __at (0xF92) DDRA;
typedef union {
	struct {
		unsigned RA0       	: 1;
		unsigned RA1       	: 1;
		unsigned RA2       	: 1;
		unsigned RA3       	: 1;
		unsigned RA4       	: 1;
		unsigned RA5       	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __DDRAbits_t;
extern volatile __DDRAbits_t __at (0xF92) DDRAbits;

extern __sfr __at (0xF92) TRISA;
typedef union {
	struct {
		unsigned TRISA0    	: 1;
		unsigned TRISA1    	: 1;
		unsigned TRISA2    	: 1;
		unsigned TRISA3    	: 1;
		unsigned TRISA4    	: 1;
		unsigned TRISA5    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __TRISAbits_t;
extern volatile __TRISAbits_t __at (0xF92) TRISAbits;

extern __sfr __at (0xF93) DDRB;
typedef union {
	struct {
		unsigned RB0       	: 1;
		unsigned RB1       	: 1;
		unsigned RB2       	: 1;
		unsigned RB3       	: 1;
		unsigned RB4       	: 1;
		unsigned RB5       	: 1;
		unsigned RB6       	: 1;
		unsigned RB7       	: 1;
	};
} __DDRBbits_t;
extern volatile __DDRBbits_t __at (0xF93) DDRBbits;

extern __sfr __at (0xF93) TRISB;
typedef union {
	struct {
		unsigned TRISB0    	: 1;
		unsigned TRISB1    	: 1;
		unsigned TRISB2    	: 1;
		unsigned TRISB3    	: 1;
		unsigned TRISB4    	: 1;
		unsigned TRISB5    	: 1;
		unsigned TRISB6    	: 1;
		unsigned TRISB7    	: 1;
	};
} __TRISBbits_t;
extern volatile __TRISBbits_t __at (0xF93) TRISBbits;

extern __sfr __at (0xF94) DDRC;
typedef union {
	struct {
		unsigned RC0       	: 1;
		unsigned RC1       	: 1;
		unsigned RC2       	: 1;
		unsigned RC3       	: 1;
		unsigned RC4       	: 1;
		unsigned RC5       	: 1;
		unsigned RC6       	: 1;
		unsigned RC7       	: 1;
	};
} __DDRCbits_t;
extern volatile __DDRCbits_t __at (0xF94) DDRCbits;

extern __sfr __at (0xF94) TRISC;
typedef union {
	struct {
		unsigned TRISC0    	: 1;
		unsigned TRISC1    	: 1;
		unsigned TRISC2    	: 1;
		unsigned TRISC3    	: 1;
		unsigned TRISC4    	: 1;
		unsigned TRISC5    	: 1;
		unsigned TRISC6    	: 1;
		unsigned TRISC7    	: 1;
	};
} __TRISCbits_t;
extern volatile __TRISCbits_t __at (0xF94) TRISCbits;

extern __sfr __at (0xF95) DDRD;
typedef union {
	struct {
		unsigned RD0       	: 1;
		unsigned RD1       	: 1;
		unsigned RD2       	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __DDRDbits_t;
extern volatile __DDRDbits_t __at (0xF95) DDRDbits;

extern __sfr __at (0xF95) TRISD;
typedef union {
	struct {
		unsigned TRISD0    	: 1;
		unsigned TRISD1    	: 1;
		unsigned TRISD2    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __TRISDbits_t;
extern volatile __TRISDbits_t __at (0xF95) TRISDbits;

extern __sfr __at (0xF96) DDRE;
typedef union {
	struct {
		unsigned RE0       	: 1;
		unsigned RE1       	: 1;
		unsigned RE2       	: 1;
		unsigned RE3       	: 1;
		unsigned RE4       	: 1;
		unsigned RE5       	: 1;
		unsigned RE6       	: 1;
		unsigned RE7       	: 1;
	};
} __DDREbits_t;
extern volatile __DDREbits_t __at (0xF96) DDREbits;

extern __sfr __at (0xF96) TRISE;
typedef union {
	struct {
		unsigned TRISE0    	: 1;
		unsigned TRISE1    	: 1;
		unsigned TRISE2    	: 1;
		unsigned TRISE3    	: 1;
		unsigned TRISE4    	: 1;
		unsigned TRISE5    	: 1;
		unsigned TRISE6    	: 1;
		unsigned TRISE7    	: 1;
	};
} __TRISEbits_t;
extern volatile __TRISEbits_t __at (0xF96) TRISEbits;

extern __sfr __at (0xF97) DDRF;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned RF1       	: 1;
		unsigned RF2       	: 1;
		unsigned RF3       	: 1;
		unsigned RF4       	: 1;
		unsigned RF5       	: 1;
		unsigned RF6       	: 1;
		unsigned RF7       	: 1;
	};
} __DDRFbits_t;
extern volatile __DDRFbits_t __at (0xF97) DDRFbits;

extern __sfr __at (0xF97) TRISF;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned TRISF1    	: 1;
		unsigned TRISF2    	: 1;
		unsigned TRISF3    	: 1;
		unsigned TRISF4    	: 1;
		unsigned TRISF5    	: 1;
		unsigned TRISF6    	: 1;
		unsigned TRISF7    	: 1;
	};
} __TRISFbits_t;
extern volatile __TRISFbits_t __at (0xF97) TRISFbits;

extern __sfr __at (0xF98) DDRG;
typedef union {
	struct {
		unsigned RG0       	: 1;
		unsigned RG1       	: 1;
		unsigned RG2       	: 1;
		unsigned RG3       	: 1;
		unsigned RG4       	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __DDRGbits_t;
extern volatile __DDRGbits_t __at (0xF98) DDRGbits;

extern __sfr __at (0xF98) TRISG;
typedef union {
	struct {
		unsigned TRISG0    	: 1;
		unsigned TRISG1    	: 1;
		unsigned TRISG2    	: 1;
		unsigned TRISG3    	: 1;
		unsigned TRISG4    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __TRISGbits_t;
extern volatile __TRISGbits_t __at (0xF98) TRISGbits;

extern __sfr __at (0xF99) DDRH;
typedef union {
	struct {
		unsigned RH0       	: 1;
		unsigned RH1       	: 1;
		unsigned RH2       	: 1;
		unsigned RH3       	: 1;
		unsigned RH4       	: 1;
		unsigned RH5       	: 1;
		unsigned RH6       	: 1;
		unsigned RH7       	: 1;
	};
} __DDRHbits_t;
extern volatile __DDRHbits_t __at (0xF99) DDRHbits;

extern __sfr __at (0xF99) TRISH;
typedef union {
	struct {
		unsigned TRISH0    	: 1;
		unsigned TRISH1    	: 1;
		unsigned TRISH2    	: 1;
		unsigned TRISH3    	: 1;
		unsigned TRISH4    	: 1;
		unsigned TRISH5    	: 1;
		unsigned TRISH6    	: 1;
		unsigned TRISH7    	: 1;
	};
} __TRISHbits_t;
extern volatile __TRISHbits_t __at (0xF99) TRISHbits;

extern __sfr __at (0xF9A) DDRJ;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RJ4       	: 1;
		unsigned RJ5       	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __DDRJbits_t;
extern volatile __DDRJbits_t __at (0xF9A) DDRJbits;

extern __sfr __at (0xF9A) TRISJ;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned TRISJ4    	: 1;
		unsigned TRISJ5    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __TRISJbits_t;
extern volatile __TRISJbits_t __at (0xF9A) TRISJbits;

extern __sfr __at (0xF9B) OSCTUNE;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned PPRE      	: 1;
		unsigned PPST0     	: 1;
		unsigned PLLEN     	: 1;
		unsigned PPST1     	: 1;
	};
} __OSCTUNEbits_t;
extern volatile __OSCTUNEbits_t __at (0xF9B) OSCTUNEbits;

extern __sfr __at (0xF9D) PIE1;
typedef union {
	struct {
		unsigned TMR1IE    	: 1;
		unsigned TMR2IE    	: 1;
		unsigned CCP1IE    	: 1;
		unsigned SSPIE     	: 1;
		unsigned TXIE_PIE1 	: 1;
		unsigned RCIE      	: 1;
		unsigned ADIE      	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned SSP1IE    	: 1;
		unsigned TX1IE     	: 1;
		unsigned RC1IE     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __PIE1bits_t;
extern volatile __PIE1bits_t __at (0xF9D) PIE1bits;

extern __sfr __at (0xF9E) PIR1;
typedef union {
	struct {
		unsigned TMR1IF    	: 1;
		unsigned TMR2IF    	: 1;
		unsigned CCP1IF    	: 1;
		unsigned SSPIF     	: 1;
		unsigned TXIF_PIR1 	: 1;
		unsigned RCIF      	: 1;
		unsigned ADIF      	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned SSP1IF    	: 1;
		unsigned TX1IF     	: 1;
		unsigned RC1IF     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __PIR1bits_t;
extern volatile __PIR1bits_t __at (0xF9E) PIR1bits;

extern __sfr __at (0xF9F) IPR1;
typedef union {
	struct {
		unsigned TMR1IP    	: 1;
		unsigned TMR2IP    	: 1;
		unsigned CCP1IP    	: 1;
		unsigned SSPIP     	: 1;
		unsigned TXIP      	: 1;
		unsigned RCIP      	: 1;
		unsigned ADIP      	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned SSP1IP    	: 1;
		unsigned TX1IP     	: 1;
		unsigned RC1IP     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __IPR1bits_t;
extern volatile __IPR1bits_t __at (0xF9F) IPR1bits;

extern __sfr __at (0xFA0) PIE2;
typedef union {
	struct {
		unsigned CCP2IE    	: 1;
		unsigned TMR3IE    	: 1;
		unsigned           	: 1;
		unsigned BCLIE     	: 1;
		unsigned ETHWIE    	: 1;
		unsigned ETHIE     	: 1;
		unsigned CMIE      	: 1;
		unsigned OSCFIE    	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned BCL1IE    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __PIE2bits_t;
extern volatile __PIE2bits_t __at (0xFA0) PIE2bits;

extern __sfr __at (0xFA1) PIR2;
typedef union {
	struct {
		unsigned CCP2IF    	: 1;
		unsigned TMR3IF    	: 1;
		unsigned           	: 1;
		unsigned BCLIF     	: 1;
		unsigned ETHWIF    	: 1;
		unsigned ETHIF     	: 1;
		unsigned CMIF      	: 1;
		unsigned OSCFIF    	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned BCL1IF    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __PIR2bits_t;
extern volatile __PIR2bits_t __at (0xFA1) PIR2bits;

extern __sfr __at (0xFA2) IPR2;
typedef union {
	struct {
		unsigned CCP2IP    	: 1;
		unsigned TMR3IP    	: 1;
		unsigned           	: 1;
		unsigned BCLIP     	: 1;
		unsigned ETHWIP    	: 1;
		unsigned ETHIP     	: 1;
		unsigned CMIP      	: 1;
		unsigned OSCFIP    	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned BCL1IP    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __IPR2bits_t;
extern volatile __IPR2bits_t __at (0xFA2) IPR2bits;

extern __sfr __at (0xFA3) PIE3;
typedef union {
	struct {
		unsigned CCP3IE    	: 1;
		unsigned CCP4IE    	: 1;
		unsigned CCP5IE    	: 1;
		unsigned TMR4IE    	: 1;
		unsigned TX2IE     	: 1;
		unsigned RC2IE     	: 1;
		unsigned BCL2IE    	: 1;
		unsigned           	: 1;
	};
} __PIE3bits_t;
extern volatile __PIE3bits_t __at (0xFA3) PIE3bits;

extern __sfr __at (0xFA4) PIR3;
typedef union {
	struct {
		unsigned CCP3IF    	: 1;
		unsigned CCP4IF    	: 1;
		unsigned CCP5IF    	: 1;
		unsigned TMR4IF    	: 1;
		unsigned TX2IF     	: 1;
		unsigned RC2IF     	: 1;
		unsigned BCL2IF    	: 1;
		unsigned           	: 1;
	};
} __PIR3bits_t;
extern volatile __PIR3bits_t __at (0xFA4) PIR3bits;

extern __sfr __at (0xFA5) IPR3;
typedef union {
	struct {
		unsigned CCP3IP    	: 1;
		unsigned CCP4IP    	: 1;
		unsigned CCP5IP    	: 1;
		unsigned TMR4IP    	: 1;
		unsigned TX2IP     	: 1;
		unsigned RC2IP     	: 1;
		unsigned BCL2IP    	: 1;
		unsigned           	: 1;
	};
} __IPR3bits_t;
extern volatile __IPR3bits_t __at (0xFA5) IPR3bits;

extern __sfr __at (0xFA6) EECON1;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned WR        	: 1;
		unsigned WREN      	: 1;
		unsigned WRERR     	: 1;
		unsigned FREE      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __EECON1bits_t;
extern volatile __EECON1bits_t __at (0xFA6) EECON1bits;

extern __sfr __at (0xFA7) EECON2;

extern __sfr __at (0xFAB) RCSTA;
typedef union {
	struct {
		unsigned RX9D      	: 1;
		unsigned OERR      	: 1;
		unsigned FERR      	: 1;
		unsigned ADDEN     	: 1;
		unsigned CREN      	: 1;
		unsigned SREN      	: 1;
		unsigned RX9       	: 1;
		unsigned SPEN      	: 1;
	};
	struct {
		unsigned RCD8      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RC9       	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_RC8   	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RC8_9     	: 1;
		unsigned           	: 1;
	};
} __RCSTAbits_t;
extern volatile __RCSTAbits_t __at (0xFAB) RCSTAbits;

extern __sfr __at (0xFAB) RCSTA1;
typedef union {
	struct {
		unsigned RX9D      	: 1;
		unsigned OERR      	: 1;
		unsigned FERR      	: 1;
		unsigned ADDEN     	: 1;
		unsigned CREN      	: 1;
		unsigned SREN      	: 1;
		unsigned RX9       	: 1;
		unsigned SPEN      	: 1;
	};
	struct {
		unsigned RCD8      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RC9       	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_RC8   	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RC8_9     	: 1;
		unsigned           	: 1;
	};
} __RCSTA1bits_t;
extern volatile __RCSTA1bits_t __at (0xFAB) RCSTA1bits;

extern __sfr __at (0xFAC) TXSTA;
typedef union {
	struct {
		unsigned TX9D      	: 1;
		unsigned TRMT      	: 1;
		unsigned BRGH      	: 1;
		unsigned SENDB     	: 1;
		unsigned SYNC      	: 1;
		unsigned TXEN      	: 1;
		unsigned TX9       	: 1;
		unsigned CSRC      	: 1;
	};
	struct {
		unsigned TXD8      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned TX8_9     	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_TX8   	: 1;
		unsigned           	: 1;
	};
} __TXSTAbits_t;
extern volatile __TXSTAbits_t __at (0xFAC) TXSTAbits;

extern __sfr __at (0xFAC) TXSTA1;
typedef union {
	struct {
		unsigned TX9D      	: 1;
		unsigned TRMT      	: 1;
		unsigned BRGH      	: 1;
		unsigned SENDB     	: 1;
		unsigned SYNC      	: 1;
		unsigned TXEN      	: 1;
		unsigned TX9       	: 1;
		unsigned CSRC      	: 1;
	};
	struct {
		unsigned TXD8      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned TX8_9     	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_TX8   	: 1;
		unsigned           	: 1;
	};
} __TXSTA1bits_t;
extern volatile __TXSTA1bits_t __at (0xFAC) TXSTA1bits;

extern __sfr __at (0xFAD) TXREG;

extern __sfr __at (0xFAD) TXREG1;

extern __sfr __at (0xFAE) RCREG;

extern __sfr __at (0xFAE) RCREG1;

extern __sfr __at (0xFAF) SPBRG;

extern __sfr __at (0xFAF) SPBRG1;

extern __sfr __at (0xFB1) T3CON;
typedef union {
	struct {
		unsigned TMR3ON    	: 1;
		unsigned TMR3CS    	: 1;
		unsigned T3SYNC    	: 1;
		unsigned T3CCP1    	: 1;
		unsigned T3CKPS0   	: 1;
		unsigned T3CKPS1   	: 1;
		unsigned T3CCP2    	: 1;
		unsigned RD16      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned T3INSYNC  	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_T3SYNC	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __T3CONbits_t;
extern volatile __T3CONbits_t __at (0xFB1) T3CONbits;

extern __sfr __at (0xFB2) TMR3L;

extern __sfr __at (0xFB3) TMR3H;

extern __sfr __at (0xFB4) CMCON;
typedef union {
	struct {
		unsigned CM0       	: 1;
		unsigned CM1       	: 1;
		unsigned CM2       	: 1;
		unsigned CIS       	: 1;
		unsigned C1INV     	: 1;
		unsigned C2INV     	: 1;
		unsigned C1OUT     	: 1;
		unsigned C2OUT     	: 1;
	};
} __CMCONbits_t;
extern volatile __CMCONbits_t __at (0xFB4) CMCONbits;

extern __sfr __at (0xFB5) CVRCON;
typedef union {
	struct {
		unsigned CVR0      	: 1;
		unsigned CVR1      	: 1;
		unsigned CVR2      	: 1;
		unsigned CVR3      	: 1;
		unsigned CVRSS     	: 1;
		unsigned CVRR      	: 1;
		unsigned CVROE     	: 1;
		unsigned CVREN     	: 1;
	};
} __CVRCONbits_t;
extern volatile __CVRCONbits_t __at (0xFB5) CVRCONbits;

extern __sfr __at (0xFB6) ECCP1AS;
typedef union {
	struct {
		unsigned PSSBD0    	: 1;
		unsigned PSSBD1    	: 1;
		unsigned PSSAC0    	: 1;
		unsigned PSSAC1    	: 1;
		unsigned ECCPAS0   	: 1;
		unsigned ECCPAS1   	: 1;
		unsigned ECCPAS2   	: 1;
		unsigned ECCPASE   	: 1;
	};
	struct {
		unsigned PSS1BD0   	: 1;
		unsigned PSS1BD1   	: 1;
		unsigned PSS1AC0   	: 1;
		unsigned PSS1AC1   	: 1;
		unsigned ECCP1AS0  	: 1;
		unsigned ECCP1AS1  	: 1;
		unsigned ECCP1AS2  	: 1;
		unsigned ECCP1ASE  	: 1;
	};
} __ECCP1ASbits_t;
extern volatile __ECCP1ASbits_t __at (0xFB6) ECCP1ASbits;

extern __sfr __at (0xFB7) CCP3CON;
typedef union {
	struct {
		unsigned CCP3M0    	: 1;
		unsigned CCP3M1    	: 1;
		unsigned CCP3M2    	: 1;
		unsigned CCP3M3    	: 1;
		unsigned DC3B0     	: 1;
		unsigned DC3B1     	: 1;
		unsigned P3M0      	: 1;
		unsigned P3M1      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned CCP3Y     	: 1;
		unsigned CCP3X     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __CCP3CONbits_t;
extern volatile __CCP3CONbits_t __at (0xFB7) CCP3CONbits;

extern __sfr __at (0xFB7) ECCP3CON;
typedef union {
	struct {
		unsigned CCP3M0    	: 1;
		unsigned CCP3M1    	: 1;
		unsigned CCP3M2    	: 1;
		unsigned CCP3M3    	: 1;
		unsigned DC3B0     	: 1;
		unsigned DC3B1     	: 1;
		unsigned P3M0      	: 1;
		unsigned P3M1      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned CCP3Y     	: 1;
		unsigned CCP3X     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __ECCP3CONbits_t;
extern volatile __ECCP3CONbits_t __at (0xFB7) ECCP3CONbits;

extern __sfr __at (0xFB8) CCPR3;

extern __sfr __at (0xFB8) CCPR3L;

extern __sfr __at (0xFB9) CCPR3H;

extern __sfr __at (0xFBA) CCP2CON;
typedef union {
	struct {
		unsigned CCP2M0    	: 1;
		unsigned CCP2M1    	: 1;
		unsigned CCP2M2    	: 1;
		unsigned CCP2M3    	: 1;
		unsigned DC2B0     	: 1;
		unsigned DC2B1     	: 1;
		unsigned P2M0      	: 1;
		unsigned P2M1      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned CCP2Y     	: 1;
		unsigned CCP2X     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __CCP2CONbits_t;
extern volatile __CCP2CONbits_t __at (0xFBA) CCP2CONbits;

extern __sfr __at (0xFBA) ECCP2CON;
typedef union {
	struct {
		unsigned CCP2M0    	: 1;
		unsigned CCP2M1    	: 1;
		unsigned CCP2M2    	: 1;
		unsigned CCP2M3    	: 1;
		unsigned DC2B0     	: 1;
		unsigned DC2B1     	: 1;
		unsigned P2M0      	: 1;
		unsigned P2M1      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned CCP2Y     	: 1;
		unsigned CCP2X     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __ECCP2CONbits_t;
extern volatile __ECCP2CONbits_t __at (0xFBA) ECCP2CONbits;

extern __sfr __at (0xFBB) CCPR2;

extern __sfr __at (0xFBB) CCPR2L;

extern __sfr __at (0xFBC) CCPR2H;

extern __sfr __at (0xFBD) CCP1CON;
typedef union {
	struct {
		unsigned CCP1M0    	: 1;
		unsigned CCP1M1    	: 1;
		unsigned CCP1M2    	: 1;
		unsigned CCP1M3    	: 1;
		unsigned DC1B0     	: 1;
		unsigned DC1B1     	: 1;
		unsigned P1M0      	: 1;
		unsigned P1M1      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned CCP1Y     	: 1;
		unsigned CCP1X     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __CCP1CONbits_t;
extern volatile __CCP1CONbits_t __at (0xFBD) CCP1CONbits;

extern __sfr __at (0xFBD) ECCP1CON;
typedef union {
	struct {
		unsigned CCP1M0    	: 1;
		unsigned CCP1M1    	: 1;
		unsigned CCP1M2    	: 1;
		unsigned CCP1M3    	: 1;
		unsigned DC1B0     	: 1;
		unsigned DC1B1     	: 1;
		unsigned P1M0      	: 1;
		unsigned P1M1      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned CCP1Y     	: 1;
		unsigned CCP1X     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __ECCP1CONbits_t;
extern volatile __ECCP1CONbits_t __at (0xFBD) ECCP1CONbits;

extern __sfr __at (0xFBE) CCPR1;

extern __sfr __at (0xFBE) CCPR1L;

extern __sfr __at (0xFBF) CCPR1H;

extern __sfr __at (0xFC0) ADCON2;
typedef union {
	struct {
		unsigned ADCS0     	: 1;
		unsigned ADCS1     	: 1;
		unsigned ADCS2     	: 1;
		unsigned ACQT0     	: 1;
		unsigned ACQT1     	: 1;
		unsigned ACQT2     	: 1;
		unsigned           	: 1;
		unsigned ADFM      	: 1;
	};
} __ADCON2bits_t;
extern volatile __ADCON2bits_t __at (0xFC0) ADCON2bits;

extern __sfr __at (0xFC1) ADCON1;
typedef union {
	struct {
		unsigned PCFG0     	: 1;
		unsigned PCFG1     	: 1;
		unsigned PCFG2     	: 1;
		unsigned PCFG3     	: 1;
		unsigned VCFG0     	: 1;
		unsigned VCFG1     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __ADCON1bits_t;
extern volatile __ADCON1bits_t __at (0xFC1) ADCON1bits;

extern __sfr __at (0xFC2) ADCON0;
typedef union {
	struct {
		unsigned ADON      	: 1;
		unsigned DONE      	: 1;
		unsigned CHS0      	: 1;
		unsigned CHS1      	: 1;
		unsigned CHS2      	: 1;
		unsigned CHS3      	: 1;
		unsigned           	: 1;
		unsigned ADCAL     	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned GO_DONE   	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned GO        	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned NOT_DONE  	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __ADCON0bits_t;
extern volatile __ADCON0bits_t __at (0xFC2) ADCON0bits;

extern __sfr __at (0xFC3) ADRES;

extern __sfr __at (0xFC3) ADRESL;

extern __sfr __at (0xFC4) ADRESH;

extern __sfr __at (0xFC5) SSP1CON2;
typedef union {
	struct {
		unsigned SEN       	: 1;
		unsigned RSEN      	: 1;
		unsigned PEN       	: 1;
		unsigned RCEN      	: 1;
		unsigned ACKEN     	: 1;
		unsigned ACKDT     	: 1;
		unsigned ACKSTAT   	: 1;
		unsigned GCEN      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned ADMSK1    	: 1;
		unsigned ADMSK2    	: 1;
		unsigned ADMSK3    	: 1;
		unsigned ADMSK4    	: 1;
		unsigned ADMSK5    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned ADMSK     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __SSP1CON2bits_t;
extern volatile __SSP1CON2bits_t __at (0xFC5) SSP1CON2bits;

extern __sfr __at (0xFC5) SSPCON2;
typedef union {
	struct {
		unsigned SEN       	: 1;
		unsigned RSEN      	: 1;
		unsigned PEN       	: 1;
		unsigned RCEN      	: 1;
		unsigned ACKEN     	: 1;
		unsigned ACKDT     	: 1;
		unsigned ACKSTAT   	: 1;
		unsigned GCEN      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned ADMSK1    	: 1;
		unsigned ADMSK2    	: 1;
		unsigned ADMSK3    	: 1;
		unsigned ADMSK4    	: 1;
		unsigned ADMSK5    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned ADMSK     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __SSPCON2bits_t;
extern volatile __SSPCON2bits_t __at (0xFC5) SSPCON2bits;

extern __sfr __at (0xFC6) SSP1CON1;
typedef union {
	struct {
		unsigned SSPM0     	: 1;
		unsigned SSPM1     	: 1;
		unsigned SSPM2     	: 1;
		unsigned SSPM3     	: 1;
		unsigned CKP       	: 1;
		unsigned SSPEN     	: 1;
		unsigned SSPOV     	: 1;
		unsigned WCOL      	: 1;
	};
} __SSP1CON1bits_t;
extern volatile __SSP1CON1bits_t __at (0xFC6) SSP1CON1bits;

extern __sfr __at (0xFC6) SSPCON1;
typedef union {
	struct {
		unsigned SSPM0     	: 1;
		unsigned SSPM1     	: 1;
		unsigned SSPM2     	: 1;
		unsigned SSPM3     	: 1;
		unsigned CKP       	: 1;
		unsigned SSPEN     	: 1;
		unsigned SSPOV     	: 1;
		unsigned WCOL      	: 1;
	};
} __SSPCON1bits_t;
extern volatile __SSPCON1bits_t __at (0xFC6) SSPCON1bits;

extern __sfr __at (0xFC7) SSP1STAT;
typedef union {
	struct {
		unsigned BF        	: 1;
		unsigned UA        	: 1;
		unsigned R_W       	: 1;
		unsigned S         	: 1;
		unsigned P         	: 1;
		unsigned D_A       	: 1;
		unsigned CKE       	: 1;
		unsigned SMP       	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned I2C_READ  	: 1;
		unsigned I2C_START 	: 1;
		unsigned I2C_STOP  	: 1;
		unsigned I2C_DAT   	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_W     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_A     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_WRITE 	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_ADDRESS	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned READ_WRITE	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned DATA_ADDRESS	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned R         	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned D         	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __SSP1STATbits_t;
extern volatile __SSP1STATbits_t __at (0xFC7) SSP1STATbits;

extern __sfr __at (0xFC7) SSPSTAT;
typedef union {
	struct {
		unsigned BF        	: 1;
		unsigned UA        	: 1;
		unsigned R_W       	: 1;
		unsigned S         	: 1;
		unsigned P         	: 1;
		unsigned D_A       	: 1;
		unsigned CKE       	: 1;
		unsigned SMP       	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned I2C_READ  	: 1;
		unsigned I2C_START 	: 1;
		unsigned I2C_STOP  	: 1;
		unsigned I2C_DAT   	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_W     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_A     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_WRITE 	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_ADDRESS	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned READ_WRITE	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned DATA_ADDRESS	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned R         	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned D         	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __SSPSTATbits_t;
extern volatile __SSPSTATbits_t __at (0xFC7) SSPSTATbits;

extern __sfr __at (0xFC8) SSP1ADD;

extern __sfr __at (0xFC8) SSPADD;

extern __sfr __at (0xFC9) SSP1BUF;

extern __sfr __at (0xFC9) SSPBUF;

extern __sfr __at (0xFCA) T2CON;
typedef union {
	struct {
		unsigned T2CKPS0   	: 1;
		unsigned T2CKPS1   	: 1;
		unsigned TMR2ON    	: 1;
		unsigned T2OUTPS0  	: 1;
		unsigned T2OUTPS1  	: 1;
		unsigned T2OUTPS2  	: 1;
		unsigned T2OUTPS3  	: 1;
		unsigned           	: 1;
	};
} __T2CONbits_t;
extern volatile __T2CONbits_t __at (0xFCA) T2CONbits;

extern __sfr __at (0xFCB) PR2;

extern __sfr __at (0xFCC) TMR2;

extern __sfr __at (0xFCD) T1CON;
typedef union {
	struct {
		unsigned TMR1ON    	: 1;
		unsigned TMR1CS    	: 1;
		unsigned T1SYNC    	: 1;
		unsigned T1OSCEN   	: 1;
		unsigned T1CKPS0   	: 1;
		unsigned T1CKPS1   	: 1;
		unsigned T1RUN     	: 1;
		unsigned RD16      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned T1INSYNC  	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_T1SYNC	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __T1CONbits_t;
extern volatile __T1CONbits_t __at (0xFCD) T1CONbits;

extern __sfr __at (0xFCE) TMR1L;

extern __sfr __at (0xFCF) TMR1H;

extern __sfr __at (0xFD0) RCON;
typedef union {
	struct {
		unsigned NOT_BOR   	: 1;
		unsigned NOT_POR   	: 1;
		unsigned NOT_PD    	: 1;
		unsigned NOT_TO    	: 1;
		unsigned NOT_RI    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned IPEN      	: 1;
	};
	struct {
		unsigned BOR       	: 1;
		unsigned POR       	: 1;
		unsigned PD        	: 1;
		unsigned TO        	: 1;
		unsigned RI        	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __RCONbits_t;
extern volatile __RCONbits_t __at (0xFD0) RCONbits;

extern __sfr __at (0xFD1) WDTCON;
typedef union {
	struct {
		unsigned SWDTE     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned SWDTEN    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __WDTCONbits_t;
extern volatile __WDTCONbits_t __at (0xFD1) WDTCONbits;

extern __sfr __at (0xFD2) ECON1;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RXEN      	: 1;
		unsigned TXRTS     	: 1;
		unsigned CSUMEN    	: 1;
		unsigned DMAST     	: 1;
		unsigned RXRST     	: 1;
		unsigned TXRST     	: 1;
	};
} __ECON1bits_t;
extern volatile __ECON1bits_t __at (0xFD2) ECON1bits;

extern __sfr __at (0xFD3) OSCCON;
typedef union {
	struct {
		unsigned SCS0      	: 1;
		unsigned SCS1      	: 1;
		unsigned           	: 1;
		unsigned OSTS      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned IDLEN     	: 1;
	};
} __OSCCONbits_t;
extern volatile __OSCCONbits_t __at (0xFD3) OSCCONbits;

extern __sfr __at (0xFD5) T0CON;
typedef union {
	struct {
		unsigned T0PS0     	: 1;
		unsigned T0PS1     	: 1;
		unsigned T0PS2     	: 1;
		unsigned PSA       	: 1;
		unsigned T0SE      	: 1;
		unsigned T0CS      	: 1;
		unsigned T08BIT    	: 1;
		unsigned TMR0ON    	: 1;
	};
} __T0CONbits_t;
extern volatile __T0CONbits_t __at (0xFD5) T0CONbits;

extern __sfr __at (0xFD6) TMR0L;

extern __sfr __at (0xFD7) TMR0H;

extern __sfr __at (0xFD8) STATUS;
typedef union {
	struct {
		unsigned C         	: 1;
		unsigned DC        	: 1;
		unsigned Z         	: 1;
		unsigned OV        	: 1;
		unsigned N         	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __STATUSbits_t;
extern volatile __STATUSbits_t __at (0xFD8) STATUSbits;

extern __sfr __at (0xFD9) FSR2L;

extern __sfr __at (0xFDA) FSR2H;

extern __sfr __at (0xFDB) PLUSW2;

extern __sfr __at (0xFDC) PREINC2;

extern __sfr __at (0xFDD) POSTDEC2;

extern __sfr __at (0xFDE) POSTINC2;

extern __sfr __at (0xFDF) INDF2;

extern __sfr __at (0xFE0) BSR;

extern __sfr __at (0xFE1) FSR1L;

extern __sfr __at (0xFE2) FSR1H;

extern __sfr __at (0xFE3) PLUSW1;

extern __sfr __at (0xFE4) PREINC1;

extern __sfr __at (0xFE5) POSTDEC1;

extern __sfr __at (0xFE6) POSTINC1;

extern __sfr __at (0xFE7) INDF1;

extern __sfr __at (0xFE8) WREG;

extern __sfr __at (0xFE9) FSR0L;

extern __sfr __at (0xFEA) FSR0H;

extern __sfr __at (0xFEB) PLUSW0;

extern __sfr __at (0xFEC) PREINC0;

extern __sfr __at (0xFED) POSTDEC0;

extern __sfr __at (0xFEE) POSTINC0;

extern __sfr __at (0xFEF) INDF0;

extern __sfr __at (0xFF0) INTCON3;
typedef union {
	struct {
		unsigned INT1F     	: 1;
		unsigned INT2F     	: 1;
		unsigned INT3F     	: 1;
		unsigned INT1E     	: 1;
		unsigned INT2E     	: 1;
		unsigned INT3E     	: 1;
		unsigned INT1P     	: 1;
		unsigned INT2P     	: 1;
	};
	struct {
		unsigned INT1IF    	: 1;
		unsigned INT2IF    	: 1;
		unsigned INT3IF    	: 1;
		unsigned INT1IE    	: 1;
		unsigned INT2IE    	: 1;
		unsigned INT3IE    	: 1;
		unsigned INT1IP    	: 1;
		unsigned INT2IP    	: 1;
	};
} __INTCON3bits_t;
extern volatile __INTCON3bits_t __at (0xFF0) INTCON3bits;

extern __sfr __at (0xFF1) INTCON2;
typedef union {
	struct {
		unsigned RBIP      	: 1;
		unsigned INT3IP    	: 1;
		unsigned T0IP      	: 1;
		unsigned INTEDG3   	: 1;
		unsigned INTEDG2   	: 1;
		unsigned INTEDG1   	: 1;
		unsigned INTEDG0   	: 1;
		unsigned NOT_RBPU  	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned TMR0IP    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RBPU      	: 1;
	};
} __INTCON2bits_t;
extern volatile __INTCON2bits_t __at (0xFF1) INTCON2bits;

extern __sfr __at (0xFF2) INTCON;
typedef union {
	struct {
		unsigned RBIF      	: 1;
		unsigned INT0F     	: 1;
		unsigned T0IF      	: 1;
		unsigned RBIE      	: 1;
		unsigned INT0E     	: 1;
		unsigned T0IE      	: 1;
		unsigned PEIE      	: 1;
		unsigned GIE       	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned INT0IF    	: 1;
		unsigned TMR0IF    	: 1;
		unsigned           	: 1;
		unsigned INT0IE    	: 1;
		unsigned TMR0IE    	: 1;
		unsigned GIEL      	: 1;
		unsigned GIEH      	: 1;
	};
} __INTCONbits_t;
extern volatile __INTCONbits_t __at (0xFF2) INTCONbits;

extern __sfr __at (0xFF3) PROD;

extern __sfr __at (0xFF3) PRODL;

extern __sfr __at (0xFF4) PRODH;

extern __sfr __at (0xFF5) TABLAT;

extern __sfr __at (0xFF6) TBLPTR;

extern __sfr __at (0xFF6) TBLPTRL;

extern __sfr __at (0xFF7) TBLPTRH;

extern __sfr __at (0xFF8) TBLPTRU;

extern __sfr __at (0xFF9) PC;

extern __sfr __at (0xFF9) PCL;

extern __sfr __at (0xFFA) PCLATH;

extern __sfr __at (0xFFB) PCLATU;

extern __sfr __at (0xFFC) STKPTR;
typedef union {
	struct {
		unsigned STKPTR0   	: 1;
		unsigned STKPTR1   	: 1;
		unsigned STKPTR2   	: 1;
		unsigned STKPTR3   	: 1;
		unsigned STKPTR4   	: 1;
		unsigned           	: 1;
		unsigned STKUNF    	: 1;
		unsigned STKOVF    	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned STKFUL    	: 1;
	};
} __STKPTRbits_t;
extern volatile __STKPTRbits_t __at (0xFFC) STKPTRbits;

extern __sfr __at (0xFFD) TOS;

extern __sfr __at (0xFFD) TOSL;

extern __sfr __at (0xFFE) TOSH;

extern __sfr __at (0xFFF) TOSU;


#endif

