#include <fitkitlib.h>
#include <string.h>

#include <lcd/display.h>
#include <picocpu/picocpu.h>


/*******************************************************************************
 * Vypis uzivatelske napovedy (funkce se vola pri vykonavani prikazu "help")
*******************************************************************************/
void print_user_help(void)
{
term_send_str_crlf(" CLEAR   ... smazani displeje");
       term_send_str_crlf(" STRING string ... zapis retezce na displej");
term_send_str_crlf(" FLASH W HEX ...... zapis programu ve formatu HEX pro HW-CPU");
       term_send_str_crlf("                    (soubor 7168 B vytvoreny KCPSM3.EXE)");
       term_send_str_crlf(" CPU STOP ...... zastaveni CPU");
       term_send_str_crlf(" CPU START ..... reset CPU");
       term_send_str_crlf(" CPU UPDATE ...... aktualizace programu (+autostart programu)");
       term_send_str_crlf(" PROG ...... naprogramovani a aktualizace");

}

/*******************************************************************************
 * Dekodovani uzivatelskych prikazu a jejich vykonavani
*******************************************************************************/
unsigned char decode_user_cmd(char *cmd_ucase, char *cmd)
{
if (strcmp5(cmd_ucase, "CLEAR"))  // Vymazani displaye
       {
         LCD_clear();
         return USER_COMMAND;
       }
       else if (strcmp7(cmd_ucase, "STRING "))
       {    // Zapis znaku na Display
         term_send_str("Poslano na displej: ");
         term_send_str((unsigned char *)&cmd[7]);
         term_send_crlf();
     
         LCD_append_string((unsigned char *)&cmd[7]);
         return USER_COMMAND;
       }
if (strcmp(cmd_ucase, "FLASH W HEX") == 0)
        {
          FLASH_WriteFile(PICOROM_PAGE,"Program pro PicoBlaze (7168B)","*.hex",32); //max 8291B
          return USER_COMMAND;
        }
        else if (strcmp(cmd_ucase, "CPU STOP") == 0) {
          PicoCPU_disable();
          return (USER_COMMAND);
        }
        else if (strcmp(cmd_ucase, "CPU START") == 0) {
          PicoCPU_enable();
          return (USER_COMMAND);
        }
        else if (strcmp(cmd_ucase, "CPU UPDATE") == 0) {
          PicoCPU_disable();
          PicoCPU_program();
          PicoCPU_enable();
          return (USER_COMMAND);
        }
        else if (strcmp(cmd_ucase, "PROG") == 0)
        {
          FLASH_WriteFile(PICOROM_PAGE,"Program pro PicoBlaze (7168B)","*.hex",32); //max 8291B
          PicoCPU_disable();
          PicoCPU_program();
          PicoCPU_enable();
          return USER_COMMAND;
        }


   return CMD_UNKNOWN;
}

/*******************************************************************************
 * Inicializace periferii/komponent po naprogramovani FPGA
*******************************************************************************/
void fpga_initialized() {
LCD_init();
		PicoCPU_disable();
        PicoCPU_program();
        //PicoCPU_enable();
}

/*******************************************************************************
 * Obsluha preruseni z FPGA
*******************************************************************************/
void fpga_interrupt_handler(unsigned char bits)
{

}

/*******************************************************************************
 * Hlavni funkce
*******************************************************************************/
int main(void)
{
   short counter = 0;
   unsigned int iter = 0;

   initialize_hardware();

   set_led_d6(1);  //rozsvitit LED D6
   set_led_d5(1);  //rozsvitit LED D5

   

   while (1) 
   {
         
      delay_ms(1);  //zpozdeni 1ms

      counter++;
      if (counter == 500) 
      {
         flip_led_d6(); //invertovat LED

         iter++;
         counter = 0;
      }

      

      terminal_idle();  // obsluha terminalu
   }

}

