/*
 * Decompiled with CFR 0.152.
 */
package program.actions;

import com.mxgraph.analysis.mxAnalysisGraph;
import com.mxgraph.analysis.mxGraphStructure;
import com.mxgraph.model.mxCell;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.util.mxResources;
import com.mxgraph.view.mxGraph;
import editor.GraphIO;
import editor.GraphViewPanel;
import editor.StyleDialogMaker;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import program.MainPanel;
import program.Program;
import program.actions.GraphComponentAction;
import simulator.graphs.AlgorithmGraph;
import simulator.graphs.BasicStylesheet;
import simulator.graphs.GraphEdgeData;
import simulator.graphs.GraphVertexData;
import simulator.gui.AlgorithmFrame;
import simulator.gui.panels.BellmanFordPanel;
import simulator.gui.panels.BfsPanel;
import simulator.gui.panels.DfsPanel;
import simulator.gui.panels.DijkstraPanel;
import simulator.gui.panels.SccPanel;
import simulator.gui.panels.TopologicalSortPanel;

public class BasicActions {
    private static void simulatorGraphError(MainPanel editor) {
        JOptionPane.showMessageDialog(editor.getGraphComponent(), mxResources.get("SimulatorInputGraphError"), mxResources.get("error"), 0);
    }

    public static class ParallelEdgeLabelAction
    extends GraphComponentAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            GraphViewPanel graphView = ParallelEdgeLabelAction.getMainPanel(e).getGraphPanel();
            graphView.doParallelEdgeLayout();
        }
    }

    public static class HideVertexLabelAction
    extends GraphComponentAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            GraphViewPanel graphView;
            graphView.setVertexLabel(!(graphView = HideVertexLabelAction.getMainPanel(e).getGraphPanel()).isVertexLabel());
        }
    }

    public static class HideEdgeLabelAction
    extends GraphComponentAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            GraphViewPanel graphView;
            graphView.setEdgeLabel(!(graphView = HideEdgeLabelAction.getMainPanel(e).getGraphPanel()).isEdgeLabel());
        }
    }

    public static class BellmanFordSimulatorAction
    extends GraphComponentAction {
        private boolean isGraphOk(AlgorithmGraph clonedGraph) {
            Object[] vertices = clonedGraph.getChildVertices(clonedGraph.getDefaultParent());
            return vertices.length != 0;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainPanel editor = BellmanFordSimulatorAction.getMainPanel(e);
            AlgorithmGraph clonedGraph = new AlgorithmGraph();
            BasicStylesheet stylesheet = BasicStylesheet.getFromMxStylesheet(editor.getGraph().getStylesheet());
            clonedGraph.addCells(editor.getGraph().cloneCells(editor.getGraph().getChildCells(editor.getGraph().getDefaultParent())));
            clonedGraph.setStylesheet(stylesheet);
            if (this.isGraphOk(clonedGraph)) {
                JFrame frame = AlgorithmFrame.getAlgorithmFrame(new BellmanFordPanel(clonedGraph), mxResources.get("BellmanFordSimulatorFrame"));
                frame.setVisible(true);
            } else {
                BasicActions.simulatorGraphError(editor);
            }
        }
    }

    public static class DijkstraSimulatorAction
    extends GraphComponentAction {
        private boolean isGraphOk(AlgorithmGraph clonedGraph) {
            Object[] vertices = clonedGraph.getChildVertices(clonedGraph.getDefaultParent());
            return vertices.length != 0;
        }

        private boolean isNegativeEdgeInGraph(AlgorithmGraph clonedGraph) {
            for (Object o : clonedGraph.getChildEdges(clonedGraph.getDefaultParent())) {
                GraphEdgeData edge = (GraphEdgeData)((mxCell)o).getValue();
                if (!(edge.getDistance() < 0.0)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainPanel editor = DijkstraSimulatorAction.getMainPanel(e);
            AlgorithmGraph clonedGraph = new AlgorithmGraph();
            BasicStylesheet stylesheet = BasicStylesheet.getFromMxStylesheet(editor.getGraph().getStylesheet());
            clonedGraph.addCells(editor.getGraph().cloneCells(editor.getGraph().getChildCells(editor.getGraph().getDefaultParent())));
            clonedGraph.setStylesheet(stylesheet);
            if (this.isGraphOk(clonedGraph)) {
                int ret;
                if (this.isNegativeEdgeInGraph(clonedGraph) && (ret = JOptionPane.showConfirmDialog(editor.getGraphComponent(), mxResources.get("SimulatorDijkstraNonValidGraph"), mxResources.get("warning"), 0)) != 0) {
                    return;
                }
                JFrame frame = AlgorithmFrame.getAlgorithmFrame(new DijkstraPanel(clonedGraph), mxResources.get("DijkstraSimulatorFrame"));
                frame.setVisible(true);
            } else {
                BasicActions.simulatorGraphError(editor);
            }
        }
    }

    public static class TopologicalSortSimulatorAction
    extends GraphComponentAction {
        private boolean isGraphOk(AlgorithmGraph clonedGraph) {
            Object[] vertices = clonedGraph.getChildVertices(clonedGraph.getDefaultParent());
            return vertices.length != 0;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainPanel editor = TopologicalSortSimulatorAction.getMainPanel(e);
            AlgorithmGraph clonedGraph = new AlgorithmGraph();
            BasicStylesheet stylesheet = BasicStylesheet.getFromMxStylesheet(editor.getGraph().getStylesheet());
            clonedGraph.addCells(editor.getGraph().cloneCells(editor.getGraph().getChildCells(editor.getGraph().getDefaultParent())));
            clonedGraph.setStylesheet(stylesheet);
            if (this.isGraphOk(clonedGraph)) {
                int ret;
                mxAnalysisGraph aGraph = new mxAnalysisGraph();
                aGraph.setGraph(clonedGraph);
                if (mxGraphStructure.isCyclicDirected(aGraph) && (ret = JOptionPane.showConfirmDialog(editor.getGraphComponent(), mxResources.get("SimulatorTopoSortNonValidGraph"), mxResources.get("warning"), 0)) != 0) {
                    return;
                }
                JFrame frame = AlgorithmFrame.getAlgorithmFrame(new TopologicalSortPanel(clonedGraph), mxResources.get("TopologicalSortSimulatorFrame"));
                frame.setVisible(true);
            } else {
                BasicActions.simulatorGraphError(editor);
            }
        }
    }

    public static class SccSimulatorAction
    extends GraphComponentAction {
        private boolean isGraphOk(AlgorithmGraph clonedGraph) {
            Object[] vertices = clonedGraph.getChildVertices(clonedGraph.getDefaultParent());
            return vertices.length != 0;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainPanel editor = SccSimulatorAction.getMainPanel(e);
            AlgorithmGraph clonedGraph = new AlgorithmGraph();
            BasicStylesheet stylesheet = BasicStylesheet.getFromMxStylesheet(editor.getGraph().getStylesheet());
            clonedGraph.addCells(editor.getGraph().cloneCells(editor.getGraph().getChildCells(editor.getGraph().getDefaultParent())));
            clonedGraph.setStylesheet(stylesheet);
            if (this.isGraphOk(clonedGraph)) {
                JFrame frame = AlgorithmFrame.getAlgorithmFrame(new SccPanel(clonedGraph), mxResources.get("SccSimulatorFrame"));
                frame.setVisible(true);
            } else {
                BasicActions.simulatorGraphError(editor);
            }
        }
    }

    public static class DfsSimulatorAction
    extends GraphComponentAction {
        private boolean isGraphOk(AlgorithmGraph clonedGraph) {
            Object[] vertices = clonedGraph.getChildVertices(clonedGraph.getDefaultParent());
            return vertices.length != 0;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainPanel editor = DfsSimulatorAction.getMainPanel(e);
            AlgorithmGraph clonedGraph = new AlgorithmGraph();
            BasicStylesheet stylesheet = BasicStylesheet.getFromMxStylesheet(editor.getGraph().getStylesheet());
            clonedGraph.addCells(editor.getGraph().cloneCells(editor.getGraph().getChildCells(editor.getGraph().getDefaultParent())));
            clonedGraph.setStylesheet(stylesheet);
            if (this.isGraphOk(clonedGraph)) {
                JFrame frame = AlgorithmFrame.getAlgorithmFrame(new DfsPanel(clonedGraph), mxResources.get("DfsSimulatorFrame"));
                frame.setVisible(true);
            } else {
                BasicActions.simulatorGraphError(editor);
            }
        }
    }

    public static class BfsSimulatorAction
    extends GraphComponentAction {
        private boolean isGraphOk(AlgorithmGraph clonedGraph) {
            Object[] vertices = clonedGraph.getChildVertices(clonedGraph.getDefaultParent());
            return vertices.length != 0;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainPanel editor = BfsSimulatorAction.getMainPanel(e);
            AlgorithmGraph clonedGraph = new AlgorithmGraph();
            BasicStylesheet stylesheet = BasicStylesheet.getFromMxStylesheet(editor.getGraph().getStylesheet());
            clonedGraph.addCells(editor.getGraph().cloneCells(editor.getGraph().getChildCells(editor.getGraph().getDefaultParent())));
            clonedGraph.setStylesheet(stylesheet);
            if (this.isGraphOk(clonedGraph)) {
                JFrame frame = AlgorithmFrame.getAlgorithmFrame(new BfsPanel(clonedGraph), mxResources.get("BfsSimulatorFrame"));
                frame.setVisible(true);
            } else {
                BasicActions.simulatorGraphError(editor);
            }
        }
    }

    public static class SetCellSelectedAction
    extends GraphComponentAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            MainPanel editor = SetCellSelectedAction.getMainPanel(e);
            mxCell selected = (mxCell)editor.getGraph().getSelectionCell();
            if (selected != null) {
                if (selected.isVertex()) {
                    editor.getGraph().getModel().beginUpdate();
                    for (Object o : editor.getGraph().getChildVertices(editor.getGraph().getDefaultParent())) {
                        mxCell cell = (mxCell)o;
                        GraphVertexData data = (GraphVertexData)cell.getValue();
                        if (cell == selected && !data.getSelected().booleanValue()) {
                            editor.getGraph().getModel().setValue(cell, new GraphVertexData(data.getName(), true));
                            editor.getGraph().getModel().setStyle(cell, "SELECTED_VERTEX_STYLE");
                            continue;
                        }
                        if (!data.getSelected().booleanValue()) continue;
                        editor.getGraph().getModel().setValue(cell, new GraphVertexData(data.getName(), false));
                        editor.getGraph().getModel().setStyle(cell, "VERTEX_STYLE");
                    }
                    editor.getGraph().getModel().endUpdate();
                    editor.getGraph().refresh();
                } else {
                    JOptionPane.showMessageDialog(editor.getGraphComponent(), mxResources.get("SelectedEdgeError"), mxResources.get("error"), 0);
                }
            }
        }
    }

    public static class ZoomAction
    extends GraphComponentAction {
        private double zoom;

        public ZoomAction(double zoom) {
            this.zoom = zoom;
        }

        public double getZoom() {
            return this.zoom;
        }

        public void setZoom(double zoom) {
            this.zoom = zoom;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.zoom > 0.0) {
                mxGraphComponent mxGC = ZoomAction.getMainPanel(e).getGraphComponent();
                mxGC.zoomTo(this.zoom, mxGC.isCenterZoom());
            }
        }
    }

    public static class SetStyleAction
    extends GraphComponentAction {
        protected StyleDialogMaker.StyleDialog styleDialog = null;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.styleDialog == null) {
                this.styleDialog = StyleDialogMaker.getStyleDialog(SetStyleAction.getProgramFrame(e), SetStyleAction.getMainPanel(e));
            }
            if (!this.styleDialog.isVisible()) {
                this.styleDialog.setStyles(SetStyleAction.getMainPanel(e).getGraphComponent().getGraph().getStylesheet());
                this.styleDialog.setVisible(true);
            }
        }
    }

    public static class MaximizeAction
    extends GraphComponentAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            Program p;
            p.setMaximize(!(p = MaximizeAction.getProgramFrame(e)).isMaximize());
        }
    }

    public static class EnglishLanguageAction
    extends GraphComponentAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            Program p = EnglishLanguageAction.getProgramFrame(e);
            mxResources.add("resources/english_language");
        }
    }

    public static class CzechLanguageAction
    extends GraphComponentAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            Program p = CzechLanguageAction.getProgramFrame(e);
            mxResources.add("resources/czech_language");
        }
    }

    public static class FullScreenAction
    extends GraphComponentAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            Program p;
            p.setFullscreen(!(p = FullScreenAction.getProgramFrame(e)).isFullScreen());
        }
    }

    public static class ToolBarLabelsAction
    extends GraphComponentAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            ToolBarLabelsAction.getProgramFrame(e).showOrHideLabels();
        }
    }

    public static class RedoAction
    extends GraphComponentAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            RedoAction.getMainPanel(e).getEditorUndoManager().redo();
        }
    }

    public static class UndoAction
    extends GraphComponentAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            UndoAction.getMainPanel(e).getEditorUndoManager().undo();
        }
    }

    public static class SaveAction
    extends GraphComponentAction {
        protected boolean showDialog;
        protected String lastDir = null;

        public SaveAction(boolean showDialog) {
            this.showDialog = showDialog;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainPanel editor = SaveAction.getMainPanel(e);
            mxGraphComponent graphComponent = editor.getGraphComponent();
            mxGraph graph = graphComponent.getGraph();
            String filename = null;
            boolean dialogShown = false;
            if (this.showDialog || editor.getCurrentFile() == null) {
                String wd = this.lastDir != null ? this.lastDir : (editor.getCurrentFile() != null ? editor.getCurrentFile().getParent() : System.getProperty("user.dir"));
                JFileChooser fc = new JFileChooser(wd);
                FileFilter defaultFilter = new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.isDirectory() || file.getName().toLowerCase().endsWith(".xml");
                    }

                    @Override
                    public String getDescription() {
                        return mxResources.get("FileDesc") + " (.xml)";
                    }
                };
                fc.addChoosableFileFilter(defaultFilter);
                fc.setFileFilter(defaultFilter);
                int rc = fc.showDialog(null, mxResources.get("save"));
                dialogShown = true;
                if (rc != 0) {
                    return;
                }
                this.lastDir = fc.getSelectedFile().getParent();
                filename = fc.getSelectedFile().getAbsolutePath();
                if (!filename.toLowerCase().endsWith(".xml")) {
                    filename = filename + ".xml";
                }
                if (new File(filename).exists() && JOptionPane.showConfirmDialog(graphComponent, mxResources.get("overwriteExistingFile")) != 0) {
                    return;
                }
            } else {
                filename = editor.getCurrentFile().getAbsolutePath();
            }
            try {
                String ext = filename.substring(filename.lastIndexOf(46) + 1);
                if (ext.equalsIgnoreCase("xml")) {
                    GraphIO.writeGraph(graph, Paths.get(filename, new String[0]));
                    editor.setModified(false);
                    editor.setCurrentFile(new File(filename));
                }
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(editor.getGraphComponent(), ex.getMessage(), mxResources.get("error"), 0);
            }
        }
    }

    public static class OpenAction
    extends GraphComponentAction {
        protected String lastDir;

        private boolean checkGraphNames(AlgorithmGraph loadedGraph) {
            for (Object o1 : loadedGraph.getChildVertices(loadedGraph.getDefaultParent())) {
                for (Object o2 : loadedGraph.getChildVertices(loadedGraph.getDefaultParent())) {
                    if (o1 == o2) continue;
                    GraphVertexData data1 = (GraphVertexData)((mxCell)o1).getValue();
                    GraphVertexData data2 = (GraphVertexData)((mxCell)o2).getValue();
                    if (!data1.getName().isEmpty() && !data1.getName().equalsIgnoreCase(data2.getName())) continue;
                    return false;
                }
            }
            return true;
        }

        private boolean checkGraphCells(AlgorithmGraph loadedGraph) {
            for (Object o : loadedGraph.getChildEdges(loadedGraph.getDefaultParent())) {
                mxCell cell = (mxCell)o;
                if (cell.isVertex()) {
                    if (cell.getValue() instanceof GraphVertexData) continue;
                    return false;
                }
                if (!(cell.getValue() instanceof GraphEdgeData)) {
                    return false;
                }
                if (cell.getSource() != null && cell.getTarget() != null) continue;
                return false;
            }
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            mxGraph graph;
            MainPanel editor = OpenAction.getMainPanel(e);
            if (!(editor.isModified() && JOptionPane.showConfirmDialog(editor, mxResources.get("loseChanges"), mxResources.get("warningSaveTitle"), 0) != 0 || (graph = editor.getGraphComponent().getGraph()) == null)) {
                String wd = this.lastDir != null ? this.lastDir : System.getProperty("user.dir");
                JFileChooser fc = new JFileChooser(wd);
                FileFilter defaultFilter = new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.isDirectory() || file.getName().toLowerCase().endsWith(".xml");
                    }

                    @Override
                    public String getDescription() {
                        return mxResources.get("FileDesc") + " (.xml)";
                    }
                };
                fc.addChoosableFileFilter(defaultFilter);
                fc.setFileFilter(defaultFilter);
                int rc = fc.showDialog(null, mxResources.get("openFile"));
                if (rc == 0) {
                    this.lastDir = fc.getSelectedFile().getParent();
                    try {
                        AlgorithmGraph loadedGraph = GraphIO.readGraph(Paths.get(fc.getSelectedFile().getAbsolutePath(), new String[0]));
                        if (!this.checkGraphNames(loadedGraph)) {
                            JOptionPane.showMessageDialog(editor.getGraphComponent(), mxResources.get("badVertexNameLoadError"), mxResources.get("error"), 0);
                            return;
                        }
                        if (!this.checkGraphCells(loadedGraph)) {
                            JOptionPane.showMessageDialog(editor.getGraphComponent(), mxResources.get("badCellLoadError"), mxResources.get("error"), 0);
                            return;
                        }
                        editor.setGraph(loadedGraph);
                        editor.setCurrentFile(fc.getSelectedFile());
                        editor.setModified(false);
                        editor.getEditorUndoManager().clear();
                        editor.getGraphComponent().zoomAndCenter();
                    }
                    catch (GraphIO.GraphIOBadXmlException | IOException | ParserConfigurationException | SAXException ex) {
                        JOptionPane.showMessageDialog(editor.getGraphComponent(), ex.getMessage(), mxResources.get("error"), 0);
                    }
                }
            }
        }
    }

    public static class NewAction
    extends GraphComponentAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            MainPanel editor = NewAction.getMainPanel(e);
            if (!(editor == null || editor.isModified() && JOptionPane.showConfirmDialog(editor, mxResources.get("loseChanges")) != 0)) {
                editor.getGraphPanel().clearGraph();
                editor.getEditorUndoManager().clear();
                editor.setModified(false);
                editor.setCurrentFile(null);
                editor.getGraphComponent().zoomAndCenter();
            }
        }
    }

    public static class ShowManualAction
    extends GraphComponentAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            ShowManualAction.getProgramFrame(e).manual();
        }
    }

    public static class AboutAction
    extends GraphComponentAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            AboutAction.getProgramFrame(e).about();
        }
    }

    public static class ExitAction
    extends GraphComponentAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            MainPanel editor = ExitAction.getMainPanel(e);
            if (!editor.isModified() || JOptionPane.showConfirmDialog(editor, mxResources.get("loseChanges"), mxResources.get("warningSaveTitle"), 0) == 0) {
                System.exit(0);
            }
        }
    }
}

