/*
 * Decompiled with CFR 0.152.
 */
package simulator.controllers;

import com.mxgraph.model.mxCell;
import java.util.Deque;
import java.util.LinkedList;
import javax.swing.JLabel;
import simulator.controllers.AbstractController;
import simulator.graphs.AlgorithmGraph;
import simulator.graphs.AlgorithmGraphComponent;
import simulator.graphs.GraphCell;
import simulator.graphs.dfs.DfsGraphEdge;
import simulator.graphs.dfs.DfsGraphVertex;
import simulator.gui.VariablesPanel;
import simulator.gui.VisualizationPseudocodePanel;

public class AbstractDfsController
extends AbstractController {
    protected int timeVariable = 0;
    protected Integer variableV = 0;
    protected Integer variableU = 1;
    protected Deque<mxCell> vertexList = new LinkedList<mxCell>();
    protected Deque<mxCell> visitStack = new LinkedList<mxCell>();
    protected Deque<ContextObject> contextStack = new LinkedList<ContextObject>();

    public AbstractDfsController(AlgorithmGraphComponent graphCom, JLabel graphComponentLabel, VisualizationPseudocodePanel completeCodePanel, VariablesPanel variablesPanel) {
        super(graphCom, graphComponentLabel, completeCodePanel, variablesPanel);
    }

    protected ContextObject getContext(AbstractController.Instruction next) {
        return new DfsContextObject(next);
    }

    protected final class ZeroTimeEdit
    extends AbstractController.AlgorithmUndoableEdit {
        protected int oldTime;

        public ZeroTimeEdit() {
            this.oldTime = AbstractDfsController.this.timeVariable;
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            AbstractDfsController.this.timeVariable = this.oldTime;
        }

        @Override
        protected void action() {
            AbstractDfsController.this.timeVariable = 0;
        }
    }

    protected final class IncTimeEdit
    extends AbstractController.AlgorithmUndoableEdit {
        public IncTimeEdit() {
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            --AbstractDfsController.this.timeVariable;
        }

        @Override
        protected void action() {
            ++AbstractDfsController.this.timeVariable;
        }
    }

    protected class ChangeTimeInstruction
    extends AbstractController.BasicInstruction {
        protected boolean zero;
        protected boolean inc;

        public ChangeTimeInstruction() {
            this(false, true);
        }

        public ChangeTimeInstruction(boolean zero) {
            this(zero, false);
        }

        public ChangeTimeInstruction(boolean zero, boolean inc) {
            this.zero = zero;
            this.inc = inc;
        }

        @Override
        public void preform() {
            if (this.zero) {
                AbstractDfsController.this.editBlock.addEdit(new ZeroTimeEdit());
            } else if (this.inc) {
                AbstractDfsController.this.editBlock.addEdit(new IncTimeEdit());
            }
        }
    }

    protected final class SetTimeEdit
    extends AbstractController.AlgorithmUndoableEdit {
        protected DfsGraphVertex graphNode;
        protected boolean first;
        protected Integer newTime;
        protected Integer oldTime;

        public SetTimeEdit(mxCell node, int time, boolean first) {
            this.graphNode = (DfsGraphVertex)node.getValue();
            this.newTime = time;
            this.first = first;
            this.oldTime = this.first ? this.graphNode.getFirstTimestamp() : this.graphNode.getSecondTimestamp();
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            if (this.first) {
                this.graphNode.setFirstTimestamp(this.oldTime);
            } else {
                this.graphNode.setSecondTimestamp(this.oldTime);
            }
        }

        @Override
        protected void action() {
            if (this.first) {
                this.graphNode.setFirstTimestamp(this.newTime);
            } else {
                this.graphNode.setSecondTimestamp(this.newTime);
            }
        }
    }

    protected class SetTimeInstruction
    extends AbstractController.BasicInstruction {
        protected boolean first;

        public SetTimeInstruction(boolean first) {
            this.first = first;
        }

        @Override
        public void preform() {
            AbstractDfsController.this.editBlock.addEdit(new SetTimeEdit((mxCell)AbstractDfsController.this.activeVariable, AbstractDfsController.this.timeVariable, this.first));
        }
    }

    protected final class SetDfsEdgeTypeEdit
    extends AbstractController.AlgorithmUndoableEdit {
        protected DfsGraphEdge edge;
        protected DfsGraphEdge.DfsEdgeType oldType;
        protected DfsGraphEdge.DfsEdgeType newType;

        public SetDfsEdgeTypeEdit(DfsGraphEdge edge, DfsGraphEdge.DfsEdgeType newType) {
            this.edge = edge;
            this.newType = newType;
            this.oldType = edge.getEdgeType();
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            this.edge.setEdgeType(this.oldType);
        }

        @Override
        protected void action() {
            this.edge.setEdgeType(this.newType);
        }
    }

    protected class SetDfsEdgeTypeInstruction
    extends AbstractController.BasicInstruction {
        protected int registerNum;
        protected String pathEdgeStyle;
        protected String edgeStyle;

        public SetDfsEdgeTypeInstruction(int registerNum, String pathEdgeStyle, String edgeStyle) {
            this.registerNum = registerNum;
            this.pathEdgeStyle = pathEdgeStyle;
            this.edgeStyle = edgeStyle;
        }

        @Override
        public void preform() {
            for (int i = 0; i < AbstractDfsController.this.graph.getModel().getEdgeCount(AbstractDfsController.this.activeVariable); ++i) {
                mxCell edge = (mxCell)AbstractDfsController.this.graph.getModel().getEdgeAt(AbstractDfsController.this.activeVariable, i);
                mxCell target = (mxCell)edge.getTarget();
                mxCell source = (mxCell)edge.getSource();
                DfsGraphVertex targetValue = (DfsGraphVertex)target.getValue();
                DfsGraphVertex sourceValue = (DfsGraphVertex)source.getValue();
                DfsGraphEdge edgeValue = (DfsGraphEdge)edge.getValue();
                if (edgeValue.getEdgeType() == DfsGraphEdge.DfsEdgeType.NOTHING) {
                    if ((target != AbstractDfsController.this.activeVariable || source != AbstractDfsController.this.registers[this.registerNum]) && (AbstractDfsController.this.graph.isOriented() || source != AbstractDfsController.this.activeVariable || target != AbstractDfsController.this.registers[this.registerNum])) continue;
                    if (!AbstractDfsController.this.graph.isOriented() && (sourceValue.getNodePath() != null && sourceValue.getNodePath().getName().equals(targetValue.getName()) || targetValue.getNodePath() != null && sourceValue.getName().equals(targetValue.getNodePath().getName()))) {
                        AbstractDfsController.this.editBlock.addEdit(new AbstractController.ChangeEdgeStyleEdit(edge, this.pathEdgeStyle));
                        continue;
                    }
                    DfsGraphEdge.DfsEdgeType type = DfsGraphEdge.DfsEdgeType.getType(edge, this.pathEdgeStyle);
                    AbstractDfsController.this.editBlock.addEdit(new SetDfsEdgeTypeEdit(edgeValue, type));
                    if (type == DfsGraphEdge.DfsEdgeType.NOTHING) continue;
                    AbstractDfsController.this.editBlock.addEdit(new AbstractController.ChangeEdgeStyleEdit(edge, this.edgeStyle));
                    continue;
                }
                AbstractDfsController.this.editBlock.addEdit(new AbstractController.ChangeEdgeStyleEdit(edge, this.edgeStyle));
            }
        }
    }

    protected final class SetPathEdit
    extends AbstractController.AlgorithmUndoableEdit {
        protected DfsGraphVertex graphNode;
        protected DfsGraphVertex newPath;
        protected DfsGraphVertex oldPath;

        public SetPathEdit(mxCell node, mxCell newPath) {
            this.graphNode = (DfsGraphVertex)node.getValue();
            this.oldPath = this.graphNode.getNodePath();
            this.newPath = newPath != null ? (DfsGraphVertex)newPath.getValue() : null;
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            this.graphNode.setNodePath(this.oldPath);
        }

        @Override
        protected void action() {
            this.graphNode.setNodePath(this.newPath);
        }
    }

    protected class SetPathInstruction
    extends AbstractController.BasicInstruction {
        protected Integer regNum = null;

        public SetPathInstruction() {
        }

        public SetPathInstruction(int regNum) {
            this.regNum = regNum;
        }

        @Override
        public void preform() {
            if (this.regNum != null) {
                AbstractDfsController.this.editBlock.addEdit(new SetPathEdit((mxCell)AbstractDfsController.this.activeVariable, (mxCell)AbstractDfsController.this.getRegisterValue(this.regNum)));
            } else {
                AbstractDfsController.this.editBlock.addEdit(new SetPathEdit((mxCell)AbstractDfsController.this.activeVariable, null));
            }
        }
    }

    protected final class ContextEditSave
    extends AbstractController.AlgorithmUndoableEdit {
        protected Deque<ContextObject> stack;
        protected ContextObject context;
        protected ContextObject actualContext;

        public ContextEditSave(Deque<ContextObject> stack, AbstractController.Instruction next) {
            this.stack = stack;
            this.context = AbstractDfsController.this.getContext(next);
            this.actualContext = AbstractDfsController.this.getContext(null);
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            this.stack.remove(this.context);
            int tmp = AbstractDfsController.this.tapePosition;
            this.actualContext.restoreContext();
            AbstractDfsController.this.tapePosition = tmp;
        }

        @Override
        protected void action() {
            this.stack.push(this.context);
        }
    }

    protected final class ContextEditRestore
    extends AbstractController.AlgorithmUndoableEdit {
        protected Deque<ContextObject> stack;
        protected ContextObject context;

        public ContextEditRestore(Deque<ContextObject> stack) {
            this.stack = stack;
            this.context = stack.getFirst();
            this.context.restoreContext();
            stack.remove(this.context);
        }

        @Override
        public void undo() {
            super.undo();
            this.stack.push(this.context);
        }

        @Override
        protected void action() {
            int tmp = AbstractDfsController.this.tapePosition;
            this.context.restoreContext();
            AbstractDfsController.this.tapePosition = tmp;
            this.stack.remove(this.context);
        }
    }

    protected class ContextInstruction
    extends AbstractController.BasicInstruction {
        protected Deque<ContextObject> stack;
        protected AbstractController.Instruction next;

        public ContextInstruction(Deque<ContextObject> stack) {
            this(stack, null);
        }

        public ContextInstruction(Deque<ContextObject> stack, AbstractController.Instruction next) {
            this.stack = stack;
            this.next = next;
        }

        @Override
        public void preform() {
            if (this.next != null) {
                AbstractDfsController.this.editBlock.addEdit(new ContextEditSave(this.stack, this.next));
            } else {
                AbstractDfsController.this.editBlock.addEdit(new ContextEditRestore(this.stack));
            }
        }
    }

    protected class EnableEdgesTypeInstruction
    extends AbstractController.BasicInstruction {
        protected EnableEdgesTypeInstruction() {
        }

        @Override
        public void preform() {
            AbstractDfsController.this.graph.traverseAllCells(new AlgorithmGraph.AlgorithmGraphCellVisitor(){

                @Override
                public boolean visit(mxCell cell, GraphCell node) {
                    if (cell.isEdge()) {
                        ((DfsGraphEdge)cell.getValue()).setEnabled(true);
                    }
                    return true;
                }

                @Override
                public boolean allowEdge() {
                    return true;
                }
            });
        }
    }

    protected class DfsContextObject
    implements ContextObject {
        protected Deque<mxCell> vList = new LinkedList<mxCell>();
        protected mxCell vU;
        protected mxCell vV;
        protected mxCell activeV;
        protected AbstractController.Instruction nextIns;
        protected int tapeIndex;

        public DfsContextObject(AbstractController.Instruction next) {
            this.nextIns = next;
            this.vU = (mxCell)AbstractDfsController.this.getRegisterValue(AbstractDfsController.this.variableU);
            this.vV = (mxCell)AbstractDfsController.this.getRegisterValue(AbstractDfsController.this.variableV);
            this.activeV = (mxCell)AbstractDfsController.this.activeVariable;
            this.vList.addAll(AbstractDfsController.this.vertexList);
            this.tapeIndex = AbstractDfsController.this.tapePosition;
        }

        @Override
        public void restoreContext() {
            AbstractDfsController.this.setRegisterValue(this.vU, AbstractDfsController.this.variableU);
            AbstractDfsController.this.setRegisterValue(this.vV, AbstractDfsController.this.variableV);
            AbstractDfsController.this.activeVariable = this.activeV;
            AbstractDfsController.this.vertexList.clear();
            AbstractDfsController.this.vertexList.addAll(this.vList);
            if (this.nextIns != null) {
                new AbstractController.SetTapePositionInstruction(AbstractDfsController.this.tape.indexOf(this.nextIns)).preform();
            } else {
                AbstractDfsController.this.tapePosition = this.tapeIndex;
            }
        }

        @Override
        public AbstractController.Instruction getNextIns() {
            return this.nextIns;
        }
    }

    protected static interface ContextObject {
        public void restoreContext();

        public AbstractController.Instruction getNextIns();
    }
}

