/*
 * Decompiled with CFR 0.152.
 */
package simulator.controllers;

import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.Timer;

public class ControllerTimer
extends Timer {
    boolean enable = true;
    boolean wasRunning = false;
    public static final String PROP_TIMER_RUNNING = "timerRunning";
    private final transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public ControllerTimer(int delay, ActionListener listener) {
        super(delay, listener);
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnabled(boolean enableTimer) {
        if (enableTimer == this.enable) {
            return;
        }
        this.enable = enableTimer;
        if (!this.enable) {
            this.wasRunning = this.isRunning();
            if (this.wasRunning) {
                this.stop();
            }
        } else if (this.wasRunning) {
            this.start();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void stop() {
        boolean running = this.isRunning();
        this.wasRunning = false;
        super.stop();
        this.propertyChangeSupport.firePropertyChange(PROP_TIMER_RUNNING, running, false);
    }

    @Override
    public void start() {
        this.wasRunning = true;
        if (this.enable) {
            boolean running = this.isRunning();
            super.start();
            this.propertyChangeSupport.firePropertyChange(PROP_TIMER_RUNNING, running, true);
        }
    }
}

