/*
 * Decompiled with CFR 0.152.
 */
package simulator.graphs;

import com.mxgraph.layout.mxEdgeLabelLayout;
import com.mxgraph.layout.mxParallelEdgeLayout;
import editor.GraphIO;
import java.io.IOException;
import java.nio.file.Paths;
import simulator.graphs.AlgorithmGraph;
import simulator.graphs.bellmanford.BellmanFordGraphEdge;
import simulator.graphs.bellmanford.BellmanFordGraphVertex;
import simulator.graphs.bellmanford.BellmanFordStylesheet;
import simulator.graphs.bfs.BfsGraphCell;
import simulator.graphs.bfs.BfsStylesheet;
import simulator.graphs.dfs.DfsGraphEdge;
import simulator.graphs.dfs.DfsGraphVertex;
import simulator.graphs.dfs.DfsStylesheet;
import simulator.graphs.dijkstra.DijkstraStyleSheet;
import simulator.graphs.scc.SccStyleSheet;
import simulator.graphs.toposort.TopologicalSortStylesheet;

public class BasicGraphs {
    public static AlgorithmGraph getOneNodeGraphDijkstra() {
        AlgorithmGraph graph = new AlgorithmGraph(DijkstraStyleSheet.getStylesheet());
        graph.setOriented(true);
        graph.getModel().beginUpdate();
        try {
            graph.insertVertex(new BellmanFordGraphVertex("A", true), 250.0, 250.0, 80.0, 60.0);
        }
        finally {
            graph.getModel().endUpdate();
        }
        return graph;
    }

    public static AlgorithmGraph getOneNodeGraphScc() {
        AlgorithmGraph graph = new AlgorithmGraph(SccStyleSheet.getStylesheet());
        graph.setOriented(true);
        graph.getModel().beginUpdate();
        try {
            graph.insertVertex(new DfsGraphVertex("A", true), 250.0, 250.0, 80.0, 60.0);
        }
        finally {
            graph.getModel().endUpdate();
        }
        return graph;
    }

    public static AlgorithmGraph getOneNodeGraphTopoSort() {
        AlgorithmGraph graph = new AlgorithmGraph(TopologicalSortStylesheet.getStylesheet());
        graph.setOriented(true);
        graph.getModel().beginUpdate();
        try {
            graph.insertVertex(new DfsGraphVertex("A", true), 250.0, 250.0, 80.0, 60.0);
        }
        finally {
            graph.getModel().endUpdate();
        }
        return graph;
    }

    public static AlgorithmGraph getOneNodeGraphBfs() {
        AlgorithmGraph graph = new AlgorithmGraph(BfsStylesheet.getStylesheet());
        graph.setOriented(true);
        graph.getModel().beginUpdate();
        try {
            graph.insertVertex(new BfsGraphCell("A", true), 250.0, 250.0, 80.0, 60.0);
        }
        finally {
            graph.getModel().endUpdate();
        }
        return graph;
    }

    public static AlgorithmGraph getOneNodeGraphDfs() {
        AlgorithmGraph graph = new AlgorithmGraph(DfsStylesheet.getStylesheet());
        graph.setOriented(true);
        Object parent = graph.getDefaultParent();
        graph.getModel().beginUpdate();
        try {
            graph.insertVertex(parent, null, new DfsGraphVertex("A", true), 250.0, 250.0, 80.0, 60.0, "VERTEX_STYLE");
        }
        finally {
            graph.getModel().endUpdate();
        }
        return graph;
    }

    public static AlgorithmGraph getOneNodeGraphBellmanFord() {
        AlgorithmGraph graph = new AlgorithmGraph(BellmanFordStylesheet.getStylesheet());
        graph.setOriented(true);
        graph.getModel().beginUpdate();
        try {
            graph.insertVertex(new BellmanFordGraphVertex("A", true), 250.0, 250.0, 80.0, 60.0);
        }
        finally {
            graph.getModel().endUpdate();
        }
        return graph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AlgorithmGraph getDijkstraGraph2() {
        AlgorithmGraph graph = new AlgorithmGraph(DijkstraStyleSheet.getStylesheet());
        graph.setOriented(true);
        graph.getModel().beginUpdate();
        try {
            Object s = graph.insertVertex(new BellmanFordGraphVertex("S", true), 40.0, 175.0, 80.0, 60.0);
            Object t = graph.insertVertex(new BellmanFordGraphVertex("T"), 180.0, 50.0, 80.0, 60.0);
            Object z = graph.insertVertex(new BellmanFordGraphVertex("Z"), 520.0, 300.0, 80.0, 60.0);
            Object x = graph.insertVertex(new BellmanFordGraphVertex("X"), 520.0, 50.0, 80.0, 60.0);
            Object y = graph.insertVertex(new BellmanFordGraphVertex("Y"), 180.0, 300.0, 80.0, 60.0);
            graph.insertEdge(new BellmanFordGraphEdge(10.0), s, t);
            graph.insertEdge(new BellmanFordGraphEdge(5.0), s, y);
            graph.insertEdge(new BellmanFordGraphEdge(2.0), t, y);
            graph.insertEdge(new BellmanFordGraphEdge(1.0), t, x);
            graph.insertEdge(new BellmanFordGraphEdge(3.0), y, t);
            graph.insertEdge(new BellmanFordGraphEdge(2.0), y, z);
            graph.insertEdge(new BellmanFordGraphEdge(9.0), y, x);
            graph.insertEdge(new BellmanFordGraphEdge(-4.0), x, z);
            graph.insertEdge(new BellmanFordGraphEdge(7.0), z, s);
            graph.insertEdge(new BellmanFordGraphEdge(-6.0), z, x);
        }
        finally {
            graph.getModel().endUpdate();
        }
        new mxParallelEdgeLayout(graph).execute(graph.getDefaultParent());
        new mxEdgeLabelLayout(graph).execute(graph.getDefaultParent());
        return graph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AlgorithmGraph getDijkstraGraph() {
        AlgorithmGraph graph = new AlgorithmGraph(DijkstraStyleSheet.getStylesheet());
        graph.setOriented(true);
        graph.getModel().beginUpdate();
        try {
            Object s = graph.insertVertex(new BellmanFordGraphVertex("S", true), 40.0, 175.0, 80.0, 60.0);
            Object t = graph.insertVertex(new BellmanFordGraphVertex("T"), 180.0, 50.0, 80.0, 60.0);
            Object z = graph.insertVertex(new BellmanFordGraphVertex("Z"), 520.0, 300.0, 80.0, 60.0);
            Object x = graph.insertVertex(new BellmanFordGraphVertex("X"), 520.0, 50.0, 80.0, 60.0);
            Object y = graph.insertVertex(new BellmanFordGraphVertex("Y"), 180.0, 300.0, 80.0, 60.0);
            graph.insertEdge(new BellmanFordGraphEdge(10.0), s, t);
            graph.insertEdge(new BellmanFordGraphEdge(5.0), s, y);
            graph.insertEdge(new BellmanFordGraphEdge(2.0), t, y);
            graph.insertEdge(new BellmanFordGraphEdge(1.0), t, x);
            graph.insertEdge(new BellmanFordGraphEdge(3.0), y, t);
            graph.insertEdge(new BellmanFordGraphEdge(2.0), y, z);
            graph.insertEdge(new BellmanFordGraphEdge(9.0), y, x);
            graph.insertEdge(new BellmanFordGraphEdge(4.0), x, z);
            graph.insertEdge(new BellmanFordGraphEdge(7.0), z, s);
            graph.insertEdge(new BellmanFordGraphEdge(6.0), z, x);
        }
        finally {
            graph.getModel().endUpdate();
        }
        new mxParallelEdgeLayout(graph).execute(graph.getDefaultParent());
        new mxEdgeLabelLayout(graph).execute(graph.getDefaultParent());
        return graph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AlgorithmGraph getBellmanFordGraph2() {
        AlgorithmGraph graph = new AlgorithmGraph(BellmanFordStylesheet.getStylesheet());
        graph.setOriented(true);
        graph.getModel().beginUpdate();
        try {
            Object s = graph.insertVertex(new BellmanFordGraphVertex("S", true), 80.0, 200.0, 80.0, 60.0);
            Object t = graph.insertVertex(new BellmanFordGraphVertex("T"), 220.0, 50.0, 80.0, 60.0);
            Object z = graph.insertVertex(new BellmanFordGraphVertex("Z"), 460.0, 350.0, 80.0, 60.0);
            Object x = graph.insertVertex(new BellmanFordGraphVertex("X"), 460.0, 50.0, 80.0, 60.0);
            Object y = graph.insertVertex(new BellmanFordGraphVertex("Y"), 220.0, 430.0, 80.0, 60.0);
            graph.insertEdge(new BellmanFordGraphEdge(6.0), s, t);
            graph.insertEdge(new BellmanFordGraphEdge(7.0), s, y);
            graph.insertEdge(new BellmanFordGraphEdge(8.0), t, y);
            graph.insertEdge(new BellmanFordGraphEdge(5.0), t, x);
            graph.insertEdge(new BellmanFordGraphEdge(-4.0), t, z);
            graph.insertEdge(new BellmanFordGraphEdge(9.0), y, z);
            graph.insertEdge(new BellmanFordGraphEdge(-3.0), y, x);
            graph.insertEdge(new BellmanFordGraphEdge(-2.0), x, t);
            graph.insertEdge(new BellmanFordGraphEdge(2.0), z, s);
            graph.insertEdge(new BellmanFordGraphEdge(-7.0), z, x);
        }
        finally {
            graph.getModel().endUpdate();
        }
        new mxParallelEdgeLayout(graph).execute(graph.getDefaultParent());
        new mxEdgeLabelLayout(graph).execute(graph.getDefaultParent());
        return graph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AlgorithmGraph getBellmanFordGraph() {
        AlgorithmGraph graph = new AlgorithmGraph(BellmanFordStylesheet.getStylesheet());
        graph.setOriented(true);
        graph.getModel().beginUpdate();
        try {
            Object s = graph.insertVertex(new BellmanFordGraphVertex("S", true), 80.0, 200.0, 80.0, 60.0);
            Object t = graph.insertVertex(new BellmanFordGraphVertex("T"), 220.0, 50.0, 80.0, 60.0);
            Object z = graph.insertVertex(new BellmanFordGraphVertex("Z"), 460.0, 350.0, 80.0, 60.0);
            Object x = graph.insertVertex(new BellmanFordGraphVertex("X"), 460.0, 50.0, 80.0, 60.0);
            Object y = graph.insertVertex(new BellmanFordGraphVertex("Y"), 220.0, 350.0, 80.0, 60.0);
            graph.insertEdge(new BellmanFordGraphEdge(6.0), s, t);
            graph.insertEdge(new BellmanFordGraphEdge(7.0), s, y);
            graph.insertEdge(new BellmanFordGraphEdge(8.0), t, y);
            graph.insertEdge(new BellmanFordGraphEdge(5.0), t, x);
            graph.insertEdge(new BellmanFordGraphEdge(-4.0), t, z);
            graph.insertEdge(new BellmanFordGraphEdge(9.0), y, z);
            graph.insertEdge(new BellmanFordGraphEdge(-3.0), y, x);
            graph.insertEdge(new BellmanFordGraphEdge(-2.0), x, t);
            graph.insertEdge(new BellmanFordGraphEdge(2.0), z, s);
            graph.insertEdge(new BellmanFordGraphEdge(7.0), z, x);
        }
        finally {
            graph.getModel().endUpdate();
        }
        new mxParallelEdgeLayout(graph).execute(graph.getDefaultParent());
        new mxEdgeLabelLayout(graph).execute(graph.getDefaultParent());
        return graph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AlgorithmGraph getSccGraph() {
        AlgorithmGraph graph = new AlgorithmGraph(SccStyleSheet.getStylesheet());
        graph.setOriented(true);
        graph.getModel().beginUpdate();
        try {
            Object a = graph.insertVertex(new DfsGraphVertex("A"), 40.0, 60.0, 80.0, 60.0);
            Object b = graph.insertVertex(new DfsGraphVertex("B"), 180.0, 60.0, 80.0, 60.0);
            Object c = graph.insertVertex(new DfsGraphVertex("C"), 320.0, 60.0, 80.0, 60.0);
            Object d = graph.insertVertex(new DfsGraphVertex("D"), 460.0, 60.0, 80.0, 60.0);
            Object e = graph.insertVertex(new DfsGraphVertex("E"), 40.0, 200.0, 80.0, 60.0);
            Object f = graph.insertVertex(new DfsGraphVertex("F"), 180.0, 200.0, 80.0, 60.0);
            Object g = graph.insertVertex(new DfsGraphVertex("G"), 320.0, 200.0, 80.0, 60.0);
            Object h = graph.insertVertex(new DfsGraphVertex("H", true), 460.0, 200.0, 80.0, 60.0);
            graph.insertEdge(new DfsGraphEdge(), a, b);
            graph.insertEdge(new DfsGraphEdge(), b, c);
            graph.insertEdge(new DfsGraphEdge(), b, e);
            graph.insertEdge(new DfsGraphEdge(), b, f);
            graph.insertEdge(new DfsGraphEdge(), c, d);
            graph.insertEdge(new DfsGraphEdge(), c, g);
            graph.insertEdge(new DfsGraphEdge(), d, c);
            graph.insertEdge(new DfsGraphEdge(), d, h);
            graph.insertEdge(new DfsGraphEdge(), e, a);
            graph.insertEdge(new DfsGraphEdge(), e, f);
            graph.insertEdge(new DfsGraphEdge(), f, g);
            graph.insertEdge(new DfsGraphEdge(), g, f);
            graph.insertEdge(new DfsGraphEdge(), g, h);
            graph.insertEdge(new DfsGraphEdge(), h, h);
        }
        finally {
            graph.getModel().endUpdate();
        }
        new mxParallelEdgeLayout(graph).execute(graph.getDefaultParent());
        return graph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AlgorithmGraph getTopologicalSortGraph() {
        AlgorithmGraph graph = new AlgorithmGraph(TopologicalSortStylesheet.getStylesheet());
        graph.setOriented(true);
        graph.getModel().beginUpdate();
        try {
            Object kosile = graph.insertVertex(new DfsGraphVertex("shirt", true), 180.0, 280.0, 80.0, 60.0);
            Object vazanka = graph.insertVertex(new DfsGraphVertex("tie"), 180.0, 400.0, 80.0, 60.0);
            Object bunda = graph.insertVertex(new DfsGraphVertex("jacket"), 180.0, 520.0, 80.0, 60.0);
            Object opasek = graph.insertVertex(new DfsGraphVertex("belt"), 60.0, 360.0, 80.0, 60.0);
            Object hodinky = graph.insertVertex(new DfsGraphVertex("watch"), 360.0, 130.0, 80.0, 60.0);
            Object spodky = graph.insertVertex(new DfsGraphVertex("underwear"), 60.0, 60.0, 80.0, 60.0);
            Object kalhoty = graph.insertVertex(new DfsGraphVertex("trousers"), 60.0, 200.0, 80.0, 60.0);
            Object boty = graph.insertVertex(new DfsGraphVertex("shoes"), 260.0, 200.0, 80.0, 60.0);
            Object ponozky = graph.insertVertex(new DfsGraphVertex("socks"), 260.0, 60.0, 80.0, 60.0);
            graph.insertEdge(new DfsGraphEdge(), spodky, boty);
            graph.insertEdge(new DfsGraphEdge(), spodky, kalhoty);
            graph.insertEdge(new DfsGraphEdge(), ponozky, boty);
            graph.insertEdge(new DfsGraphEdge(), kalhoty, boty);
            graph.insertEdge(new DfsGraphEdge(), kalhoty, opasek);
            graph.insertEdge(new DfsGraphEdge(), kosile, opasek);
            graph.insertEdge(new DfsGraphEdge(), kosile, vazanka);
            graph.insertEdge(new DfsGraphEdge(), vazanka, bunda);
            graph.insertEdge(new DfsGraphEdge(), opasek, bunda);
        }
        finally {
            graph.getModel().endUpdate();
        }
        return graph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AlgorithmGraph getDfsGraph2() {
        AlgorithmGraph graph = new AlgorithmGraph(DfsStylesheet.getStylesheet());
        graph.setOriented(true);
        graph.getModel().beginUpdate();
        try {
            Object a = graph.insertVertex(new DfsGraphVertex("A"), 40.0, 60.0, 60.0, 60.0);
            Object b = graph.insertVertex(new DfsGraphVertex("B"), 180.0, 60.0, 60.0, 60.0);
            Object c = graph.insertVertex(new DfsGraphVertex("C"), 320.0, 60.0, 60.0, 60.0);
            Object d = graph.insertVertex(new DfsGraphVertex("D"), 460.0, 60.0, 60.0, 60.0);
            Object e = graph.insertVertex(new DfsGraphVertex("E"), 40.0, 200.0, 60.0, 60.0);
            Object f = graph.insertVertex(new DfsGraphVertex("F"), 180.0, 200.0, 60.0, 60.0);
            Object g = graph.insertVertex(new DfsGraphVertex("G"), 320.0, 200.0, 60.0, 60.0);
            Object h = graph.insertVertex(new DfsGraphVertex("H"), 460.0, 200.0, 60.0, 60.0);
            graph.insertEdge(new DfsGraphEdge(), a, e);
            graph.insertEdge(new DfsGraphEdge(), b, a);
            graph.insertEdge(new DfsGraphEdge(), b, f);
            graph.insertEdge(new DfsGraphEdge(), c, b);
            graph.insertEdge(new DfsGraphEdge(), c, f);
            graph.insertEdge(new DfsGraphEdge(), d, g);
            graph.insertEdge(new DfsGraphEdge(), d, h);
            graph.insertEdge(new DfsGraphEdge(), e, b);
            graph.insertEdge(new DfsGraphEdge(), f, e);
            graph.insertEdge(new DfsGraphEdge(), g, c);
            graph.insertEdge(new DfsGraphEdge(), g, f);
            graph.insertEdge(new DfsGraphEdge(), h, g);
            graph.insertEdge(new DfsGraphEdge(), h, d);
        }
        finally {
            graph.getModel().endUpdate();
        }
        new mxParallelEdgeLayout(graph).execute(graph.getDefaultParent());
        return graph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AlgorithmGraph getDfsGraph() {
        AlgorithmGraph graph = new AlgorithmGraph(DfsStylesheet.getStylesheet());
        graph.setOriented(true);
        graph.getModel().beginUpdate();
        try {
            DfsGraphVertex aCell = new DfsGraphVertex("A");
            Object a = graph.insertVertex(aCell, 60.0, 60.0, 60.0, 60.0);
            Object b = graph.insertVertex(new DfsGraphVertex("B"), 220.0, 60.0, 60.0, 60.0);
            Object c = graph.insertVertex(new DfsGraphVertex("C"), 220.0, 220.0, 60.0, 60.0);
            Object d = graph.insertVertex(new DfsGraphVertex("D"), 60.0, 220.0, 60.0, 60.0);
            Object e = graph.insertVertex(new DfsGraphVertex("E"), 380.0, 60.0, 60.0, 60.0);
            Object f = graph.insertVertex(new DfsGraphVertex("F"), 380.0, 220.0, 60.0, 60.0);
            graph.insertEdge(new DfsGraphEdge(), a, b);
            graph.insertEdge(new DfsGraphEdge(), a, d);
            graph.insertEdge(new DfsGraphEdge(), c, d);
            graph.insertEdge(new DfsGraphEdge(), d, b);
            graph.insertEdge(new DfsGraphEdge(), b, c);
            graph.insertEdge(new DfsGraphEdge(), e, c);
            graph.insertEdge(new DfsGraphEdge(), e, f);
            graph.insertEdge(new DfsGraphEdge(), f, f);
        }
        finally {
            graph.getModel().endUpdate();
        }
        return graph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AlgorithmGraph getBfsGraph2() {
        AlgorithmGraph graph = new AlgorithmGraph(BfsStylesheet.getStylesheet());
        graph.setOriented(true);
        graph.getModel().beginUpdate();
        try {
            Object first = graph.insertVertex(new BfsGraphCell("1"), 130.0, 130.0, 60.0, 60.0);
            Object a = graph.insertVertex(new BfsGraphCell("a"), 20.0, 20.0, 40.0, 40.0);
            Object b = graph.insertVertex(new BfsGraphCell("b"), 200.0, 60.0, 40.0, 40.0);
            Object c = graph.insertVertex(new BfsGraphCell("c"), 240.0, 240.0, 40.0, 40.0);
            Object d = graph.insertVertex(new BfsGraphCell("d"), 10.0, 200.0, 40.0, 40.0);
            Object e = graph.insertVertex(new BfsGraphCell("e"), 120.0, 260.0, 40.0, 40.0);
            graph.insertEdge(null, a, first);
            graph.insertEdge(null, b, first);
            graph.insertEdge(null, c, first);
            graph.insertEdge(null, d, first);
            graph.insertEdge(null, e, first);
            Object second = graph.insertVertex(new BfsGraphCell("2"), 320.0, 130.0, 60.0, 60.0);
            Object q = graph.insertVertex(new BfsGraphCell("q"), 320.0, 10.0, 40.0, 40.0);
            Object r = graph.insertVertex(new BfsGraphCell("r"), 440.0, 80.0, 40.0, 40.0);
            Object h = graph.insertVertex(new BfsGraphCell("h"), 400.0, 240.0, 40.0, 40.0);
            graph.insertEdge(null, c, second);
            graph.insertEdge(null, h, second);
            graph.insertEdge(null, q, second);
            graph.insertEdge(null, r, second);
            Object third = graph.insertVertex(new BfsGraphCell("3"), 510.0, 130.0, 60.0, 60.0);
            Object p = graph.insertVertex(new BfsGraphCell("p"), 600.0, 90.0, 40.0, 40.0);
            Object o = graph.insertVertex(new BfsGraphCell("o"), 590.0, 240.0, 40.0, 40.0);
            graph.insertEdge(null, h, third);
            graph.insertEdge(null, p, third);
            graph.insertEdge(null, o, third);
            Object fourth = graph.insertVertex(new BfsGraphCell("4"), 130.0, 360.0, 60.0, 60.0);
            Object f = graph.insertVertex(new BfsGraphCell("f"), 80.0, 440.0, 40.0, 40.0);
            Object g = graph.insertVertex(new BfsGraphCell("g"), 260.0, 450.0, 40.0, 40.0);
            graph.insertEdge(null, e, fourth);
            graph.insertEdge(null, f, fourth);
            graph.insertEdge(null, g, fourth);
            BfsGraphCell vCell = new BfsGraphCell("5");
            vCell.setSelected(true);
            Object fifth = graph.insertVertex(vCell, 320.0, 360.0, 60.0, 60.0);
            Object i = graph.insertVertex(new BfsGraphCell("i"), 380.0, 480.0, 40.0, 40.0);
            graph.insertEdge(null, c, fifth);
            graph.insertEdge(null, g, fifth);
            graph.insertEdge(null, i, fifth);
            Object sixth = graph.insertVertex(new BfsGraphCell("6"), 510.0, 360.0, 60.0, 60.0);
            Object n = graph.insertVertex(new BfsGraphCell("n"), 450.0, 420.0, 40.0, 40.0);
            Object m = graph.insertVertex(new BfsGraphCell("m"), 620.0, 400.0, 40.0, 40.0);
            Object k = graph.insertVertex(new BfsGraphCell("k"), 550.0, 490.0, 40.0, 40.0);
            graph.insertEdge(null, o, sixth);
            graph.insertEdge(null, n, sixth);
            graph.insertEdge(null, m, sixth);
            graph.insertEdge(null, k, sixth);
        }
        finally {
            graph.getModel().endUpdate();
        }
        return graph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AlgorithmGraph getBfsGraph() {
        AlgorithmGraph graph = new AlgorithmGraph(BfsStylesheet.getStylesheet());
        graph.setOriented(false);
        graph.getModel().beginUpdate();
        try {
            BfsGraphCell sCell = new BfsGraphCell("s");
            sCell.setSelected(true);
            Object v1 = graph.insertVertex(sCell, 200.0, 120.0, 60.0, 60.0);
            Object v2 = graph.insertVertex(new BfsGraphCell("r"), 40.0, 60.0, 60.0, 60.0);
            Object v3 = graph.insertVertex(new BfsGraphCell("v"), 40.0, 300.0, 60.0, 60.0);
            Object v4 = graph.insertVertex(new BfsGraphCell("t"), 350.0, 40.0, 60.0, 60.0);
            Object v5 = graph.insertVertex(new BfsGraphCell("x"), 350.0, 300.0, 60.0, 60.0);
            Object v6 = graph.insertVertex(new BfsGraphCell("w"), 200.0, 400.0, 60.0, 60.0);
            Object v7 = graph.insertVertex(new BfsGraphCell("u"), 460.0, 160.0, 60.0, 60.0);
            Object v8 = graph.insertVertex(new BfsGraphCell("z"), 460.0, 380.0, 60.0, 60.0);
            graph.insertEdge(null, v1, v2);
            graph.insertEdge(null, v2, v3);
            graph.insertEdge(null, v1, v6);
            graph.insertEdge(null, v6, v4);
            graph.insertEdge(null, v6, v5);
            graph.insertEdge(null, v5, v4);
            graph.insertEdge(null, v5, v7);
            graph.insertEdge(null, v5, v8);
            graph.insertEdge(null, v7, v4);
            graph.insertEdge(null, v7, v8);
        }
        finally {
            graph.getModel().endUpdate();
        }
        return graph;
    }

    public static void main(String[] args) throws IOException {
        GraphIO.writeGraph(BasicGraphs.getBfsGraph(), Paths.get(System.getProperty("user.dir"), "BfsGraph1.xml"));
        GraphIO.writeGraph(BasicGraphs.getBfsGraph2(), Paths.get(System.getProperty("user.dir"), "BfsGraph2.xml"));
        GraphIO.writeGraph(BasicGraphs.getDfsGraph(), Paths.get(System.getProperty("user.dir"), "DfsGraph1.xml"));
        GraphIO.writeGraph(BasicGraphs.getDfsGraph2(), Paths.get(System.getProperty("user.dir"), "DfsGraph2.xml"));
        GraphIO.writeGraph(BasicGraphs.getTopologicalSortGraph(), Paths.get(System.getProperty("user.dir"), "TopologicalSortGraph1.xml"));
        GraphIO.writeGraph(BasicGraphs.getSccGraph(), Paths.get(System.getProperty("user.dir"), "SccGraph1.xml"));
        GraphIO.writeGraph(BasicGraphs.getBellmanFordGraph(), Paths.get(System.getProperty("user.dir"), "BellmanFordGraph1.xml"));
        GraphIO.writeGraph(BasicGraphs.getDijkstraGraph(), Paths.get(System.getProperty("user.dir"), "DijkstraGraph1.xml"));
        GraphIO.writeGraph(BasicGraphs.getDijkstraGraph2(), Paths.get(System.getProperty("user.dir"), "DijkstraGraph2.xml"));
    }
}

