/*
 * Decompiled with CFR 0.152.
 */
package simulator.graphs;

import com.mxgraph.util.mxConstants;
import com.mxgraph.view.mxStylesheet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import simulator.graphs.AlgorithmGraphStylesheet;

public class BasicStylesheet
extends mxStylesheet
implements AlgorithmGraphStylesheet {
    protected BasicStylesheet() {
    }

    public static BasicStylesheet getClearsheet() {
        return new BasicStylesheet();
    }

    public static BasicStylesheet getFromMxStylesheet(mxStylesheet sheet) {
        BasicStylesheet newSheet = new BasicStylesheet();
        HashMap<String, Map<String, Object>> newStyles = new HashMap<String, Map<String, Object>>();
        for (Map.Entry<String, Map<String, Object>> e : sheet.getStyles().entrySet()) {
            HashMap<String, Object> tmp = new HashMap<String, Object>();
            for (Map.Entry<String, Object> e2 : e.getValue().entrySet()) {
                tmp.put(e2.getKey(), e2.getValue());
            }
            newStyles.put(e.getKey(), tmp);
        }
        newSheet.setStyles(newStyles);
        return newSheet;
    }

    public static BasicStylesheet getStyleDefaultsheet() {
        BasicStylesheet newSheet = new BasicStylesheet();
        HashMap<String, Object> styleVertex = new HashMap<String, Object>();
        styleVertex.put(mxConstants.STYLE_SHAPE, "ellipse");
        styleVertex.put(mxConstants.STYLE_PERIMETER, "ellipsePerimeter");
        styleVertex.put(mxConstants.STYLE_FONTSIZE, 16);
        styleVertex.put(mxConstants.STYLE_FONTCOLOR, "black");
        styleVertex.put(mxConstants.STYLE_STROKECOLOR, "black");
        styleVertex.put(mxConstants.STYLE_STROKEWIDTH, 4);
        styleVertex.put(mxConstants.STYLE_FILLCOLOR, "557290");
        newSheet.putCellStyle("VERTEX_STYLE", styleVertex);
        newSheet.setDefaultVertexStyle(styleVertex);
        newSheet.putCellStyle("INIT_VERTEX_STYLE", styleVertex);
        newSheet.putCellStyle("FIRST_PASS_VERTEX_STYLE", styleVertex);
        newSheet.putCellStyle("DONE_VERTEX_STYLE", styleVertex);
        newSheet.putCellStyle("ROOT_VERTEX_STYLE", styleVertex);
        newSheet.putCellStyle("COMPONENT_VERTEX_STYLE", styleVertex);
        newSheet.putCellStyle("MINI_VERTEX_STYLE", styleVertex);
        newSheet.putCellStyle("ACTIVE_VERTEX_STYLE", styleVertex);
        HashMap<String, Object> styleSelectedVertex = new HashMap<String, Object>();
        styleSelectedVertex.putAll(styleVertex);
        styleSelectedVertex.put(mxConstants.STYLE_FILLCOLOR, "FF4040");
        newSheet.putCellStyle("SELECTED_VERTEX_STYLE", styleSelectedVertex);
        HashMap<String, Object> styleEdge = new HashMap<String, Object>();
        styleEdge.put(mxConstants.STYLE_STROKECOLOR, "08E8DE");
        styleEdge.put(mxConstants.STYLE_ENDARROW, "classic");
        styleEdge.put(mxConstants.STYLE_STARTARROW, "none");
        styleEdge.put(mxConstants.STYLE_SHAPE, "connector");
        styleEdge.put(mxConstants.STYLE_FONTSIZE, 20);
        newSheet.putCellStyle("EDGE_STYLE", styleEdge);
        newSheet.setDefaultEdgeStyle(styleEdge);
        newSheet.putCellStyle("PATH_EDGE_STYLE", styleEdge);
        newSheet.putCellStyle("BREAK_CON_EDGE_STYLE", styleEdge);
        HashMap<String, Object> styleHighlightEdge = new HashMap<String, Object>();
        styleHighlightEdge.putAll(styleEdge);
        styleHighlightEdge.put(mxConstants.STYLE_STROKECOLOR, "red");
        styleHighlightEdge.put(mxConstants.STYLE_STROKEWIDTH, "4");
        newSheet.putCellStyle("HIGHLIGHT_EDGE_STYLE", styleHighlightEdge);
        HashMap<String, Object> selectedEdge = new HashMap<String, Object>();
        selectedEdge.putAll(styleEdge);
        selectedEdge.put(mxConstants.STYLE_STROKECOLOR, "#7FFF00");
        selectedEdge.put(mxConstants.STYLE_STROKEWIDTH, "4");
        newSheet.putCellStyle("SELECTED_EDGE_STYLE", selectedEdge);
        return newSheet;
    }

    @Override
    public String getSelectedStyle(boolean edge) {
        if (edge) {
            return this.getSelectedEdgeStyle();
        }
        return this.getSelectedVertexStyle();
    }

    @Override
    public String getSelectedVertexStyle() {
        return "SELECTED_VERTEX_STYLE";
    }

    @Override
    public String getSelectedEdgeStyle() {
        return "SELECTED_EDGE_STYLE";
    }

    @Override
    public String getVertexStyle() {
        return "VERTEX_STYLE";
    }

    @Override
    public String getInitVertexStyle() {
        return "INIT_VERTEX_STYLE";
    }

    @Override
    public String getFirstPassVertexStyle() {
        return "FIRST_PASS_VERTEX_STYLE";
    }

    @Override
    public String getDoneVertexStyle() {
        return "DONE_VERTEX_STYLE";
    }

    @Override
    public String getRootVertexStyle() {
        return "ROOT_VERTEX_STYLE";
    }

    @Override
    public String getComponentVertexStyle() {
        return "COMPONENT_VERTEX_STYLE";
    }

    @Override
    public String getEdgeStyle() {
        return "EDGE_STYLE";
    }

    @Override
    public String getHighlighEdgeStyle() {
        return "HIGHLIGHT_EDGE_STYLE";
    }

    @Override
    public String getPathEdgeStyle() {
        return "PATH_EDGE_STYLE";
    }

    @Override
    public String getBreakConEdgeStyle() {
        return "BREAK_CON_EDGE_STYLE";
    }

    @Override
    public String getMiniVertexStyle() {
        return "MINI_VERTEX_STYLE";
    }

    @Override
    public String getActiveVertexStyle() {
        return "ACTIVE_VERTEX_STYLE";
    }

    @Override
    public boolean isDirectedEgeStyle() {
        String arrow = (String)this.getStyles().get(this.getEdgeStyle()).get(mxConstants.STYLE_ENDARROW);
        return !arrow.equalsIgnoreCase(mxConstants.NONE);
    }

    public static boolean isVertexStyle(String style) {
        switch (style) {
            case "VERTEX_STYLE": 
            case "INIT_VERTEX_STYLE": 
            case "FIRST_PASS_VERTEX_STYLE": 
            case "DONE_VERTEX_STYLE": 
            case "COMPONENT_VERTEX_STYLE": 
            case "MINI_VERTEX_STYLE": 
            case "ACTIVE_VERTEX_STYLE": 
            case "SELECTED_VERTEX_STYLE": {
                return true;
            }
        }
        return false;
    }

    public static boolean isEdgeStyle(String style) {
        switch (style) {
            case "EDGE_STYLE": 
            case "HIGHLIGHT_EDGE_STYLE": 
            case "PATH_EDGE_STYLE": 
            case "BREAK_CON_EDGE_STYLE": 
            case "SELECTED_EDGE_STYLE": {
                return true;
            }
        }
        return false;
    }

    public static String getDesc(String style) {
        switch (style) {
            case "EDGE_STYLE": {
                return "Styl pro z\u00e1kladn\u00ed hrany";
            }
            case "HIGHLIGHT_EDGE_STYLE": {
                return "Styl pro aktu\u00e1ln\u011b zv\u00fdrazn\u011bnou hranu";
            }
            case "PATH_EDGE_STYLE": {
                return "Styl hranu, kter\u00e1 je cestou";
            }
            case "BREAK_CON_EDGE_STYLE": {
                return "Styl pro hranu poru\u0161uj\u00edc\u00ed pravidlo p\u0159i hled\u00e1n\u00ed nejkrat\u0161\u00ed cesty";
            }
            case "SELECTED_EDGE_STYLE": {
                return "Styl pro u\u017eivatelem vybranou hranu";
            }
            case "VERTEX_STYLE": {
                return "Styl pro z\u00e1kladn\u00ed uzel";
            }
            case "INIT_VERTEX_STYLE": {
                return "Styl pro uzel, kter\u00fd byl inicializov\u00e1n";
            }
            case "FIRST_PASS_VERTEX_STYLE": {
                return "Styl pro uzel, kter\u00fd byl poprv\u00e9 nav\u0161t\u00edven";
            }
            case "DONE_VERTEX_STYLE": {
                return "Styl pro uzel, kter\u00fd je dokon\u010den";
            }
            case "COMPONENT_VERTEX_STYLE": {
                return "Styl pro uzel slou\u017e\u00edc\u00ed jako uzel komponenty v SCC";
            }
            case "MINI_VERTEX_STYLE": {
                return "Styl pro uzel slou\u017e\u00edc\u00ed jako uzel seznamu v Topologick\u00e9m uspo\u0159\u00e1d\u00e1n\u00ed";
            }
            case "ACTIVE_VERTEX_STYLE": {
                return "Styl pro zpracov\u00e1van\u00fd uzel";
            }
            case "SELECTED_VERTEX_STYLE": {
                return "Styl pro u\u017eivatelem vybran\u00fd uzel";
            }
        }
        return null;
    }

    public static Set<String> getAllStyles() {
        TreeSet<String> names = new TreeSet<String>();
        names.add("VERTEX_STYLE");
        names.add("SELECTED_VERTEX_STYLE");
        names.add("INIT_VERTEX_STYLE");
        names.add("FIRST_PASS_VERTEX_STYLE");
        names.add("DONE_VERTEX_STYLE");
        names.add("COMPONENT_VERTEX_STYLE");
        names.add("MINI_VERTEX_STYLE");
        names.add("ACTIVE_VERTEX_STYLE");
        names.add("EDGE_STYLE");
        names.add("HIGHLIGHT_EDGE_STYLE");
        names.add("PATH_EDGE_STYLE");
        names.add("BREAK_CON_EDGE_STYLE");
        names.add("SELECTED_EDGE_STYLE");
        return names;
    }

    @Override
    public BasicStylesheet getThisStylesheet() {
        return this;
    }

    @Override
    public void setDirected(boolean directed) {
        for (String style : BasicStylesheet.getAllStyles()) {
            Map<String, Object> sett;
            if (!BasicStylesheet.isEdgeStyle(style) || (sett = this.getStyles().get(style)) == null) continue;
            if (directed) {
                sett.put(mxConstants.STYLE_ENDARROW, "classic");
                continue;
            }
            sett.put(mxConstants.STYLE_ENDARROW, mxConstants.NONE);
        }
    }

    public static Map<String, Object> stringToStyle(String styleString) {
        TreeMap<String, Object> styles = new TreeMap<String, Object>();
        for (String str : styleString.split(";")) {
            String[] style;
            if (str.length() <= 0 || (style = str.split(":")).length != 2) continue;
            styles.put(style[0], style[1]);
        }
        return styles;
    }

    public static String styleToString(Map<String, Object> styles) {
        if (styles == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> entry : styles.entrySet()) {
            sb.append(entry.getKey()).append(":").append(entry.getValue()).append(";");
        }
        return sb.toString();
    }
}

