/*
 * Decompiled with CFR 0.152.
 */
package simulator.graphs.bellmanford;

import java.text.DecimalFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import simulator.graphs.AbstractGraphCell;
import simulator.graphs.bellmanford.BellmanFordNodeData;
import simulator.graphs.bellmanford.BellmanFordOperations;

public class BellmanFordGraphVertex
extends AbstractGraphCell
implements BellmanFordOperations {
    protected BellmanFordNodeData state = null;

    public BellmanFordGraphVertex() {
        this((String)null);
    }

    public BellmanFordGraphVertex(String name) {
        this(name, false);
    }

    public BellmanFordGraphVertex(String name, Boolean selected) {
        this(name, new BellmanFordNodeData(), selected);
    }

    public BellmanFordGraphVertex(String name, BellmanFordNodeData state, Boolean selected) {
        super(name, selected);
        this.state = state;
    }

    @Override
    public String getLabel() {
        if (!this.state.isEnabled() || this.state.getDistance() == null) {
            return this.getName();
        }
        if (this.state.getDistance() == Double.POSITIVE_INFINITY) {
            return this.getName() + " / \u221e";
        }
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append(" / ");
        if (this.state.getDistance() != null) {
            sb.append(new DecimalFormat("#").format(this.state.getDistance()));
        }
        return sb.toString();
    }

    @Override
    public String getToolTips() {
        if (!this.state.isEnabled() || !this.state.isToolTipsEnabled()) {
            return "\u03c0 = ";
        }
        if (this.state.getNodePath() == null) {
            return "\u03c0 = NIL";
        }
        return "\u03c0 = " + this.state.getNodePath().getName();
    }

    @Override
    public void clearState() {
        this.state = null;
    }

    @Override
    public boolean isEnabled() {
        return this.state.isEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.state.setEnabled(enabled);
    }

    @Override
    public boolean isActive() {
        return this.state.isActive();
    }

    @Override
    public void setActive(boolean active) {
        this.state.setActive(active);
    }

    @Override
    public void resetState() {
        this.state.resetState();
    }

    @Override
    public void setToolTipsEnabled(boolean toolTipsEnabled) {
        this.state.setToolTipsEnabled(toolTipsEnabled);
    }

    @Override
    public boolean isToolTipsEnabled() {
        return this.state.isToolTipsEnabled();
    }

    @Override
    public void setDistance(Double distance) {
        this.state.setDistance(distance);
    }

    @Override
    public Double getDistance() {
        return this.state.getDistance();
    }

    @Override
    public BellmanFordGraphVertex getNodePath() {
        return this.state.getNodePath();
    }

    @Override
    public void setNodePath(BellmanFordGraphVertex nodePath) {
        this.state.setNodePath(nodePath);
    }

    @Override
    public void edit(String newValue) {
        if (this.isEditable()) {
            if (newValue.contains("\u221e") || newValue.contains("inf")) {
                this.state.setDistance(Double.POSITIVE_INFINITY);
                return;
            }
            Pattern p = Pattern.compile("-?\\d+");
            Matcher m = p.matcher(newValue);
            if (m.find()) {
                double d = Double.parseDouble(m.group());
                this.state.setDistance(d);
            }
        }
    }
}

