/*
 * Decompiled with CFR 0.152.
 */
package simulator.gui;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Ellipse2D;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleConstants;
import javax.swing.text.Utilities;
import simulator.gui.LineHighlighter;

public class TextLineNumber
extends JPanel
implements MouseListener {
    public static final float LEFT = 0.0f;
    public static final float CENTER = 0.5f;
    public static final float RIGHT = 1.0f;
    public static final Color defaultHighlightColor = Color.decode("#BBFFFF");
    private static final Border OUTER = new MatteBorder(0, 0, 0, 2, Color.GRAY);
    private static final int HEIGHT = 2146483647;
    private JTextComponent component;
    private int borderGap;
    private Color currentLineForeground;
    private float digitAlignment;
    private int minimumDisplayDigits;
    private int currentLine;
    private int lastPrintedLine;
    private Set<Integer> debugLinesSet = new HashSet<Integer>();
    private int lastDigits;
    private int lastHeight;
    private Element actualLineElement;
    int lastCurrentLine = 0;
    private Map<String, FontMetrics> fonts = new HashMap<String, FontMetrics>();
    private boolean scrollEnabled = true;
    private LineHighlighter painter;

    public TextLineNumber(JTextComponent component) {
        this(component, 3, defaultHighlightColor);
    }

    public TextLineNumber(JTextComponent component, Color col) {
        this(component, 3, col);
    }

    public TextLineNumber(JTextComponent component, int minimumDisplayDigits) {
        this(component, minimumDisplayDigits, defaultHighlightColor);
    }

    public TextLineNumber(JTextComponent component, int minimumDisplayDigits, Color col) {
        this.component = component;
        this.addMouseListener(this);
        this.lastPrintedLine = 0;
        this.currentLine = 0;
        DefaultHighlighter hilit = new DefaultHighlighter();
        this.painter = new LineHighlighter(col);
        component.setHighlighter(hilit);
        try {
            hilit.addHighlight(0, 0, this.painter);
        }
        catch (BadLocationException ex) {
            Logger.getLogger(TextLineNumber.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.setFont(component.getFont());
        this.setBorderGap(5);
        this.setCurrentLineForeground(Color.RED);
        this.setDigitAlignment(1.0f);
        this.setMinimumDisplayDigits(minimumDisplayDigits);
    }

    public int getBorderGap() {
        return this.borderGap;
    }

    public void setBorderGap(int borderGap) {
        this.borderGap = borderGap;
        EmptyBorder inner = new EmptyBorder(0, borderGap, 0, borderGap);
        this.setBorder(new CompoundBorder(OUTER, inner));
        this.lastDigits = 0;
        this.setPreferredWidth();
    }

    public boolean isScrollEnabled() {
        return this.scrollEnabled;
    }

    public void setScrollEnabled(boolean scrollEnabled) {
        this.scrollEnabled = scrollEnabled;
    }

    public void clearAllHighlight() {
        this.painter.clearAllHighlight();
    }

    public void highlightLine(int lineNum, Color color) {
        this.painter.highlightLine(lineNum, color);
    }

    public void clearAllhighlightStart() {
        this.painter.clearAllhighlightStart();
    }

    public Map<Integer, Color> getAllhighlightStart() {
        return this.painter.getAllhighlightStart();
    }

    public void highlightLineStart(int lineNum, Color color) {
        this.painter.highlightLineStart(lineNum, color);
    }

    public void highlightLineStartArea(int lineNumStart, int lineNumEnd, Color color) {
        for (int i = lineNumStart; i <= lineNumEnd; ++i) {
            this.painter.highlightLineStart(i, color);
        }
    }

    public void setActualLineHighlightColor(Color actualLineHighlightColor) {
        this.painter.setActualLineHighlightColor(actualLineHighlightColor);
    }

    public Color getActualLineHighlightColor() {
        return this.painter.getActualLineHighlightColor();
    }

    public Color getCurrentLineForeground() {
        return this.currentLineForeground == null ? this.getForeground() : this.currentLineForeground;
    }

    public int getCurrentLine() {
        return this.currentLine;
    }

    public void setCurrentLine(int line) {
        if (line < 0 || line > this.component.getDocument().getDefaultRootElement().getElementCount()) {
            throw new IllegalArgumentException();
        }
        this.currentLine = line;
        this.painter.setActualLine(this.currentLine);
    }

    public void moveFromCurrentLine(int count) {
        this.setCurrentLine(this.currentLine + count);
    }

    public void setCurrentLineForeground(Color currentLineForeground) {
        this.currentLineForeground = currentLineForeground;
    }

    public float getDigitAlignment() {
        return this.digitAlignment;
    }

    public void setDigitAlignment(float digitAlignment) {
        this.digitAlignment = digitAlignment > 1.0f ? 1.0f : (digitAlignment < 0.0f ? -1.0f : digitAlignment);
    }

    public int getMinimumDisplayDigits() {
        return this.minimumDisplayDigits;
    }

    public void setMinimumDisplayDigits(int minimumDisplayDigits) {
        this.minimumDisplayDigits = minimumDisplayDigits;
        this.setPreferredWidth();
    }

    public double getLinesNumbersPartWidth() {
        return this.getSize().getWidth() - this.component.getSize().getWidth();
    }

    private void setPreferredWidth() {
        Element root = this.component.getDocument().getDefaultRootElement();
        int lines = root.getElementCount();
        int digits = Math.max(String.valueOf(lines).length(), this.minimumDisplayDigits);
        if (this.lastDigits != digits) {
            this.lastDigits = digits;
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int width = fontMetrics.charWidth('0') * digits;
            Insets insets = this.getInsets();
            int preferredWidth = insets.left + insets.right + width + 15;
            Dimension d = this.getPreferredSize();
            d.setSize(preferredWidth, 2146483647);
            this.setPreferredSize(d);
            this.setSize(d);
        }
    }

    public static void centerLineInScrollPane(JTextComponent component) {
        Container container = SwingUtilities.getAncestorOfClass(JViewport.class, component);
        if (container == null) {
            return;
        }
        try {
            Rectangle r = component.modelToView(component.getCaretPosition());
            JViewport viewport = (JViewport)container;
            int extentHeight = viewport.getExtentSize().height;
            int viewHeight = viewport.getViewSize().height;
            int y = Math.max(0, r.y - extentHeight / 2);
            y = Math.min(y, viewHeight - extentHeight);
            viewport.setViewPosition(new Point(0, y));
        }
        catch (BadLocationException ex) {
            Logger.getLogger(TextLineNumber.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected void positionCaret(int offset, int realLineNum) {
        if (this.currentLine != this.lastCurrentLine) {
            this.lastCurrentLine = this.currentLine;
            if (realLineNum != 1) {
                this.component.setCaretPosition(offset + 1);
            } else {
                this.component.setCaretPosition(0);
            }
            TextLineNumber.centerLineInScrollPane(this.component);
        }
    }

    protected void paintActiveLine(Graphics2D g2d, int x, int y) {
        Color oldColor = g2d.getColor();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        Polygon polygon = new Polygon();
        polygon.addPoint(12, y - 11);
        polygon.addPoint(12, y + 1);
        polygon.addPoint(20, y - 5);
        g2d.setColor(Color.GREEN);
        g2d.fillPolygon(polygon);
        g2d.fillRect(5, y - 8, 7, 6);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
        g2d.setColor(oldColor);
    }

    protected void paintDebugSymbol(Graphics2D g2d, int x, int y) {
        Color oldColor = g2d.getColor();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        double radius = 5.0;
        x = 28;
        Ellipse2D.Double circle = new Ellipse2D.Double((double)x - radius, (double)(y -= 5) - radius, 2.0 * radius, 2.0 * radius);
        g2d.setColor(Color.RED);
        g2d.draw(circle);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
        g2d.fill(circle);
        g2d.setColor(oldColor);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.component.repaint();
        Graphics2D g2d = (Graphics2D)g;
        Font setFont = g2d.getFont();
        FontMetrics fontMetrics = this.component.getFontMetrics(this.component.getFont());
        Insets insets = this.getInsets();
        int availableWidth = this.getSize().width - insets.left - insets.right;
        int rowStartOffset = 0;
        int endOffset = this.component.getDocument().getLength();
        this.actualLineElement = null;
        while (rowStartOffset <= endOffset) {
            try {
                Element root = this.component.getDocument().getDefaultRootElement();
                Element line = root.getElement(root.getElementIndex(rowStartOffset));
                int lineNumber = this.getLineNumber(line);
                int realLineNum = this.getRealLineNumber(line);
                if (this.lastPrintedLine != realLineNum && realLineNum != 0) {
                    String strLine = this.getTextLineNumber(lineNumber);
                    int stringWidth = fontMetrics.stringWidth(strLine);
                    int x = this.getOffsetX(availableWidth, stringWidth) + insets.left;
                    int y = this.getOffsetY(rowStartOffset, fontMetrics);
                    if (realLineNum != 0 && realLineNum == this.currentLine) {
                        this.paintActiveLine(g2d, x, y);
                        g2d.setColor(this.getCurrentLineForeground());
                        this.actualLineElement = line;
                    } else {
                        g2d.setColor(this.getForeground());
                    }
                    if (realLineNum != 0 && this.debugLinesSet.contains(realLineNum)) {
                        this.paintDebugSymbol(g2d, x, y);
                    } else {
                        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                        g2d.drawString(strLine, x, y);
                        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
                    }
                    this.lastPrintedLine = realLineNum;
                }
                rowStartOffset = Utilities.getRowEnd(this.component, rowStartOffset) + 1;
            }
            catch (BadLocationException ex) {
                Logger.getLogger(TextLineNumber.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.scrollToCurrentLine();
        this.lastPrintedLine = 0;
    }

    public void scrollToCurrentLine() {
        if (this.scrollEnabled) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (TextLineNumber.this.actualLineElement != null) {
                        TextLineNumber.this.positionCaret(TextLineNumber.this.actualLineElement.getEndOffset(), TextLineNumber.this.getRealLineNumber(TextLineNumber.this.actualLineElement));
                    }
                }
            });
        }
    }

    protected int getRealLineNumber(Element line) {
        Object lineNum = line.getAttributes().getAttribute("line");
        return (Integer)(lineNum == null ? Integer.valueOf(0) : lineNum);
    }

    protected int getLineNumber(Element line) {
        Object lineNum = line.getAttributes().getAttribute("lineNum");
        return (Integer)(lineNum == null ? Integer.valueOf(0) : lineNum);
    }

    protected String getTextLineNumber(int index) {
        if (index != 0) {
            return String.valueOf(index);
        }
        return "";
    }

    private int getOffsetX(int availableWidth, int stringWidth) {
        return (int)((float)(availableWidth - stringWidth) * this.digitAlignment);
    }

    private int getOffsetY(int rowStartOffset, FontMetrics fontMetrics) throws BadLocationException {
        Rectangle r = this.component.modelToView(rowStartOffset);
        int lineHeight = fontMetrics.getHeight();
        int y = r.y + r.height;
        int descent = 0;
        if (r.height == lineHeight) {
            descent = fontMetrics.getDescent();
        } else {
            Element root = this.component.getDocument().getDefaultRootElement();
            int index = root.getElementIndex(rowStartOffset);
            Element line = root.getElement(index);
            for (int i = 0; i < line.getElementCount(); ++i) {
                Element child = line.getElement(i);
                AttributeSet as = child.getAttributes();
                String fontFamily = (String)as.getAttribute(StyleConstants.FontFamily);
                Integer fontSize = (Integer)as.getAttribute(StyleConstants.FontSize);
                String key = fontFamily + fontSize;
                FontMetrics fm = this.fonts.get(key);
                if (fm == null) {
                    Font font = new Font(fontFamily, 0, fontSize);
                    fm = this.component.getFontMetrics(font);
                    this.fonts.put(key, fm);
                }
                descent = Math.max(descent, fm.getDescent());
            }
        }
        return y - descent;
    }

    public boolean isDebugOnCurrentLine() {
        return this.debugLinesSet.contains(this.currentLine);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() % 2 == 0) {
            int index;
            int offset = this.component.viewToModel(e.getPoint());
            Element root = this.component.getDocument().getDefaultRootElement();
            Element line = root.getElement(index = root.getElementIndex(offset));
            if (line != null) {
                int realLineNum = this.getRealLineNumber(line);
                if (this.debugLinesSet.contains(realLineNum)) {
                    this.debugLinesSet.remove(realLineNum);
                } else {
                    this.debugLinesSet.add(realLineNum);
                }
                this.repaint();
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

