/*
 * Decompiled with CFR 0.152.
 */
package simulator.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.basic.BasicToolBarUI;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;

public class VariablesPanel
extends JPanel {
    private JTable varTable;
    private JTable nodeMatrixTable;
    private VariablesTableModel tableModelVar;
    private VariablesTableModel tableModelNodeMatrix;
    private JTextField textField = new JTextField();
    private JToolBar toolBar1;
    private JToolBar toolBar2;

    public VariablesPanel() {
        this.setLayout(new BorderLayout());
        this.tableModelVar = new VariablesTableModel(new String[]{"Variable name", "Value"});
        this.varTable = new JTable(this.tableModelVar);
        this.varTable.setSelectionMode(0);
        this.tableModelNodeMatrix = new VariablesTableModel(new String[]{"Nodel", "List of neighbours"});
        this.nodeMatrixTable = new JTable(this.tableModelNodeMatrix);
        this.toolBar1 = new JToolBar();
        this.toolBar1.setRollover(false);
        this.toolBar1.setUI(new VariablesToolBarUI());
        this.toolBar2 = new JToolBar();
        this.toolBar2.setRollover(false);
        this.toolBar2.setUI(new VariablesToolBarUI());
        this.toolBar1.add(new JScrollPane(this.varTable));
        this.toolBar2.add(new JScrollPane(this.nodeMatrixTable));
        Box box = Box.createVerticalBox();
        JPanel tp1 = new JPanel(new GridLayout(1, 0));
        tp1.add(this.toolBar1);
        box.add(tp1);
        box.add(Box.createVerticalStrut(5));
        JPanel tp2 = new JPanel(new GridLayout(1, 0));
        tp2.add(this.toolBar2);
        box.add(tp2);
        this.add((Component)box, "Center");
        this.tablesSetting(this.varTable, this.tableModelVar);
        this.tablesSetting(this.nodeMatrixTable, this.tableModelNodeMatrix);
    }

    private void tablesSetting(final JTable table, final VariablesTableModel model) {
        table.setSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        table.getColumnModel().getColumn(1).setCellEditor(new MyTableCellEditor());
        table.getColumnModel().getColumn(0).setMinWidth(95);
        table.getColumnModel().getColumn(1).setMinWidth(95);
        table.getColumnModel().getColumn(1).setPreferredWidth(Short.MAX_VALUE);
        Font f = new Font("SansSerif", 0, 16);
        table.setFont(f);
        table.setRowHeight(table.getFontMetrics(f).getHeight());
        model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (model.getValueAt(table.getSelectedRow(), table.getSelectedColumn()) != null) {
                    VariablesPanel.this.textField.setText(model.getValueAt(table.getSelectedRow(), table.getSelectedColumn()).toString());
                }
            }
        });
        table.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    ((JTable)e.getSource()).clearSelection();
                }
            }
        });
    }

    public void dockTables() {
        ((VariablesToolBarUI)this.toolBar1.getUI()).returnPanel();
        ((VariablesToolBarUI)this.toolBar2.getUI()).returnPanel();
    }

    public void addNodeAdjList(String nodeName, String adjList) {
        this.addData(this.tableModelNodeMatrix, nodeName, adjList);
    }

    public void addVariable(String name) {
        this.addVariable(name, null);
    }

    public void addVariable(String name, String val) {
        this.addData(this.tableModelVar, name, val);
    }

    private void addData(VariablesTableModel model, String data1, String data2) {
        if (model.getData().containsKey(data1)) {
            model.getData().get(data1).put(model.getColumnName(1), data2);
        } else {
            HashMap<String, String> newRow = new HashMap<String, String>();
            newRow.put(model.getColumnName(0), data1);
            newRow.put(model.getColumnName(1), data2);
            model.getData().put(data1, newRow);
        }
        model.fireTableDataChanged();
    }

    public void removeVariable(String name) {
        if (this.tableModelVar.getData().containsKey(name)) {
            this.tableModelVar.getData().remove(name);
            this.tableModelVar.fireTableDataChanged();
        }
    }

    public class MyTableCellEditor
    extends DefaultCellEditor
    implements TableCellEditor {
        public MyTableCellEditor() {
            super(VariablesPanel.this.textField);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex) {
            JTextField textField = (JTextField)super.getTableCellEditorComponent(table, value, isSelected, rowIndex, 1);
            textField.setFont(new Font("Serif", 0, 12));
            textField.setEditable(false);
            return textField;
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public void cancelCellEditing() {
            super.cancelCellEditing();
        }
    }

    public static class VariablesTableModel
    extends DefaultTableModel {
        private String[] columnNames;
        private Map<String, Map<String, String>> data = new LinkedHashMap<String, Map<String, String>>();

        public VariablesTableModel(String[] columnNames) {
            this.columnNames = columnNames;
        }

        public Map<String, Map<String, String>> getData() {
            return this.data;
        }

        public void setData(Map<String, Map<String, String>> data) {
            this.data = data;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 1;
        }

        @Override
        public int getRowCount() {
            return this.data == null ? 0 : this.data.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            int count = 0;
            for (Map<String, String> i : this.data.values()) {
                if (count == rowIndex) {
                    return i.get(this.columnNames[columnIndex]);
                }
                ++count;
            }
            return null;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
        }
    }

    class VariablesToolBarUI
    extends BasicToolBarUI {
        private JDialog dialog;
        private Dimension toolBarPreferredSize;
        private Dimension newBarPreferredSize = new Dimension(300, 100);

        VariablesToolBarUI() {
        }

        public void returnPanel() {
            this.toolBar.setPreferredSize(this.toolBarPreferredSize);
            this.setFloating(false, null);
        }

        @Override
        protected RootPaneContainer createFloatingWindow(JToolBar toolbar) {
            Window window = SwingUtilities.getWindowAncestor(toolbar);
            this.dialog = new JDialog((Frame)null, toolbar.getName(), false);
            this.dialog.getRootPane().setName("ToolBar.FloatingWindow");
            this.dialog.setTitle(toolbar.getName());
            this.dialog.setResizable(true);
            this.dialog.setAlwaysOnTop(false);
            this.dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    VariablesToolBarUI.this.toolBar.setPreferredSize(VariablesToolBarUI.this.toolBarPreferredSize);
                }
            });
            WindowListener wl = this.createFrameListener();
            this.dialog.addWindowListener(wl);
            return this.dialog;
        }

        @Override
        protected void dragTo(Point position, Point origin) {
            if (!this.toolBar.getPreferredSize().equals(this.newBarPreferredSize)) {
                this.toolBarPreferredSize = this.toolBar.getPreferredSize();
                this.toolBar.setPreferredSize(this.newBarPreferredSize);
            }
            super.dragTo(position, origin);
        }
    }
}

