/*
 * Decompiled with CFR 0.152.
 */
package simulator.gui.panels;

import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGraphModel;
import java.awt.BorderLayout;
import java.awt.Component;
import simulator.algorithms.AlgorithmBfs;
import simulator.controllers.BfsController;
import simulator.graphs.AlgorithmGraph;
import simulator.graphs.GraphVertexBasicData;
import simulator.graphs.bfs.BfsGraphCell;
import simulator.gui.AbstractSimulatorPanel;
import simulator.gui.panels.AbstractAlgorithmPanel;

public class BfsPanel
extends AbstractAlgorithmPanel {
    protected AbstractSimulatorPanel simulatorPanel;

    public BfsPanel(AlgorithmGraph graph) {
        this.makeBfsGraph(graph);
        graph.refresh();
        graph.setOriented(graph.getAlgorithmStylesheet().isDirectedEgeStyle());
        this.setLayout(new BorderLayout());
        this.simulatorPanel = new AbstractSimulatorPanel(graph, new AlgorithmBfs());
        this.simulatorPanel.getGraphPanel().add((Component)this.simulatorPanel.getGraphComponent(), "Center");
        BfsController controller = new BfsController(this.simulatorPanel.getGraphComponent(), this.simulatorPanel.getLabel(), this.simulatorPanel.getCodePanel(), this.simulatorPanel.getVariablesPanel());
        this.simulatorPanel.setController(controller);
        this.add((Component)this.simulatorPanel, "Center");
    }

    @Override
    public void stop() {
        this.simulatorPanel.getVariablesPanel().dockTables();
        this.simulatorPanel.getController().setTimerStart(false);
    }

    private void makeBfsGraph(AlgorithmGraph graph) {
        for (Object o : mxGraphModel.getChildren(graph.getModel(), graph.getDefaultParent())) {
            if (!(o instanceof mxCell)) continue;
            mxCell cell = (mxCell)o;
            if (cell.isVertex()) {
                if (cell.getValue() == null || !(cell.getValue() instanceof GraphVertexBasicData)) {
                    throw new IllegalArgumentException();
                }
                if (!(cell.getValue() instanceof BfsGraphCell)) {
                    GraphVertexBasicData data = (GraphVertexBasicData)cell.getValue();
                    cell.setValue(new BfsGraphCell(data.getName(), data.isSelected()));
                }
                cell.setStyle(graph.getAlgorithmStylesheet().getVertexStyle());
                continue;
            }
            cell.setValue(null);
            cell.setStyle(graph.getAlgorithmStylesheet().getEdgeStyle());
        }
    }
}

