/*
 * Decompiled with CFR 0.152.
 */
package simulator.gui.panels;

import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGraphModel;
import java.awt.BorderLayout;
import java.awt.Component;
import simulator.algorithms.AlgorithmDfs;
import simulator.controllers.DfsController;
import simulator.graphs.AlgorithmGraph;
import simulator.graphs.GraphEdgeBasicData;
import simulator.graphs.GraphVertexBasicData;
import simulator.graphs.dfs.DfsGraphEdge;
import simulator.graphs.dfs.DfsGraphVertex;
import simulator.gui.AbstractSimulatorPanel;
import simulator.gui.panels.AbstractAlgorithmPanel;

public class DfsPanel
extends AbstractAlgorithmPanel {
    protected AbstractSimulatorPanel simulatorPanel;

    public DfsPanel(AlgorithmGraph graph) {
        this.makeDfsGraph(graph);
        graph.refresh();
        graph.setOriented(graph.getAlgorithmStylesheet().isDirectedEgeStyle());
        this.setLayout(new BorderLayout());
        this.simulatorPanel = new AbstractSimulatorPanel(graph, new AlgorithmDfs());
        this.simulatorPanel.getGraphPanel().add((Component)this.simulatorPanel.getGraphComponent(), "Center");
        DfsController controller = new DfsController(this.simulatorPanel.getGraphComponent(), this.simulatorPanel.getLabel(), this.simulatorPanel.getCodePanel(), this.simulatorPanel.getVariablesPanel());
        this.simulatorPanel.setController(controller);
        this.add((Component)this.simulatorPanel, "Center");
    }

    @Override
    public void stop() {
        this.simulatorPanel.getVariablesPanel().dockTables();
        this.simulatorPanel.getController().setTimerStart(false);
    }

    private void makeDfsGraph(AlgorithmGraph graph) {
        for (Object o : mxGraphModel.getChildren(graph.getModel(), graph.getDefaultParent())) {
            if (!(o instanceof mxCell)) continue;
            mxCell cell = (mxCell)o;
            if (cell.isVertex()) {
                if (cell.getValue() == null || !(cell.getValue() instanceof GraphVertexBasicData)) {
                    throw new IllegalArgumentException();
                }
                if (!(cell.getValue() instanceof DfsGraphVertex)) {
                    GraphVertexBasicData data = (GraphVertexBasicData)cell.getValue();
                    cell.setValue(new DfsGraphVertex(data.getName(), data.isSelected()));
                }
                cell.setStyle(graph.getAlgorithmStylesheet().getVertexStyle());
                continue;
            }
            if (cell.getValue() != null && !(cell.getValue() instanceof GraphEdgeBasicData)) {
                throw new IllegalArgumentException();
            }
            cell.setValue(new DfsGraphEdge());
            cell.setStyle(graph.getAlgorithmStylesheet().getEdgeStyle());
        }
    }
}

