/*
 * Decompiled with CFR 0.152.
 */
package simulator.gui.panels;

import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGraphModel;
import com.mxgraph.swing.handler.mxRubberband;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import simulator.algorithms.AlgorithmScc;
import simulator.controllers.SccController;
import simulator.graphs.AlgorithmGraph;
import simulator.graphs.AlgorithmGraphComponent;
import simulator.graphs.GraphEdgeBasicData;
import simulator.graphs.GraphVertexBasicData;
import simulator.graphs.dfs.DfsGraphEdge;
import simulator.graphs.dfs.DfsGraphVertex;
import simulator.graphs.scc.SccStyleSheet;
import simulator.gui.AbstractSimulatorPanel;
import simulator.gui.panels.AbstractAlgorithmPanel;

public class SccPanel
extends AbstractAlgorithmPanel {
    protected AbstractSimulatorPanel simulatorPanel;

    public SccPanel(AlgorithmGraph graph) {
        this.makeSccGraph(graph);
        graph.setOriented(true);
        if (!graph.getAlgorithmStylesheet().isDirectedEgeStyle()) {
            graph.getAlgorithmStylesheet().setDirected(true);
        }
        graph.refresh();
        this.setLayout(new BorderLayout());
        this.simulatorPanel = new AbstractSimulatorPanel(graph, new AlgorithmScc());
        final AlgorithmGraphComponent transposeGraph = AbstractSimulatorPanel.getmxGraphComponent(new AlgorithmGraph(SccStyleSheet.getStylesheet(), true));
        mxRubberband rubberBand2 = new mxRubberband(transposeGraph);
        transposeGraph.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (e.isControlDown()) {
                    if (e.getWheelRotation() < 0) {
                        transposeGraph.zoomIn();
                    } else {
                        transposeGraph.zoomOut();
                    }
                }
            }
        });
        final AlgorithmGraphComponent graphOfComponents = AbstractSimulatorPanel.getmxGraphComponent(new AlgorithmGraph(SccStyleSheet.getStylesheet(), true));
        graphOfComponents.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (e.isControlDown()) {
                    if (e.getWheelRotation() < 0) {
                        graphOfComponents.zoomIn();
                    } else {
                        graphOfComponents.zoomOut();
                    }
                }
            }
        });
        mxRubberband rubberBand3 = new mxRubberband(graphOfComponents);
        JTabbedPane tabPane = new JTabbedPane();
        tabPane.add("Transpose Graph", transposeGraph);
        tabPane.add("Component Graph", graphOfComponents);
        JSplitPane pane2 = new JSplitPane(0, this.simulatorPanel.getGraphComponent(), tabPane);
        pane2.setContinuousLayout(true);
        pane2.setDividerSize(6);
        pane2.setDividerLocation(350);
        pane2.setResizeWeight(1.0);
        this.simulatorPanel.getGraphPanel().add((Component)pane2, "Center");
        SccController controller = new SccController(this.simulatorPanel.getGraphComponent(), this.simulatorPanel.getLabel(), this.simulatorPanel.getCodePanel(), this.simulatorPanel.getVariablesPanel(), transposeGraph, graphOfComponents);
        this.simulatorPanel.setController(controller);
        this.add((Component)this.simulatorPanel, "Center");
    }

    @Override
    public void stop() {
        this.simulatorPanel.getVariablesPanel().dockTables();
        this.simulatorPanel.getController().setTimerStart(false);
    }

    private void makeSccGraph(AlgorithmGraph graph) {
        for (Object o : mxGraphModel.getChildren(graph.getModel(), graph.getDefaultParent())) {
            if (!(o instanceof mxCell)) continue;
            mxCell cell = (mxCell)o;
            if (cell.isVertex()) {
                if (cell.getValue() == null || !(cell.getValue() instanceof GraphVertexBasicData)) {
                    throw new IllegalArgumentException();
                }
                if (!(cell.getValue() instanceof DfsGraphVertex)) {
                    GraphVertexBasicData data = (GraphVertexBasicData)cell.getValue();
                    cell.setValue(new DfsGraphVertex(data.getName(), data.isSelected()));
                }
                cell.setStyle(graph.getAlgorithmStylesheet().getVertexStyle());
                continue;
            }
            if (cell.getValue() != null && !(cell.getValue() instanceof GraphEdgeBasicData)) {
                throw new IllegalArgumentException();
            }
            cell.setValue(new DfsGraphEdge());
            cell.setStyle(graph.getAlgorithmStylesheet().getEdgeStyle());
        }
    }
}

