/*
 * Decompiled with CFR 0.152.
 */
package simulator.gui.panels;

import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGraphModel;
import com.mxgraph.swing.handler.mxRubberband;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JSplitPane;
import simulator.algorithms.AlgorithmTopologicalSort;
import simulator.controllers.TopologicalSortController;
import simulator.graphs.AlgorithmGraph;
import simulator.graphs.AlgorithmGraphComponent;
import simulator.graphs.GraphEdgeBasicData;
import simulator.graphs.GraphVertexBasicData;
import simulator.graphs.dfs.DfsGraphEdge;
import simulator.graphs.dfs.DfsGraphVertex;
import simulator.graphs.toposort.TopologicalSortStylesheet;
import simulator.gui.AbstractSimulatorPanel;
import simulator.gui.panels.AbstractAlgorithmPanel;

public class TopologicalSortPanel
extends AbstractAlgorithmPanel {
    protected AbstractSimulatorPanel simulatorPanel;

    public TopologicalSortPanel(AlgorithmGraph graph) {
        this.makeTopologicalSortGraph(graph);
        graph.setOriented(true);
        if (!graph.getAlgorithmStylesheet().isDirectedEgeStyle()) {
            graph.getAlgorithmStylesheet().setDirected(true);
        }
        graph.refresh();
        this.setLayout(new BorderLayout());
        this.simulatorPanel = new AbstractSimulatorPanel(graph, new AlgorithmTopologicalSort());
        final AlgorithmGraphComponent graphComponentList = AbstractSimulatorPanel.getmxGraphComponent(new AlgorithmGraph(TopologicalSortStylesheet.getStylesheet()));
        mxRubberband rubberBand2 = new mxRubberband(graphComponentList);
        graphComponentList.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (e.isControlDown()) {
                    if (e.getWheelRotation() < 0) {
                        graphComponentList.zoomIn();
                    } else {
                        graphComponentList.zoomOut();
                    }
                }
            }
        });
        JSplitPane pane2 = new JSplitPane(0, this.simulatorPanel.getGraphComponent(), graphComponentList);
        pane2.setContinuousLayout(true);
        pane2.setDividerSize(6);
        pane2.setDividerLocation(500);
        pane2.setResizeWeight(1.0);
        this.simulatorPanel.getGraphPanel().add((Component)pane2, "Center");
        TopologicalSortController controller = new TopologicalSortController(this.simulatorPanel.getGraphComponent(), this.simulatorPanel.getLabel(), this.simulatorPanel.getCodePanel(), this.simulatorPanel.getVariablesPanel(), graphComponentList);
        this.simulatorPanel.setController(controller);
        this.add((Component)this.simulatorPanel, "Center");
    }

    @Override
    public void stop() {
        this.simulatorPanel.getVariablesPanel().dockTables();
        this.simulatorPanel.getController().setTimerStart(false);
    }

    private void makeTopologicalSortGraph(AlgorithmGraph graph) {
        for (Object o : mxGraphModel.getChildren(graph.getModel(), graph.getDefaultParent())) {
            if (!(o instanceof mxCell)) continue;
            mxCell cell = (mxCell)o;
            if (cell.isVertex()) {
                if (cell.getValue() == null || !(cell.getValue() instanceof GraphVertexBasicData)) {
                    throw new IllegalArgumentException();
                }
                if (!(cell.getValue() instanceof DfsGraphVertex)) {
                    GraphVertexBasicData data = (GraphVertexBasicData)cell.getValue();
                    cell.setValue(new DfsGraphVertex(data.getName(), data.isSelected()));
                }
                cell.setStyle(graph.getAlgorithmStylesheet().getVertexStyle());
                continue;
            }
            if (cell.getValue() != null && !(cell.getValue() instanceof GraphEdgeBasicData)) {
                throw new IllegalArgumentException();
            }
            cell.setValue(new DfsGraphEdge());
            cell.setStyle(graph.getAlgorithmStylesheet().getEdgeStyle());
        }
    }
}

