/*
 * Decompiled with CFR 0.152.
 */
package editor;

import com.mxgraph.model.mxCell;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxResources;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxStylesheet;
import java.text.DecimalFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import simulator.graphs.GraphEdgeData;
import simulator.graphs.GraphVertexData;

public class EditorGraph
extends mxGraph {
    protected boolean vertexLabel = true;
    protected boolean edgeLabel = true;

    public EditorGraph(mxStylesheet stylesheet) {
        super(stylesheet);
    }

    public boolean isVertexLabel() {
        return this.vertexLabel;
    }

    public void setVertexLabel(boolean vertexLabel) {
        this.vertexLabel = vertexLabel;
    }

    public boolean isEdgeLabel() {
        return this.edgeLabel;
    }

    public void setEdgeLabel(boolean edgeLabel) {
        this.edgeLabel = edgeLabel;
    }

    @Override
    public String getToolTipForCell(Object cell) {
        GraphVertexData data;
        mxCell node = (mxCell)cell;
        if (node.isVertex() && (data = (GraphVertexData)node.getValue()).getSelected().booleanValue()) {
            return mxResources.get("selected");
        }
        return null;
    }

    @Override
    public String convertValueToString(Object cell) {
        if (cell instanceof mxCell) {
            if (((mxCell)cell).isVertex() && !this.vertexLabel || ((mxCell)cell).isEdge() && !this.edgeLabel) {
                return "";
            }
            Object value = ((mxCell)cell).getValue();
            if (this.vertexLabel && value instanceof GraphVertexData) {
                GraphVertexData node = (GraphVertexData)value;
                return node.getName();
            }
            if (this.edgeLabel && value instanceof GraphEdgeData) {
                GraphEdgeData node = (GraphEdgeData)value;
                return new DecimalFormat("#").format(node.getDistance());
            }
        }
        return super.convertValueToString(cell);
    }

    @Override
    public boolean isVertexLabelsMovable() {
        return false;
    }

    @Override
    public boolean isEdgeLabelsMovable() {
        return false;
    }

    @Override
    public boolean isCellEditable(Object cell) {
        mxCell node = (mxCell)cell;
        if (this.vertexLabel && node.isVertex() || this.edgeLabel && node.isEdge()) {
            return super.isCellEditable(cell);
        }
        return false;
    }

    public boolean containCellName(String name, mxCell original) {
        for (Object o : this.getChildVertices(this.getDefaultParent())) {
            GraphVertexData data = (GraphVertexData)((mxCell)o).getValue();
            if (o == original || !data.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void cellLabelChanged(Object cell, Object value, boolean autoSize) {
        this.model.beginUpdate();
        if (autoSize) {
            this.cellSizeUpdated(cell, false);
        }
        String strValue = (String)value;
        if (this.vertexLabel && ((mxCell)cell).isVertex()) {
            GraphVertexData data = (GraphVertexData)((mxCell)cell).getValue();
            this.getModel().setValue(cell, new GraphVertexData((String)value, data.isSelected()));
        } else if (this.edgeLabel) {
            GraphEdgeData data = new GraphEdgeData();
            if (strValue.contains("\u221e") || strValue.contains("inf")) {
                data.setDistance(Double.POSITIVE_INFINITY);
            } else {
                Pattern p = Pattern.compile("-?\\d+");
                Matcher m = p.matcher(strValue);
                if (m.find()) {
                    double d = Double.parseDouble(m.group());
                    data.setDistance(d);
                }
            }
            this.getModel().setValue(cell, data);
        }
        this.getSelectionModel().clear();
        this.fireEvent(new mxEventObject("labelChanged"));
        this.model.endUpdate();
    }

    @Override
    public boolean isAllowDanglingEdges() {
        return false;
    }

    @Override
    public boolean isAllowLoops() {
        return true;
    }

    @Override
    public boolean isAllowNegativeCoordinates() {
        return false;
    }

    public boolean isOriented() {
        String arrow = (String)this.getStylesheet().getStyles().get("EDGE_STYLE").get(mxConstants.STYLE_ENDARROW);
        return !arrow.equalsIgnoreCase(mxConstants.NONE);
    }
}

