/*
 * Decompiled with CFR 0.152.
 */
package editor;

import com.mxgraph.layout.mxParallelEdgeLayout;
import com.mxgraph.model.mxCell;
import com.mxgraph.swing.handler.mxRubberband;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.mxGraphOutline;
import com.mxgraph.util.mxResources;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxStylesheet;
import editor.EditorGraph;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import simulator.graphs.BasicStylesheet;
import simulator.graphs.GraphEdgeData;
import simulator.graphs.GraphVertexData;

public class GraphViewPanel
extends JPanel {
    protected mxGraphComponent graphComponent;
    protected double vertexWidth = 80.0;
    protected double vertexHeight = 80.0;
    protected EditorGraph graph;
    private int last = 0;
    private char c = (char)65;

    public GraphViewPanel() {
        this.setLayout(new GridLayout(1, 0));
        this.graph = new EditorGraph((mxStylesheet)BasicStylesheet.getStyleDefaultsheet()){

            private void duplicityNameCheckError() {
                JOptionPane.showMessageDialog(GraphViewPanel.this.graphComponent, mxResources.get("badVertexNameError"), mxResources.get("error"), 0);
            }

            private boolean duplicityNameCheck(Object cell, Object value) {
                return !this.containCellName((String)value, (mxCell)cell);
            }

            public void cellLabelChangedImp(Object cell, Object value, boolean autoSize) {
                super.cellLabelChanged(cell, value, autoSize);
                this.refresh();
            }

            @Override
            public void cellLabelChanged(Object cell, Object value, boolean autoSize) {
                if (this.vertexLabel && ((mxCell)cell).isVertex() && ((String)value).length() == 0) {
                    JOptionPane.showMessageDialog(GraphViewPanel.this.graphComponent, mxResources.get("NewNodeNameError"), mxResources.get("error"), 0);
                    return;
                }
                if (this.duplicityNameCheck(cell, value)) {
                    this.cellLabelChangedImp(cell, value, autoSize);
                } else {
                    this.duplicityNameCheckError();
                }
            }

            @Override
            public Object createVertex(Object parent, String id, Object value, double x, double y, double width, double height, String style, boolean relative) {
                if (value == null) {
                    GraphVertexData data = new GraphVertexData();
                    Object newCell = super.createVertex(parent, id, data, x, y, width, height, "VERTEX_STYLE", relative);
                    this.setNewName(newCell);
                    return newCell;
                }
                if (this.duplicityNameCheck(null, value)) {
                    GraphVertexData data = new GraphVertexData();
                    data.setName((String)value);
                    return super.createVertex(parent, id, data, x, y, width, height, "VERTEX_STYLE", relative);
                }
                this.duplicityNameCheckError();
                return null;
            }

            @Override
            public Object createEdge(Object parent, String id, Object value, Object source, Object target, String style) {
                return super.createEdge(parent, id, new GraphEdgeData(), source, target, "EDGE_STYLE");
            }

            private String getNextName() {
                String name;
                do {
                    name = Character.toString(GraphViewPanel.this.c);
                    if (GraphViewPanel.this.last != 0) {
                        name = name + GraphViewPanel.this.last;
                    }
                    if (GraphViewPanel.this.c == 'Z') {
                        GraphViewPanel.this.c = 'A';
                        GraphViewPanel.this.last++;
                        continue;
                    }
                    GraphViewPanel.access$008(GraphViewPanel.this);
                } while (!this.duplicityNameCheck(null, name));
                return name;
            }

            private void setNewName(Object o) {
                GraphVertexData data = (GraphVertexData)((mxCell)o).getValue();
                data.setSelected(false);
                data.setName(this.getNextName());
            }

            @Override
            public Object[] moveCells(Object[] cells, double dx, double dy, boolean clone, Object target, Point location) {
                Object[] newCells = super.moveCells(cells, dx, dy, clone, target, location);
                if (clone) {
                    for (Object o : newCells) {
                        if (!((mxCell)o).isVertex()) continue;
                        ((mxCell)o).setStyle("VERTEX_STYLE");
                        this.setNewName(o);
                    }
                    this.refresh();
                }
                return newCells;
            }
        };
        this.graphComponent = new mxGraphComponent(this.graph);
        this.graphComponent.setToolTips(true);
        this.graphComponent.setEnterStopsCellEditing(true);
        this.graphComponent.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                GraphViewPanel.this.zoomByMouseWheel(e, GraphViewPanel.this.graphComponent);
            }
        });
        this.graphComponent.getGraphControl().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!e.isPopupTrigger() && e.isAltDown()) {
                    GraphViewPanel.this.addNewNodeByMouse(e, GraphViewPanel.this.graphComponent);
                }
            }
        });
        mxRubberband rubberBand = new mxRubberband(this.graphComponent);
        this.graphComponent.getViewport().setBackground(Color.WHITE);
        this.graphComponent.setBackground(Color.WHITE);
        this.add(this.graphComponent);
    }

    public mxGraphComponent getGraphComponent() {
        return this.graphComponent;
    }

    public EditorGraph getGraph() {
        return this.graph;
    }

    public void clearGraph() {
        this.graph.removeCells(this.graph.getChildCells(this.graph.getDefaultParent()), true);
        this.resetNewNodesNames();
    }

    public void resetNewNodesNames() {
        this.last = 0;
        this.c = (char)65;
    }

    public void setGraph(mxGraph newGraph) {
        if (newGraph == null) {
            this.clearGraph();
            return;
        }
        mxGraph oldGraph = this.graphComponent.getGraph();
        oldGraph.getModel().beginUpdate();
        oldGraph.setStylesheet(newGraph.getStylesheet());
        oldGraph.removeCells(oldGraph.getChildCells(oldGraph.getDefaultParent()), true);
        oldGraph.addCells(newGraph.cloneCells(newGraph.getChildCells(newGraph.getDefaultParent())));
        for (Object o : oldGraph.getChildVertices(oldGraph.getDefaultParent())) {
            mxCell cell = (mxCell)o;
            GraphVertexData data = (GraphVertexData)cell.getValue();
            if (!data.isSelected().booleanValue()) continue;
            oldGraph.getModel().setStyle(cell, "SELECTED_VERTEX_STYLE");
        }
        oldGraph.getModel().endUpdate();
        this.resetNewNodesNames();
    }

    public mxGraphOutline getGraphOutline() {
        mxGraphOutline graphOutline = new mxGraphOutline(this.graphComponent);
        graphOutline.setAntiAlias(true);
        graphOutline.setDrawLabels(true);
        graphOutline.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                GraphViewPanel.this.zoomByMouseWheel(e, GraphViewPanel.this.graphComponent);
            }
        });
        return graphOutline;
    }

    protected void zoomByMouseWheel(MouseWheelEvent e, mxGraphComponent gc) {
        if (e.isControlDown()) {
            if (e.getWheelRotation() < 0) {
                gc.zoomIn();
            } else {
                gc.zoomOut();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addNewNodeByMouse(MouseEvent e, mxGraphComponent gc) {
        double scale = gc.getGraph().getView().getScale();
        double x = (double)e.getX() / scale;
        double y = (double)e.getY() / scale;
        x = x - this.vertexWidth / 2.0 < 0.0 ? 0.0 : (x -= this.vertexWidth / 2.0);
        y = y - this.vertexHeight / 2.0 < 0.0 ? 0.0 : (y -= this.vertexHeight / 2.0);
        Object s = null;
        gc.getGraph().getModel().beginUpdate();
        try {
            gc.getGraph().insertVertex(gc.getGraph().getDefaultParent(), null, s, x, y, this.vertexWidth, this.vertexHeight);
        }
        finally {
            gc.getGraph().getModel().endUpdate();
        }
    }

    public void doParallelEdgeLayout() {
        new mxParallelEdgeLayout(this.graphComponent.getGraph()).execute(this.graphComponent.getGraph().getDefaultParent());
        this.graphComponent.getGraph().refresh();
    }

    public boolean isVertexLabel() {
        return this.graph.isVertexLabel();
    }

    public void setVertexLabel(boolean vertexLabel) {
        if (vertexLabel != this.graph.isVertexLabel()) {
            this.graph.setVertexLabel(vertexLabel);
            this.graphComponent.getGraph().refresh();
        }
    }

    public boolean isEdgeLabel() {
        return this.graph.isEdgeLabel();
    }

    public void setEdgeLabel(boolean edgeLabel) {
        if (edgeLabel != this.graph.isEdgeLabel()) {
            this.graph.setEdgeLabel(edgeLabel);
            this.graphComponent.getGraph().refresh();
        }
    }

    static /* synthetic */ char access$008(GraphViewPanel x0) {
        char c = x0.c;
        x0.c = (char)(c + '\u0001');
        return c;
    }
}

