/*
 * Decompiled with CFR 0.152.
 */
package program;

import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.util.mxGraphActions;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxResources;
import com.mxgraph.util.mxUndoManager;
import com.mxgraph.view.mxGraphView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.TransferHandler;
import program.MainPanel;
import program.actions.ActionLogger;
import program.actions.BasicActions;

public class ToolBar
extends JToolBar
implements mxEventSource.mxIEventListener {
    private static final Insets margins = new Insets(0, 0, 0, 0);
    protected boolean hideLabels = true;
    protected ToolBarButton redoButton;
    protected ToolBarButton undoButton;
    private boolean ignoreZoomChange = false;

    public ToolBar(final MainPanel mainPanel, int orientation) {
        super(orientation);
        this.setFloatable(false);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), this.getBorder()));
        this.add(new ToolBarButton(mainPanel.bind(mxResources.get("new"), new ActionLogger(new BasicActions.NewAction()), "/images/new.gif")));
        this.add(new ToolBarButton(mainPanel.bind(mxResources.get("open"), new ActionLogger(new BasicActions.OpenAction()), "/images/open.gif")));
        this.add(new ToolBarButton(mainPanel.bind(mxResources.get("save"), new ActionLogger(new BasicActions.SaveAction(false)), "/images/save.gif")));
        this.addSeparator();
        this.add(new ToolBarButton(mainPanel.bindGraphAction(mxResources.get("cut"), new ActionLogger(TransferHandler.getCutAction()), "/images/cut.gif")));
        this.add(new ToolBarButton(mainPanel.bindGraphAction(mxResources.get("copy"), new ActionLogger(TransferHandler.getCopyAction()), "/images/copy.gif")));
        this.add(new ToolBarButton(mainPanel.bindGraphAction(mxResources.get("paste"), new ActionLogger(TransferHandler.getPasteAction()), "/images/paste.gif")));
        this.addSeparator();
        this.add(new ToolBarButton(mainPanel.bindGraphAction(mxResources.get("delete"), new ActionLogger(mxGraphActions.getDeleteAction()), "/images/delete.gif")));
        this.addSeparator();
        this.undoButton = (ToolBarButton)this.add(new ToolBarButton(mainPanel.bind(mxResources.get("undo"), new ActionLogger(new BasicActions.UndoAction()), "/images/undo.gif")));
        this.undoButton.setEnabled(false);
        this.redoButton = (ToolBarButton)this.add(new ToolBarButton(mainPanel.bind(mxResources.get("redo"), new ActionLogger(new BasicActions.RedoAction()), "/images/redo.gif")));
        this.redoButton.setEnabled(false);
        this.addSeparator();
        final mxGraphView view = mainPanel.getGraphComponent().getGraph().getView();
        final JComboBox<String> zoomCombo = new JComboBox<String>(new String[]{"400%", "200%", "150%", "100%", "75%", "50%", mxResources.get("actualSize")});
        zoomCombo.setName("Zoom");
        zoomCombo.setEditable(true);
        zoomCombo.setMinimumSize(new Dimension(75, 0));
        zoomCombo.setPreferredSize(new Dimension(75, 0));
        zoomCombo.setMaximumSize(new Dimension(75, 100));
        zoomCombo.setMaximumRowCount(9);
        this.add(zoomCombo);
        this.addSeparator();
        mxEventSource.mxIEventListener scaleTracker = new mxEventSource.mxIEventListener(){

            @Override
            public void invoke(Object sender, mxEventObject evt) {
                ToolBar.this.ignoreZoomChange = true;
                try {
                    zoomCombo.setSelectedItem((int)Math.round(100.0 * view.getScale()) + "%");
                }
                finally {
                    ToolBar.this.ignoreZoomChange = false;
                }
            }
        };
        view.getGraph().getView().addListener("scale", scaleTracker);
        view.getGraph().getView().addListener("scaleAndTranslate", scaleTracker);
        scaleTracker.invoke(null, null);
        zoomCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                mxGraphComponent graphComponent = mainPanel.getGraphComponent();
                if (!ToolBar.this.ignoreZoomChange) {
                    String zoom = zoomCombo.getSelectedItem().toString();
                    if (zoom.equals(mxResources.get("actualSize"))) {
                        graphComponent.zoomActual();
                    } else {
                        try {
                            zoom = zoom.replace("%", "");
                            double scale = Math.min(16.0, Math.max(0.01, Double.parseDouble(zoom) / 100.0));
                            graphComponent.zoomTo(scale, graphComponent.isCenterZoom());
                        }
                        catch (Exception ex) {
                            JOptionPane.showMessageDialog(mainPanel, ex.getMessage());
                        }
                    }
                }
            }
        });
        this.add(new ToolBarButton(mainPanel.bindGraphAction(mxResources.get("setSelected"), new ActionLogger(new BasicActions.SetCellSelectedAction()), "/images/preferences.gif")));
    }

    public void showOrHideLabels() {
        this.hideLabels = !this.hideLabels;
        for (Component c : this.getComponents()) {
            if (c instanceof ToolBarButton) {
                ToolBarButton button = (ToolBarButton)c;
                button.setHideActionText(this.hideLabels);
                continue;
            }
            if (!(c instanceof JComboBox)) continue;
            JComboBox cb = (JComboBox)c;
            cb.setMaximumSize(cb.getSize());
        }
    }

    @Override
    public void invoke(Object sender, mxEventObject evt) {
        if (sender != null && sender instanceof mxUndoManager) {
            mxUndoManager undoManager = (mxUndoManager)sender;
            this.redoButton.setEnabled(undoManager.canRedo());
            this.undoButton.setEnabled(undoManager.canUndo());
        }
    }

    public class ToolBarButton
    extends JButton {
        public ToolBarButton(Action a) {
            super(a);
            this.setMargin(margins);
            this.setVerticalTextPosition(3);
            this.setHorizontalTextPosition(0);
            this.setHideActionText(ToolBar.this.hideLabels);
            this.setFocusPainted(false);
            this.setToolTipText((String)a.getValue("Name"));
        }
    }
}

