/*
 * Decompiled with CFR 0.152.
 */
package simulator.algorithms;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import simulator.algorithms.AlgorithmBase;

public abstract class AbstractAlgorithm
extends DefaultStyledDocument {
    protected AlgorithmBase algorithmBase = new AlgorithmBase();
    protected String algorithmName;
    protected List<AlgorithmBase.AlgorithmElement[]> algorithmParts = new ArrayList<AlgorithmBase.AlgorithmElement[]>();
    protected ArrayList<DefaultStyledDocument.ElementSpec> batch;
    protected int lineNumberCount = 0;

    protected DefaultStyledDocument.ElementSpec createSpecStart(AttributeSet attr, short direction) {
        DefaultStyledDocument.ElementSpec spec = new DefaultStyledDocument.ElementSpec(attr, 1);
        spec.setDirection(direction);
        return spec;
    }

    protected DefaultStyledDocument.ElementSpec createSpecEnd() {
        DefaultStyledDocument.ElementSpec spec = new DefaultStyledDocument.ElementSpec(null, 2);
        return spec;
    }

    protected DefaultStyledDocument.ElementSpec createContent(AttributeSet attr, String str, short direction) {
        DefaultStyledDocument.ElementSpec spec = new DefaultStyledDocument.ElementSpec(attr, 3, str.toCharArray(), 0, str.length());
        spec.setDirection(direction);
        return spec;
    }

    protected void addEmtyLine() {
        SimpleAttributeSet as = new SimpleAttributeSet();
        as.addAttribute("lineNum", 0);
        as.addAttribute("line", 0);
        as.addAttributes(this.algorithmBase.getAlgorithmsStyle("AlgorithmHeading"));
        this.batch.add(this.createSpecStart(as, (short)6));
        this.batch.add(this.createContent(SimpleAttributeSet.EMPTY, "\n", (short)6));
        this.batch.add(this.createSpecEnd());
    }

    protected void addLine(AlgorithmBase.AlgorithmContent[] lineContent) {
        for (AlgorithmBase.AlgorithmContent ac : lineContent) {
            AttributeSet algStyle = ac.getStyleName() == null ? SimpleAttributeSet.EMPTY : this.algorithmBase.getAlgorithmsStyle(ac.getStyleName());
            this.batch.add(this.createContent(algStyle, ac.getContent(), (short)6));
        }
        this.batch.add(this.createContent(null, "\n", (short)6));
    }

    protected int addAlgorithmPart(AlgorithmBase.AlgorithmElement[] algorithmPart, int realLine) {
        int line = 0;
        for (AlgorithmBase.AlgorithmElement element : algorithmPart) {
            SimpleAttributeSet as = new SimpleAttributeSet();
            as.addAttribute("lineNum", line);
            as.addAttribute("line", ++realLine);
            if (element.getStyleName() != null) {
                as.addAttributes(this.algorithmBase.getAlgorithmsStyle(element.getStyleName()));
            }
            this.batch.add(this.createSpecStart(as, (short)6));
            this.addLine(element.getContentArray());
            this.batch.add(this.createSpecEnd());
            ++line;
        }
        return realLine;
    }

    protected void addAlgorithm() {
        this.batch = new ArrayList();
        this.batch.add(this.createSpecEnd());
        int realLine = 0;
        for (AlgorithmBase.AlgorithmElement[] algorithmPart : this.algorithmParts) {
            realLine = this.addAlgorithmPart(algorithmPart, realLine);
            this.addEmtyLine();
        }
        DefaultStyledDocument.ElementSpec[] inserts = new DefaultStyledDocument.ElementSpec[this.batch.size()];
        this.batch.toArray(inserts);
        try {
            this.insert(0, inserts);
        }
        catch (BadLocationException ex) {
            Logger.getLogger(AbstractAlgorithm.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.lineNumberCount = realLine;
    }

    public int getBeforeRealLine(int realLine) {
        if (realLine - 1 < 0) {
            return this.lineNumberCount;
        }
        return (realLine - 1) % (this.lineNumberCount + 1);
    }

    public int getNextRealLine(int realLine) {
        return (realLine + 1) % (this.lineNumberCount + 1);
    }

    public int getRealLineNumber(int algorithmPart, int line) {
        line %= this.algorithmParts.get(algorithmPart %= this.algorithmParts.size()).length;
        int realLine = 0;
        for (int i = 0; i < algorithmPart; ++i) {
            realLine += this.algorithmParts.get(i).length;
        }
        return realLine + line + 1;
    }

    public int getNumberOfAlgorithms() {
        return this.algorithmParts.size();
    }

    public int getNumberOfAlgorithmLine(int algorithmPart) {
        return this.algorithmParts.get(algorithmPart).length;
    }
}

