/*
 * Decompiled with CFR 0.152.
 */
package simulator.controllers;

import com.mxgraph.model.mxCell;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.Timer;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import simulator.algorithms.AbstractAlgorithm;
import simulator.controllers.ControllerTimer;
import simulator.controllers.SelectCellsMouseAdapter;
import simulator.controllers.VariableObject;
import simulator.graphs.AlgorithmGraph;
import simulator.graphs.AlgorithmGraphComponent;
import simulator.graphs.AlgorithmGraphStylesheet;
import simulator.graphs.GraphCell;
import simulator.gui.TextLineNumber;
import simulator.gui.VariablesPanel;
import simulator.gui.VisualizationPseudocodePanel;

public abstract class AbstractController {
    protected Map<String, VariableObject> variables = new LinkedHashMap<String, VariableObject>();
    protected Color doneColor = Color.red;
    protected List<Instruction> tape = new LinkedList<Instruction>();
    protected int tapePosition = 0;
    protected boolean pause = false;
    protected boolean end = false;
    protected boolean interactiveMode = false;
    protected CompoundEditBlock editBlock;
    protected UndoManager undoManager = new UndoManager();
    protected Object activeVariable;
    protected Object[] registers = new Object[8];
    protected Object lastScroll;
    protected boolean scrollEnabled = true;
    protected final AbstractAlgorithm algorithm;
    protected AlgorithmGraph graph;
    protected AlgorithmGraphStylesheet stylesheet;
    protected final VisualizationPseudocodePanel completeCodePanel;
    protected final TextLineNumber codePanel;
    protected final VariablesPanel variablesPanel;
    protected AlgorithmGraphComponent graphComponent;
    protected final JLabel graphComponentLabel;
    protected mxCell selectedNode = null;
    protected final ControllerTimer timer = new ControllerTimer(0, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!AbstractController.this.doNext()) {
                ((Timer)e.getSource()).stop();
            }
            if (AbstractController.this.codePanel.isDebugOnCurrentLine()) {
                AbstractController.this.timer.stop();
                AbstractController.this.codePanel.scrollToCurrentLine();
            }
        }
    });
    private final transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public AbstractController(AlgorithmGraphComponent graphCom, JLabel graphComponentLabel, VisualizationPseudocodePanel completeCodePanel, VariablesPanel variablesPanel) {
        this.completeCodePanel = completeCodePanel;
        this.algorithm = completeCodePanel.getAlgorithm();
        this.graphComponentLabel = graphComponentLabel;
        this.graphComponent = graphCom;
        this.graph = this.graphComponent.getGraph();
        this.stylesheet = this.graph.getAlgorithmStylesheet();
        this.codePanel = completeCodePanel.getTln();
        this.variablesPanel = variablesPanel;
        this.addAllAdjLists();
        this.graph.traverseAllCells(new AlgorithmGraph.AlgorithmGraphCellVisitor(){

            @Override
            public boolean visit(mxCell cell, GraphCell value) {
                if (value.isSelected().booleanValue()) {
                    AbstractController.this.selectedNode = cell;
                    return false;
                }
                return true;
            }

            @Override
            public boolean allowEdge() {
                return false;
            }
        });
        this.editBlock = new CompoundEditBlock();
        this.undoManager.setLimit(10000);
        this.timer.setRepeats(true);
    }

    private void addAllAdjLists() {
        for (Object o : this.graph.getChildVertices(this.graph.getDefaultParent())) {
            mxCell vertex = (mxCell)o;
            LinkedList<mxCell> adjList = new LinkedList<mxCell>();
            for (int i = 0; i < this.graph.getModel().getEdgeCount(vertex); ++i) {
                mxCell edge = (mxCell)this.graph.getModel().getEdgeAt(vertex, i);
                mxCell source = (mxCell)edge.getSource();
                mxCell target = (mxCell)edge.getTarget();
                if (source == vertex && !adjList.contains(target)) {
                    adjList.addFirst(target);
                    continue;
                }
                if (this.graph.isOriented() || target != vertex || adjList.contains(source)) continue;
                adjList.addFirst(source);
            }
            this.variablesPanel.addNodeAdjList(((GraphCell)vertex.getValue()).getName(), AbstractController.dequeToString(adjList));
        }
    }

    protected void updateVariablesShow() {
        for (Map.Entry<String, VariableObject> e : this.variables.entrySet()) {
            if (e.getValue().isEnabled()) {
                this.variablesPanel.addVariable(e.getKey(), e.getValue().toString());
                continue;
            }
            this.variablesPanel.removeVariable(e.getKey());
        }
    }

    public void resetController() {
        this.end = false;
        this.timer.stop();
        this.timer.setEnabled(true);
        this.timer.setRepeats(true);
        this.graph.resetCells();
        this.graph.traverseAllCells(new AlgorithmGraph.AlgorithmGraphCellVisitor(){

            @Override
            public boolean visit(mxCell cell, GraphCell value) {
                if (cell == AbstractController.this.selectedNode) {
                    value.setSelected(true);
                } else {
                    value.setSelected(false);
                }
                return true;
            }

            @Override
            public boolean allowEdge() {
                return false;
            }
        });
        this.graph.refresh();
        this.editBlock.die();
        this.editBlock = new CompoundEditBlock();
        this.undoManager.discardAllEdits();
        this.activeVariable = null;
        for (int i = 0; i < this.registers.length; ++i) {
            this.registers[i] = null;
        }
        this.lastScroll = null;
        this.pause = false;
        this.tapePosition = 0;
        this.codePanel.setCurrentLine(0);
        this.codePanel.clearAllHighlight();
        this.codePanel.clearAllhighlightStart();
        this.graph.refresh();
        this.codePanel.repaint();
        this.updateVariablesShow();
        for (Instruction ins : this.tape) {
            ins.stop();
        }
    }

    public void setDelay(int delay) {
        this.timer.setDelay(delay);
    }

    protected String getNodeName(Object o) {
        if (o == null || !(o instanceof mxCell)) {
            return "";
        }
        return ((GraphCell)((mxCell)o).getValue()).getName();
    }

    public static String dequeToString(Deque<mxCell> q) {
        if (q == null) {
            return "[]";
        }
        Iterator<mxCell> it = q.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            mxCell node;
            if ((node = it.next()).isVertex()) {
                sb.append(((GraphCell)node.getValue()).getName());
            } else {
                mxCell source = (mxCell)node.getSource();
                mxCell target = (mxCell)node.getTarget();
                sb.append('(');
                sb.append(((GraphCell)source.getValue()).getName());
                sb.append(", ");
                sb.append(((GraphCell)target.getValue()).getName());
                sb.append(')');
            }
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }

    protected void clearGraphComponent(AlgorithmGraphComponent gc) {
        AlgorithmGraph gcGraph = gc.getGraph();
        for (Object o : gcGraph.getChildCells(gcGraph.getDefaultParent(), true, true)) {
            gcGraph.getModel().remove(o);
        }
    }

    protected boolean isDoublesEquals(double first, double second) {
        return first == Double.POSITIVE_INFINITY && second == Double.POSITIVE_INFINITY || Math.abs(second - first) <= 1.0E-6;
    }

    public void setScrollEnabled(boolean scrollEnabled) {
        this.scrollEnabled = scrollEnabled;
    }

    public void runSimulation() {
        if (!this.timer.isEnable()) {
            this.performNext();
            this.timer.start();
        } else if (this.timer.isRunning()) {
            this.timer.stop();
        } else {
            this.timer.start();
        }
    }

    public void addTimerPropertyChangeListener(PropertyChangeListener listener) {
        this.timer.addPropertyChangeListener(listener);
    }

    public void removeTimerPropertyChangeListener(PropertyChangeListener listener) {
        this.timer.removePropertyChangeListener(listener);
    }

    public void setTimerStart(boolean start) {
        if (start) {
            this.timer.start();
        } else {
            this.timer.stop();
        }
    }

    public boolean isTimerRunning() {
        return this.timer.isRunning();
    }

    protected void scrollToActive() {
        if (this.scrollEnabled && this.activeVariable instanceof mxCell && this.lastScroll != this.activeVariable) {
            this.lastScroll = this.activeVariable;
            mxCell cell = (mxCell)this.activeVariable;
            double centerX = cell.getGeometry().getCenterX();
            double centerY = cell.getGeometry().getCenterY();
            Rectangle viewRect = this.graphComponent.getViewport().getViewRect();
            Point p = new Point((int)centerX - viewRect.width / 2, (int)centerY - viewRect.height / 2);
            if (p.getX() < 0.0) {
                p.x = 0;
            }
            if (p.getY() < 0.0) {
                p.y = 0;
            }
            this.graphComponent.getViewport().setViewPosition(p);
        }
    }

    protected boolean nextStep() {
        if (this.undoManager.canRedo()) {
            this.undoManager.redo();
        } else if (!this.end) {
            this.pause = false;
            while (!this.pause && this.tapePosition < this.tape.size()) {
                Instruction ins = this.tape.get(this.tapePosition);
                if (this.interactiveMode || !ins.isInteractive()) {
                    ins.preform();
                    this.tapePosition = ins.nextTapePos();
                    continue;
                }
                ++this.tapePosition;
            }
            return this.tapePosition != this.tape.size();
        }
        return this.undoManager.canRedo();
    }

    protected boolean doNext() {
        boolean ret = this.nextStep();
        this.graph.refresh();
        this.codePanel.repaint();
        this.scrollToActive();
        this.updateVariablesShow();
        return ret;
    }

    public boolean performNext() {
        this.timer.stop();
        return this.doNext();
    }

    public boolean canDoNext() {
        return this.undoManager.canRedo() || !this.end && this.tapePosition < this.tape.size();
    }

    public boolean canDoBefore() {
        if (this.tapePosition < this.tape.size() && this.tape.get(this.tapePosition).isInteractive() && this.tape.get(this.tapePosition).nextTapePos() == this.tapePosition) {
            return false;
        }
        return this.undoManager.canUndo();
    }

    protected boolean doBefore() {
        if (!this.canDoBefore()) {
            return false;
        }
        this.undoManager.undo();
        this.graph.refresh();
        this.codePanel.repaint();
        this.updateVariablesShow();
        return true;
    }

    public boolean performBefore() {
        this.timer.stop();
        return this.doBefore();
    }

    public void setInteractiveMode(boolean interactiveMode) {
        Instruction ins;
        if (this.interactiveMode && !interactiveMode && this.tapePosition < this.tape.size() && (ins = this.tape.get(this.tapePosition)).isInteractive()) {
            ins.stop();
        }
        this.interactiveMode = interactiveMode;
    }

    protected void setRegisterValue(Object newValue, int index) {
        this.registers[index] = newValue;
    }

    protected Object getRegisterValue(int index) {
        return this.registers[index];
    }

    protected String getTextForLabel(String text) {
        return "<html><div style=\"text-align: center;\">" + text.replaceAll("\n", "<br>") + "</html>";
    }

    protected final class ShowOrHideVariableEdit
    extends AlgorithmUndoableEdit {
        protected boolean show;
        protected boolean showBefore;
        protected VariableObject variable;

        public ShowOrHideVariableEdit(VariableObject variable, boolean show) {
            this.variable = variable;
            this.show = show;
            this.showBefore = variable.isShow();
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            this.variable.setShow(this.showBefore);
        }

        @Override
        protected void action() {
            this.variable.setShow(this.show);
        }
    }

    protected final class DequeueEdit
    extends AlgorithmUndoableEdit {
        protected mxCell oldActive;
        protected mxCell oldFirstInQueue;
        protected Deque<mxCell> q;

        public DequeueEdit(Deque<mxCell> q) {
            this.q = q;
            this.oldActive = (mxCell)AbstractController.this.activeVariable;
            this.oldFirstInQueue = this.q.getFirst();
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            this.q.addFirst(this.oldFirstInQueue);
            AbstractController.this.activeVariable = this.oldActive;
        }

        @Override
        protected void action() {
            AbstractController.this.activeVariable = this.q.removeFirst();
        }
    }

    protected final class EnqueueEdit
    extends AlgorithmUndoableEdit {
        protected mxCell oldActive;
        protected Deque<mxCell> q;
        protected boolean last;

        public EnqueueEdit(Deque<mxCell> q, boolean last) {
            this.q = q;
            this.last = last;
            this.oldActive = (mxCell)AbstractController.this.activeVariable;
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            this.q.remove(this.oldActive);
        }

        @Override
        protected void action() {
            if (this.last) {
                this.q.addLast(this.oldActive);
            } else {
                this.q.addFirst(this.oldActive);
            }
        }
    }

    protected final class MakeAdjListEdit
    extends AlgorithmUndoableEdit {
        protected Deque<mxCell> q;
        protected mxCell oldActive;
        protected boolean oriented;

        public MakeAdjListEdit(Deque<mxCell> q, boolean oriented) {
            this.q = q;
            this.oldActive = (mxCell)AbstractController.this.activeVariable;
            this.oriented = oriented;
            this.action();
        }

        private void addAllVerticesToAdjlist(mxCell vertex) {
            this.q.clear();
            for (int i = 0; i < AbstractController.this.graph.getModel().getEdgeCount(vertex); ++i) {
                mxCell edge = (mxCell)AbstractController.this.graph.getModel().getEdgeAt(vertex, i);
                mxCell source = (mxCell)edge.getSource();
                mxCell target = (mxCell)edge.getTarget();
                if (source == vertex) {
                    this.q.addFirst(target);
                    continue;
                }
                if (this.oriented || target != vertex) continue;
                this.q.addFirst(source);
            }
        }

        @Override
        public void undo() {
            super.undo();
            this.q.clear();
        }

        @Override
        protected void action() {
            this.q.clear();
            this.addAllVerticesToAdjlist(this.oldActive);
        }
    }

    protected final class SetColorHighlighEdit
    extends AlgorithmUndoableEdit {
        protected int start;
        protected int end;
        protected Color c;
        protected Map<Integer, Color> lastHighlight;

        public SetColorHighlighEdit(int start, int end, Color c) {
            this.start = start;
            this.end = end;
            this.c = c;
            this.lastHighlight = AbstractController.this.codePanel.getAllhighlightStart();
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            for (Map.Entry<Integer, Color> e : this.lastHighlight.entrySet()) {
                AbstractController.this.codePanel.highlightLineStart(e.getKey(), e.getValue());
            }
        }

        @Override
        protected void action() {
            AbstractController.this.codePanel.highlightLineStartArea(this.start, this.end, this.c);
        }
    }

    protected final class ChangeEdgeStyleEdit
    extends AlgorithmUndoableEdit {
        protected mxCell edge;
        protected String newStyle;
        protected String oldStyle;

        public ChangeEdgeStyleEdit(mxCell edge, String newStyle) {
            this.edge = edge;
            this.newStyle = newStyle;
            this.oldStyle = edge.getStyle();
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            this.edge.setStyle(this.oldStyle);
        }

        @Override
        protected void action() {
            this.edge.setStyle(this.newStyle);
        }
    }

    protected final class MoveRegisterToActive
    extends AlgorithmUndoableEdit {
        protected Object oldActive;
        protected int registerNumber;

        public MoveRegisterToActive(int registerNumber) {
            this.oldActive = AbstractController.this.activeVariable;
            this.registerNumber = registerNumber;
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            AbstractController.this.activeVariable = this.oldActive;
        }

        @Override
        protected void action() {
            AbstractController.this.activeVariable = AbstractController.this.registers[this.registerNumber];
        }
    }

    protected final class MoveActiveToRegister
    extends AlgorithmUndoableEdit {
        protected Object oldRegister;
        protected Object active;
        protected int registerNumber;

        public MoveActiveToRegister(int registerNumber, Object active) {
            this.oldRegister = AbstractController.this.registers[registerNumber];
            this.registerNumber = registerNumber;
            this.active = active;
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            AbstractController.this.registers[this.registerNumber] = this.oldRegister;
        }

        @Override
        protected void action() {
            AbstractController.this.registers[this.registerNumber] = this.active;
        }
    }

    protected final class SetCursorEdit
    extends AlgorithmUndoableEdit {
        protected int oldPosition;
        protected int newPosition;

        public SetCursorEdit(int newPosition) {
            this.newPosition = newPosition;
            this.oldPosition = AbstractController.this.codePanel.getCurrentLine();
            this.action();
        }

        @Override
        protected void action() {
            AbstractController.this.codePanel.setCurrentLine(this.newPosition);
        }

        @Override
        public void undo() {
            super.undo();
            AbstractController.this.codePanel.setCurrentLine(this.oldPosition);
        }
    }

    protected final class SetColorEdit
    extends AlgorithmUndoableEdit {
        protected mxCell node;
        protected String oldStyle;
        protected String newStyle;

        public SetColorEdit(String newStyle, mxCell node) {
            this.node = node;
            this.newStyle = newStyle;
            this.oldStyle = node.getStyle();
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            AbstractController.this.graph.setCellStyle(this.oldStyle, new Object[]{this.node});
        }

        @Override
        protected void action() {
            AbstractController.this.graph.setCellStyle(this.newStyle, new Object[]{this.node});
        }
    }

    protected final class SetLabelTextEdit
    extends AlgorithmUndoableEdit {
        protected String oldText;
        protected String newText;

        public SetLabelTextEdit(String newText) {
            this.oldText = AbstractController.this.graphComponentLabel.getText();
            this.newText = AbstractController.this.getTextForLabel(newText);
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            AbstractController.this.graphComponentLabel.setText(this.oldText);
        }

        @Override
        protected void action() {
            AbstractController.this.graphComponentLabel.setText(this.newText);
        }
    }

    protected final class SetEnableToolTipsEdit
    extends AlgorithmUndoableEdit {
        protected GraphCell graphNode;
        protected boolean toolTips;

        public SetEnableToolTipsEdit(mxCell node) {
            this.graphNode = (GraphCell)node.getValue();
            this.toolTips = this.graphNode.isToolTipsEnabled();
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            this.graphNode.setToolTipsEnabled(this.toolTips);
        }

        @Override
        protected void action() {
            this.graphNode.setToolTipsEnabled(!this.toolTips);
        }
    }

    protected final class SetNewActiveGraphEdit
    extends AlgorithmUndoableEdit {
        protected AlgorithmGraph newGraph;
        protected AlgorithmGraph oldGraph;

        public SetNewActiveGraphEdit(AlgorithmGraph newGraph) {
            this.oldGraph = AbstractController.this.graph;
            this.newGraph = newGraph;
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            AbstractController.this.graph = this.oldGraph;
        }

        @Override
        protected void action() {
            AbstractController.this.graph = this.newGraph;
        }
    }

    protected final class SetNewActiveGraphComponentEdit
    extends AlgorithmUndoableEdit {
        protected AlgorithmGraphComponent newGraph;
        protected AlgorithmGraphComponent oldGraph;

        public SetNewActiveGraphComponentEdit(AlgorithmGraphComponent newGraph) {
            this.oldGraph = AbstractController.this.graphComponent;
            this.newGraph = newGraph;
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            AbstractController.this.graphComponent = this.oldGraph;
        }

        @Override
        protected void action() {
            AbstractController.this.graphComponent = this.newGraph;
        }
    }

    protected final class SetEnableEdit
    extends AlgorithmUndoableEdit {
        protected GraphCell graphNode;
        protected boolean enable;

        public SetEnableEdit(mxCell node) {
            this.graphNode = (GraphCell)node.getValue();
            this.enable = this.graphNode.isEnabled();
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            this.graphNode.setEnabled(this.enable);
        }

        @Override
        protected void action() {
            this.graphNode.setEnabled(!this.enable);
        }
    }

    protected class SetColorHighlighInstruction
    extends BasicInstruction {
        protected int start;
        protected int end;
        protected Color c;

        public SetColorHighlighInstruction(int start, int end, Color c) {
            this.start = start;
            this.end = end;
            this.c = c;
        }

        @Override
        public void preform() {
            AbstractController.this.editBlock.addEdit(new SetColorHighlighEdit(this.start, this.end, this.c));
        }
    }

    protected class ShowOrHideVariableInstruction
    extends BasicInstruction {
        protected boolean show;
        protected String variable;

        public ShowOrHideVariableInstruction(String variable, boolean show) {
            this.show = show;
            this.variable = variable;
        }

        @Override
        public void preform() {
            AbstractController.this.editBlock.addEdit(new ShowOrHideVariableEdit(AbstractController.this.variables.get(this.variable), this.show));
        }
    }

    protected class ActiveToRegisterInstruction
    extends BasicInstruction {
        protected int registerIndex;

        public ActiveToRegisterInstruction(int registerIndex) {
            this.registerIndex = registerIndex;
        }

        @Override
        public void preform() {
            AbstractController.this.editBlock.addEdit(new MoveActiveToRegister(this.registerIndex, AbstractController.this.activeVariable));
        }
    }

    protected class SetNewActiveGraphInstruction
    extends BasicInstruction {
        protected AlgorithmGraph newGraph;
        protected AlgorithmGraphComponent newComp;

        public SetNewActiveGraphInstruction(AlgorithmGraphComponent newComp) {
            this.newGraph = null;
            this.newComp = null;
            this.newComp = newComp;
        }

        public SetNewActiveGraphInstruction(AlgorithmGraph newGraph) {
            this.newGraph = null;
            this.newComp = null;
            this.newGraph = newGraph;
        }

        @Override
        public void preform() {
            if (this.newComp == null) {
                AbstractController.this.editBlock.addEdit(new SetNewActiveGraphEdit(this.newGraph));
            } else {
                AbstractController.this.editBlock.addEdit(new SetNewActiveGraphEdit(this.newComp.getGraph()));
                AbstractController.this.editBlock.addEdit(new SetNewActiveGraphComponentEdit(this.newComp));
            }
        }
    }

    protected final class SetSelectedCellFirstEdit
    extends AlgorithmUndoableEdit {
        protected Deque<mxCell> q;
        protected mxCell cell;
        protected Deque<mxCell> oldQ;

        public SetSelectedCellFirstEdit(Deque<mxCell> q, mxCell cell) {
            this.q = q;
            this.cell = cell;
            this.oldQ = new LinkedList<mxCell>();
            this.oldQ.addAll(q);
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            this.q.clear();
            this.q.addAll(this.oldQ);
        }

        @Override
        protected void action() {
            if (this.q.contains(this.cell)) {
                this.q.remove(this.cell);
                this.q.addFirst(this.cell);
            }
        }
    }

    protected class SetSelectedCellFirstInstruction
    extends BasicInstruction {
        protected Deque<mxCell> q;

        public SetSelectedCellFirstInstruction(Deque<mxCell> q) {
            this.q = q;
        }

        @Override
        public void preform() {
            AbstractController.this.graph.traverseAllCells(new AlgorithmGraph.AlgorithmGraphCellVisitor(){

                @Override
                public boolean visit(mxCell vertex, GraphCell node) {
                    if (node.isSelected().booleanValue() && SetSelectedCellFirstInstruction.this.q.contains(vertex)) {
                        AbstractController.this.editBlock.addEdit(new SetSelectedCellFirstEdit(SetSelectedCellFirstInstruction.this.q, vertex));
                        return false;
                    }
                    return true;
                }

                @Override
                public boolean allowEdge() {
                    return true;
                }
            });
        }
    }

    protected class ColorEdgeActiveAndRegisterInstruction
    extends BasicInstruction {
        protected String newStyle;
        protected int registerNum;
        protected boolean oriented;

        public ColorEdgeActiveAndRegisterInstruction(int registerNum, String newStyle, boolean oriented) {
            this.newStyle = newStyle;
            this.registerNum = registerNum;
            this.oriented = oriented;
        }

        @Override
        public void preform() {
            for (int i = 0; i < AbstractController.this.graph.getModel().getEdgeCount(AbstractController.this.activeVariable); ++i) {
                mxCell edge = (mxCell)AbstractController.this.graph.getModel().getEdgeAt(AbstractController.this.activeVariable, i);
                mxCell source = (mxCell)edge.getTarget();
                mxCell target = (mxCell)edge.getSource();
                if (AbstractController.this.getRegisterValue(this.registerNum) == AbstractController.this.activeVariable) {
                    if (source != AbstractController.this.activeVariable || target != AbstractController.this.activeVariable) continue;
                    AbstractController.this.editBlock.addEdit(new ChangeEdgeStyleEdit(edge, this.newStyle));
                    continue;
                }
                if (target != AbstractController.this.getRegisterValue(this.registerNum) && (this.oriented || source != AbstractController.this.getRegisterValue(this.registerNum))) continue;
                AbstractController.this.editBlock.addEdit(new ChangeEdgeStyleEdit(edge, this.newStyle));
            }
        }
    }

    protected class RegisterToActiveInstruction
    extends BasicInstruction {
        protected int registerIndex;

        public RegisterToActiveInstruction(int registerIndex) {
            this.registerIndex = registerIndex;
        }

        @Override
        public void preform() {
            AbstractController.this.editBlock.addEdit(new MoveRegisterToActive(this.registerIndex));
        }
    }

    protected class LabelInstruction
    extends BasicInstruction {
        protected Instruction jump;
        protected Condition condition;

        public LabelInstruction() {
            this.jump = null;
        }

        public LabelInstruction(Instruction jump, Condition condition) {
            this.jump = jump;
            this.condition = condition;
        }

        @Override
        public void preform() {
            if (this.jump != null && (this.condition == null || this.condition.isFulfil())) {
                new SetTapePositionInstruction(AbstractController.this.tape.indexOf(this.jump)).preform();
            }
        }
    }

    protected class SetLabelTextInstruction
    extends BasicInstruction {
        protected String text;

        public SetLabelTextInstruction(String text) {
            this.text = text;
        }

        @Override
        public void preform() {
            AbstractController.this.editBlock.addEdit(new SetLabelTextEdit(this.text));
        }
    }

    protected class SetCursorInstruction
    extends BasicInstruction {
        protected int cursorPos;

        public SetCursorInstruction(int cursorPos) {
            this.cursorPos = cursorPos;
        }

        @Override
        public void preform() {
            AbstractController.this.editBlock.addEdit(new SetCursorEdit(this.cursorPos));
        }
    }

    protected class SetColorInstruction
    extends BasicInstruction {
        protected String style;

        public SetColorInstruction(String style) {
            this.style = style;
        }

        @Override
        public void preform() {
            AbstractController.this.editBlock.addEdit(new SetColorEdit(this.style, (mxCell)AbstractController.this.activeVariable));
        }
    }

    protected class SetTapePositionInstruction
    extends BasicInstruction {
        protected int tapePos;

        public SetTapePositionInstruction(int tapePos) {
            this.tapePos = tapePos;
        }

        @Override
        public void preform() {
            AbstractController.this.tapePosition = this.tapePos;
        }
    }

    protected class PauseInstruction
    extends BasicInstruction {
        protected boolean bigPause;

        protected PauseInstruction() {
            this.bigPause = false;
        }

        public PauseInstruction setBigPause(boolean bigPause) {
            this.bigPause = bigPause;
            return this;
        }

        @Override
        public void preform() {
            AbstractController.this.editBlock.setLastTapeIndex(AbstractController.this.tapePosition);
            AbstractController.this.editBlock.end();
            AbstractController.this.undoManager.addEdit(AbstractController.this.editBlock);
            AbstractController.this.editBlock = new CompoundEditBlock();
            AbstractController.this.editBlock.setFirstTapeIndex(AbstractController.this.tapePosition);
            AbstractController.this.pause = true;
        }
    }

    protected class MakeAdjListInstruction
    extends BasicInstruction {
        protected Deque<mxCell> q;
        protected boolean oriented;

        public MakeAdjListInstruction(Deque<mxCell> q, boolean oriented) {
            this.q = q;
            this.oriented = oriented;
        }

        @Override
        public void preform() {
            AbstractController.this.editBlock.addEdit(new MakeAdjListEdit(this.q, this.oriented));
        }
    }

    protected final class SetIntRegisterEdit
    extends AlgorithmUndoableEdit {
        protected Integer newValue;
        protected Integer oldValue;
        protected int registerIndex;

        public SetIntRegisterEdit(int registerIndex, Integer newValue) {
            this.newValue = newValue;
            this.oldValue = (Integer)AbstractController.this.getRegisterValue(registerIndex);
            this.registerIndex = registerIndex;
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            AbstractController.this.setRegisterValue(this.oldValue, this.registerIndex);
        }

        @Override
        protected void action() {
            AbstractController.this.setRegisterValue(this.newValue, this.registerIndex);
        }
    }

    protected class IncIntRegisterInstruction
    extends BasicInstruction {
        protected int registerIndex;

        public IncIntRegisterInstruction(int registerIndex) {
            this.registerIndex = registerIndex;
        }

        @Override
        public void preform() {
            Integer value = (Integer)AbstractController.this.getRegisterValue(this.registerIndex) + 1;
            AbstractController.this.editBlock.addEdit(new SetIntRegisterEdit(this.registerIndex, value));
        }
    }

    protected class SetIntRegisterInstruction
    extends BasicInstruction {
        protected Integer value;
        protected int registerIndex;

        public SetIntRegisterInstruction(int registerIndex, Integer value) {
            this.value = value;
            this.registerIndex = registerIndex;
        }

        @Override
        public void preform() {
            AbstractController.this.editBlock.addEdit(new SetIntRegisterEdit(this.registerIndex, this.value));
        }
    }

    protected final class AddAllCellToListEdit
    extends AlgorithmUndoableEdit {
        protected Deque<mxCell> q;
        protected boolean vertices;
        protected boolean edges;

        public AddAllCellToListEdit(Deque<mxCell> q, boolean vertices, boolean edges) {
            this.q = q;
            this.vertices = vertices;
            this.edges = edges;
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            this.q.clear();
        }

        @Override
        protected void action() {
            this.q.clear();
            AbstractController.this.graph.traverseAllCells(new AlgorithmGraph.AlgorithmGraphCellVisitor(){

                @Override
                public boolean visit(mxCell cell, GraphCell node) {
                    if (cell.isVertex() && AddAllCellToListEdit.this.vertices || cell.isEdge() && AddAllCellToListEdit.this.edges) {
                        AddAllCellToListEdit.this.q.add(cell);
                    }
                    return true;
                }

                @Override
                public boolean allowEdge() {
                    return AddAllCellToListEdit.this.edges;
                }
            });
        }
    }

    protected class AddAllVertexListInstruction
    extends BasicInstruction {
        protected Deque<mxCell> q;

        public AddAllVertexListInstruction(Deque<mxCell> q) {
            this.q = q;
        }

        @Override
        public void preform() {
            AbstractController.this.editBlock.addEdit(new AddAllCellToListEdit(this.q, true, false));
        }
    }

    protected class AddAllEdgesListInstruction
    extends BasicInstruction {
        protected Deque<mxCell> q;

        public AddAllEdgesListInstruction(Deque<mxCell> q) {
            this.q = q;
        }

        @Override
        public void preform() {
            AbstractController.this.editBlock.addEdit(new AddAllCellToListEdit(this.q, false, true));
        }
    }

    protected class DequeueInstruction
    extends BasicInstruction {
        protected Deque<mxCell> q;

        public DequeueInstruction(Deque<mxCell> q) {
            this.q = q;
        }

        @Override
        public void preform() {
            AbstractController.this.editBlock.addEdit(new DequeueEdit(this.q));
        }
    }

    protected class EnqueueInstruction
    extends BasicInstruction {
        protected Deque<mxCell> q;

        public EnqueueInstruction(Deque<mxCell> q) {
            this.q = q;
        }

        @Override
        public void preform() {
            AbstractController.this.editBlock.addEdit(new EnqueueEdit(this.q, true));
        }
    }

    protected class PushInstruction
    extends BasicInstruction {
        protected Deque<mxCell> s;

        public PushInstruction(Deque<mxCell> s) {
            this.s = s;
        }

        @Override
        public void preform() {
            AbstractController.this.editBlock.addEdit(new EnqueueEdit(this.s, false));
        }
    }

    protected final class ClearQueueEdit
    extends AlgorithmUndoableEdit {
        protected Deque<mxCell> q;
        protected Deque<mxCell> oldQ;

        public ClearQueueEdit(Deque<mxCell> q) {
            this.q = q;
            this.oldQ = new LinkedList<mxCell>();
            this.oldQ.addAll(q);
            this.action();
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.q.clear();
            this.q.addAll(this.oldQ);
        }

        @Override
        protected void action() {
            this.q.clear();
        }
    }

    protected class ClearQueueInstruction
    extends BasicInstruction {
        protected Deque<mxCell> q;

        public ClearQueueInstruction(Deque<mxCell> q) {
            this.q = q;
        }

        @Override
        public void preform() {
            AbstractController.this.editBlock.addEdit(new ClearQueueEdit(this.q));
        }
    }

    protected class SetVertexToolTipsInstruction
    extends BasicInstruction {
        protected SetVertexToolTipsInstruction() {
        }

        @Override
        public void preform() {
            AbstractController.this.editBlock.addEdit(new SetEnableToolTipsEdit((mxCell)AbstractController.this.activeVariable));
        }
    }

    protected class SetVertexEnableInstruction
    extends BasicInstruction {
        protected SetVertexEnableInstruction() {
        }

        @Override
        public void preform() {
            AbstractController.this.editBlock.addEdit(new SetEnableEdit((mxCell)AbstractController.this.activeVariable));
        }
    }

    protected class SelectStartNodeInstruction
    extends InteractiveInstruction {
        protected SelectCellsMouseAdapter adapter;

        public SelectStartNodeInstruction() {
            this.adapter = new SelectCellsMouseAdapter(1, AbstractController.this.graphComponent, AbstractController.this.graph);
            this.adapter.setActivated(false);
            AbstractController.this.graphComponent.getGraphControl().addMouseListener(this.adapter);
        }

        @Override
        public void preform() {
            AbstractController.this.graphComponentLabel.setText(AbstractController.this.getTextForLabel("Vyber po\u010d\u00e1te\u010dn\u00ed uzel a klikni pokra\u010dovat\n[u\u017eivatelsk\u00e1 akce]"));
            if (!this.adapter.isActivated()) {
                AbstractController.this.timer.setEnabled(false);
                this.adapter.setActivated(true);
            } else if (this.adapter.getLastSelected() != null) {
                AbstractController.this.graph.traverseAllCells(new AlgorithmGraph.AlgorithmGraphCellVisitor(){

                    @Override
                    public boolean visit(mxCell vertex, GraphCell node) {
                        if (vertex == SelectStartNodeInstruction.this.adapter.getLastSelected()) {
                            node.setSelected(true);
                        } else {
                            node.setSelected(false);
                        }
                        return true;
                    }

                    @Override
                    public boolean allowEdge() {
                        return false;
                    }
                });
                this.stop();
                return;
            }
            AbstractController.this.pause = true;
        }

        @Override
        public int nextTapePos() {
            if (this.adapter.isActivated()) {
                return AbstractController.this.tapePosition;
            }
            return super.nextTapePos();
        }

        @Override
        public void stop() {
            if (this.adapter.isActivated()) {
                this.adapter.setActivated(false);
                this.adapter.resetStyles();
                this.adapter.reset();
                AbstractController.this.timer.setEnabled(true);
            }
        }
    }

    protected class EndInstruction
    extends BasicInstruction {
        protected EndInstruction() {
        }

        @Override
        public void preform() {
            AbstractController.this.editBlock.addEdit(new SetCursorEdit(0));
            AbstractController.this.editBlock.setLastTapeIndex(AbstractController.this.tapePosition);
            AbstractController.this.editBlock.end();
            AbstractController.this.undoManager.addEdit(AbstractController.this.editBlock);
            AbstractController.this.pause = true;
            AbstractController.this.end = true;
        }

        @Override
        public int nextTapePos() {
            return AbstractController.this.tape.size();
        }
    }

    protected static interface Condition {
        public boolean isFulfil();
    }

    protected abstract class BasicInstruction
    implements Instruction {
        protected BasicInstruction() {
        }

        @Override
        public boolean isInteractive() {
            return false;
        }

        @Override
        public int nextTapePos() {
            return AbstractController.this.tapePosition + 1;
        }

        @Override
        public void stop() {
        }
    }

    protected abstract class InteractiveInstruction
    implements Instruction {
        protected InteractiveInstruction() {
        }

        @Override
        public boolean isInteractive() {
            return true;
        }

        @Override
        public int nextTapePos() {
            return AbstractController.this.tapePosition + 1;
        }
    }

    public class CompoundEditBlock
    extends CompoundEdit {
        protected int firstTapeIndex;
        protected int lastTapeIndex;

        public int getFirstTapeIndex() {
            return this.firstTapeIndex;
        }

        public void setFirstTapeIndex(int firstTapeIndex) {
            this.firstTapeIndex = firstTapeIndex;
        }

        public int getLastTapeIndex() {
            return this.lastTapeIndex;
        }

        public void setLastTapeIndex(int lastTapeIndex) {
            this.lastTapeIndex = lastTapeIndex;
        }
    }

    public static abstract class AlgorithmUndoableEdit
    extends AbstractUndoableEdit {
        protected abstract void action();

        @Override
        public void redo() {
            super.redo();
            this.action();
        }
    }

    public static interface Instruction {
        public void preform();

        public void stop();

        public int nextTapePos();

        public boolean isInteractive();
    }
}

