/*
 * Decompiled with CFR 0.152.
 */
package simulator.controllers;

import com.mxgraph.model.mxCell;
import java.util.Deque;
import java.util.LinkedList;
import javax.swing.JLabel;
import simulator.controllers.AbstractController;
import simulator.graphs.AlgorithmGraph;
import simulator.graphs.AlgorithmGraphComponent;
import simulator.graphs.GraphCell;
import simulator.graphs.bellmanford.BellmanFordGraphEdge;
import simulator.graphs.bellmanford.BellmanFordGraphVertex;
import simulator.gui.VariablesPanel;
import simulator.gui.VisualizationPseudocodePanel;

public class AbstractShortestPathController
extends AbstractController {
    protected Deque<mxCell> cellList = new LinkedList<mxCell>();
    protected Integer variableS = 0;
    protected Integer variableV = 1;
    protected Integer variableU = 2;

    public AbstractShortestPathController(AlgorithmGraphComponent graphCom, JLabel graphComponentLabel, VisualizationPseudocodePanel completeCodePanel, VariablesPanel variablesPanel) {
        super(graphCom, graphComponentLabel, completeCodePanel, variablesPanel);
    }

    protected final class SetDistanceEdit
    extends AbstractController.AlgorithmUndoableEdit {
        protected BellmanFordGraphVertex graphNode;
        protected Double newValue;
        protected Double oldValue;

        public SetDistanceEdit(mxCell node, Double newValue) {
            this.graphNode = (BellmanFordGraphVertex)node.getValue();
            this.newValue = newValue;
            this.oldValue = this.graphNode.getDistance();
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            this.graphNode.setDistance(this.oldValue);
        }

        @Override
        protected void action() {
            this.graphNode.setDistance(this.newValue);
        }
    }

    protected class SetDistanceInstruction
    extends AbstractController.BasicInstruction {
        protected Integer regIndex1;
        protected Integer regIndex2;
        protected Double value;

        public SetDistanceInstruction(Double value) {
            this.value = value;
            this.regIndex1 = null;
        }

        public SetDistanceInstruction(int regIndex, Double value) {
            this.value = value;
            this.regIndex1 = regIndex;
        }

        public SetDistanceInstruction(int regIndex1, int regIndex2) {
            this.regIndex1 = regIndex1;
            this.regIndex2 = regIndex2;
        }

        @Override
        public void preform() {
            if (this.regIndex1 == null) {
                AbstractShortestPathController.this.editBlock.addEdit(new SetDistanceEdit((mxCell)AbstractShortestPathController.this.activeVariable, this.value));
            } else if (this.regIndex1 != null && this.value != null) {
                AbstractShortestPathController.this.editBlock.addEdit(new SetDistanceEdit((mxCell)AbstractShortestPathController.this.getRegisterValue(this.regIndex1), this.value));
            } else if (this.regIndex1 != null && this.regIndex2 != null) {
                BellmanFordGraphEdge edge = (BellmanFordGraphEdge)((mxCell)AbstractShortestPathController.this.activeVariable).getValue();
                BellmanFordGraphVertex node = (BellmanFordGraphVertex)((mxCell)AbstractShortestPathController.this.getRegisterValue(this.regIndex2)).getValue();
                Double newValue = node.getDistance() + edge.getDistance();
                AbstractShortestPathController.this.editBlock.addEdit(new SetDistanceEdit((mxCell)AbstractShortestPathController.this.getRegisterValue(this.regIndex1), newValue));
            }
        }
    }

    protected final class EdgeToRegistersEdit
    extends AbstractController.AlgorithmUndoableEdit {
        protected int register1;
        protected int register2;
        protected Object register1Value;
        protected Object register2Value;
        protected mxCell edge;

        public EdgeToRegistersEdit(mxCell edge, int register1, int register2) {
            this.register1 = register1;
            this.register2 = register2;
            this.edge = edge;
            this.register1Value = AbstractShortestPathController.this.getRegisterValue(register1);
            this.register2Value = AbstractShortestPathController.this.getRegisterValue(register2);
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            AbstractShortestPathController.this.setRegisterValue(this.register1Value, this.register1);
            AbstractShortestPathController.this.setRegisterValue(this.register2Value, this.register2);
        }

        @Override
        protected void action() {
            AbstractShortestPathController.this.setRegisterValue(this.edge.getSource(), this.register1);
            AbstractShortestPathController.this.setRegisterValue(this.edge.getTarget(), this.register2);
        }
    }

    protected class EdgeToRegistersInstruction
    extends AbstractController.BasicInstruction {
        protected int register1;
        protected int register2;

        public EdgeToRegistersInstruction(int register1, int register2) {
            this.register1 = register1;
            this.register2 = register2;
        }

        @Override
        public void preform() {
            AbstractShortestPathController.this.editBlock.addEdit(new EdgeToRegistersEdit((mxCell)AbstractShortestPathController.this.activeVariable, this.register1, this.register2));
        }
    }

    protected final class EdgeToActiveEdit
    extends AbstractController.AlgorithmUndoableEdit {
        protected mxCell oldActive;
        protected mxCell edge;

        public EdgeToActiveEdit(mxCell source, mxCell target) {
            this.action();
            this.edge = (mxCell)AbstractShortestPathController.this.graph.getEdgesBetween(source, target, true)[0];
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            AbstractShortestPathController.this.activeVariable = this.oldActive;
        }

        @Override
        protected void action() {
            AbstractShortestPathController.this.activeVariable = this.edge;
        }
    }

    protected class EdgeToActiveInstruction
    extends AbstractController.BasicInstruction {
        protected int sourceReg;
        protected int targetReg;

        public EdgeToActiveInstruction(int sourceReg, int targetReg) {
            this.sourceReg = sourceReg;
            this.targetReg = targetReg;
        }

        @Override
        public void preform() {
            AbstractShortestPathController.this.editBlock.addEdit(new EdgeToActiveEdit((mxCell)AbstractShortestPathController.this.getRegisterValue(this.sourceReg), (mxCell)AbstractShortestPathController.this.getRegisterValue(this.targetReg)));
        }
    }

    protected final class SetPathEdit
    extends AbstractController.AlgorithmUndoableEdit {
        protected BellmanFordGraphVertex graphNode;
        protected BellmanFordGraphVertex newPath;
        protected BellmanFordGraphVertex oldPath;

        public SetPathEdit(mxCell node, mxCell newPath) {
            this.graphNode = (BellmanFordGraphVertex)node.getValue();
            this.oldPath = this.graphNode.getNodePath();
            this.newPath = newPath != null ? (BellmanFordGraphVertex)newPath.getValue() : null;
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            this.graphNode.setNodePath(this.oldPath);
        }

        @Override
        protected void action() {
            this.graphNode.setNodePath(this.newPath);
        }
    }

    protected class SetPathInstruction
    extends AbstractController.BasicInstruction {
        protected Integer regNum1 = null;
        protected Integer regNum2 = null;

        public SetPathInstruction() {
        }

        public SetPathInstruction(int regNum) {
            this.regNum1 = regNum;
        }

        public SetPathInstruction(int regNum1, int regNum2) {
            this.regNum1 = regNum1;
            this.regNum2 = regNum2;
        }

        @Override
        public void preform() {
            if (this.regNum1 == null && this.regNum2 == null) {
                AbstractShortestPathController.this.editBlock.addEdit(new SetPathEdit((mxCell)AbstractShortestPathController.this.activeVariable, null));
            } else if (this.regNum1 != null && this.regNum2 == null) {
                AbstractShortestPathController.this.editBlock.addEdit(new SetPathEdit((mxCell)AbstractShortestPathController.this.activeVariable, (mxCell)AbstractShortestPathController.this.getRegisterValue(this.regNum1)));
            } else {
                AbstractShortestPathController.this.editBlock.addEdit(new SetPathEdit((mxCell)AbstractShortestPathController.this.getRegisterValue(this.regNum1), (mxCell)AbstractShortestPathController.this.getRegisterValue(this.regNum2)));
            }
        }
    }

    protected class ColorPathsInstruction
    extends AbstractController.BasicInstruction {
        protected String pathStyle;
        protected String normalStyle;

        public ColorPathsInstruction(String pathStyle, String normalStyle) {
            this.pathStyle = pathStyle;
            this.normalStyle = normalStyle;
        }

        @Override
        public void preform() {
            AbstractShortestPathController.this.graph.traverseAllCells(new AlgorithmGraph.AlgorithmGraphCellVisitor(){

                @Override
                public boolean visit(mxCell cell, GraphCell value) {
                    if (cell.isEdge()) {
                        BellmanFordGraphVertex source = (BellmanFordGraphVertex)cell.getSource().getValue();
                        BellmanFordGraphVertex target = (BellmanFordGraphVertex)cell.getTarget().getValue();
                        if (target.getNodePath() == source) {
                            AbstractShortestPathController.this.editBlock.addEdit(new AbstractController.SetColorEdit(ColorPathsInstruction.this.pathStyle, cell));
                        } else {
                            AbstractShortestPathController.this.editBlock.addEdit(new AbstractController.SetColorEdit(ColorPathsInstruction.this.normalStyle, cell));
                        }
                    }
                    return true;
                }

                @Override
                public boolean allowEdge() {
                    return true;
                }
            });
        }
    }

    protected class InitInstruction
    extends AbstractController.BasicInstruction {
        protected String style;
        protected boolean wasSelected = false;

        public InitInstruction(String style) {
            this.style = style;
        }

        @Override
        public void preform() {
            AbstractShortestPathController.this.graph.traverseAllCells(new AlgorithmGraph.AlgorithmGraphCellVisitor(){

                @Override
                public boolean visit(mxCell vertex, GraphCell node) {
                    if (node.isSelected().booleanValue()) {
                        InitInstruction.this.wasSelected = true;
                        AbstractShortestPathController.this.editBlock.addEdit(new AbstractController.SetColorEdit(InitInstruction.this.style, vertex));
                        AbstractShortestPathController.this.setRegisterValue(vertex, AbstractShortestPathController.this.variableS);
                    }
                    return true;
                }

                @Override
                public boolean allowEdge() {
                    return false;
                }
            });
            if (!this.wasSelected) {
                mxCell vertex = (mxCell)AbstractShortestPathController.this.graph.getChildVertices(AbstractShortestPathController.this.graph.getDefaultParent())[0];
                AbstractShortestPathController.this.editBlock.addEdit(new AbstractController.SetColorEdit(this.style, vertex));
                AbstractShortestPathController.this.setRegisterValue(vertex, AbstractShortestPathController.this.variableS);
            }
        }
    }
}

