/*
 * Decompiled with CFR 0.152.
 */
package simulator.controllers;

import com.mxgraph.model.mxCell;
import java.awt.Color;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JLabel;
import simulator.controllers.AbstractController;
import simulator.controllers.AbstractShortestPathController;
import simulator.controllers.SelectCellsMouseAdapter;
import simulator.controllers.VariableObject;
import simulator.graphs.AlgorithmGraphComponent;
import simulator.graphs.bellmanford.BellmanFordGraphEdge;
import simulator.graphs.bellmanford.BellmanFordGraphVertex;
import simulator.gui.VariablesPanel;
import simulator.gui.VisualizationPseudocodePanel;

public class DijkstraController
extends AbstractShortestPathController {
    protected Deque<mxCell> Q = new LinkedList<mxCell>();
    protected Deque<mxCell> S = new LinkedList<mxCell>();

    public DijkstraController(AlgorithmGraphComponent graphCom, JLabel graphComponentLabel, VisualizationPseudocodePanel completeCodePanel, VariablesPanel variablesPanel) {
        super(graphCom, graphComponentLabel, completeCodePanel, variablesPanel);
        this.resetControllerImpl();
        this.interactiveMode = false;
        AbstractController.LabelInstruction iniSingleSource = new AbstractController.LabelInstruction();
        AbstractController.LabelInstruction relax = new AbstractController.LabelInstruction();
        AbstractController.LabelInstruction returnIniSingleSource = new AbstractController.LabelInstruction();
        AbstractController.LabelInstruction returnRelax = new AbstractController.LabelInstruction();
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(0, 1), this.algorithm.getRealLineNumber(0, 10), Color.GREEN));
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(1, 1), this.algorithm.getRealLineNumber(1, 4), Color.GREEN));
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(2, 1), this.algorithm.getRealLineNumber(2, 5), Color.GREEN));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("Q", false));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("S", false));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("u", false));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("v", false));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("Iterative list", false));
        this.tape.add(new AbstractController.SelectStartNodeInstruction());
        this.tape.add(new AbstractShortestPathController.InitInstruction(this.stylesheet.getSelectedVertexStyle()));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(0, 1)));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Initialization of all nodes"));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.LabelInstruction(iniSingleSource, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return true;
            }
        }));
        this.tape.add(returnIniSingleSource);
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(0, 1), this.algorithm.getRealLineNumber(0, 1), this.doneColor));
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(2, 1), this.algorithm.getRealLineNumber(2, 5), this.doneColor));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(0, 2)));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Initialization of the set S of finished node"));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(0, 1), this.algorithm.getRealLineNumber(0, 2), this.doneColor));
        this.tape.add(new AbstractController.ClearQueueInstruction(this.S));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("S", true));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(0, 3)));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Inserted nodes to queue Q"));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(0, 1), this.algorithm.getRealLineNumber(0, 3), this.doneColor));
        this.tape.add(new AbstractController.AddAllVertexListInstruction(this.Q));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("Q", true));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("u", true));
        AbstractController.LabelInstruction whileLabel = new AbstractController.LabelInstruction();
        AbstractController.LabelInstruction endWhile = new AbstractController.LabelInstruction(whileLabel, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return !DijkstraController.this.Q.isEmpty();
            }
        });
        this.tape.add(new AbstractController.LabelInstruction(endWhile, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return DijkstraController.this.Q.isEmpty();
            }
        }));
        this.tape.add(whileLabel);
        this.tape.add(new AbstractController.SetLabelTextInstruction("Main cycle, until all the nodes are in process in the queue Q"));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(0, 4)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetLabelTextInstruction("Take off the node with the lowest distance from queue Q"));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(0, 5)));
        this.tape.add(new SelectNextNodeInstruction());
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetLabelTextInstruction("Add node into the set S of completed nodes"));
        this.tape.add(new DequeueMinInstruction(this.Q));
        this.tape.add(new AbstractController.ActiveToRegisterInstruction(this.variableU));
        this.tape.add(new AbstractController.SetColorInstruction(this.stylesheet.getDoneVertexStyle()));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(0, 6)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.EnqueueInstruction(this.S));
        this.tape.add(new AbstractController.MakeAdjListInstruction(this.cellList, true));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("Iterative list", true));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(0, 7)));
        this.tape.add(new SetVerticesDistanceInstruction());
        AbstractController.LabelInstruction forLabel = new AbstractController.LabelInstruction();
        AbstractController.LabelInstruction forEndLabel1 = new AbstractController.LabelInstruction();
        this.tape.add(forLabel);
        this.tape.add(new AbstractController.SetLabelTextInstruction("Make a relaxation of all edges leading to the actual node"));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(0, 7)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.LabelInstruction(forEndLabel1, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return DijkstraController.this.cellList.isEmpty();
            }
        }));
        this.tape.add(new AbstractController.DequeueInstruction(this.cellList));
        this.tape.add(new AbstractController.ActiveToRegisterInstruction(this.variableV));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("v", true));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(0, 8)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractShortestPathController.EdgeToActiveInstruction(this.variableU, this.variableV));
        this.tape.add(new AbstractController.SetColorInstruction(this.stylesheet.getHighlighEdgeStyle()));
        this.tape.add(new AbstractController.LabelInstruction(relax, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return true;
            }
        }));
        this.tape.add(returnRelax);
        this.tape.add(new AbstractShortestPathController.ColorPathsInstruction(this.stylesheet.getPathEdgeStyle(), this.stylesheet.getEdgeStyle()));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(0, 9)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.LabelInstruction(forLabel, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return !DijkstraController.this.cellList.isEmpty();
            }
        }));
        this.tape.add(forEndLabel1);
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("v", false));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("Iterative list", false));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(0, 10)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(endWhile);
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(0, 1), this.algorithm.getRealLineNumber(0, 10), this.doneColor));
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(1, 1), this.algorithm.getRealLineNumber(1, 4), this.doneColor));
        this.tape.add(new AbstractController.EndInstruction());
        this.tape.add(relax);
        this.tape.add(new AbstractController.SetLabelTextInstruction("The method of relaxation writes new distance to the node, if it is smaller than the previous"));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 0)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 1)));
        this.tape.add(new AbstractController.PauseInstruction());
        AbstractController.LabelInstruction ifEnd2 = new AbstractController.LabelInstruction();
        this.tape.add(new AbstractController.LabelInstruction(ifEnd2, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                BellmanFordGraphVertex u = (BellmanFordGraphVertex)((mxCell)DijkstraController.this.getRegisterValue(DijkstraController.this.variableU)).getValue();
                BellmanFordGraphVertex v = (BellmanFordGraphVertex)((mxCell)DijkstraController.this.getRegisterValue(DijkstraController.this.variableV)).getValue();
                BellmanFordGraphEdge edge = (BellmanFordGraphEdge)((mxCell)DijkstraController.this.activeVariable).getValue();
                return v.getDistance() <= u.getDistance() + edge.getDistance();
            }
        }));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 2)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add((AbstractShortestPathController)this.new AbstractShortestPathController.SetDistanceInstruction((int)this.variableV, this.variableU));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 3)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractShortestPathController.SetPathInstruction(this.variableV, this.variableU));
        this.tape.add(ifEnd2);
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 4)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.LabelInstruction(returnRelax, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return true;
            }
        }));
        this.tape.add(iniSingleSource);
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 0)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.AddAllVertexListInstruction(this.cellList));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("Iterative list", true));
        AbstractController.LabelInstruction forLabel2 = new AbstractController.LabelInstruction();
        this.tape.add(forLabel2);
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 1)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.DequeueInstruction(this.cellList));
        this.tape.add(new AbstractController.ActiveToRegisterInstruction(this.variableV));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("v", true));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 2)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetVertexEnableInstruction());
        this.tape.add(new AbstractShortestPathController.SetDistanceInstruction(Double.POSITIVE_INFINITY));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 3)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetVertexToolTipsInstruction());
        this.tape.add(new AbstractShortestPathController.SetPathInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 4)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.LabelInstruction(forLabel2, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return !DijkstraController.this.cellList.isEmpty();
            }
        }));
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(2, 1), this.algorithm.getRealLineNumber(2, 4), this.doneColor));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("v", false));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("Iterative list", false));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 5)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.RegisterToActiveInstruction(this.variableS));
        this.tape.add(new AbstractShortestPathController.SetDistanceInstruction(0.0));
        this.tape.add(new AbstractController.SetColorInstruction(this.stylesheet.getVertexStyle()));
        this.tape.add(new AbstractController.LabelInstruction(returnIniSingleSource, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return true;
            }
        }));
    }

    private void resetControllerImpl() {
        this.graphComponentLabel.setText("Dijkstra's algorithm");
        this.codePanel.setCurrentLine(1);
        this.variables.put("Q", new VariableObject(){

            @Override
            public String getVariableValue() {
                return AbstractController.dequeToString(DijkstraController.this.Q);
            }
        });
        this.variables.put("S", new VariableObject(){

            @Override
            public String getVariableValue() {
                return AbstractController.dequeToString(DijkstraController.this.S);
            }
        });
        this.variables.put("s", new VariableObject(){

            @Override
            public String getVariableValue() {
                return DijkstraController.this.getNodeName(DijkstraController.this.getRegisterValue(DijkstraController.this.variableS));
            }
        });
        this.variables.put("u", new VariableObject(){

            @Override
            public String getVariableValue() {
                return DijkstraController.this.getNodeName(DijkstraController.this.getRegisterValue(DijkstraController.this.variableU));
            }
        });
        this.variables.put("v", new VariableObject(){

            @Override
            public String getVariableValue() {
                return DijkstraController.this.getNodeName(DijkstraController.this.getRegisterValue(DijkstraController.this.variableV));
            }
        });
        this.variables.put("Iterative list", new VariableObject(){

            @Override
            public String getVariableValue() {
                return AbstractController.dequeToString(DijkstraController.this.cellList);
            }
        });
        for (Map.Entry e : this.variables.entrySet()) {
            if (!((VariableObject)e.getValue()).isEnabled()) continue;
            this.variablesPanel.addVariable((String)e.getKey());
        }
        this.Q.clear();
        this.S.clear();
        this.cellList.clear();
    }

    @Override
    public void resetController() {
        super.resetController();
        this.resetControllerImpl();
    }

    protected final class DequeueMinEdit
    extends AbstractController.AlgorithmUndoableEdit {
        protected mxCell oldActive;
        protected mxCell NodeForRemove;
        protected Deque<mxCell> q;
        protected Deque<mxCell> oldQ = new LinkedList<mxCell>();

        public DequeueMinEdit(Deque<mxCell> q) {
            this.q = q;
            this.oldActive = (mxCell)DijkstraController.this.activeVariable;
            this.oldQ.addAll(q);
            for (mxCell cell : q) {
                if (this.NodeForRemove != null && !(((BellmanFordGraphVertex)cell.getValue()).getDistance() <= ((BellmanFordGraphVertex)this.NodeForRemove.getValue()).getDistance())) continue;
                this.NodeForRemove = cell;
                if (!((BellmanFordGraphVertex)cell.getValue()).isSelected().booleanValue()) continue;
                break;
            }
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            this.q.clear();
            this.q.addAll(this.oldQ);
            DijkstraController.this.activeVariable = this.oldActive;
        }

        @Override
        protected void action() {
            this.q.remove(this.NodeForRemove);
            DijkstraController.this.activeVariable = this.NodeForRemove;
        }
    }

    protected class DequeueMinInstruction
    extends AbstractController.BasicInstruction {
        protected Deque<mxCell> q;

        public DequeueMinInstruction(Deque<mxCell> q) {
            this.q = q;
        }

        @Override
        public void preform() {
            DijkstraController.this.editBlock.addEdit(new DequeueMinEdit(this.q));
        }
    }

    protected class SelectNextNodeInstruction
    extends AbstractController.InteractiveInstruction {
        protected SelectCellsMouseAdapter adapter;
        protected mxCell minNode = null;

        public SelectNextNodeInstruction() {
            this.adapter = new SelectCellsMouseAdapter(1, DijkstraController.this.graphComponent, DijkstraController.this.graph);
            this.adapter.setActivated(false);
            DijkstraController.this.graphComponent.getGraphControl().addMouseListener(this.adapter);
        }

        @Override
        public void preform() {
            if (!this.adapter.isActivated()) {
                this.minNode = null;
                for (mxCell cell : DijkstraController.this.Q) {
                    if (this.minNode != null && !(((BellmanFordGraphVertex)cell.getValue()).getDistance() < ((BellmanFordGraphVertex)this.minNode.getValue()).getDistance())) continue;
                    this.minNode = cell;
                }
                DijkstraController.this.graphComponentLabel.setText(DijkstraController.this.getTextForLabel("Select a node to be taken from queue Q\n[u\u017eivatelsk\u00e1 akce]"));
                DijkstraController.this.timer.setEnabled(false);
                this.adapter.setActivated(true);
            } else if (this.adapter.getLastSelected() != null && !DijkstraController.this.S.contains(this.adapter.getLastSelected())) {
                BellmanFordGraphVertex selected = (BellmanFordGraphVertex)this.adapter.getLastSelected().getValue();
                if (DijkstraController.this.isDoublesEquals(selected.getDistance(), ((BellmanFordGraphVertex)this.minNode.getValue()).getDistance())) {
                    selected.setSelected(true);
                    this.stop();
                    return;
                }
                DijkstraController.this.graphComponentLabel.setText(DijkstraController.this.getTextForLabel("Wrong node selected\n[u\u017eivatelsk\u00e1 akce]"));
            }
            DijkstraController.this.pause = true;
        }

        @Override
        public int nextTapePos() {
            if (this.adapter.isActivated()) {
                return DijkstraController.this.tapePosition;
            }
            return super.nextTapePos();
        }

        @Override
        public void stop() {
            if (this.adapter.isActivated()) {
                this.adapter.setActivated(false);
                this.adapter.resetStyles();
                this.adapter.reset();
                DijkstraController.this.timer.setEnabled(true);
            }
        }
    }

    protected class SetVerticesDistanceInstruction
    extends AbstractController.InteractiveInstruction {
        protected Map<mxCell, Double> newDistanceMap = new HashMap<mxCell, Double>();
        protected Map<mxCell, Double> oldDistanceMap = new HashMap<mxCell, Double>();

        protected SetVerticesDistanceInstruction() {
        }

        @Override
        public void preform() {
            if (!DijkstraController.this.graph.isCellsEditable()) {
                DijkstraController.this.graphComponentLabel.setText(DijkstraController.this.getTextForLabel("Enter the value of the distance into the nodes for the process of relaxation\n[u\u017eivatelsk\u00e1 akce]"));
                DijkstraController.this.graph.setCellsEditable(true, true, false);
                DijkstraController.this.timer.setEnabled(false);
                mxCell u = (mxCell)DijkstraController.this.getRegisterValue(DijkstraController.this.variableU);
                BellmanFordGraphVertex uValue = (BellmanFordGraphVertex)u.getValue();
                this.newDistanceMap.clear();
                this.oldDistanceMap.clear();
                for (mxCell cell : DijkstraController.this.cellList) {
                    BellmanFordGraphEdge edge = (BellmanFordGraphEdge)((mxCell)DijkstraController.this.graph.getEdgesBetween(u, cell, true)[0]).getValue();
                    BellmanFordGraphVertex cellValue = (BellmanFordGraphVertex)cell.getValue();
                    this.oldDistanceMap.put(cell, cellValue.getDistance());
                    double newDistance = cellValue.getDistance();
                    if (cellValue.getDistance() > uValue.getDistance() + edge.getDistance()) {
                        newDistance = uValue.getDistance() + edge.getDistance();
                    }
                    this.newDistanceMap.put(cell, newDistance);
                    cellValue.setEditable(true);
                }
            } else {
                BellmanFordGraphVertex cellValue;
                boolean isRight = true;
                for (mxCell cell : DijkstraController.this.cellList) {
                    cellValue = (BellmanFordGraphVertex)cell.getValue();
                    if (DijkstraController.this.isDoublesEquals(cellValue.getDistance(), this.newDistanceMap.get(cell))) continue;
                    cellValue.setDistance(this.oldDistanceMap.get(cell));
                    isRight = false;
                }
                if (isRight) {
                    for (mxCell cell : DijkstraController.this.cellList) {
                        cellValue = (BellmanFordGraphVertex)cell.getValue();
                        cellValue.setDistance(this.oldDistanceMap.get(cell));
                    }
                    this.stop();
                    DijkstraController.this.graph.refresh();
                    return;
                }
                DijkstraController.this.graphComponentLabel.setText(DijkstraController.this.getTextForLabel("Wrong set up of the distances\n[u\u017eivatelsk\u00e1 akce]"));
            }
            DijkstraController.this.pause = true;
        }

        @Override
        public void stop() {
            if (DijkstraController.this.graph.isCellsEditable()) {
                for (mxCell cell : DijkstraController.this.cellList) {
                    BellmanFordGraphVertex cellValue = (BellmanFordGraphVertex)cell.getValue();
                    cellValue.setEditable(false);
                }
                DijkstraController.this.graph.setCellsEditable(false);
                DijkstraController.this.timer.setEnabled(true);
            }
        }

        @Override
        public int nextTapePos() {
            if (DijkstraController.this.graph.isCellsEditable()) {
                return DijkstraController.this.tapePosition;
            }
            return super.nextTapePos();
        }
    }
}

