/*
 * Decompiled with CFR 0.152.
 */
package simulator.controllers;

import com.mxgraph.model.mxCell;
import com.mxgraph.swing.mxGraphComponent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Deque;
import java.util.LinkedList;
import simulator.controllers.SimulatorMouseAdapter;
import simulator.graphs.AlgorithmGraph;

public class SelectCellsMouseAdapter
extends SimulatorMouseAdapter {
    public static final String PROPERTY_SELECTED_NODES = "selectedNodes";
    protected int maxSelected;
    protected mxGraphComponent graphComponent;
    protected AlgorithmGraph graph;
    protected Deque<mxCell> selectedCells;
    protected boolean vertices;
    protected boolean edges;
    private final transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public SelectCellsMouseAdapter(mxGraphComponent graphComponent, AlgorithmGraph graph) {
        this(graphComponent, graph, true, false);
    }

    public SelectCellsMouseAdapter(int maxSelected, mxGraphComponent graphComponent, AlgorithmGraph graph) {
        this(maxSelected, graphComponent, graph, true, false);
    }

    public SelectCellsMouseAdapter(mxGraphComponent graphComponent, AlgorithmGraph graph, boolean vertices, boolean edges) {
        this(graph.getChildCells(graph.getDefaultParent(), true, false).length, graphComponent, graph, vertices, edges);
    }

    public SelectCellsMouseAdapter(int maxSelected, mxGraphComponent graphComponent, AlgorithmGraph graph, boolean vertices, boolean edges) {
        this.vertices = vertices;
        this.edges = edges;
        this.maxSelected = maxSelected;
        this.graphComponent = graphComponent;
        this.graph = graph;
        this.selectedCells = new LinkedList<mxCell>();
    }

    public mxCell getLastSelected() {
        return this.selectedCells.peekLast();
    }

    public Deque<mxCell> getSelectedNodes() {
        return this.selectedCells;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void reset() {
        super.reset();
        this.selectedCells.clear();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        mxCell cell;
        if (this.activated && (cell = (mxCell)this.graphComponent.getCellAt(e.getX(), e.getY())) != null && (cell.isVertex() && this.vertices || cell.isEdge() && this.edges)) {
            if (this.selectedCells.contains(cell)) {
                cell.setStyle((String)this.oldStyles.get(cell));
                this.oldStyles.remove(cell);
                this.selectedCells.remove(cell);
                this.propertyChangeSupport.firePropertyChange(PROPERTY_SELECTED_NODES, null, this.selectedCells);
            } else {
                if (this.selectedCells.size() == this.maxSelected) {
                    mxCell last = this.selectedCells.removeFirst();
                    last.setStyle((String)this.oldStyles.get(last));
                    this.oldStyles.remove(last);
                }
                this.selectedCells.add(cell);
                this.oldStyles.put(cell, cell.getStyle());
                if (!this.vertices || !this.edges) {
                    cell.setStyle(this.graph.getAlgorithmStylesheet().getSelectedStyle(this.edges));
                }
                this.propertyChangeSupport.firePropertyChange(PROPERTY_SELECTED_NODES, null, this.selectedCells);
            }
            this.graphComponent.getGraph().getSelectionModel().clear();
            this.graphComponent.refresh();
        }
    }
}

