/*
 * Decompiled with CFR 0.152.
 */
package simulator.controllers;

import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGeometry;
import com.mxgraph.util.mxPoint;
import com.mxgraph.view.mxConnectionConstraint;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JLabel;
import simulator.controllers.AbstractController;
import simulator.controllers.AbstractDfsController;
import simulator.controllers.SelectCellsMouseAdapter;
import simulator.controllers.VariableObject;
import simulator.graphs.AlgorithmGraph;
import simulator.graphs.AlgorithmGraphComponent;
import simulator.graphs.GraphCell;
import simulator.graphs.dfs.DfsGraphVertex;
import simulator.gui.VariablesPanel;
import simulator.gui.VisualizationPseudocodePanel;

public class TopologicalSortController
extends AbstractDfsController {
    protected Deque<mxCell> listL = new LinkedList<mxCell>();
    protected AlgorithmGraphComponent graphComponentList;

    public TopologicalSortController(AlgorithmGraphComponent graphCom, JLabel graphComponentLabel, VisualizationPseudocodePanel completeCodePanel, VariablesPanel variablesPanel, AlgorithmGraphComponent graphComponentList) {
        super(graphCom, graphComponentLabel, completeCodePanel, variablesPanel);
        this.graphComponentList = graphComponentList;
        this.interactiveMode = false;
        this.resetControllerImpl();
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(0, 1), this.algorithm.getRealLineNumber(0, 3), Color.GREEN));
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(1, 1), this.algorithm.getRealLineNumber(1, 10), Color.GREEN));
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(2, 1), this.algorithm.getRealLineNumber(2, 11), Color.GREEN));
        this.tape.add(new AbstractController.SetLabelTextInstruction("DFS algorithm"));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(0, 1)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(0, 1), this.algorithm.getRealLineNumber(0, 1), this.doneColor));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 0)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetLabelTextInstruction("Initialization of all nodes"));
        this.tape.add(new AbstractController.AddAllVertexListInstruction(this.vertexList));
        AbstractController.LabelInstruction forLabel = new AbstractController.LabelInstruction();
        this.tape.add(forLabel);
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 1)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 2)));
        this.tape.add(new AbstractController.DequeueInstruction(this.vertexList));
        this.tape.add(new AbstractController.ActiveToRegisterInstruction(this.variableU));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 3)));
        this.tape.add(new AbstractController.SetColorInstruction(this.stylesheet.getInitVertexStyle()));
        this.tape.add(new AbstractController.SetVertexEnableInstruction());
        this.tape.add(new AbstractController.SetVertexToolTipsInstruction());
        this.tape.add(new AbstractDfsController.SetPathInstruction());
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 4)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.LabelInstruction(forLabel, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return !TopologicalSortController.this.vertexList.isEmpty();
            }
        }));
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(1, 1), this.algorithm.getRealLineNumber(1, 4), this.doneColor));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 5)));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Time initialization"));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(1, 5), this.algorithm.getRealLineNumber(1, 5), this.doneColor));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("time", true));
        this.tape.add(new AbstractController.AddAllVertexListInstruction(this.vertexList));
        AbstractController.LabelInstruction forLabel2 = new AbstractController.LabelInstruction();
        this.tape.add(forLabel2);
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 6)));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Call the DFS-VISIT method to\nall unvisited nodes"));
        this.tape.add(new SelectNextNodeInstruction());
        this.tape.add(new AbstractController.SetSelectedCellFirstInstruction(this.vertexList));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 7)));
        this.tape.add(new AbstractController.DequeueInstruction(this.vertexList));
        this.tape.add(new AbstractController.ActiveToRegisterInstruction(this.variableU));
        AbstractController.LabelInstruction ifEnd = new AbstractController.LabelInstruction();
        this.tape.add(new AbstractController.LabelInstruction(ifEnd, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return !((mxCell)TopologicalSortController.this.activeVariable).getStyle().equals(TopologicalSortController.this.stylesheet.getInitVertexStyle());
            }
        }));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 8)));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Calling the DFS-VISIT method"));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("Iterative list", false));
        this.tape.add(new AbstractDfsController.ContextInstruction(this.contextStack, ifEnd));
        AbstractController.LabelInstruction dfsVisitLabel = new AbstractController.LabelInstruction();
        this.tape.add(new AbstractController.LabelInstruction(dfsVisitLabel, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return true;
            }
        }));
        this.tape.add(ifEnd);
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("Iterative list", true));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 9)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 10)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.LabelInstruction(forLabel2, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return !TopologicalSortController.this.vertexList.isEmpty();
            }
        }));
        this.tape.add(new AbstractController.ClearQueueInstruction(this.vertexList));
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(2, 1), this.algorithm.getRealLineNumber(2, 11), this.doneColor));
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(1, 1), this.algorithm.getRealLineNumber(1, 10), this.doneColor));
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(0, 2), this.algorithm.getRealLineNumber(0, 2), this.doneColor));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(0, 3)));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Return the result as list L"));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(0, 3), this.algorithm.getRealLineNumber(0, 3), this.doneColor));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Topological-Sort algorithm is completed"));
        this.tape.add(new AbstractController.EndInstruction());
        this.tape.add(dfsVisitLabel);
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("v", false));
        this.tape.add(new AbstractController.RegisterToActiveInstruction(this.variableU));
        this.tape.add(new AbstractController.PushInstruction(this.visitStack));
        this.tape.add(new AbstractController.SetLabelTextInstruction("The Begining of DFS-VISIT"));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 0)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetLabelTextInstruction("The first visit of the node"));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 1)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetLabelTextInstruction("Time increment"));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 2)));
        this.tape.add(new AbstractController.SetColorInstruction(this.stylesheet.getFirstPassVertexStyle()));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetLabelTextInstruction("Set first time stamp"));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 3)));
        this.tape.add(new AbstractDfsController.ChangeTimeInstruction());
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractDfsController.SetTimeInstruction(true));
        this.tape.add(new AbstractController.MakeAdjListInstruction(this.vertexList, true));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 4)));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("Iterative list", true));
        AbstractController.LabelInstruction forEndLabel = new AbstractController.LabelInstruction();
        AbstractController.LabelInstruction forLabel3 = new AbstractController.LabelInstruction();
        this.tape.add(forLabel3);
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 4)));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Go through all nodes that are next to the one in progress"));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new SelectNextVisitedNodeInstruction());
        this.tape.add(new AbstractController.LabelInstruction(forEndLabel, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return TopologicalSortController.this.vertexList.isEmpty();
            }
        }));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("v", true));
        this.tape.add(new AbstractController.SetLabelTextInstruction("If a node has not been visited, adjust path\nand call DFS-visit for him"));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 5)));
        this.tape.add(new AbstractController.DequeueInstruction(this.vertexList));
        this.tape.add(new AbstractController.ActiveToRegisterInstruction(this.variableV));
        this.tape.add(new AbstractController.ColorEdgeActiveAndRegisterInstruction(this.variableU, this.stylesheet.getHighlighEdgeStyle(), true));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 6)));
        AbstractController.LabelInstruction ifEnd2 = new AbstractController.LabelInstruction();
        this.tape.add(new AbstractController.LabelInstruction(ifEnd2, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return !((mxCell)TopologicalSortController.this.activeVariable).getStyle().equals(TopologicalSortController.this.stylesheet.getInitVertexStyle());
            }
        }));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Setting of path"));
        this.tape.add(new AbstractController.ColorEdgeActiveAndRegisterInstruction(this.variableU, this.stylesheet.getPathEdgeStyle(), true));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetLabelTextInstruction("Call the DFS-VISIT method on neghboring nodes"));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 7)));
        this.tape.add(new AbstractDfsController.SetPathInstruction(this.variableU));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractDfsController.ContextInstruction(this.contextStack, ifEnd2));
        this.tape.add(new AbstractController.RegisterToActiveInstruction(this.variableV));
        this.tape.add(new AbstractController.ActiveToRegisterInstruction(this.variableU));
        this.tape.add(new AbstractController.LabelInstruction(dfsVisitLabel, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return true;
            }
        }));
        this.tape.add(ifEnd2);
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 8)));
        this.tape.add(new AbstractDfsController.SetDfsEdgeTypeInstruction(this.variableU, this.stylesheet.getPathEdgeStyle(), this.stylesheet.getEdgeStyle()));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 9)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.LabelInstruction(forLabel3, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return !TopologicalSortController.this.vertexList.isEmpty();
            }
        }));
        this.tape.add(forEndLabel);
        this.tape.add(new AbstractController.ClearQueueInstruction(this.vertexList));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("v", false));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("Iterative list", false));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 10)));
        this.tape.add(new AbstractController.RegisterToActiveInstruction(this.variableU));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Second visit of the node"));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 11)));
        this.tape.add(new AbstractController.SetColorInstruction("DONE_VERTEX_STYLE"));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Setting the second time stamp"));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractDfsController.ChangeTimeInstruction());
        this.tape.add(new AbstractDfsController.SetTimeInstruction(false));
        this.tape.add(new AbstractController.DequeueInstruction(this.visitStack));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(0, 2)));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Add node into the list L"));
        this.tape.add(new AddActiveNodeToListLInstruction());
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractDfsController.ContextInstruction(this.contextStack));
    }

    private void resetControllerImpl() {
        this.graphComponentLabel.setText("Topological-Sort algorithm");
        this.codePanel.setCurrentLine(1);
        this.variables.put("Seznam L", new VariableObject(){

            @Override
            public String getVariableValue() {
                return AbstractController.dequeToString(TopologicalSortController.this.listL);
            }
        });
        this.variables.put("Stack S", new VariableObject(){

            @Override
            public String getVariableValue() {
                return AbstractController.dequeToString(TopologicalSortController.this.visitStack);
            }
        });
        this.variables.put("u", new VariableObject(){

            @Override
            public String getVariableValue() {
                return TopologicalSortController.this.getNodeName(TopologicalSortController.this.getRegisterValue(TopologicalSortController.this.variableU));
            }
        });
        this.variables.put("v", new VariableObject(){

            @Override
            public String getVariableValue() {
                return TopologicalSortController.this.getNodeName(TopologicalSortController.this.getRegisterValue(TopologicalSortController.this.variableV));
            }
        });
        this.variables.put("time", new VariableObject(true, false){

            @Override
            public String getVariableValue() {
                return Integer.toString(TopologicalSortController.this.timeVariable);
            }
        });
        this.variables.put("Iterative list", new VariableObject(){

            @Override
            public String getVariableValue() {
                return AbstractController.dequeToString(TopologicalSortController.this.vertexList);
            }
        });
        for (Map.Entry e : this.variables.entrySet()) {
            if (!((VariableObject)e.getValue()).isEnabled()) continue;
            this.variablesPanel.addVariable((String)e.getKey());
        }
        this.contextStack.clear();
        this.vertexList.clear();
        this.listL.clear();
        this.visitStack.clear();
        this.timeVariable = 0;
        this.clearGraphComponent(this.graphComponentList);
        this.graphComponentList.getGraph().refresh();
    }

    @Override
    public void resetController() {
        super.resetController();
        this.resetControllerImpl();
    }

    protected final class AddActiveNodeToListLEdit
    extends AbstractController.AlgorithmUndoableEdit {
        private final int VERTEX_X = 10;
        private final int VERTEX_Y = 60;
        private final int VERTEX_WIDTH = 80;
        private final int VERTEX_HEIGHT = 60;
        private final int VERTEX_MOVE = 120;
        private final int MAX_LEVEL = 4;
        private final int EDGE_LEVEL_STEP = 12;
        protected mxCell inserted;
        protected mxCell newLGraphVertex;

        public AddActiveNodeToListLEdit(mxCell active) {
            this.inserted = active;
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            TopologicalSortController.this.listL.remove(this.newLGraphVertex);
            AlgorithmGraph listGraph = TopologicalSortController.this.graphComponentList.getGraph();
            for (Object edge : listGraph.getEdges(this.newLGraphVertex)) {
                listGraph.getModel().remove(edge);
            }
            listGraph.getModel().remove(this.newLGraphVertex);
            listGraph.moveCells(listGraph.getChildCells(listGraph.getDefaultParent()), -120.0, 0.0);
            this.arrangeEdges(listGraph);
            listGraph.refresh();
        }

        protected void insertAllEdges(AlgorithmGraph listGraph, List<List<mxCell>> levelsMap) {
            int maxLevel;
            int minLevel = 1;
            for (int i = 1; i < levelsMap.size(); ++i) {
                if (levelsMap.get(i).size() <= 0) continue;
                minLevel = i;
                break;
            }
            if ((maxLevel = levelsMap.size() - minLevel + 1) > 4) {
                maxLevel = 4;
            }
            for (int i = 1; i < levelsMap.size(); ++i) {
                int r = 0;
                for (mxCell edge : levelsMap.get(i)) {
                    r += 10 / levelsMap.get(i).size();
                    mxCell source = (mxCell)edge.getSource();
                    mxCell target = (mxCell)edge.getTarget();
                    Point p1 = listGraph.getModel().getGeometry(source).getPoint();
                    Point p2 = listGraph.getModel().getGeometry(target).getPoint();
                    int level = i - minLevel + 1;
                    mxGeometry geometryOfEdge = listGraph.getModel().getGeometry(edge);
                    geometryOfEdge = (mxGeometry)geometryOfEdge.clone();
                    ArrayList<mxPoint> pointsOfTheEdge = new ArrayList<mxPoint>();
                    if (level > 4) {
                        listGraph.setConnectionConstraint(edge, source, true, new mxConnectionConstraint(new mxPoint(1.0 - (double)(level -= 4) / (double)maxLevel, 1.0), true));
                        listGraph.setConnectionConstraint(edge, target, false, new mxConnectionConstraint(new mxPoint((double)level / (double)maxLevel, 1.0), true));
                        pointsOfTheEdge.add(new mxPoint((double)p1.x + 80.0 * (1.0 - (double)level / (double)maxLevel), p1.y + 60 + 12 * level + r));
                        pointsOfTheEdge.add(new mxPoint((double)p2.x + 80.0 * ((double)level / (double)maxLevel), p2.y + 60 + 12 * level + r));
                    } else {
                        listGraph.setConnectionConstraint(edge, source, true, new mxConnectionConstraint(new mxPoint(1.0 - (double)(--level) / (double)maxLevel, 0.0), true));
                        listGraph.setConnectionConstraint(edge, target, false, new mxConnectionConstraint(new mxPoint((double)level / (double)maxLevel, 0.0), true));
                        pointsOfTheEdge.add(new mxPoint((double)p1.x + 80.0 * (1.0 - (double)level / (double)maxLevel), p1.y - 12 * (level + 1) - r));
                        pointsOfTheEdge.add(new mxPoint((double)p2.x + 80.0 * ((double)level / (double)maxLevel), p2.y - 12 * (level + 1) - r));
                    }
                    geometryOfEdge.setPoints(pointsOfTheEdge);
                    listGraph.getModel().setGeometry(edge, geometryOfEdge);
                }
            }
        }

        protected void arrangeEdges(AlgorithmGraph listGraph) {
            for (mxCell vertex : TopologicalSortController.this.listL) {
                listGraph.moveCells(listGraph.getChildCells(listGraph.getDefaultParent()), 120.0, 0.0);
                mxGeometry cellGeo = listGraph.getModel().getGeometry(vertex);
                cellGeo = (mxGeometry)cellGeo.clone();
                cellGeo.setX(10.0);
                cellGeo.setY(60.0);
                listGraph.getModel().setGeometry(vertex, cellGeo);
            }
            ArrayList<List<mxCell>> levelsMap = new ArrayList<List<mxCell>>();
            for (Object o : listGraph.getChildEdges(listGraph.getDefaultParent())) {
                mxCell edge = (mxCell)o;
                Point p1 = listGraph.getModel().getGeometry(edge.getSource()).getPoint();
                Point p2 = listGraph.getModel().getGeometry(edge.getTarget()).getPoint();
                int level = p1.x > p2.x ? (p1.x - p2.x) / 120 : (p2.x - p1.x) / 120;
                for (int f = levelsMap.size(); f < level; ++f) {
                    levelsMap.add(f, new ArrayList());
                }
                ((List)levelsMap.get(level - 1)).add(edge);
                listGraph.resetEdge(edge);
            }
            this.insertAllEdges(listGraph, levelsMap);
        }

        protected void insertNewEdges(AlgorithmGraph listGraph, mxCell active) {
            for (int i = 0; i < TopologicalSortController.this.graph.getModel().getEdgeCount(active); ++i) {
                mxCell edge = (mxCell)TopologicalSortController.this.graph.getModel().getEdgeAt(active, i);
                GraphCell source = (GraphCell)edge.getSource().getValue();
                GraphCell target = (GraphCell)edge.getTarget().getValue();
                mxCell sourceIn = null;
                mxCell targetIn = null;
                for (mxCell cellInList : TopologicalSortController.this.listL) {
                    if (sourceIn == null && ((GraphCell)cellInList.getValue()).getName().equals(source.getName())) {
                        sourceIn = cellInList;
                        continue;
                    }
                    if (targetIn != null || !((GraphCell)cellInList.getValue()).getName().equals(target.getName())) continue;
                    targetIn = cellInList;
                }
                if (sourceIn == null || targetIn == null) continue;
                listGraph.insertEdge(listGraph.getDefaultParent(), null, null, sourceIn, targetIn, edge.getStyle());
            }
        }

        @Override
        protected void action() {
            AlgorithmGraph listGraph = TopologicalSortController.this.graphComponentList.getGraph();
            listGraph.moveCells(listGraph.getChildCells(listGraph.getDefaultParent()), 120.0, 0.0);
            this.newLGraphVertex = (mxCell)listGraph.insertVertex(listGraph.getDefaultParent(), null, (DfsGraphVertex)this.inserted.getValue(), 10.0, 60.0, 80.0, 60.0, TopologicalSortController.this.stylesheet.getMiniVertexStyle());
            TopologicalSortController.this.listL.addLast(this.newLGraphVertex);
            this.insertNewEdges(listGraph, this.inserted);
            this.arrangeEdges(listGraph);
            listGraph.refresh();
        }
    }

    protected class AddActiveNodeToListLInstruction
    extends AbstractController.BasicInstruction {
        protected AddActiveNodeToListLInstruction() {
        }

        @Override
        public void preform() {
            TopologicalSortController.this.editBlock.addEdit(new AddActiveNodeToListLEdit((mxCell)TopologicalSortController.this.activeVariable));
        }
    }

    protected class SelectNextNodeInstruction
    extends AbstractController.InteractiveInstruction {
        protected SelectCellsMouseAdapter adapter;

        public SelectNextNodeInstruction() {
            this.adapter = new SelectCellsMouseAdapter(1, TopologicalSortController.this.graphComponent, TopologicalSortController.this.graph);
            this.adapter.setActivated(false);
            TopologicalSortController.this.graphComponent.getGraphControl().addMouseListener(this.adapter);
        }

        @Override
        public void preform() {
            if (!this.adapter.isActivated()) {
                TopologicalSortController.this.graph.traverseAllCells(new AlgorithmGraph.AlgorithmGraphCellVisitor(){

                    @Override
                    public boolean visit(mxCell vertex, GraphCell value) {
                        if (vertex.getStyle().equals(TopologicalSortController.this.stylesheet.getInitVertexStyle())) {
                            TopologicalSortController.this.graphComponentLabel.setText(TopologicalSortController.this.getTextForLabel("Select a node which has not been visited and click continue\n[u\u017eivatelsk\u00e1 akce]"));
                            TopologicalSortController.this.timer.setEnabled(false);
                            SelectNextNodeInstruction.this.adapter.setActivated(true);
                            return false;
                        }
                        return true;
                    }

                    @Override
                    public boolean allowEdge() {
                        return false;
                    }
                });
            } else if (this.adapter.getLastSelected() != null) {
                TopologicalSortController.this.graph.traverseAllCells(new AlgorithmGraph.AlgorithmGraphCellVisitor(){

                    @Override
                    public boolean visit(mxCell vertex, GraphCell node) {
                        if (vertex == SelectNextNodeInstruction.this.adapter.getLastSelected()) {
                            node.setSelected(true);
                        } else {
                            node.setSelected(false);
                        }
                        return true;
                    }

                    @Override
                    public boolean allowEdge() {
                        return false;
                    }
                });
                this.stop();
                return;
            }
            TopologicalSortController.this.pause = true;
        }

        @Override
        public int nextTapePos() {
            if (this.adapter.isActivated()) {
                return TopologicalSortController.this.tapePosition;
            }
            return super.nextTapePos();
        }

        @Override
        public void stop() {
            if (this.adapter.isActivated()) {
                this.adapter.setActivated(false);
                this.adapter.resetStyles();
                this.adapter.reset();
                TopologicalSortController.this.timer.setEnabled(true);
            }
        }
    }

    protected class SelectNextVisitedNodeInstruction
    extends AbstractController.InteractiveInstruction {
        protected SelectCellsMouseAdapter adapter;
        protected mxCell lastClosed = null;
        protected Set<mxCell> canBeVisitedSet = new HashSet<mxCell>();

        public SelectNextVisitedNodeInstruction() {
            this.adapter = new SelectCellsMouseAdapter(1, TopologicalSortController.this.graphComponent, TopologicalSortController.this.graph);
            this.adapter.setActivated(false);
            TopologicalSortController.this.graphComponent.getGraphControl().addMouseListener(this.adapter);
        }

        @Override
        public void preform() {
            if (!this.adapter.isActivated()) {
                if (this.lastClosed == TopologicalSortController.this.getRegisterValue(TopologicalSortController.this.variableU)) {
                    return;
                }
                this.canBeVisitedSet.clear();
                for (int i = 0; i < TopologicalSortController.this.graph.getModel().getEdgeCount(TopologicalSortController.this.getRegisterValue(TopologicalSortController.this.variableU)); ++i) {
                    mxCell edge = (mxCell)TopologicalSortController.this.graph.getModel().getEdgeAt(TopologicalSortController.this.getRegisterValue(TopologicalSortController.this.variableU), i);
                    mxCell source = (mxCell)edge.getSource();
                    mxCell target = (mxCell)edge.getTarget();
                    DfsGraphVertex value = (DfsGraphVertex)target.getValue();
                    if (source != TopologicalSortController.this.getRegisterValue(TopologicalSortController.this.variableU) || value.getFirstTimestamp() != null) continue;
                    this.canBeVisitedSet.add(target);
                }
                TopologicalSortController.this.graphComponentLabel.setText(TopologicalSortController.this.getTextForLabel("Select a next node to be visited and continue\n[u\u017eivatelsk\u00e1 akce]"));
                TopologicalSortController.this.timer.setEnabled(false);
                this.adapter.setActivated(true);
            } else if (this.adapter.getLastSelected() != null) {
                mxCell selected = this.adapter.getLastSelected();
                if (this.canBeVisitedSet.isEmpty() && selected == TopologicalSortController.this.getRegisterValue(TopologicalSortController.this.variableU) || this.canBeVisitedSet.contains(selected)) {
                    if (!this.canBeVisitedSet.contains(selected)) {
                        this.lastClosed = selected;
                    }
                    if (!TopologicalSortController.this.vertexList.isEmpty() && TopologicalSortController.this.vertexList.contains(selected)) {
                        TopologicalSortController.this.vertexList.remove(selected);
                        TopologicalSortController.this.vertexList.addFirst(selected);
                    }
                    this.stop();
                    return;
                }
            }
            TopologicalSortController.this.pause = true;
        }

        @Override
        public void stop() {
            if (this.adapter.isActivated()) {
                this.adapter.setActivated(false);
                this.adapter.resetStyles();
                this.adapter.reset();
                TopologicalSortController.this.timer.setEnabled(true);
            }
        }

        @Override
        public int nextTapePos() {
            if (this.adapter.isActivated()) {
                return TopologicalSortController.this.tapePosition;
            }
            return super.nextTapePos();
        }
    }
}

