/*
 * Decompiled with CFR 0.152.
 */
package simulator.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public class LineHighlighter
implements Highlighter.HighlightPainter {
    protected int actualLine = 0;
    protected Color actualLineHighlightColor;
    protected Map<Integer, Color> highlighedLines = new HashMap<Integer, Color>();
    protected Map<Integer, Color> highlighedStartOfLines = new HashMap<Integer, Color>();
    protected boolean resetCarretsetting = true;

    public LineHighlighter(Color col) {
        this.actualLineHighlightColor = col;
    }

    protected void paintBeginHighlight(Graphics g, JTextComponent c, Element line) throws BadLocationException {
        TextUI mapper = c.getUI();
        Rectangle r0 = mapper.modelToView(c, line.getStartOffset());
        Rectangle r1 = mapper.modelToView(c, line.getEndOffset());
        g.fillRect(0, r0.y, 10, r1.y - r0.y);
    }

    protected void paintWholeHighlight(Graphics g, JTextComponent c, Element line) throws BadLocationException {
        TextUI mapper = c.getUI();
        Rectangle r0 = mapper.modelToView(c, line.getStartOffset());
        Rectangle r1 = mapper.modelToView(c, line.getEndOffset());
        g.fillRect(0, r0.y, c.getWidth(), r1.y - r0.y);
    }

    @Override
    public void paint(Graphics g, int p0, int p1, Shape bounds, JTextComponent c) {
        try {
            Element root = c.getDocument().getDefaultRootElement();
            int rowStartOffset = root.getStartOffset();
            int endOffset = root.getEndOffset();
            while (rowStartOffset <= endOffset) {
                Element line = root.getElement(root.getElementIndex(rowStartOffset));
                Object lineNumO = line.getAttributes().getAttribute("line");
                if (lineNumO != null) {
                    int lineNum = (Integer)lineNumO;
                    if (lineNum == this.actualLine && this.actualLineHighlightColor != null) {
                        g.setColor(this.actualLineHighlightColor);
                        this.paintWholeHighlight(g, c, line);
                    }
                    if (this.highlighedStartOfLines.containsKey(lineNum)) {
                        g.setColor(this.highlighedStartOfLines.get(lineNum));
                        this.paintBeginHighlight(g, c, line);
                    } else if (this.highlighedLines.containsKey(lineNum)) {
                        g.setColor(this.highlighedLines.get(lineNum));
                        this.paintWholeHighlight(g, c, line);
                    }
                }
                rowStartOffset = line.getEndOffset() + 1;
            }
        }
        catch (BadLocationException ex) {
            Logger.getLogger(LineHighlighter.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void clearAllHighlight() {
        this.highlighedLines.clear();
    }

    public void highlightLine(int lineNum, Color color) {
        this.highlighedLines.put(lineNum, color);
    }

    public void clearAllhighlightStart() {
        this.highlighedStartOfLines.clear();
    }

    public Map<Integer, Color> getAllhighlightStart() {
        HashMap<Integer, Color> ret = new HashMap<Integer, Color>();
        ret.putAll(this.highlighedStartOfLines);
        return ret;
    }

    public void highlightLineStart(int lineNum, Color color) {
        this.highlighedStartOfLines.put(lineNum, color);
    }

    public void setActualLineHighlightColor(Color actualLineHighlightColor) {
        this.actualLineHighlightColor = actualLineHighlightColor;
    }

    public Color getActualLineHighlightColor() {
        return this.actualLineHighlightColor;
    }

    public int getActualLine() {
        return this.actualLine;
    }

    public void setActualLine(int actualLine) {
        this.resetCarretsetting = true;
        this.actualLine = actualLine;
    }
}

