/*
 * Decompiled with CFR 0.152.
 */
package simulator.gui.panels;

import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGraphModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Serializable;
import simulator.algorithms.AlgorithmDijkstra;
import simulator.controllers.DijkstraController;
import simulator.graphs.AlgorithmGraph;
import simulator.graphs.GraphEdgeBasicData;
import simulator.graphs.GraphVertexBasicData;
import simulator.graphs.bellmanford.BellmanFordGraphEdge;
import simulator.graphs.bellmanford.BellmanFordGraphVertex;
import simulator.gui.AbstractSimulatorPanel;
import simulator.gui.panels.AbstractAlgorithmPanel;

public class DijkstraPanel
extends AbstractAlgorithmPanel {
    protected AbstractSimulatorPanel simulatorPanel;

    public DijkstraPanel(AlgorithmGraph graph) {
        this.makeDijkstraGraph(graph);
        graph.setOriented(true);
        if (!graph.getAlgorithmStylesheet().isDirectedEgeStyle()) {
            graph.getAlgorithmStylesheet().setDirected(true);
        }
        graph.refresh();
        this.setLayout(new BorderLayout());
        this.simulatorPanel = new AbstractSimulatorPanel(graph, new AlgorithmDijkstra());
        this.simulatorPanel.getGraphPanel().add((Component)this.simulatorPanel.getGraphComponent(), "Center");
        DijkstraController controller = new DijkstraController(this.simulatorPanel.getGraphComponent(), this.simulatorPanel.getLabel(), this.simulatorPanel.getCodePanel(), this.simulatorPanel.getVariablesPanel());
        this.simulatorPanel.setController(controller);
        this.add((Component)this.simulatorPanel, "Center");
    }

    @Override
    public void stop() {
        this.simulatorPanel.getVariablesPanel().dockTables();
        this.simulatorPanel.getController().setTimerStart(false);
    }

    private void makeDijkstraGraph(AlgorithmGraph graph) {
        for (Object o : mxGraphModel.getChildren(graph.getModel(), graph.getDefaultParent())) {
            Serializable data;
            if (!(o instanceof mxCell)) continue;
            mxCell cell = (mxCell)o;
            if (cell.isVertex()) {
                if (cell.getValue() == null || !(cell.getValue() instanceof GraphVertexBasicData)) {
                    throw new IllegalArgumentException();
                }
                if (!(cell.getValue() instanceof BellmanFordGraphVertex)) {
                    data = (GraphVertexBasicData)cell.getValue();
                    cell.setValue(new BellmanFordGraphVertex(data.getName(), data.isSelected()));
                }
                cell.setStyle(graph.getAlgorithmStylesheet().getVertexStyle());
                continue;
            }
            if (cell.getValue() == null || !(cell.getValue() instanceof GraphEdgeBasicData)) {
                throw new IllegalArgumentException();
            }
            if (!(cell.getValue() instanceof BellmanFordGraphEdge)) {
                data = (GraphEdgeBasicData)cell.getValue();
                cell.setValue(new BellmanFordGraphEdge(data.getDistance()));
            }
            cell.setStyle(graph.getAlgorithmStylesheet().getEdgeStyle());
        }
    }
}

