/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.logging.log4j.core.appender.AbstractManager;
import org.apache.logging.log4j.core.appender.AppenderRuntimeException;
import org.apache.logging.log4j.core.appender.ManagerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputStreamManager
extends AbstractManager {
    private OutputStream os;
    private byte[] footer = null;

    protected OutputStreamManager(OutputStream os, String streamName) {
        super(streamName);
        this.os = os;
    }

    public static <T> OutputStreamManager getManager(String name, T data, ManagerFactory<? extends OutputStreamManager, T> factory) {
        return AbstractManager.getManager(name, factory, data);
    }

    public synchronized void setHeader(byte[] header) {
        if (header != null) {
            try {
                this.os.write(header, 0, header.length);
            }
            catch (IOException ioe) {
                LOGGER.error("Unable to write header", (Throwable)ioe);
            }
        }
    }

    public synchronized void setFooter(byte[] footer) {
        if (footer != null) {
            this.footer = footer;
        }
    }

    @Override
    public void releaseSub() {
        if (this.footer != null) {
            this.write(this.footer);
        }
        this.close();
    }

    public boolean isOpen() {
        return this.getCount() > 0;
    }

    protected OutputStream getOutputStream() {
        return this.os;
    }

    protected void setOutputStream(OutputStream os) {
        this.os = os;
    }

    protected synchronized void write(byte[] bytes, int offset, int length) {
        try {
            this.os.write(bytes, offset, length);
        }
        catch (IOException ex) {
            String msg = "Error writing to stream " + this.getName();
            throw new AppenderRuntimeException(msg, ex);
        }
    }

    protected void write(byte[] bytes) {
        this.write(bytes, 0, bytes.length);
    }

    protected void close() {
        if (this.os == System.out || this.os == System.err) {
            return;
        }
        try {
            this.os.close();
        }
        catch (IOException ex) {
            LOGGER.error("Unable to close stream " + this.getName() + ". " + ex);
        }
    }

    public void flush() {
        try {
            this.os.flush();
        }
        catch (IOException ex) {
            String msg = "Error flushing stream " + this.getName();
            throw new AppenderRuntimeException(msg, ex);
        }
    }
}

