/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.impl.ThrowableProxy;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.ThrowablePatternConverter;

@Plugin(name="ExtendedThrowablePatternConverter", type="Converter")
@ConverterKeys(value={"xEx", "xThrowable", "xException"})
public final class ExtendedThrowablePatternConverter
extends ThrowablePatternConverter {
    private static final String FILTERS = "filters(";
    private final List<String> packages;

    private ExtendedThrowablePatternConverter(String[] options) {
        super("ExtendedThrowable", "throwable", options);
        String filterStr;
        String[] array;
        ArrayList<String> tempPackages = null;
        if (options != null && options.length > 1 && options[1].startsWith(FILTERS) && options[1].endsWith(")") && (array = (filterStr = options[1].substring(FILTERS.length(), options[1].length() - 1)).split(",")).length > 0) {
            tempPackages = new ArrayList<String>(array.length);
            for (String token : array) {
                tempPackages.add(token.trim());
            }
        }
        this.packages = tempPackages;
    }

    public static ExtendedThrowablePatternConverter newInstance(String[] options) {
        String type = null;
        String[] array = options;
        if (options != null && options.length == 1 && options[0].length() > 0) {
            String filter;
            String[] opts = options[0].split(",", 2);
            String first = opts[0].trim();
            Scanner scanner = new Scanner(first);
            if (first.equalsIgnoreCase("full") || first.equalsIgnoreCase("short") || scanner.hasNextInt()) {
                type = first;
                filter = opts[1].trim();
            } else {
                filter = options[0].trim();
            }
            array = new String[]{type, filter};
        }
        return new ExtendedThrowablePatternConverter(array);
    }

    public void format(LogEvent event, StringBuilder toAppendTo) {
        Throwable throwable = event.getThrown();
        if (throwable != null && this.lines > 0) {
            if (!(throwable instanceof ThrowableProxy)) {
                super.format(event, toAppendTo);
                return;
            }
            ThrowableProxy t = (ThrowableProxy)throwable;
            String trace = t.getExtendedStackTrace(this.packages);
            int len = toAppendTo.length();
            if (len > 0 && !Character.isWhitespace(toAppendTo.charAt(len - 1))) {
                toAppendTo.append(" ");
            }
            if (this.lines != Integer.MAX_VALUE) {
                StringBuilder sb = new StringBuilder();
                String[] array = trace.split("\n");
                int limit = this.lines > array.length ? array.length : this.lines;
                for (int i = 0; i < limit; ++i) {
                    sb.append(array[i]).append("\n");
                }
                toAppendTo.append(sb.toString());
            } else {
                toAppendTo.append(trace);
            }
        }
    }
}

