# script for Gnuplot
# FILE variable set externally

set term pdf; set output FILE

TITLE="Damped oscillator, RK4 step=`cat rk4-test.dat|sed -n '2s/^ *\([0-9.]*\).*$/\1/p'|sed 's/00*$//'`"
set multiplot layout 2, 1 title TITLE font ",14"

set xtics font ",8"
set ytics font ",8"

set style data lines
set nokey
set grid

#set xlabel "t"
set ylabel "y"
plot [][-1.1:1.1] "rk4-test.dat", 10/(3*sqrt(11))*exp(-0.1 * x) lt 5

set xlabel "t"
set ylabel "error_{abs}"
plot "rk4-test.dat" using 1:4

unset multiplot
