// Ukzkov pklad znzorujc vyuit vizualizanho systmu spolu
// s knihovnou SimLib
//
// Kostra pkladu pevzata z ukzkovch pklad dodvanch ke knihovn
// SimLib
//
// Pklad zobrazuje skkajc mky
//

#include <iostream>
#include <string>
#include "visualisation.h"

#include "simlib.h"            // simulan jdro


Socket* c;

const int MaxBang = 15;         // maximln poet odraz

// popis modelu:
//Problem!!! Constant g = 9.81;              // gravitan zrychlen
Constant g(9.81);               // gravitan zrychlen

struct Ball {                   // popis modelu mku
  Integrator v,y;               // stav mku
  unsigned count;               // poet odraz
  Ball(double initialposition) :
    ylim(this),                 // podmnka dopadu
    v(-g - v*0.1),              // popis volnho pdu:
    y(v, initialposition),
    count(0) {}

  void Bang()  {                // stavov udlost - odraz mku
    Out();                      // tisk stavu pi dopadu
    Print("\n# Odraz %u\n", ++count);
    v = -0.9 * v.Value();       // ztrta energie
    y = 0;                      // toto je nutn z hlediska pesnosti!
    if(count>=MaxBang)          // maximln poet odraz
      Stop();                   //   konec simulace
    Out();                      // tisk novho stavu
  }
  void Out() {
    Print("%g  %g  %g\n", T.Value(), y.Value(), v.Value());
  }
  // detektor stavovch udlost:
  class LimitY : ConditionDown {
    Ball *b;
    void Action() { b->Bang(); }  // stavov udlost: posln zprvy
   public:
    LimitY(Ball *ball) :
      ConditionDown(ball->y),     // podmnka: (y>=0)  TRUE --> FALSE
      b(ball) {}
  } ylim;
};

DNode* ball1pos;
DNode* ball2pos;
DNode* ball3pos;
DNode* ball4pos;

// vytvoen modelu mk
Ball b1(20.0);
Ball b2(18.0);
Ball b3(16.0);
Ball b4(14.0);


void Sample() {          // vzorkovn stavu mku
  b1.Out();
  // uvedomme vizualizan server o nov pozici mku v aktulnm simulanm ase
  ball1pos->moveABS( 0.0 , b1.y.Value() * 15 ,0.0, T.Value());
  ball2pos->moveABS( 0.0 , b2.y.Value() * 15,0.0, T.Value());
  ball3pos->moveABS( 0.0 , b3.y.Value() * 15 ,0.0, T.Value());
  ball4pos->moveABS( 0.0 , b4.y.Value() * 15,0.0, T.Value());
}

Sampler S(Sample, 0.01);





int main(int argc,char** argv)
{

//vytvoreni spojeni s serverem
  VClient::init(argc,argv);

  point* v = new point[4](0,-10,0);

//vytvoreni souradneho systemu
  DNode dpos1("DP1",NULL);
  DNode dpos2("DP2",NULL);
  DNode dpos3("DP3",NULL);
  DNode dpos4("DP4",NULL);
  DNode dposZ("DPZ",NULL);

//nastaveni souradnic zakladove plochy
  v[0].x = -200;
  v[0].z = 200;
  v[1].x = -200;
  v[1].z = -200;
  v[2].x = 200;
  v[2].z = -200;
  v[3].x = 200;
  v[3].z = 200;


//vytvoreni zakladove desky
  Polygon pl2("PL","DPZ",4,v);
  pl2.setColor(1,1,0);
  pl2.setDrawType(1);


  ball1pos = new DNode("d1","DP1");
  ball2pos = new DNode("d2","DP2");
  ball3pos = new DNode("d3","DP3");
  ball4pos = new DNode("d4","DP4");


//vytvoreni micku
  Sphere b1("b1","d1");
  Sphere b2("b2","d2");
  Sphere b3("b3","d3");
  Sphere b4("b4","d4");

//nastaveni barvy
  b1.setColor(1.0,0.0,0.0);
  b2.setColor(0.0,0.0,1.0);
  b3.setColor(0.0,1.0,0.0);
  b4.setColor(0.0,1.0,1.0);
//nastaveni polomeru
  b1.setRadius(15);
  b2.setRadius(16);
  b3.setRadius(17);
  b4.setRadius(18);
  
  
  b1.setDrawType(0);
  b2.setDrawType(0);
  b3.setDrawType(0);
  b4.setDrawType(0);

//posunuti micku
  dpos1.move(-60,0,0,0);
  dpos2.move(-20,0,0,0);
  dpos3.move(20,0,0,0);
  dpos4.move(60,0,0,0);





    SetOutput("example1.data");
    _Print("# Vizualizovany model skakajiciho micku\n");
    Print("# Time y v \n");
    Init(0);                      // od asu 0
    SetStep(1e-10, 0.5);
    SetAccuracy(1e-5, 0.001);
    Run();                        // simulace



   //uklid objektu
    delete ball1pos;
    delete ball2pos;
    delete ball3pos;
    delete ball4pos;

    delete[] v;

    //ukonceni prace klienta
    VClient::finish();



}

