
// Uk�kov p�lad zn�oruj��vyuit�vizualiza��o syst�u spolu
// s knihovnou SimLib

// Kostra p�ladu pevzata z uk�kovch p�lad dod�anch ke knihovn�// SimLib
//
// P�lad zobrazuje sk�aj��m�ky
//

#include <iostream>
#include <string>
#include <math.h>
#include "visualisation.h"

#include "simlib.h"            // simula��j�ro




const int G = 8100; //modul prunosti pro legovanou ocel
const int d = 3; //prm� ty�
const int l = 100; //delka tyce
const double Pi = 3.14159;
const double m = 0.5; //hmotnost kyvadla
const double delta = 2;

const double start_angle = 90.0; //pocatecni uhel natoceni kyvadla


class TorzniKyvadlo
{
public:
  Integrator y1,y;

  TorzniKyvadlo():y1(-delta*y1+(-G*Pi*pow(d,4.0) / 32*l*0.5*m*pow(d/2.0,2.0) )*y,0 ), y(y1,start_angle) {};
  //TK() : y1( 5*y,0 ),y(y1,0) {};
  double Y() {return y.Value();};
};

TorzniKyvadlo TK;


DNode *drot;

// vytvoen�modelu m�k

void Sample() {          // vzorkov��stavu m�ku
static double ang = start_angle;

  Print("%g  %g\n", T.Value(), TK.Y());
  // uvedom�e vizualiza��server o nov�pozici kyvadla v aktu�n� simula�� �se
  drot->rotate(TK.Y() - ang,0,1,0,T.Value());
  ang = TK.Y();
}

Sampler S(Sample, 0.01);





int main(int argc,char** argv)
{

  VClient::init(argc,argv);


  //modelovani sceny

  point* v = new point[3](0,0,40);
  v[0].x = 30;
  v[0].y = -30;
  v[2].x = -30;
  v[2].y = -30;

  v[1].x = 0;
  v[1].y = 45;



  DNode dpos1("DP1",NULL);
  drot = new DNode("DR1","DP1");



  DNode drot2("DR2","DR1");
  DNode dpos2("DP2","DR2");
  DNode dposC1("DPC1","DR2");

  Polygon PL("L","DR2",3,v);
  PL.setColor(0.0,0,1);



  drot2.rotate(-90,1,0,0);

  Cylinder C("CL","DR2",80,80,30);

  dposC1.move(0,0,30);
  Cylinder C1("CL1","DPC1",80,6,0);
  Cylinder C12("CL12","DR2",80,6,0);

  Cylinder C2("C2","DR2",6,6,200);
  //C.setColor(0.5,0.5,0.5);
  C1.setColor(0.5,0.5,0.5);
  C12.setColor(0.5,0.5,0.5);
  //C2.setColor(0.5,0.5,0.5);
/*
  C.setDrawType(0);
  C1.setDrawType(0);
  C12.setDrawType(0);
  C2.setDrawType(0);
*/
  //nastaveni kyvadla na pocatecni uhel
  drot->rotate(start_angle,0,1,0,0);





    SetOutput("example2.data");
    _Print("# Vizualizovany model torzniho kyvadla\n");
    Print("# Cas   uhel \n");
    Init(0,5);                      // od �su 0 do casu 5
    SetStep(1e-10, 0.01);
    SetAccuracy(1e-5, 0.001);
    Run();                        // simulace



  VClient::finish();


}

