//
// Ukzkov pklad znzorujc vyuit vizualizanho systmu spolu
// s knihovnou SimLib
//
// Pklad zobrazuje sit polygonu vytvarejici 3D graf linearni a harmonicke funkce
//

#include <iostream>
#include <string>
#include <math.h>
#include "visualisation.h"

#include "simlib.h"            // simulan jdro




int main(int argc,char** argv)
{

  int i,j,k,t;
  int m=50,n=50;
  float jp,ip;
//navazani spojeni se serverem
  VClient::init(argc,argv);


  string name,tmp;

  //modelovani sceny

  point **v;
  tColor **c;

 //vytvoreni site bodu (m+1)*(n+1)
  v = new point*[m+1];
  for (i=0;i<m+1;i++)
    v[i] = new point[n+1];

  //vytvoreni site barev polygonu (m*n)
  c = new tColor*[m];
  for (i=0;i<m;i++)
    c[i] = new tColor[n];


  DNode dpos1("DP1",NULL);
  DNode drot("DR1","DP1");


  PolygonMatrix pm("PM","DP1",m,n,400,400);

  pm.setDrawType(0);


  k = 400 / n;

//pocatecni nastaveni souradnic a barev site polygonu

  for (i=0;i<m+1;i++)
    for(j=0;j<n+1;j++)
    {
      v[i][j].x = i * k - (m/2.0 * k);
      v[i][j].z = j * k - (n/2.0 * k) + n/2;

      ip = (i - m/2)*k;
      jp = (j - n/2)*k;

      v[i][j].y =(1-(sqrt(ip*ip + jp*jp)/280.0)) * (100.0 * cos ( ((sqrt(ip*ip + jp*jp)) / 150.0) ));
    }

  //nastaveni barev polygonu
  for (i=0;i<m;i++)
    for(j=0;j<m;j++)
    {
      c[i][j].color[0] = (( v[i][j].y + 100.0)/200.0);
      c[i][j].color[1] = (( v[i][j].y + 100.0)/200.0);
      c[i][j].color[2] = (( v[i][j].y + 100.0)/200.0);
      c[i][j].color[3] = 1.0;

    }

  pm.setMVCoord(v,0);
  pm.setMVColor(c,0);


//zmena grafu v case, meni se pouze y-ova souradnice polygonu
//for (t=0;t<500;t+=5)
for (t=0;t<500;t+=5)
{
  for (i=0;i<m+1;i++)
    for(j=0;j<n+1;j++)
    {
      ip = (i - m/2)*k;
      jp = (j - n/2)*k;

      v[i][j].y =(1-(sqrt(ip*ip + jp*jp)/220.0)) * (120.0 * sin ( ((sqrt(ip*ip + jp*jp)) / 40.0)+(t/50.0) ));
    }

  for (i=0;i<m;i++)
    for(j=0;j<m;j++)
    {
      c[i][j].color[0] = (( v[i][j].y + 100.0)/200.0);
      c[i][j].color[1] = (( v[i][j].y + 100.0)/200.0);
      c[i][j].color[2] = (( v[i][j].y + 100.0)/200.0);
      c[i][j].color[3] = 1.0;

    }

   pm.setMVCoord(v,t);
   pm.setMVColor(c,t);
}

//ukonceni spojeni
  VClient::finish();



}

