
// Ukzkov pklad znzorujc vyuit vizualizanho systmu spolu
// s knihovnou SimLib

// Kostra pkladu pevzata z ukzkovch pklad dodvanch ke knihovn
// SimLib
//
// Pklad zobrazuje sit polygonu vytvarejici nejaky obecny 3D graf
//

#include <iostream>
#include <string>
#include <math.h>
#include "visualisation.h"

#include "simlib.h"            // simulan jdro


Socket* c;




int main(int argc,char** argv)
{

  int i,j,k,t;
  int m=20,n=20;
  float jp,ip;
  Polygon *p[m][n][2];


  if (argc > 3)
  //zapis do souboru
    c = new Socket(argv[3],TO_FILE);
  else
    c = new Socket();

  if (c->Connect(argv[1],atoi(argv[2])) != 0)
  {
    cerr << "Nepodarilo se navazat spojeni" << endl;
    return -1;
  }
  char s[30];
  string name,tmp;


  //modelovani sceny



  point* v[m][n];
  point vt[4];



  DNode dpos1(c,"DP1",NULL);
  DNode drot(c,"DR1","DP1");


  k = 200 / n;

  //vytvoreni site bodu
  for (i=0;i<m;i++)
    for(j=0;j<n;j++)
    {
      v[i][j] = new point(0,0,0);
      v[i][j]->x = i * k - (m/2 * k);
      v[i][j]->z = j * k - (n/2 * k) + 100;

      ip = (i - m/2)*k;
      jp = (j - m/2)*k;


      v[i][j]->y =30.0 * sin ((sqrt(ip*ip + jp*jp)) / 5.0);
      //cout << v[i][j]->y << endl;
    }


  //nastaveni souradnic + vytvoreni site polygonu

  //vytvareni site trojuhelniku
  for (i=0;i<m-1;i++)
    for(j=0;j<n-1;j++)
      //for(t=0;t<2;t++)

    {

      vt[0].x = v[i][j]->x;
      vt[0].z = v[i][j]->z;
      vt[0].y = v[i][j]->y;
      vt[1].x = v[i+1][j]->x;
      vt[1].z = v[i+1][j]->z;
      vt[1].y = v[i+1][j]->y;
      vt[2].x = v[i+1][j+1]->x;
      vt[2].z = v[i+1][j+1]->z;
      vt[2].y = v[i+1][j+1]->y;
      vt[3].x = v[i][j+1]->x;
      vt[3].z = v[i][j+1]->z;
      vt[3].y = v[i][j+1]->y;

/*

      if(t==0)
      {
      vt[0].x = v[i][j]->x;
      vt[0].z = v[i][j]->z;
      vt[0].y = v[i][j]->y;
      vt[1].x = v[i+1][j]->x;
      vt[1].z = v[i+1][j]->z;
      vt[1].y = v[i+1][j]->y;
      vt[2].x = v[i+1][j+1]->x;
      vt[2].z = v[i+1][j+1]->z;
      vt[2].y = v[i+1][j+1]->y;
      }
      else
      {
      vt[0].x = v[i+1][j+1]->x;
      vt[0].z = v[i+1][j+1]->z;
      vt[0].y = v[i+1][j+1]->y;
      vt[1].x = v[i][j+1]->x;
      vt[1].z = v[i][j+1]->z;
      vt[1].y = v[i][j+1]->y;
      vt[2].x = v[i][j]->x;
      vt[2].z = v[i][j]->z;
      vt[2].y = v[i][j]->y;
      }
*/
      //vytvareni unikatnich jmen polygonu
      name = "DLP";
      sprintf(s,"%d",i);
      name += s;
      strcpy(s,"#");
      name += s;
      sprintf(s,"%d",j);
      name += s;
      strcpy(s,"#");
      name += s;
      t=0;
      sprintf(s,"%d",t);
      name += s;


      //vytvoreni polygonu & nastaveni barvy
      //p[i][j][t] = new Polygon(c,(char*)name.c_str(),"DR1",3,vt);
      p[i][j][t] = new Polygon(c,(char*)name.c_str(),"DR1",4,vt);
      p[i][j][t]->setColor(c,1.0,(i/(float)n),(j/(float)m));

    }

/*
    for (t=0;t<20;t++)
    {
      v[0][0]->y += 5;
      v[0][1]->y -= 2;

      vt[0].x = v[0][0]->x;
      vt[0].y = v[0][0]->y;
      vt[0].z = v[0][0]->z;

      vt[1].x = v[0][1]->x;
      vt[1].y = v[0][1]->y;
      vt[1].z = v[0][1]->z;


        p[0][0][0]->setVCoord(c,2,vt[0],t);
        //p[0][0][0]->setVCoord(c,1,vt[1],t);

    }

*/

  int index[4];
  char **name;

  for (t=0;t<500;t++)
  {
    for(i=0;i<m-1;i++)
      for(j=0;j<n-1;j++)
      {

        v[i][j]->x = i * k - (m/2 * k);
        v[i][j]->z = j * k - (n/2 * k) + 100;

        ip = (i - m/2)*k;
        jp = (j - m/2)*k;

        v[i][j]->y =30.0 * sin ( ((sqrt(ip*ip + jp*jp)) / 5.0) + (t/50.0) );

	index[0] = 0;
	index[1] = 1;
	index[2] = 2;
	index[3] = 3;
	
	name[0] = p[i][j][0]->



        p[i][j][0]->setMVCoord(c,4,vt[0],t);


/*

	vt[0].x = v[i][j]->x;
	vt[0].y = v[i][j]->y;
	vt[0].z = v[i][j]->z;
	p[i][j][0]->setVCoord(c,0,vt[0],t);
	vt[0].x = v[i+1][j]->x;
	vt[0].y = v[i+1][j]->y;
	vt[0].z = v[i+1][j]->z;
	p[i][j][0]->setVCoord(c,1,vt[0],t);
	vt[0].x = v[i+1][j+1]->x;
	vt[0].y = v[i+1][j+1]->y;
	vt[0].z = v[i+1][j+1]->z;
	p[i][j][0]->setVCoord(c,2,vt[0],t);
	vt[0].x = v[i][j+1]->x;
	vt[0].y = v[i][j+1]->y;
	vt[0].z = v[i][j+1]->z;
	p[i][j][0]->setVCoord(c,3,vt[0],t);
*/

      }
  }



  //PL.setColor(c,1.0,0,0);


  for (i=0;i<m;i++)
    for(j=0;j<n;j++)
    {
      delete v[i][j];

    }


  cout << "Dokonceno" << endl;

  c->Disconnect();

  delete c;

}

