// Ukzkov pklad znzorujc vyuit vizualizanho systmu spolu
// s knihovnou SimLib

// Model struna.cc
// Problem: kmitani struny (SKRIPTA strana 42)
// reseni parcialni dif. rovnice, metoda primek
// (c) Petr Peringer, 1997

#include "simlib.h"
#include "visualisation.h"
#include <sstream>
#include <iostream>

// parameters of simulation:
const double Print_Step = 0.001;  // perioda vzorkovn
const double Simul_Time = 0.2;   // doba simulace

const int K = 5000;
const int L = 300;

Line *lines[100];

// equation
class Struna {
  const int N; // pocet useku
  const double l;   // delka
  const double a;   // koeficient  (napeti ve strune ???)
  const double b;   // pocatecni vychylka uprostred struny



  class Point : public aContiBlock {
    Integrator v; // y'
    Integrator y; // y
   public:
    Point() : v(), y(v) {}
    double Value() { return y.Value(); }
    void Set(Input i, double y0) {
      v.SetInput(i);
      y.Init(y0);
    }
  };

  Point *y;  // uzlove body
 public:
  Struna(unsigned _N, double _l, double _a, double _b) :
    N(_N), l(_l), a(_a), b(_b)  {
    // konstrukce modelu:
    y = new Point[N+1];
    const double dx = l/N;                          // delka useku
    const double adx2 = a/(dx*dx);
    double xi = dx;

    DNode dr("ROOT",NULL);
    dr.move(-L/2.0,0,0,0);

    char s[30];
    string name;
    point v[2];

    for(int i=1; i<N; i++) {
      y[i].Set( adx2 * (y[i+1] - 2*y[i] + y[i-1]),  // nastaveni vstupu
                b * (-4/(l*l) * xi*xi + 4/l * xi)); // pocatecni podminka
      xi += dx;


    }

    for(int i=0; i<N; i++)
    {
      name = "line";
      sprintf(s,"%d",i);
      name += s;
      v[0].y = K*y[i].Value();
      v[0].x = L*(i*l/N);
      v[1].y = K*y[i+1].Value();
      v[1].x = L*((i+1)*l/N);

      lines[i] = new Line((char*)name.c_str(),"ROOT",v);
      lines[i]->setColor(1,0,0);

    }

    v[0].y=0;v[0].x=0;v[1].y=0;v[1].x=L;
    Line xa("x_axis","ROOT",v);
    xa.setColor(0,0,0);

    v[0].y= -60;v[0].x=0;v[1].y=60;v[1].x=0;
    Line ya("y_axis","ROOT",v);
    ya.setColor(0,0,0);


   dr.move(0,100,0);



  }
  double GetX(int i) { return (i<=N) ? i*l/N : 0.0; }
  double GetY(int i) { return (i<=N) ? y[i].Value() : 0.0; }
  int GetN() { return N; }
};



Struna *s;
float t = 0;

void Sample() {
  Print("# x       y \n");
  point v;
  t++;
  for(int i=0; i<s->GetN(); i++)
  {
    Print("%-8g %g \n", s->GetX(i), s->GetY(i) );
    //zjisteni souradnic segmentu struny a jejich nastaveni ve vizualizaci
    v.x = s->GetX(i)*L;
    v.y = K*s->GetY(i);
    lines[i]->setVCoord(0,v,t);
    v.x = s->GetX(i+1)*L;
    v.y = K*s->GetY(i+1);
    lines[i]->setVCoord(1,v,t);

  }
  Print("\n");
}





int main(int argc,char** argv)
{
  //vytvoreni spojeni se serverem
  VClient::init(argc,argv);

  s=new Struna(100, 1, 1e3, 0.01);

  Sampler S(Sample, Print_Step);


  SetOutput("struna.dat");      // output file
  _Print("# Struna \n");
  Init(0, Simul_Time);          // inicializace experimentu
  Run();                        // simulace


  VClient::finish(); //ukonceni spojeni
}
