// Model struna.cc
// Problem: kmitani struny (SKRIPTA strana 42)
// reseni parcialni dif. rovnice, metoda primek
// (c) Petr Peringer, 1997

#include "simlib.h"

// parameters of simulation:
const double Print_Step = 0.001;  // perioda vzorkovn
const double Simul_Time = 0.05;   // doba simulace

Line *lines[100];

// equation
class Struna {
  const unsigned N; // pocet useku
  const double l;   // delka
  const double a;   // koeficient  (napeti ve strune ???)
  const double b;   // pocatecni vychylka uprostred struny



  class Point : public aContiBlock {
    Integrator v; // y'
    Integrator y; // y
   public:
    Point() : v(), y(v) {}
    double Value() { return y.Value(); }
    void Set(Input i, double y0) {
      v.SetInput(i);
      y.Init(y0);
    }
  };

  Point *y;  // uzlove body
 public:
  Struna(unsigned _N, double _l, double _a, double _b) :
    N(_N), l(_l), a(_a), b(_b)  {
    // konstrukce modelu:
    y = new Point[N+1];
    const double dx = l/N;                          // delka useku
    const double adx2 = a/(dx*dx);
    double xi = dx;

    DNode dpos1("ROOT",NULL);

    char s[30];
    string name;
    point v[2];

    for(int i=1; i<N; i++) {
      y[i].Set( adx2 * (y[i+1] - 2*y[i] + y[i-1]),  // nastaveni vstupu
                b * (-4/(l*l) * xi*xi + 4/l * xi)); // pocatecni podminka
      xi += dx;


    }

    for(int i=0; i<N; i++)
    {
      name = "line";
      sprintf(s,"%d",i);
      name += s;
      v[0].y = y[i].Value();
      v[0].x = i*l/N
      v[1].y = y[i+1].Value();
      v[1].x = i+1*l/N

      lines[i] = new Line((char*)name.c_str(),"ROOT",v);
      lines[i]->setColor(0,1,1);

    }

  }
  double GetX(unsigned i) { return (i<=N) ? i*l/N : 0.0; }
  double GetY(unsigned i) { return (i<=N) ? y[i].Value() : 0.0; }
  unsigned GetN() { return N; }
};



Struna s(100, 1, 1e3, 0.01);

void Sample() {
  Print("# x       y \n");
  for(int i=0; i<=s.GetN(); i++)
  {
    Print("%-8g %g \n", s.GetX(i), s.GetY(i) );

  }
  Print("\n");
}
Sampler S(Sample, Print_Step);




int main()
{
  SetOutput("struna.dat");      // output file
  _Print("# Struna \n");
  Init(0, Simul_Time);          // inicializace experimentu
  Run();                        // simulace
}
