/*==========================================================================
   Vizualizacni server
   Copyright (c) 2003 Vladimir Florian
   All rights reserved.

  This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   GLDrawer.cpp
   Trida pro inicializaci a vykreslovani OpenGL grafiky
   ========================================================================*/


#include "GLDrawer.h"
#include <GL/glut.h>
#include "GObjects.h"
#include <iostream>
#include <qtimer.h>
#include <math.h>


#define		PI	3.14159265359f


GLDrawer::GLDrawer( QWidget *parent, const char *name,dag *dtree )
            : QGLWidget(parent,name) {
    //graf popisu sceny
    tree = dtree;

    refresh = new QTimer(this,"refresh handler");


    //pri preteceni casovace se vola fce RefreshScreen
     connect(refresh,SIGNAL(timeout()),this,SLOT(refreshTimeout()) );

    //obnoveni sceny nejdrive po 20ms = max. 50 snimku / s
    //refresh -> start(20);


    //pocatecni nastaveni sirky a vysky okna pro OpenGL grafiku
    w_heigth = 200;
    w_width = 200;

    drawEnabled = true;

    //nastaveni pozice svetla 0
    light_position[0] = 0.0;
    light_position[1] = 400.0;
    light_position[2] = -400.0;
    light_position[3] = 0.0;

    //nastaveni pozice svetla 1
    light_position1[0] = 0.0;
    light_position1[1] = 400.0;
    light_position1[2] = 400.0;
    light_position1[3] = 0.0;


    //nastaveni pozice kamery
    angleX = 0.0;
    angleY = -20.0;
    distance=300.0f;
    ComputeCamera();

    //nastaveni promennych pro testovani stisku tlacitka mysi
    RPressed = false;
    LPressed = false;

	    }

//**************************************************************************


void GLDrawer::initializeGL()
{
    //inicilalizace OpenGL grafiky

    //nastaveni background color
    glClearColor(1.0,1.0,1.0,0);

    //nastaveni parametru svetla
    GLfloat mat_specular[] = {1.0, 1.0, 1.0, 1.0};
    GLfloat mat_shininess[] = { 50.0 };
    GLfloat ambient[] = {0.2,0.2,0.2,1.0};
    GLfloat diffuse[] = {1.0,1.0,1.0,1.0};

    glMatrixMode(GL_MODELVIEW);

    //hladke - Gouradovo stinovani
    glShadeModel(GL_SMOOTH);

    //zakladni nastaveni materialu objektu ve scene, aby byly viditelne
    glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR,mat_specular);
    glMaterialfv(GL_FRONT_AND_BACK, GL_SHININESS, mat_shininess);

    //zapnuti osvetleni
    glEnable(GL_LIGHTING);
    //zapnuti svetla 0
    glEnable(GL_LIGHT0);
    //zapnuti svetla 1
    glEnable(GL_LIGHT1);

    //zapnuti Z-Bufferu
    glEnable(GL_DEPTH_TEST);
    //nastaveni svetla
    glLightfv(GL_LIGHT0,GL_AMBIENT,ambient);
    glLightfv(GL_LIGHT0,GL_DIFFUSE,diffuse);
    glLightfv(GL_LIGHT0,GL_POSITION,light_position);
    glLightfv(GL_LIGHT1,GL_AMBIENT,ambient);
    glLightfv(GL_LIGHT1,GL_DIFFUSE,diffuse);
    glLightfv(GL_LIGHT1,GL_POSITION,light_position1);
    
    //zapnuti antialiasingu pri vykreslovani polygonu
    glHint(GL_POLYGON_SMOOTH_HINT,GL_NICEST);

}


/*****************************************************************/

void GLDrawer::resizeGL(int w,int h)
{
  //fce volana pri zmene velikosti okna na w / h

  w_heigth = h;
  w_width = w;

  glViewport(0, 0, w, h);
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
// perspektivni projekce
  //glFrustum( -100,100,-100,100,0,600);
  //gluPerspective(100.0,2.0,10,600);
  // orthografick�projekce
  glOrtho ( 0,w ,0,h , 500, -500);
// a zp� do ModelView - tedy d�e pracujeme s matic� kter�transformuje objekty na sc��..
  glMatrixMode(GL_MODELVIEW);


}

/*****************************************************************/

void GLDrawer::paintGL()
{
   //funkce prochazi graf sceny a vykresluje scenu

        GLfloat mat_diff[] = {1.0,0.0,0.0,1.0};
	GLfloat mat_diff_g[] = {1.0,1.0,1.0,1.0};
	//GLfloat mat_amb_g[] = {

	//smazani obrazovky a "vynulovani" Z-Bufferu
     	glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();

// nastaveni pocatku souradnic doprostred obrazovky...

	glTranslatef(w_width/2,w_heigth*0.2,0);

        //vypocet pozice kamery
	ComputeCamera();
	gluLookAt(distance*-camera_u[0]+camera_pos[0], distance*-camera_u[1]+camera_pos[1], distance*-camera_u[2]+camera_pos[2], camera_pos[0], camera_pos[1], camera_pos[2], camera_w[0], camera_w[1], camera_w[2]);


	glMaterialfv(GL_FRONT, GL_DIFFUSE,mat_diff_g);
	glMaterialfv(GL_FRONT, GL_AMBIENT,mat_diff_g);



	glMaterialfv(GL_FRONT, GL_DIFFUSE,mat_diff);

        glFlush();

        //pruchod grafem sceny a jeji vykresleni
	tree->MakeTree(tree->tree);

        //okamzite vyprazdneni bufferu a vykresleni sceny
    	glFlush();
}


//***********************************************************

void GLDrawer::RefreshScreen()
{

  //vyvola prekresleni sceny
  if (!refresh->isActive() && drawEnabled)

  {
    updateGL();
    //obnoveni sceny nejdrive po 20ms = max. 50 snimku / s
    refresh -> start(20);
  }

}

//************************************************************

   void GLDrawer::mousePressEvent( QMouseEvent *e )
   //funkce pro obsluhu stisknuti tlacitka mysi
    {
        if ( e->button() == LeftButton )
          LPressed = true;
        if ( e->button() == RightButton )
          RPressed = true;

        QPoint pnt = e->pos();
        //zapamatovani souradnic, kde bylo stisknuto tlacitko
	mx = pnt.x();
	my = pnt.y();

    }

//**************************************************************


void GLDrawer::mouseMoveEvent( QMouseEvent *e )
//fce pro obsluhu pohybu kursoru mysi
    {
      if ( LPressed )
      {
        QPoint pnt = e->pos();
        //aktualizace pozice kamery , uhlu pohledu
        addx = (pnt.x() - mx) / 30 ;
	addy = (pnt.y() - my) / 30;

	if ((angleX+=addx)>360.0f)
	  angleX-=360.0f;
	if ((angleY+=addy)>90.0f)
	  angleY=90.0f;
	if (angleX<0.0f)
	  angleX+=360.0f;
	if (angleY<-90.0f)
	  angleY=-90.0f;

        RefreshScreen();
      }
      else
      if ( RPressed )
      {
        //aktualizace pozice kamery , vzdalenosti od sceny
        QPoint pnt = e->pos();
        addy = (pnt.y() - my) / 30;
        distance+=addy;
	if (distance<1.0f) distance=1.0f;
	else if (distance>300.0f) distance=300.0f;

	RefreshScreen();
      }

    }


//****************************************************************

void GLDrawer::mouseReleaseEvent( QMouseEvent *e )
//fce obsluhujici uvolneni tlacitka mysi
    {
        if ( e->button() == LeftButton )
            LPressed = FALSE;
        if ( e->button() == RightButton )
            RPressed = FALSE;
    }

//******************************************************************

void GLDrawer::ComputeCamera()
// vypocita osy kamery podle vypoctenych uhlu rotaci, kamera vzdy bude mit y-ovou osu smerujici vzhuru!
{
  float	sx=(float)sin(angleX*PI/180.0f);
  float	cx=(float)cos(angleX*PI/180.0f);
  float	sy=(float)sin(angleY*PI/180.0f);
  float	cy=(float)cos(angleY*PI/180.0f);
	camera_u[0]=-cy*sx;
	camera_u[1]=-sy;
	camera_u[2]=-cy*cx;
	camera_v[0]=-cx;
	camera_v[1]=0.0f;
	camera_v[2]=sx;
	camera_w[0]=camera_u[1]*camera_v[2]-camera_u[2]*camera_v[1];
	camera_w[1]=camera_u[2]*camera_v[0]-camera_u[0]*camera_v[2];
	camera_w[2]=camera_u[0]*camera_v[1]-camera_u[1]*camera_v[0];
  //Pri zmene pozice kamery se prekresli scena
  //RefreshScreen();

}

//******************************************************************

void GLDrawer::refreshTimeout()
{
  //zde je osetreni preteceni timeru refresh

  refresh->stop();
  RefreshScreen();
}

