/*==========================================================================
   Vizualizacni server
   Copyright (c) 2003 Vladimir Florian
   All rights reserved.

  This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   GLDrawer.h
   Trida pro inicializaci a vykreslovani OpenGL grafiky
   ========================================================================*/

#ifndef GLDRAWER_H
#define GLDRAWER_H

#include <qgl.h>
#include "dag.h"

class QTimer;

class GLDrawer : public QGLWidget
{
  Q_OBJECT

  float angleX, angleY;		// natoceni kamery
  float distance;			// vzdalenost kamery od referencniho bodu (bodu pohledu)
  float camera_u[3], camera_v[3], camera_w[3];	// souradny system kamery (tri ortogonalni osy)
  float camera_pos[3];				// pozice referencniho bodu kamery

  GLfloat light_position[4]; //pozice svetla 1
  GLfloat light_position1[4]; //pozice svetla 1

  bool drawEnabled;  //povoluje/zakazuje vykreslovani

public:

  QTimer *refresh;

  bool RPressed;
  bool LPressed;

  int zeme,mars,mesic,slunce;
  int w_heigth; //vyska okna
  int w_width;  //sirka okna

  int cx,cy,cz;  //souradnice kamery
  int mx,my,mz;  //souradnice ,na kterych bylo stisknute tlacitko
  int addx,addy;

  dag* tree;

  GLDrawer(QWidget *parent = 0,const char *name = 0,dag *dtree=0);

  void initializeGL();

  void resizeGL(int w,int h);

  void paintGL();

  void enableDrawing(){drawEnabled = true;}

  void disableDrawing(){drawEnabled = false;}

  ~GLDrawer() { /*delete tree;*/}

public slots:
  void RefreshScreen();

protected slots:
  void refreshTimeout();

protected:
  //funkce pro obsluhu stisknuti tlacitka mysi
  void  mousePressEvent( QMouseEvent * );
  //fce pro obsluhu pohybu kursoru mysi
  void  mouseMoveEvent( QMouseEvent * );
  //fce obsluhujici uvolneni tlacitka mysi
  void  mouseReleaseEvent( QMouseEvent * );
  //prepocita pozici kamery
  void  ComputeCamera();


};

#endif
