/*==========================================================================
   Vizualizacni server
   Copyright (c) 2003 Vladimir Florian
   All rights reserved.

  This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   GObjects.cpp
   Zde je popis objektu, z kterych je mozne modelovat scenu na strane serveru
   ========================================================================*/



#include "GObjects.h"
#include "parser.h"
#include <iostream>

using namespace std;



BaseElement::BaseElement()
{
   //nastaveni vychoziho materialu = barvy odrazeneho svetla
  ambient[0] = 0.3;
  ambient[1] = 0.3;
  ambient[2] = 0.3;
  ambient[3] = 1.0;

  diffuse[0] = 1.0;
  diffuse[1] = 1.0;
  diffuse[2] = 1.0;
  diffuse[3] = 1.0;

}

//***********************************************************************

void BaseElement::SetColor(float r,float g,float b)
{

  ambient[0] = 0.3 * r;
  ambient[1] = 0.3 * g;
  ambient[2] = 0.3 * b;
  ambient[3] = 1.0;

  diffuse[0] = 1.0 * r;
  diffuse[1] = 1.0 * g;
  diffuse[2] = 1.0 * b;
  diffuse[3] = 1.0;


}

//**********************************************************************

void BaseElement::SetDrawType(int type)
{
  solid = type;
}

//**********************************************************************


Sphere::Sphere(char *name) :  TNode(name)
{
  //pocatecni nastaveni jako solid
  solid = 1;
  radius = 10;
  

}


//**********************************************************************

void Sphere::Make()
{
  //nastaveni barvy materialu
  glMaterialfv(GL_FRONT, GL_DIFFUSE,diffuse);
  glMaterialfv(GL_FRONT, GL_AMBIENT,ambient);
  

  if (solid)
    glutSolidSphere(radius,16,8);
  else
    glutWireSphere(radius,16,8);

}

//**********************************************************************
//**********************************************************************

Cube::Cube(char *name) :  TNode(name)
{

  solid = 1;
  size = 10;

}


//**********************************************************************

void Cube::Make()
{
  //nastaveni barvy materialu
  glMaterialfv(GL_FRONT, GL_DIFFUSE,diffuse);
  glMaterialfv(GL_FRONT, GL_AMBIENT,ambient);

  if (solid)
    glutSolidCube(size);
  else
    glutWireCube(size);

}

//**********************************************************************

Polygon::Polygon(char* name,int pocet,point* vert) : TNode(name)
{

  pocet_v = pocet;
  //vytvoreni pole vrcholu polygonu
  v = new point[pocet_v];
  for(int i=0;i<pocet_v;i++)
  {
    v[i] = vert[i];
  }
};

//**********************************************************************

void Polygon::Make()
{

  glMaterialfv(GL_FRONT, GL_DIFFUSE,diffuse);
  glMaterialfv(GL_FRONT, GL_AMBIENT,ambient);


  glBegin(GL_POLYGON);
    for(int i=0;i<pocet_v;i++)
    {
      glVertex3f(v[i].x,v[i].y,v[i].z);
    }
  glEnd();

}

//**********************************************************************

Line::Line(char* name,point* vert) : TNode(name)
{
  //vytvoreni pole vrcholu polygonu
  v = new point[2];
  for(int i=0;i<2;i++)
    {
      v[i].x = vert[i].x;
      v[i].y = vert[i].y;
      v[i].z = vert[i].z;
    }
};

//**********************************************************************

void Line::Make()
{

  glMaterialfv(GL_FRONT, GL_DIFFUSE,diffuse);
  glMaterialfv(GL_FRONT, GL_AMBIENT,ambient);

  glBegin(GL_LINES);
    for(int i=0;i<2;i++)
    {
      glVertex3f(v[i].x,v[i].y,v[i].z);
    }
  glEnd();

}


//**********************************************************************

pMatrix::pMatrix(parser *pars,char* name,char* parent,int px,int py,int pxsize,int pysize,float ptime)
  : TNode(name)
{

  x = px;
  y = py;
  xsize = pxsize;
  ysize = pysize;
  p = pars;



  int i,j;
  //vytvoreni pole vrcholu
  v = new point*[x+1];
  for(i=0;i<=x;i++)
    v[i] = new point[y+1];

  //vytvoreni pole vrcholu
  colors = new tColor*[x];
  for(i=0;i<x;i++)
    colors[i] = new tColor[y];


  //nastaveni defaultnich souradnic
  for(i=0;i<x+1;i++)
    for(j=0;j<y+1;j++)
    {
      v[i][j].x = i * ((float)xsize /(float) x);
      v[i][j].z = j * ((float)ysize /(float) y);
    }

}

//**********************************************************************

void pMatrix::Make()
{

  int i,j;



  if (v==NULL)
  {
    cerr << "Chyba"<<endl;
    return;
  }

if (solid)
{
  glBegin(GL_QUADS);
    for(i=0;i<x;i++)
      for(j=0;j<y;j++)
      {
        ambient[0] = 0.3 * colors[i][j].color[0];
        ambient[1] = 0.3 * colors[i][j].color[1];
        ambient[2] = 0.3 * colors[i][j].color[2];
        ambient[3] = 1.0 * colors[i][j].color[3];


        glMaterialfv(GL_FRONT, GL_DIFFUSE,colors[i][j].color);
        glMaterialfv(GL_FRONT, GL_AMBIENT,ambient);

        glVertex3f(v[i][j].x, v[i][j].y, v[i][j].z);
	glVertex3f(v[i][j+1].x, v[i][j+1].y, v[i][j+1].z);
	glVertex3f(v[i+1][j+1].x, v[i+1][j+1].y, v[i+1][j+1].z);
	glVertex3f(v[i+1][j].x, v[i+1][j].y, v[i+1][j].z);

      }
  glEnd();
}
else
{
    for(i=0;i<x;i++)
      for(j=0;j<y;j++)
      {
        glBegin(GL_LINE_LOOP);
        ambient[0] = 0.3 * colors[i][j].color[0];
        ambient[1] = 0.3 * colors[i][j].color[1];
        ambient[2] = 0.3 * colors[i][j].color[2];
        ambient[3] = 1.0 * colors[i][j].color[3];


        glMaterialfv(GL_FRONT, GL_DIFFUSE,colors[i][j].color);
        glMaterialfv(GL_FRONT, GL_AMBIENT,ambient);

        glVertex3f(v[i][j].x, v[i][j].y, v[i][j].z);
	glVertex3f(v[i][j+1].x, v[i][j+1].y, v[i][j+1].z);
	glVertex3f(v[i+1][j+1].x, v[i+1][j+1].y, v[i+1][j+1].z);
	glVertex3f(v[i+1][j].x, v[i+1][j].y, v[i+1][j].z);
	glEnd();

      } 
}


}



//**********************************************************************

Cylinder::Cylinder(char* name,int ra,int rb,int h) : TNode(name)
{
  r1 = ra;
  r2 = rb;
  height = h;
  qobj = gluNewQuadric();

  gluQuadricDrawStyle(qobj, GLU_FILL); /* smooth shaded */
  //gluQuadricDrawStyle(qobj, GLU_LINE); /* wired */

  gluQuadricNormals(qobj, GLU_SMOOTH);

}

//**********************************************************************

void Cylinder::Make()
{

  glMaterialfv(GL_FRONT, GL_DIFFUSE,diffuse);
  glMaterialfv(GL_FRONT, GL_AMBIENT,ambient);

  glPushMatrix();

  if (solid == 0)
    gluQuadricDrawStyle(qobj, GLU_LINE); /* wired */

  gluCylinder(qobj, r1, r2, height, 15, 5);
  glRotatef(180,0,1,0);
  gluDisk(qobj, r1, 0, 15, 5);
  glRotatef(-180,0,1,0);
  glTranslatef(0,0,height);
  gluDisk(qobj, r2, 0, 15, 5);

  glPopMatrix();

}


//**********************************************************************
//**********************************************************************

void TNode::Make()
{
  
  glRotatef(ang,xa,ya,za);

  glTranslatef(x,y,z);
}

//***********************************************************************

void TNode::reset()
{
  x = 0.0;
  y = 0.0;
  z = 0.0;
  xa = 0.0;
  ya = 0.0;
  za = 0.0;
  ang = 0.0;
}

