/*==========================================================================
   Vizualizacni server
   Copyright (c) 2003 Vladimir Florian
   All rights reserved.

  This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   GObjects.h
   Zde je popis objektu, z kterych je mozne modelovat scenu na strane serveru
   ========================================================================*/


#ifndef GOBJECTS_H
#define GOBJECTS_H
#include "dag.h"
#include <GL/glut.h>
#include <GL/gl.h>



//typy objektu
typedef enum {TNODE,SPHERE,CUBE,POLYGON,LINE,CYLINDER,PMATRIX} node_types;

//typy operaci
typedef enum {CREATE,MOVE,MOVEABS,ROTATE,SETCOLOR,SETRADIUS,SETDRAWTYPE,SETSIZE,
              SETVCOORD,SET_PMATRIX_COORD,SET_PMATRIX_COLOR} operation_types;

class node;
class parser;




//obsahuje nektere vlastnosti, ktere maji vsechny objekty stejne

class BaseElement
{

public:
  //vlastnosti materialu
  float ambient[4];
  float diffuse[4];
  int solid;

  BaseElement();
  //nastaveni barvy odrazeneho svetla
  void SetColor(float r,float g,float b);
  void SetDrawType(int type);

};

//********************************************************************


class TNode : public node
//uzel slouzici pro manipulaci s objekty ve scene, ktere jsou v grafu sceny
//ulozeny jako jeho potomci
{

public:

  float x,y,z; //souradnice
  float ang,xa,ya,za; //uhel + vektor osy otaceni




  TNode(char *name) : node(name) {x =0.0;y =0.0;z =0.0;ang=0.0,xa=0.0;ya=0.0;za=0.0;}

  //rotace o uhel angr, podle vektoru definovaneho parametry xr,yr,zr
  void rotate(float angr,float xr,float yr,float zr) {ang+=angr;xa=xr;ya=yr;za=zr;}

  //relativni posun souradnic
  void move(float xr,float yr,float zr)
  {
    x+=xr; y+=yr; z+=zr;
  }

  //posun na absolutni pozici
  void moveABS(float xr,float yr,float zr){x=xr; y=yr; z=zr;}

  //vynulovani vsech parametru uzlu, slouzi pro rychly navrat na zacatek sceny
  void reset();

  virtual void Make();

  virtual ~TNode(){}
};

//************************************************************************

struct tColor //trida pro ulozeni barvy objektu
{
  float color[4];
  tColor(float r = 1.0, float g = 1.0, float b = 1.0, float a = 1.0)
  {
    color[0] = r;
    color[1] = g;
    color[2] = b;
    color[3] = a;
  }
};

//************************************************************************
//trida pro uchovani souradnic jednoho bodu

struct point
{

  float x,y,z;
  point(float xx = 0.0,float yy = 0.0, float zz = 0.0) { x=xx;y=yy;z=zz;}

};



//************************************************************************

class Sphere : public TNode , public BaseElement
//koule
{
public:

int radius;
public:
  Sphere(char* name);

  virtual void Make();
  //nastavi , zda se ma vykreslit jako dratena nebo solid
  void setType(int type) {if (type == 0) solid = 0; else solid = 1;}

  //nastaveni velikosti
  void SetRadius(int r) {radius = r;}

  virtual ~Sphere(){}
};


//********************************************************************

class Cube : public TNode , public BaseElement
//krychle
{
public:

int size;
public:
  Cube(char* name);

  virtual void Make();

  void setType(int type) {if (type == 0) solid = 0; else solid = 1;}

  //nastaveni velikosti hrany krychle
  void SetSize(int s) {size = s;}

  virtual ~Cube(){}
};


//********************************************************************

class Line : public TNode , public BaseElement

{
public:

point *v;  //ukazatel na pole vrcholu

public:
  Line(char* name,point* vert);

  virtual void Make();

  void setVCoord(int cislo_vrcholu,float vx,float vy,float vz)
  {
    int i = cislo_vrcholu;
    v[i].x = vx;
    v[i].y = vy;
    v[i].z = vz;
  }


  virtual ~Line(){}


};


//********************************************************************

class Polygon : public TNode , public BaseElement
//obecny polygon
{
public:

point *v;  //ukazatel na pole vrcholu
int pocet_v; //pocet vrcholu

public:
  Polygon(char* name,int pocet,point* vert);

  virtual void Make();

  virtual ~Polygon(){}

  //nastavi souradnice vrcholu
  void setVCoord(int cislo_vrcholu,float vx,float vy,float vz)
  {
    int i = cislo_vrcholu;
    v[i].x = vx;
    v[i].y = vy;
    v[i].z = vz;
  }

};

//********************************************************************

class pMatrix : public TNode , public BaseElement
//pravouhla sit polygonu
{
public:

int x,y,xsize,ysize;
parser *p;

public:

//node *mp[200][200];
node **mp;

point **v;  //pole vrcholu
tColor **colors;//barvy polygonu

float ambient[4];


public:
  pMatrix(parser *pars,char* name,char* parent,int px,int py,int pxsize,int pysize,float ptime);

  //setMVCoord(

  virtual void Make();

  virtual ~pMatrix(){};


};



//********************************************************************

class Cylinder : public TNode , public BaseElement
//obecny polygon
{
public:

GLUquadricObj *qobj;


int r1; //polomer dolni zakladny
int r2; //polomer horni zakladny
int height; //vyska cylindru

public:
  Cylinder(char* name,int ra,int rb,int h);

  virtual void Make();

  virtual ~Cylinder(){}


};






//********************************************************************


#endif

