/*==========================================================================
   Vizualizacni server
   Copyright (c) 2003 Vladimir Florian
   All rights reserved.

  This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   IOWidget.cpp

   Obsahuje definici casti GUI pro rizeni animace

   ========================================================================*/

#include "IOWidget.h"

#include <qslider.h>
#include <qlcdnumber.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qpushbutton.h>



LCDRange::LCDRange( QWidget *parent, const char *name )
        : QWidget( parent, name )
{
    lcd  = new QLCDNumber( 6, this, "lcd"  );
    slider = new QSlider( Horizontal, this, "slider" );
    slider->setRange( 0, MAX_RANGE-1);
    slider->setValue( 0 );

    status = 0; //vychozi stav


    connect( slider, SIGNAL(valueChanged(int))
             , SLOT(ChangeTime(int)) );

    setFocusProxy( slider );

    QVBoxLayout * l = new QVBoxLayout( this );
    l->addWidget( lcd, 1 );
    l->addWidget( slider );

}


//*********************************************************************


int LCDRange::value()
{
    return slider->value();
}

//***********************************************************************



void LCDRange::setValue( int value )
{
    slider->setValue( value );
}

//***********************************************************************

void LCDRange::setRange( int minVal, int maxVal )
{
    if ( minVal < 0 || maxVal > MAX_RANGE || minVal > maxVal ) {
        qWarning( "LCDRange::setRange(%d,%d)\n"
                  "\tRange must be 0..%d\n"
                  "\tand minVal must not be greater than maxVal",
                  minVal, maxVal, MAX_RANGE);
        return;
    }
    slider->setRange( minVal, maxVal );
}

//***********************************************************************

void LCDRange::setTime(float f)
{
  //zachyceni a zpracovani signalu od scheduleru indikujiciho zmenu casu
  if (f < 0.0) f = 0.0;
  if (f > 1.0) f = 1.0;
  status = 1;//pozice nastavena jinym objektem
  slider->setValue((int)(f*MAX_RANGE)); //nastavi slider

  lcd->display(f);
}

//***********************************************************************

void LCDRange::ChangeTime(int v)
//prepocita absolutni pozici na relativni a vysle signal s touto hodnotou
{
  if (status == 0)
  {
    emit GoTo(v/(float)MAX_RANGE);
    lcd->display(v/(float)MAX_RANGE);
  }
  else status = 0;
}


//*******************************************************************


SpeedControl::SpeedControl( QWidget *parent, const char *name )
        : QWidget( parent, name )
{
  lcd = new QLCDNumber(6,this,"lcd");


  up = new QPushButton("Speed x2",this,"up");
  down = new QPushButton("Speed /2",this,"down");

  connect(up,SIGNAL(clicked()),SLOT(SpeedUp()) );
  connect(down,SIGNAL(clicked()),SLOT(SpeedDown()) );

  QGridLayout *grid = new QGridLayout( this, 2, 3, 10 );

  grid -> addWidget(down, 0, 0);
  grid -> addWidget(up, 0, 2);
  grid -> addWidget(lcd, 0, 1);


  speed = 1.0; //pocatecni nastaveni rychlosti prehravani na normalni rychlost
  lcd->display(speed);

}

//*********************************************************************

void SpeedControl::SpeedUp()
//nastavi rychlost prehravani na dvojnasobek - zasle signal scheduleru
//max na 16-ti nasobek
{
  speed *= 2.0;
  if (speed > 16.0) speed = 16.0;
  //zobrazeni aktualni hodnoty na displeji
  lcd->display(speed);

  emit SetSpeed(speed);
}

//*********************************************************************

void SpeedControl::SpeedDown()
//nastavi rychlost prehravani na dvojnasobek - zasle signal scheduleru
//max na 1/16-inu
{
  speed /= 2.0;
  if (speed < (1.0/16.0))
    speed = (1.0/16.0);
  //zobrazeni aktualni hodnoty na displeji
  lcd->display(speed);

  emit SetSpeed(speed);
}

